c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine calc_mass
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), 
     &          soub(0:nnrb,0:nntb,0:nnpb),
     &          souf(0:nnr,0:nnt,0:nnp)
c
c
      call adm_source(soug,soub,souf)
      call vol_int_gr(soug,volg,1)
      call vol_int_bh(soub,volb,1)
      call vol_int_fluid(souf,rs,volf)
c
      fac2pi = 0.5d0/pi
      ahoadm = fac2pi*(radi*(volg + volb) + radi**3*volf)
     &       + bhmass
c
      call komar_source(soug,soub,souf)
      call vol_int_gr(soug,volg,1)
      call vol_int_bh(soub,volb,1)
      call vol_int_fluid(souf,rs,volf)
c
      fac4pi = 0.25d0/pi
      ahokombaka = fac4pi*(radi*(volg + volb) + radi**3*volf)
     &       + apmass + 0.5d0*bhmass 
c
      call alpsm_source(soug,soub,souf)
      call vol_int_gr(soug,volg,1)
      call vol_int_bh(soub,volb,1)
      call vol_int_fluid(souf,rs,volf)
c
      fac4pi = 0.25d0/pi
      ahoalps= fac4pi*(radi*(volg + volb) + radi**3*volf)
     &       + apmass
c
      ahokom = ahoalps + 0.5d0*ahoadm
c
      write (6,*)' volume integral of adm, komar, and alpha mass'
      write (6,*) ahoadm, ahokom, ahokombaka
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine calc_mom
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      dimension souf(0:nnr,0:nnt,0:nnp)
c
c
      call linmom_source(souf)
      call vol_int_fluid(souf,rs,volf)
c
      aholin = radi**3*volf
     &       + pmomy
c
      call angmom_source(souf)
      call vol_int_fluid(souf,rs,volf)
c
      ahoang = radi**3*volf
     &       + (dis - orbc)*pmomy
c
c
      write (6,*)' volume integral of linear and angular momentum'
      write (6,*) aholin, ahoang
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine calc_dipole_psi
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), 
     &          soub(0:nnrb,0:nntb,0:nnpb)
c
c
      call dipole_psi_source(soug,soub)
      call vol_int_gr(soug,volg,1)
      call vol_int_bh(soub,volb,1)
c
      dipole = radi**4*(volg + volb)
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adm_source(soug,soub,souf)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metfl.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_grav.f'
      include 'common_blocks/CB_excurvBY_bh.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / flusw / swflu
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), 
     &          soub(0:nnrb,0:nntb,0:nnpb),
     &          souf(0:nnr,0:nnt,0:nnp)
c
c --  haijaij = psi^12 aijaij
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      psiw = psi(irg,itg,ipg)
      psiwm7 = 1.0d0/psiw**7
      haijaijw = haijaij(irg,itg,ipg)
      soug(irg,itg,ipg) = 0.125d0*psiwm7*haijaijw
  100 continue
c
c
      do 110 ipb = 0, npb
      do 110 itb = 0, ntb
      do 110 irb = 0, nrb
      psiw = psib(irb,itb,ipb)
      psiwm7 = 1.0d0/psiw**7
      haijaijw = haijaijb(irb,itb,ipb)
      soub(irb,itb,ipb) = 0.125d0*psiwm7*haijaijw
  110 continue
c
c
      do 120 ipf = 0, npf
      do 120 itf = 0, ntf
      do 120 irf = 0, nrf
      emdw = emd(irf,itf,ipf)
      ramw = ram(irf,itf,ipf)
      psiw = psif(irf,itf,ipf)
      alphw = alphf(irf,itf,ipf)
      rhow = emdw**pinx
      prew = rhow*emdw
      hhw  = 1.0d0 + (pinx+1.0d0)*emdw
c
      utw  =       swflu *ram(irf,itf,ipf)/(alphw**2*hhw)
     &     +(1.0d0-swflu)*hhw/ber
c
      zfac = 1.0d0
      if (emdw.le.0.0d0) zfac = 0.0d0
      rhoHw = hhw*rhow*(alphw*utw)**2 - prew
c
      souf(irf,itf,ipf) = 2.0d0*pi*psiw**5*rhoHw
  120 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine komar_source(soug,soub,souf)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metfl.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_grav.f'
      include 'common_blocks/CB_excurvBY_bh.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / flusw / swflu
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), 
     &          soub(0:nnrb,0:nntb,0:nnpb),
     &          souf(0:nnr,0:nnt,0:nnp)
c
c --  haijaij = psi^12 aijaij
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      psiw = psi(irg,itg,ipg)
      alphw = alph(irg,itg,ipg)
      psiwm6 = 1.0d0/psiw**6
      haijaijw = haijaij(irg,itg,ipg)
      soug(irg,itg,ipg) = alphw*psiwm6*haijaijw
  100 continue
c
c
      do 110 ipb = 0, npb
      do 110 itb = 0, ntb
      do 110 irb = 0, nrb
      psiw = psib(irb,itb,ipb)
      alphw = alphb(irb,itb,ipb)
      psiwm6 = 1.0d0/psiw**6
      haijaijw = haijaijb(irb,itb,ipb)
      soub(irb,itb,ipb) = alphw*psiwm6*haijaijw
  110 continue
c
c
      do 120 ipf = 0, npf
      do 120 itf = 0, ntf
      do 120 irf = 0, nrf
      emdw = emd(irf,itf,ipf)
      ramw = ram(irf,itf,ipf)
      psiw = psif(irf,itf,ipf)
      alphw = alphf(irf,itf,ipf)
      rhow = emdw**pinx
      prew = rhow*emdw
      hhw  = 1.0d0 + (pinx+1.0d0)*emdw
c
      utw  =       swflu *ram(irf,itf,ipf)/(alphw**2*hhw)
     &     +(1.0d0-swflu)*hhw/ber
c
      zfac = 1.0d0
      if (emdw.le.0.0d0) zfac = 0.0d0
      rhoHw = hhw*rhow*(alphw*utw)**2 - prew
      rps = -hhw*rhow + 4.0d0*prew + rhoHw
c
      souf(irf,itf,ipf) = 4.0d0*pi*alphw*psiw**6*rps
  120 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine alpsm_source(soug,soub,souf)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metfl.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_grav.f'
      include 'common_blocks/CB_excurvBY_bh.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / flusw / swflu
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), 
     &          soub(0:nnrb,0:nntb,0:nnpb),
     &          souf(0:nnr,0:nnt,0:nnp)
c
c --  haijaij = psi^12 aijaij
c
      fac78 = 7.0d0/8.0d0
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      psiw = psi(irg,itg,ipg)
      alphw = alph(irg,itg,ipg)
      psiwm7 = 1.0d0/psiw**7
      haijaijw = haijaij(irg,itg,ipg)
      soug(irg,itg,ipg) = fac78*alphw*psiwm7*haijaijw
  100 continue
c
c
      do 110 ipb = 0, npb
      do 110 itb = 0, ntb
      do 110 irb = 0, nrb
      psiw = psib(irb,itb,ipb)
      alphw = alphb(irb,itb,ipb)
      psiwm7 = 1.0d0/psiw**7
      haijaijw = haijaijb(irb,itb,ipb)
      soub(irb,itb,ipb) = fac78*alphw*psiwm7*haijaijw
  110 continue
c
c
      do 120 ipf = 0, npf
      do 120 itf = 0, ntf
      do 120 irf = 0, nrf
      emdw = emd(irf,itf,ipf)
      ramw = ram(irf,itf,ipf)
      psiw = psif(irf,itf,ipf)
      alphw = alphf(irf,itf,ipf)
      rhow = emdw**pinx
      prew = rhow*emdw
      hhw  = 1.0d0 + (pinx+1.0d0)*emdw
c
      utw  =       swflu *ram(irf,itf,ipf)/(alphw**2*hhw)
     &     +(1.0d0-swflu)*hhw/ber
c
      zfac = 1.0d0
      if (emdw.le.0.0d0) zfac = 0.0d0
      rhoHw = hhw*rhow*(alphw*utw)**2 - prew
      rp2s = 3.0d0*hhw*rhow*(alphw*utw)**2 
     &     - 2.0d0*hhw*rhow + 5.0d0*prew
c
      souf(irf,itf,ipf) = 2.0d0*pi*alphw*psiw**5*rp2s
  120 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine linmom_source(souf)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metfl.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / flusw / swflu
c
      dimension gradv(0:nnr,0:nnt,0:nnp,1:3)
      dimension souf(0:nnr,0:nnt,0:nnp)
c
c --  haijaij = psi^12 aijaij
c
      call flgrad4(vep,gradv,rs,1,0)
c
      do 120 ipf = 0, npf
      do 120 itf = 0, ntf
      do 120 irf = 0, nrf
      emdw = emd(irf,itf,ipf)
      ramw = ram(irf,itf,ipf)
      psiw = psif(irf,itf,ipf)
      alphw = alphf(irf,itf,ipf)
      rhow = emdw**pinx
      prew = rhow*emdw
      hhw  = 1.0d0 + (pinx+1.0d0)*emdw
c
      utw  =       swflu *ram(irf,itf,ipf)/(alphw**2*hhw)
     &     +(1.0d0-swflu)*hhw/ber
c
      zfac = 1.0d0
      if (emdw.le.0.0d0) zfac = 0.0d0
      ovyfdw = ovyuf(irf,itf,ipf)
c --  Fluid
c
      oterm = swflu *gradv(irf,itf,ipf,2)
     &      +(1.0d0-swflu)*ovyfdw
c
      zfac = 1.0d0
      if (emdw.le.0.0d0) zfac = 0.0d0
      rjj =       swflu *rhow*alphw*utw*oterm 
     &    +(1.0d0-swflu)*hhw*rhow*alphw*utw**2*psiw**4*oterm
c
      souf(irf,itf,ipf) = rjj*psiw**6*zfac
c
  120 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine angmom_source(souf)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metfl.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / flusw / swflu
c
      dimension gradv(0:nnr,0:nnt,0:nnp,1:3)
      dimension souf(0:nnr,0:nnt,0:nnp)
c
c --  haijaij = psi^12 aijaij
c
      call flgrad4(vep,gradv,rs,1,0)
c
      do 120 ipf = 0, npf
      do 120 itf = 0, ntf
      do 120 irf = 0, nrf
      emdw = emd(irf,itf,ipf)
      ramw = ram(irf,itf,ipf)
      psiw = psif(irf,itf,ipf)
      alphw = alphf(irf,itf,ipf)
      rhow = emdw**pinx
      prew = rhow*emdw
      hhw  = 1.0d0 + (pinx+1.0d0)*emdw
c
      utw  =       swflu *ram(irf,itf,ipf)/(alphw**2*hhw)
     &     +(1.0d0-swflu)*hhw/ber
c
      zfac = 1.0d0
      if (emdw.le.0.0d0) zfac = 0.0d0
c
      ovxfdw = ovxuf(irf,itf,ipf)
      ovyfdw = ovyuf(irf,itf,ipf)
      ovzfdw = ovzuf(irf,itf,ipf)
c
      vphix = vphif(irf,itf,ipf,1)
      vphiy = vphif(irf,itf,ipf,2)
      vphiz = vphif(irf,itf,ipf,3)
c
c --  Fluid
c
      otermx = swflu *gradv(irf,itf,ipf,1)
     &       +(1.0d0-swflu)*  ovxfdw
      otermy = swflu *gradv(irf,itf,ipf,2)
     &       +(1.0d0-swflu)*  ovyfdw
      otermz = swflu *gradv(irf,itf,ipf,3)
     &       +(1.0d0-swflu)*  ovzfdw
c
      zfac = 1.0d0
      if (emdw.le.0.0d0) zfac = 0.0d0
      rjjx =       swflu *rhow*alphw*utw*otermx 
     &     +(1.0d0-swflu)*hhw*rhow*alphw*utw**2*psiw**4*otermx
      rjjy =       swflu *rhow*alphw*utw*otermy 
     &     +(1.0d0-swflu)*hhw*rhow*alphw*utw**2*psiw**4*otermy
      rjjz =       swflu *rhow*alphw*utw*otermz 
     &     +(1.0d0-swflu)*hhw*rhow*alphw*utw**2*psiw**4*otermz
c
      rjjphi = rjjx*vphix + rjjy*vphiy + rjjz*vphiz
      souf(irf,itf,ipf) = rjjphi*psiw**6*zfac
c
  120 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine dipole_psi_source(soug,soub)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), 
     &          soub(0:nnrb,0:nntb,0:nnpb)
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      psiw = psi(irg,itg,ipg)
      xxx = rg(irg)*sintheg(itg)*cosphig(ipg) - orbc
      soug(irg,itg,ipg) = xxx*psiw
  100 continue
c
c
      do 110 ipb = 0, npb
      do 110 itb = 0, ntb
      do 110 irb = 0, nrb
      psiw = psib(irb,itb,ipb)
      xxx = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - orbc
      soub(irb,itb,ipb) = xxx*psiw
  110 continue
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine halfsou_gr(soug,ixysym)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), fnc(0:nnrg,0:nntg,0:nnpg)
      dimension x4(4), f4(4)
c
      tnsym = dble(ixysym)
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      fnc(irg,itg,ipg) = soug(irg,itg,ipg)
  100 continue
c
      do 101 ipg = 0, npg
      do 101 itg = 0, ntg
      do 101 irg = 1, nrtot
      hhrr = hrg(irg)
      ir0 = min0(irg-2,nrtot-3)
      do 102 ii = 1, 4
      irg0 = ir0 + ii - 1
      irga = iabs(irg0)
      irg0sg = isign(1,irg0)
      ipgcx = (1-irg0sg)/2*mod(ipg+npg/2+npg,npg) + (1+irg0sg)/2*ipg
      facr = dble((1-irg0sg)/2)*tnsym + dble((1+irg0sg)/2)
      x4(ii)  = rg(irga)*dble(irg0sg)
      f4(ii) = facr*fnc(irga,itg,ipgcx)      
  102 continue
      soug(irg,itg,ipg) = fn_lagint(x4,f4,hhrr)
  101 continue
c
      do 105 ipg = 0, npg
      do 105 itg = 0, ntg
      soug(0,itg,ipg) = 0.0d0
  105 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine halfsou_bh(soub,ixysym)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension soub(0:nnrb,0:nntb,0:nnpb), fnc(0:nnrb,0:nntb,0:nnpb)
      dimension x4(4), f4(4)
c
      tnsym = dble(ixysym)
c
      do 110 ipb = 0, npb
      do 110 itb = 0, ntb
      do 110 irb = 0, nrb
      fnc(irb,itb,ipb) = soub(irb,itb,ipb)
  110 continue
c
      do 111 ipb = 0, npb
      do 111 itb = 0, ntb
      do 111 irb = 1, nrb
      hhrr = hrb(irb)
      ir0 = min0(irb-2,nrb-3)
      do 112 ii = 1, 4
      irb0 = ir0 + ii - 1
      irba = iabs(irb0)
      irb0sg = isign(1,irb0)
      ipbcx = (1-irb0sg)/2*mod(ipb+npb/2+npb,npb) + (1+irb0sg)/2*ipb
      facr = dble((1-irb0sg)/2)*tnsym + dble((1+irb0sg)/2)
      x4(ii) = rb(irba)*dble(irb0sg)
      f4(ii) = facr*fnc(irba,itb,ipbcx)
  112 continue
      soub(irb,itb,ipb) = fn_lagint(x4,f4,hhrr)
  111 continue
c
      do 115 ipb = 0, npb
      do 115 itb = 0, ntb
      soub(0,itb,ipb) = 0.0d0
  115 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine vol_int_fluid(souf,rs,vol)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/CB_weight_fluid.f'
c
      dimension souf(0:nnr,0:nnt,0:nnp), rs(0:nnt,0:nnp)
c
c --  1/4 domain
c
      vol = 0.0d0
      do 100 ipf = 0, npf
      do 100 itf = 0, ntf
      do 100 irf = 0, nrf
      wei = rs(itf,ipf)**3*wahop(irf,itf,ipf)
      vol = vol + souf(irf,itf,ipf)*wei
 100  continue
c
      vol = 4.0d0*vol
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine vol_int_bh(soub,vol,ixysym)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/CB_weight_bh.f'
c
      dimension soub(0:nnrb,0:nntb,0:nnpb)
c
c --  half domain
c
      call halfsou_bh(soub,ixysym)
c
      vol = 0.0d0
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
      do 100 irb = 1, nrbin
      wei = wgrtpb(irb,itb,ipb)
      vol = vol + soub(irb,itb,ipb)*wei
 100  continue
c
      vol = 2.0d0*vol
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine vol_int_gr(soug,vol,ixysym)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/CB_weight_grav.f'
c
      common / ifhgb / ihrgbiin(0:nntg,0:nnpg),
     &                 ihrgbiou(0:nntg,0:nnpg),
     &                 ihtgbi(0:nnrg,0:nnpg),
     &                 ihpgbiin(0:nnrg,0:nntg),
     &                 ihpgbiou(0:nnrg,0:nntg)
c
      dimension soug(0:nnrg,0:nntg,0:nnpg)
c
c --  half domain
c
      call halfsou_gr(soug,ixysym)
c
      vol = 0.0d0
      do 1001 irr = 1, nrtot
      do 1001 itt = 0, ntg
c
      ipin = ihpgbiin(irr,itt)
      ipou = ihpgbiou(irr,itt)
c
      if (ipou.eq.0) go to 1404
      do 1401 ipp = 0, ipin
      wei = wmrtpg(irr,itt,ipp)
      vol = vol + soug(irr,itt,ipp)*wei
 1401 continue
 1404 continue
      do 1402 ipp = ipou, npg
      wei = wmrtpg(irr,itt,ipp)
      vol = vol + soug(irr,itt,ipp)*wei
 1402 continue
c
 1001 continue
c
      vol = 2.0d0*vol
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine admmass(iswitch)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_bhphy.f'
      include 'common_blocks/CB_weight_grav.f'
      include 'common_blocks/CB_excurvBY_grav.f'
c
      dimension pydat(0:nnrg), admmdat(0:nnrg), 
     &        rkomdat(0:nnrg), angjdat(0:nnrg)
      dimension cdbvd(3,3), gradbx(3), gradby(3), gradbz(3)
      dimension aij(3,3), baij(3,3), haij(3,3)
      dimension snvd(3), snvu(3), vphig(3)
c
c --
c
      irg10 = nrtot
      do 4 irg = nrtot, 0, -1
      if (rg(irg).ge.10.0d0*pi/ome) irg10 = irg
    4 continue
      irgini = min0(nrtot-15,irg10)
      nrgend = nrtot - 5
      npoi = nrgend - irgini + 1
c
      do 10 irg = irgini, nrgend
      admm = 0.0d0
      rkom = 0.0d0
      angj = 0.0d0
      py   = 0.0d0
c
      do 20 ipg = 0, npg
      do 20 itg = 0, ntg
c
      psic = psi(irg,itg,ipg)
      psiw = psi(irg,itg,ipg)
      alphw = alph(irg,itg,ipg)
      wds  = rg(irg)**2*w4dtg(itg)*w4dpg(ipg)
      w2ds = psic**2*wds
      w6ds = psic**6*wds
      rx = sintheg(itg)*cosphig(ipg)
      ry = sintheg(itg)*sinphig(ipg)
      rz = costheg(itg)
c
c --  baij = 2\alpha aij
c --   aij = psi^{-6} haij
c
      haij(1,1) = haxxd(irg,itg,ipg)
      haij(2,2) = hayyd(irg,itg,ipg)
      haij(3,3) = hazzd(irg,itg,ipg)
      haij(1,2) = haxyd(irg,itg,ipg)
      haij(1,3) = haxzd(irg,itg,ipg)
      haij(2,3) = hayzd(irg,itg,ipg)
      haij(2,1) = haij(1,2)
      haij(3,1) = haij(1,3)
      haij(3,2) = haij(2,3)
      facap6 = 2.0d0*alphw/psiw**6
      baij(1,1) = facap6*haxxd(irg,itg,ipg)
      baij(2,2) = facap6*hayyd(irg,itg,ipg)
      baij(3,3) = facap6*hazzd(irg,itg,ipg)
      baij(1,2) = facap6*haxyd(irg,itg,ipg)
      baij(1,3) = facap6*haxzd(irg,itg,ipg)
      baij(2,3) = facap6*hayzd(irg,itg,ipg)
      baij(2,1) = baij(1,2)
      baij(3,1) = baij(1,3)
      baij(3,2) = baij(2,3)
      facp6 = 1.0d0/psiw**6
      aij(1,1) = facp6*haxxd(irg,itg,ipg)
      aij(2,2) = facp6*hayyd(irg,itg,ipg)
      aij(3,3) = facp6*hazzd(irg,itg,ipg)
      aij(1,2) = facp6*haxyd(irg,itg,ipg)
      aij(1,3) = facp6*haxzd(irg,itg,ipg)
      aij(2,3) = facp6*hayzd(irg,itg,ipg)
      aij(2,1) = aij(1,2)
      aij(3,1) = aij(1,3)
      aij(3,2) = aij(2,3)
c
      snvd(1) = sintheg(itg)*cosphig(ipg)
      snvd(2) = sintheg(itg)*sinphig(ipg)
      snvd(3) = costheg(itg)
      snvu(1) = sintheg(itg)*cosphig(ipg)
      snvu(2) = sintheg(itg)*sinphig(ipg)
      snvu(3) = costheg(itg)      
      vphig(1) = - rg(irg)*sintheg(itg)*sinphig(ipg)
      vphig(2) = - orbc + rg(irg)*sintheg(itg)*cosphig(ipg)
      vphig(3) = 0.0d0
c
      call grderiv1rg(psi,grpsi,irg,itg,ipg,1,1,1)
      call grderiv1rg(alph,gralp,irg,itg,ipg,1,1,1)
      rjphir = aij(1,1)*vphig(1)*snvd(1) + aij(2,1)*vphig(2)*snvd(1)
     &       + aij(1,2)*vphig(1)*snvd(2) + aij(2,2)*vphig(2)*snvd(2)
     &       + aij(1,3)*vphig(1)*snvd(3) + aij(2,3)*vphig(2)*snvd(3)
c
      admm = admm + grpsi*wds
      rkom = rkom + gralp*w2ds
      angj = angj + rjphir*w6ds
      py = py + (aij(2,1)*rx + aij(2,2)*ry + aij(2,3)*rz)*w6ds
c
   20 continue
      admmdat(irg) = - 1.0d0/(2.0d0*pi)*admm*radi*2.0d0
      rkomdat(irg) =   1.0d0/(4.0d0*pi)*rkom*radi*2.0d0
      angjdat(irg) =   1.0d0/(8.0d0*pi)*angj*radi**2*2.0d0
      pydat(irg)   =   1.0d0/(8.0d0*pi)*py*radi*2.0d0
   10 continue
c
      ave = dble(nrgend - irgini + 1)
      s1 = 0.0d0
      s2 = 0.0d0
      s3 = 0.0d0
      s4 = 0.0d0
      do 30 irg = irgini, nrgend
      s1  = s1  + admmdat(irg)
      s2  = s2  + rkomdat(irg)
      s3  = s3  + angjdat(irg)
      s4  = s4  + pydat(irg)
      if (iswitch.eq.0)
     &write(6,820) irg, rg(irg), admmdat(irg), rkomdat(irg), 
     &    angjdat(irg), pydat(irg)
      if (iswitch.eq.1)
     &write(34,821) irg, rg(irg), admmdat(irg), rkomdat(irg), 
     &    angjdat(irg), angjdat(irg)/admmdat(irg)**2, pydat(irg)
   30 continue
c
      fitadm = s1/ave
      fitkom = s2/ave
      fitang = s3/ave
      fitpy = s4/ave
c
      fitvir = dabs((fitadm-fitkom)/fitadm)
c
  820 format(1i5,1p,7e12.4)
  821 format(1i5,1p,7e18.10)
c
      end
c
