c ==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+=
c      program ahfind
      subroutine ahfind(iahwrite)
c ==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+=
c
c     Apparent horizon finder.
c
c ###      phib is taken from 0 to 2 pi.
c
c ==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+=
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
      include 'common_blocks/CB_param_phisp.f'
c
c      common / cordp / dis, radint, radext, ding, rvout, radmid, ngdin
c      common / bhpar / bhrad, bhspin, bhmass, bhdis, pat, patfac, bhfac
c      common / calcp / ome, ber, radi
c      common / phisp / pinx, surr, ratio, ratmas, sepato, 
c     &                 g, pi, emdc, ipolar
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, iwrite
c
      common / aphzn / ahz(0:nntb,0:nnpb)
      dimension sou(0:nntb,0:nnpb)
      dimension potb(0:nntb,0:nnpb),backb(0:nntb,0:nnpb)
c
      character*10 cherr
c
c --- Constants.  
c
      g = 6.6726d-8
      pi = 3.14159265358979d+0
c
c      write(6,*) ' --  AH finder -- '
c
c --  Initialize
c
      do 10 ipb = 0, npb
      do 10 itb = 0, ntb
      ahz(itb,ipb) = (bhrad + radint)/2.0d0
   10 continue
c
      convf0 = 0.1d0
      fffacini = 1.0d0
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c     Iteration starts.  
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      fmin = fffacini
      iter = 0
      epsmaxb = 0.0d0
      epsmax = 0.0d0
c
 2444 continue 
c 
      iter = iter + 1 
      fcon = convf0*dble(iter)
      fffah = dmin1( fmin, fcon)
c
c --- Start computation.  
c
ccc      write(6,*) ' #### Iteration NO. = ', iter
c
c
      do 3000 ipb = 0, npb
      do 3000 itb = 0, ntb
      sou(itb,ipb) = 0.0d0
      potb(itb,ipb) = 0.0d0
      backb(itb,ipb) = ahz(itb,ipb)
 3000 continue
c
c --- Compute source terms.
c
      call source_ah(sou)
c 
c --- Call Poisson solver.
c
      call apho_gravsf4(sou,potb,0,0,0)
c
c --  Check error.
c
      call aherror(backb,potb,epsmaxb,itber,ipber)
      epsmax = epsmaxb
cca      epsmax = dmax1(epsmaxb,epsmax)
c
      cherr = ' AH error '
      if (iter.eq.itmx.or.epsmax.le.eps) then
      write(6,*) ' ##  AH finder iteration NO. = ', iter
      write(6,4904) cherr, itber, ipber, 
     & backb(itber,ipber), potb(itber,ipber), epsmax
      end if
 4904 format(a10,2i5,1p,3e12.4)
c
c --  Update variables.
c
      call ahimpro(potb,backb,fffah)
c
      do 3010 ipb = 0, npb
      do 3010 itb = 0, ntb
      ahz(itb,ipb) = potb(itb,ipb)
 3010 continue
c
c --- Untill convergence is made, go to 2444.
c
      if (iter.eq.itmx.or.epsmax.le.eps) go to 2445
      go to 2444
 2445 continue
c
c --- Print out the converged state.
c
c      call aharea(aharea)
      if (iahwrite.eq.1) call subio_ah
c
      if (iter.eq.itmx.and.epsmax.gt.eps) write(6,*) ' **iter** '
c
 1400 continue
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine source_ah(sou)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_bh.f'
c
      common / aphzn / ahz(0:nntb,0:nnpb)
c
      dimension sou(0:nntb,0:nnpb)
      dimension dfn(0:nntb,0:nnpb)
      dimension fnc0(nnrb0:nnrb,0:nntb,0:nnpb),
     &          fnc2(0:nntb,0:nnpb)
c
      dimension trkij(nnrb0:nnrb,0:nntb,0:nnpb)
      dimension allog(nnrb0:nnrb,0:nntb,0:nnpb)
c
      dimension gamd(3,3),gamu(3,3),sgmu(3,3)
      dimension grad(3),gradp(3),gradbx(3),gradby(3),gradbz(3)
      dimension gradbv(3,3),cdbvd(3,3)
c
      dimension aij(3,3), baij(3,3), haij(3,3)
      dimension grada(3)
      dimension r4(4), f4(4)
c
c --- Compute source terms for volume integrals.
c
      fac23 = 2.0d0/3.0d0
c
      do 10 ipb = 0, npb
      do 10 itb = 0, ntb
      call grgradFrh(ahz,grad,itb,ipb,0)
      dfn(itb,ipb) = 
     &   dsqrt(dabs(grad(1)*grad(1)+grad(2)*grad(2)+grad(3)*grad(3)))
      dfnw = dfn(itb,ipb)
      do 10 irb = 0, nrb
      psi4 = psib(irb,itb,ipb)**4
      fnc0(irb,itb,ipb) = dlog(psi4/dfnw)
   10 continue
c
      do 20 ipb = 0, npb
      do 20 itb = 0, ntb
      rbv = ahz(itb,ipb)
      do 21 irb = 0, nrb-1
      detr = (rb(irb+1)-rbv)*(rb(irb)-rbv)
      if(detr.le.0.0d0) then
      irb0 = irb
      go to 30
      end if
   21 continue
   30 continue
      ir0 = min0(max0(irb0-1,0),nrb-3)
c
      rbv = ahz(itb,ipb)
      call grgradFrh(ahz,grad,itb,ipb,0)
      dfnw = dfn(itb,ipb)
      sxd = grad(1)/dfnw
      syd = grad(2)/dfnw
      szd = grad(3)/dfnw
      sxu = sxd
      syu = syd
      szu = szd
c
      sgmu(1,1) = 1.0d0 - sxu*sxu
      sgmu(1,2) =       - sxu*syu
      sgmu(1,3) =       - sxu*szu
      sgmu(2,1) =       - syu*sxu
      sgmu(2,2) = 1.0d0 - syu*syu
      sgmu(2,3) =       - syu*szu
      sgmu(3,1) =       - szu*sxu
      sgmu(3,2) =       - szu*syu
      sgmu(3,3) = 1.0d0 - szu*szu
c
c
      do 22 ii = 1, 4
      irb = ir0-1 + ii
      r4(ii) = rb(irb)
c
      psiw = psib(irb,itb,ipb)
      alphw = alphb(irb,itb,ipb)
c
      call grgrad1b(fnc0,gradp,irb,itb,ipb,0)
c
      dlpfdf = grad(1)*gradp(1) + grad(2)*gradp(2) + grad(3)*gradp(3)
c
c --  Aij.
c --   aij = psi^{-6} haij
c
      haij(1,1) = haxxdb(irb,itb,ipb)
      haij(2,2) = hayydb(irb,itb,ipb)
      haij(3,3) = hazzdb(irb,itb,ipb)
      haij(1,2) = haxydb(irb,itb,ipb)
      haij(1,3) = haxzdb(irb,itb,ipb)
      haij(2,3) = hayzdb(irb,itb,ipb)
      haij(2,1) = haij(1,2)
      haij(3,1) = haij(1,3)
      haij(3,2) = haij(2,3)
      facp6 = 1.0d0/psiw**6
      aij(1,1) = facp6*haxxdb(irb,itb,ipb)
      aij(2,2) = facp6*hayydb(irb,itb,ipb)
      aij(3,3) = facp6*hazzdb(irb,itb,ipb)
      aij(1,2) = facp6*haxydb(irb,itb,ipb)
      aij(1,3) = facp6*haxzdb(irb,itb,ipb)
      aij(2,3) = facp6*hayzdb(irb,itb,ipb)
      aij(2,1) = aij(1,2)
      aij(3,1) = aij(1,3)
      aij(3,2) = aij(2,3)
c 
c --  trk = 0
c
      term2 = 0.0d0
      do 23 ib = 1,3
      do 23 ia = 1,3
      term2 = term2 + aij(ia,ib)*sgmu(ia,ib)
   23 continue
      pdfkabsab = psiw**2*dfnw*term2
c
      f4(ii) = dlpfdf - pdfkabsab
c
   22 continue
c
      sou(itb,ipb) = rbv**2*fn_lagint(r4,f4,rbv)
c
   20 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgradFrh(fnc,grad1,itb,ipb,nrb0p)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension fnc(0:nntb,0:nnpb),
     &          fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function r - h(th,phi).  
c --- derivatives are evaluated at r = h(th,phi).  
c
      irb = nrb/2 
      ir0 = min0(max0(irb-2,nrb0p),nrb-4)
      it0 = min0(max0(itb-2,0),ntb-4)
ccc      ip0 = min0(max0(ipb-2,0),npb-4)
c ##  phib = 0 to 2pi      
      ip0 = ipb
c
c ##  phib = 0 to 2pi
      npnp = npb/4
c
      do 8 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r5(ii) = rb(irb0)
      th5(ii) = thb(itb0)
ccc      phi5(ii) = phib(ipb0)
c
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-3+npb,npb) 
      phi5(ii) = phib(ip0) + dphib*dble(ii-3)
c
c --  version r(0) > 0,  cf) subroutine grgrad1b0.
c
      if (itb.eq.0) then
      fr5(ii) = fnc(itb0,0)
      ft5(ii) = fnc(itb0,npnp)
      fp5(ii) = rb(irb0)
      else
      fr5(ii) = rb(irb0)
      ft5(ii) = fnc(itb0,ipb)
      fp5(ii) = fnc(itb,ipb0)
      end if
    8 continue
c
      rbv = fnc(itb,ipb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinv = 1.0d0/rbv
c
c --- To cartesian component.  
c
      if (itb.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tbv)*rrbbinv
      grad1(2) = dfncdx(th5,ft5,tbv)*rrbbinv
cc      grad1(3) = dfncdx(r5,fp5,rbv)
      grad1(3) = 1.0d0
      else
cc      gr1 = dfncdx(r5,fr5,rbv)
      gr1 = 1.0d0
      gr2 = dfncdx(th5,ft5,tbv)*rrbbinv
      gr3 = dfncdx(phi5,fp5,pbv)*rrbbinv*cosecb(itb)
      grad1(1) = gr1*sintheb(itb)*cosphib(ipb)
     &         + gr2*costheb(itb)*cosphib(ipb)  
     &         - gr3*sinphib(ipb) 
      grad1(2) = gr1*sintheb(itb)*sinphib(ipb)
     &         + gr2*costheb(itb)*sinphib(ipb)
     &         + gr3*cosphib(ipb) 
      grad1(3) = gr1*costheb(itb)
     &         - gr2*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgradS2(fnc,grad1,itb,ipb)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension fnc(0:nntb,0:nnpb),
     &          fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function f(th,phi).  
c --- derivatives are evaluated at r = h(th,phi).  
c
      it0 = min0(max0(itb-2,0),ntb-4)
ccc      ip0 = min0(max0(ipb-2,0),npb-4)
c ##  phib = 0 to 2pi      
      ip0 = ipb
c
c ##  phib = 0 to 2pi
      npnp = npb/4
c
      do 8 ii = 1, 5
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      th5(ii) = thb(itb0)
ccc      phi5(ii) = phib(ipb0)
c
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-3+npb,npb) 
      phi5(ii) = phib(ip0) + dphib*dble(ii-3)
c
c --  f = h(theta,phi)
c
      if (itb.eq.0) then
      fr5(ii) = fnc(itb0,0)
      ft5(ii) = fnc(itb0,npnp)
      fp5(ii) = 0.0d0
      else
      fr5(ii) = 0.0d0
      ft5(ii) = fnc(itb0,ipb)
      fp5(ii) = fnc(itb,ipb0)
      end if
    8 continue
c
      rbv = fnc(itb,ipb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinv = 1.0d0/rbv
c
c --- To cartesian component.  
c
      if (itb.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tbv)*rrbbinv
      grad1(2) = dfncdx(th5,ft5,tbv)*rrbbinv
      grad1(3) = 0.0d0
      else
      gr1 = 0.0d0
      gr2 = dfncdx(th5,ft5,tbv)*rrbbinv
      gr3 = dfncdx(phi5,fp5,pbv)*rrbbinv*cosecb(itb)
      grad1(1) = gr1*sintheb(itb)*cosphib(ipb)
     &         + gr2*costheb(itb)*cosphib(ipb)  
     &         - gr3*sinphib(ipb) 
      grad1(2) = gr1*sintheb(itb)*sinphib(ipb)
     &         + gr2*costheb(itb)*sinphib(ipb)
     &         + gr3*cosphib(ipb) 
      grad1(3) = gr1*costheb(itb)
     &         - gr2*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine apho_gravsf4(sou,pot,iesy,ilini,imini)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_weight_bh.f'
c
      common / trmpb / sinmpb(0:nnlb,0:nnpb), cosmpb(0:nnlb,0:nnpb)
      common / brleg / pnab(0:nnlb,0:nnlb,0:nntb),
     &               facnmb(0:nnlb,0:nnlb), epsib(0:nnlb)
c
      dimension  pot(0:nntb,0:nnpb)
      dimension  sou(0:nntb,0:nnpb)
      dimension work1c(0:nntb,0:nnlb), 
     &          work2c(0:nnlb,0:nnlb), 
     &          work4c(0:nnlb,0:nntb)
      dimension work1s(0:nntb,0:nnlb), 
     &          work2s(0:nnlb,0:nnlb), 
     &          work4s(0:nnlb,0:nntb)
c
c --- Gravitational and Velocity potential is caluculated. ---
c
c     L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(th) sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c
c     pi-rotation (anti-)symmetry.
c
c     iesy --> 0 for equatorially symmetric source.
c              1 for equatorially anti-symmetric source.
c     ilini --> start of summation for index l. 
c     imini --> start of summation for index m. 
c              
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c   work1(itt,im) = sum_ipp (scmp(im,ipp)*sou(itt,ipp))
c   work2(il,im) = sum_itt (pn(il,im,itt)*work1(itt,im))
c   work4(im,it) = sum_il (pn(il,im,it)*work2(il,im))
c   pot(it,ip) = sum_im (scmp(im,ip)*work4(im,it))
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c      write(6,*)' grav4sf  '
c
      do 1001 im = 0, nlb
      do 1001 itt = 0, ntb
      work1c(itt,im) = 0.0d0
      work1s(itt,im) = 0.0d0
      do 1001 ipp = 0, npb
      wok = w4dtb(itt)*w4dpb(ipp)*sou(itt,ipp)
      work1c(itt,im) = work1c(itt,im) + wok*cosmpb(im,ipp)
      work1s(itt,im) = work1s(itt,im) + wok*sinmpb(im,ipp)
 1001 continue
c
      do 1002 il = 0, nlb
      do 1002 im = 0, nlb
      pari = 1.0d0 + (-1.0d0)**(il+im+iesy)
      pef  = pari*epsib(im)*facnmb(il,im)
      work2c(il,im) = 0.0d0
      work2s(il,im) = 0.0d0
      do 1002 itt = 0, ntb
      wok = pef*pnab(il,im,itt)
      work2c(il,im) = work2c(il,im) + wok*work1c(itt,im)
      work2s(il,im) = work2s(il,im) + wok*work1s(itt,im)
 1002 continue
c
      do 1004 it = 0, ntb
      do 1004 im = 0, nlb
      work4c(im,it) = 0.0d0
      work4s(im,it) = 0.0d0
      do 1004 il = 0, nlb
      ell = dble(il)
      facl = (2.0d0*ell+1.0d0)/(ell*(ell+1.0d0)+2.0d0)
      wok = pnab(il,im,it)*facl
      work4c(im,it) = work4c(im,it) + wok*work2c(il,im)
      work4s(im,it) = work4s(im,it) + wok*work2s(il,im)
 1004 continue
c
      do 1000 ip = 0, npb
      do 1000 it = 0, ntb
      pot(it,ip) = 0.0d0
      do 1000 im = 0, nlb
      pot(it,ip) = pot(it,ip)
     &           + work4c(im,it)*cosmpb(im,ip)
     &           + work4s(im,it)*sinmpb(im,ip)
 1000 continue
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      pi4aho = - pi4inv
c
      do 100 ip = 0, npb
      do 100 it = 0, ntb
 100  pot(it,ip) = pi4aho*pot(it,ip)
c
      end
c
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine aherror(backb,rnewb,epsmaxb,itber,ipber)
c
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension rnewb(0:nntb,0:nnpb),backb(0:nntb,0:nnpb)
c
c --- Set improved values for quantities on GR-coordinate and 
c --- convergence check.  
c
      epsmaxb = 0.0d0
      do 400 ipb = 0, npb
      do 400 itb = 0, ntb
      edet  = rnewb(itb,ipb)
      edetb = backb(itb,ipb)
      devi  = dabs(rnewb(itb,ipb)) + dabs(backb(itb,ipb))
c      
      if (devi.ge.1.0d-8) then
      error = dabs(2.d0*(edet - edetb))/devi
      if(error .gt. epsmaxb) then
      epsmaxb = error
      itber = itb
      ipber = ipb
      end if
      end if
 400  continue
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine ahimpro(potb,backb,fffah)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension potb(0:nntb,0:nnpb),backb(0:nntb,0:nnpb)
c
      do 3004 ipb = 0, npb
      do 3004 itb = 0, ntb
      potb(itb,ipb) = (1.0d0-fffah)*backb(itb,ipb)
     &                     + fffah * potb(itb,ipb)
 3004 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subio_ah
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, iwrite
c
      common / aphzn / ahz(0:nntb,0:nnpb)
c
      open(30,file='bbhahz.dat',status='old')
c
c --- Apparent horizon.
c
      write(30,5000) nrb, ntb, npb, nlb
      write(30,5000) nrbov, msymb
      write(30,5000) ntg, npg, nlg, msymg
      write(30,5005) ngdin, nrout, rvout
      write(30,5001) ding, radint
      write(30,5002) itmx, eps, convf
      write(30,5005) iddd, numseq, bhcop
      write(30,5001) fffac,ffvep 
      write(30,5004) itype, iwrite, char
      write(30,5010) bhrad, bhmass, bhspin
      write(30,5010) ome,   patfac
      write(30,5011) bhfac, numseq
c
      write(30,4000) ome, ber, radi, orbc
c
c --  BH coordinate
      do 500 ipb = 0, npb
      write(30,4000) (ahz(itb,ipb), itb = 0, ntb)
 500  continue
c
      close(30)
c
 4000  format(1p,6e12.4)
 4999   format(' ')
c
 5000    format( 5i5)
 5001     format( 1p,2e10.3)
 5002      format( 1i5, 1p,2e10.3)
 5003       format( 1p,1e10.3, 1i4)
 5004        format( 2i5, 3x, a2)
 5005         format( 2i5, 1p,1e10.3)
 5010          format(1p,3e10.3)
 5011           format(1p,1e10.3,2i5)
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine find_aharea(aharea,ahmass)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_weight_bh.f'
c
      common / aphzn / ahz(0:nntb,0:nnpb)
c
      dimension r4(4), f4(4)
c
c --- Compute AH area.
c
      area = 0.0d0
      do 20 ipb = 0, npb
      do 20 itb = 0, ntb
      rbv = ahz(itb,ipb)
      do 21 irb = 0, nrb-1
      detr = (rb(irb+1)-rbv)*(rb(irb)-rbv)
      if(detr.le.0.0d0) then
      irb0 = irb
      go to 30
      end if
   21 continue
   30 continue
c
      ir0 = min0(max0(irb0-1,0),nrb-3)
      rbv = ahz(itb,ipb)
c
      do 22 ii = 1, 4
      irb = ir0-1 + ii
      r4(ii) = rb(irb)
      f4(ii) = psib(irb,itb,ipb)
   22 continue
c
      psiw = fn_lagint(r4,f4,rbv)
      wds = w4dtb(itb)*w4dpb(ipb)
      area = area + psiw**4*rbv**2*wds
c
   20 continue
c
      pi = 3.14159265358979d+0
c
      aharea = area*2.0d0
      ahmass = dsqrt(aharea/(16.0d0*pi))
c
      end
c
