c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine ram_fluid(gradv,ram)
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/CB_mesh_grav.f'
      include 'common_blocks/CB_mesh_fluid.f'
      include 'common_blocks/CB_shift_fluid.f'
      include 'common_blocks/CB_param_calcp.f'
c
      dimension gradv(0:nnr,0:nnt,0:nnp,3), ram(0:nnr,0:nnt,0:nnp)
c
c
ccc      bvyfg = bvyu(nrgmid,ntg,0)
      do 77 ip = 0, np
      do 77 it = 0, nt
      ir = 0
      bvyfc = bvyuf(ir,ntfeq,npfyz)
      vphiy = vphif(ir,ntfeq,npfyz,2)
      dyvp  = gradv(ir,ntfeq,npfyz,2)
      ram(ir,it,ip) = ber + (bvyfc + ome*vphiy)*dyvp
      do 77 ir = 1, nr
      bvxfc = bvxuf(ir,it,ip)
      bvyfc = bvyuf(ir,it,ip)
      bvzfc = bvzuf(ir,it,ip)
      vphix = vphif(ir,it,ip,1)
      vphiy = vphif(ir,it,ip,2)
      vphiz = vphif(ir,it,ip,3)
      dxvp  = gradv(ir,it,ip,1)
      dyvp  = gradv(ir,it,ip,2)
      dzvp  = gradv(ir,it,ip,3)
      ram(ir,it,ip) = ber + (bvxfc + ome*vphix)*dxvp
     &                    + (bvyfc + ome*vphiy)*dyvp
     &                    + (bvzfc + ome*vphiz)*dzvp
 77   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvfl(iddd)
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/CB_weight_fluid.f'
c
      common / extpt / cospmp(0:nnp,0:nnp), cosppp(0:nnp,0:nnp) 
      common / legen / spn(0:nnt,0:nnp,0:nnl), 
     &                 fsn(0:nnr,0:nnl,0:nnr)
      common / asleg / pna(0:nnla,0:nnla,0:nnt),
     &               dtpna(0:nnla,0:nnla,0:nnt), 
     &               facnm(0:nnla,0:nnla), epsi(0:nnla)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
      common / asylm / ypna(0:nnla,0:nnla,0:nnt),
     &               dtypna(0:nnla,0:nnla,0:nnt)
c
      dimension fac(0:nnla)
      dimension qp1(0:nnl), qp2(0:nnl), qp3(0:nnl), qp4(0:nnl)
c
c- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Set up of meshes  ---  ( r(1) = dr ( not the center ) )
c --- The constatnt msym means the symmetry of the configuration.
c
      pi = 3.14159265358979d+0
      dr   = 1.0d0/dble(nr)
      dth  = pi/2.d0/dble(nt)
      dphi = pi/dble(msym)/dble(np)
      drf   = dr
      dthf  = dth
      dphif = dphi
c
      drinv = 1.0d0/dr
      dthinv = 1.0d0/dth
      dphiinv = 1.0d0/dphi
      drfinv = drinv
      dthfinv = dthinv
      dphifinv = dphiinv
c
      do 100 ir = 0, nr
      r(ir) = dble(ir)*dr
      rf(ir) = r(ir)
  100 continue
      rinv( 0) = 0.d0
      rfinv(0) = rinv(0)
      do 104 ir = 1, nr
      rinv(ir) = 1.0d0/r(ir)
      rfinv(ir) = rinv(ir)
  104 continue      
c
      do 101 it = 0, nt
      th(it) = dble(it)*dth
      thf(it) = th(it)
  101 continue
      do 102 ip = 0, np
      phi(ip) = dble(ip)*dphi
      phif(ip) = phi(ip)
  102 continue
c
c --- cal. sine ,cosine and tange on grids of polar angle. ---
c --- notice ; tange diverge to infinity when agr=pi/2, j1=m
c
      do 121 it  = 0, nt
      sinthe(it) = dsin(th(it))
      costhe(it) = dcos(th(it))
      sinthef(it) = sinthe(it)
      costhef(it) = costhe(it)
  121 continue
      cosec( 0) = 0.0d0
      cosecf(0) = cosec(0)
      do 122 it = 1, nt
      cosec(it) = 1.0d0/dsin(th(it))
      cosecf(it)= cosec(it)
  122 continue
c
      do 124 ip  = 0, np
      sinphi(ip) = dsin(phi(ip))
      cosphi(ip) = dcos(phi(ip))
      sinphif(ip) = sinphi(ip)
      cosphif(ip) = cosphi(ip)
      do 124 nn  = 0, nla
      fnn = dble(nn)
      sinmp(nn,ip) = dsin(fnn*phi(ip))
      cosmp(nn,ip) = dcos(fnn*phi(ip))
  124 continue
c
      do 125 ip  = 0, np
      do 125 ipp = 0, np
      cospmp(ipp,ip) = dcos(phi(ip) - phi(ipp))
      cosppp(ipp,ip) = dcos(phi(ip) + phi(ipp))
  125 continue
c
c --- weight for integration.
c
      san1 = 1.0d0/3.0d0
      san4 = 4.0d0/3.0d0
      san2 = 2.0d0/3.0d0
      do 191 ip = 0, np
      if(ip.eq.0.or .ip.eq.np) wgdp(ip) = 0.5d0*dphi
      if(ip.ne.0.and.ip.ne.np) wgdp(ip) = 1.0d0*dphi
      if(ip.eq.0.or .ip.eq.np                   ) w4dp(ip) = san1*dphi
      if(ip.ne.0.and.ip.ne.np.and.mod(ip,2).eq.1) w4dp(ip) = san4*dphi
      if(ip.ne.0.and.ip.ne.np.and.mod(ip,2).eq.0) w4dp(ip) = san2*dphi
  191 continue
      do 192 it = 0, nt
      if(it.eq.0.or .it.eq.nt) wgdt(it) = 0.5d0*sinthe(it)*dth
      if(it.ne.0.and.it.ne.nt) wgdt(it) = 1.0d0*sinthe(it)*dth
      if(it.eq.0.or .it.eq.nt                   ) 
     &   w4dt(it) = san1*sinthe(it)*dth
      if(it.ne.0.and.it.ne.nt.and.mod(it,2).eq.1) 
     &   w4dt(it) = san4*sinthe(it)*dth
      if(it.ne.0.and.it.ne.nt.and.mod(it,2).eq.0) 
     &   w4dt(it) = san2*sinthe(it)*dth
  192 continue
      do 194 ir = 0, nr
      if(ir.eq.0.or .ir.eq.nr) wgdr(ir) = 0.5d0*r(ir)**2*dr
      if(ir.ne.0.and.ir.ne.nr) wgdr(ir) = 1.0d0*r(ir)**2*dr
      if(ir.eq.0.or .ir.eq.nr                   ) 
     &   w4dr(ir) = san1*r(ir)**2*dr
      if(ir.ne.0.and.ir.ne.nr.and.mod(ir,2).eq.1) 
     &   w4dr(ir) = san4*r(ir)**2*dr
      if(ir.ne.0.and.ir.ne.nr.and.mod(ir,2).eq.0) 
     &   w4dr(ir) = san2*r(ir)**2*dr
  194 continue
c
      do 195 ip = 0, np
      do 195 it = 0, nt
      do 195 ir = 0, nr
      wgrtp(ir,it,ip)=wgdr(ir)*wgdt(it)*wgdp(ip)
      w4rtp(ir,it,ip)=w4dr(ir)*w4dt(it)*w4dp(ip)
      if (iddd.ne.4) wahop(ir,it,ip) = wgrtp(ir,it,ip)
      if (iddd.eq.4) wahop(ir,it,ip) = w4rtp(ir,it,ip)
  195 continue
c
c --- computation of the legendre polynomials
c
      do 2001 ipp = 0, np
      do 2001 itt = 0, nt
c
      do 2002 il = 0, nl
      spn(itt,ipp,il) = 0.0d0
 2002 continue
c
      it = nt
      ip = np
      ssit  = dsin(th(it))
      ccit  = dcos(th(it))
      ssitt = dsin(th(itt))
      ccitt = dcos(th(itt))
      spitt = dsin(pi-th(itt))
      cpitt = dcos(pi-th(itt))
      corot = dcos(phi(ip)-phi(ipp))
      coref = dcos(phi(ip)+phi(ipp))
c
      cosg1 = ccit*ccitt+ssit*ssitt*corot
      cosg2 = ccit*cpitt+ssit*spitt*corot
      cosg3 = ccit*ccitt+ssit*ssitt*coref
      cosg4 = ccit*cpitt+ssit*spitt*coref
c
      qp1(0) = 1.0d+0
      qp1(1) = cosg1
      qp2(0) = 1.0d+0
      qp2(1) = cosg2
      qp3(0) = 1.0d+0
      qp3(1) = cosg3
      qp4(0) = 1.0d+0
      qp4(1) = cosg4
c
      do 2010 il = 2, nl
      b1 = 1.0d0-1.0d0/dble(il)
      b2 = 2.0d0-1.0d0/dble(il)
      qp1(il) = b2*cosg1*qp1(il-1)-b1*qp1(il-2)
      qp2(il) = b2*cosg2*qp2(il-1)-b1*qp2(il-2)
      qp3(il) = b2*cosg3*qp3(il-1)-b1*qp3(il-2)
      qp4(il) = b2*cosg4*qp4(il-1)-b1*qp4(il-2)
 2010 continue
c
      do 2014 il = 0, nl
       spn(itt,ipp,il) = spn(itt,ipp,il) 
     &     +   qp1(il)  +   qp2(il) +   qp3(il) +   qp4(il)
 2014 continue
c
 2001 continue
c
c ----------------------------------------------------------------------
c        The associated Legendre polynomials are computed.  
c 
c        nla : maximum value of n
c ----------------------------------------------------------------------
c
c --- computation of associated Legendre polynomials.
c
      do 2110 it = 0, nt
c
      cc = dcos(dth*dble(it))
      ss = dsin(dth*dble(it))
c
      do 2120 nn = 0, nla
      do 2120 mm = 0, nla
      pna(nn,mm,it)  = 0.0d0
      dtpna(nn,mm,it)  = 0.0d0
 2120 continue
c
      fac(0) = 1.0d0
      do 2121 mm = 1, nla
      fmm = dble(mm)
      fac(mm) = (2.0d0*fmm-1.0d0) * fac(mm-1)
 2121 continue
c
      pna(0,0,it) = 1.d0
      dtpna(0,0,it) = 0.d0
      do 2122 mm = 1, nla
        pna(mm,mm,it) = fac(mm) * (-ss)**mm 
 2122 continue
      mm = 1
      dtpna(mm,mm,it) = fac(mm) * dble(mm)*(-cc)
      do 2220 mm = 2, nla
      dtpna(mm,mm,it) = fac(mm) * dble(mm)*(-ss)**(mm-1)*(-cc)
 2220 continue
c
      do 2123 mm = 0, nla-1
      fmm = dble(mm)
        pna(mm+1,mm,it) = (2.0d0*fmm + 1.0d0)* cc*  pna(mm,mm,it)
      dtpna(mm+1,mm,it) = (2.0d0*fmm + 1.0d0)*(cc*dtpna(mm,mm,it)
     &                                  -ss*  pna(mm,mm,it))
 2123 continue
c
      do 2124 mm = 0, nla-2
      fmm = dble(mm)
      do 2124 kk = 2, nla-mm
      fkk = dble(kk)
      q1 = ( 2.0d0 * fmm + 2.0d0 * fkk - 1.0d0 ) / fkk
      q2 = ( 2.0d0 * fmm + fkk - 1.0d0 ) / fkk
      pna(mm+kk,mm,it) = q1 * cc * pna(mm+kk-1,mm,it)
     &                 - q2      * pna(mm+kk-2,mm,it)
      dtpna(mm+kk,mm,it) = q1 *(cc * dtpna(mm+kk-1,mm,it)
     &                        - ss *   pna(mm+kk-1,mm,it)) 
     &                   - q2      * dtpna(mm+kk-2,mm,it)
 2124 continue
c
 2110 continue
c
c -------------------------------
c --- Computation of factors. ---
c -------------------------------
c
      do 2139 nn = 0, nla
      do 2139 mm = 0, nla
      facnm(nn,mm) = 0.0d+0
 2139 continue
c
      facnm(0,0) = 1.0d0
      do 2140 nn = 1, nla
      fnn  = dble(nn)
      facnm(nn,0) = 1.0d0
      do 2140 mm = 1, nn
      fmm  = dble(mm)
      fnmfm= fnn-fmm + 1.0d0 
      facnm(nn,mm) = facnm(nn,mm-1)/(fnn+fmm)/fnmfm
 2140 continue
c
      do 2141 mm = 0, nla 
      epsi(mm) = 2.0d+0 
      if (mm.eq.0) epsi(mm) = 1.0d+0 
 2141 continue
c
      do 2142 it = 0, nt
      do 2142 nn = 0, nla
      do 2142 mm = 0, nn
        ypna(nn,mm,it) = (epsi(mm)*(2.0d0*dble(nn)+1.0d0)/(4.0d0*pi)*
     &                   facnm(nn,mm))**0.5d0*pna(nn,mm,it)
      dtypna(nn,mm,it) = (epsi(mm)*(2.0d0*dble(nn)+1.0d0)/(4.0d0*pi)*
     &                   facnm(nn,mm))**0.5d0*dtpna(nn,mm,it)
 2142 continue
c
c ------------------------------------
c --- Computation of functoin fsn. ---
c ------------------------------------
c
c    fsn(irr,nn,id,ir) --> id =  0 for rs'*r' < rs*r
c                          id = +1 for rs*r < rs'*r'
c
      do 418 nn  = 0, nl
      do 418 ir  = 0, nr
      do 418 irr = 0, nr
        fsn(irr,nn,ir) = 0.d0
  418 continue
c
      do 419 ir  = 1, nr
      do 419 irr = 1, nr
      if (r(irr).lt.r(ir)) then
      do 4190 nn  = 0, nl
        fsn(irr,nn,ir) = r(irr)**nn/r(ir)**(nn+1)
 4190 continue
      end if
      if (r(irr).ge.r(ir)) then
      do 4191 nn  = 0, nl
        fsn(irr,nn,ir) = r(ir)**nn/r(irr)**(nn+1)
 4191 continue
      end if
 419  continue
c
      ir  = 0
      nn  = 0
      do 420 irr = 1, nr
        fsn(irr,nn,ir) = 1.0d0/r(irr)
 420  continue
      irr = 0
      nn  = 0
      do 421 ir = 1, nr
        fsn(irr,nn,ir) = 1.0d0/r(ir)
 421  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subio_fluid(istat,iseq,char)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, iwrite
      common / hijsw / swlp(4), swls(4), iswl
      common / cutsw / cutfac
c
      character*3 char
      character*3 moji
c
c ------------------------------------------------------------
c     istat = 0 and iseq 0 -> open ini file and close it 
c                             and open las file
c     istat = 2            -> close las file and open nxt file
c ------------------------------------------------------------
c
      if (istat.eq.0.and.iseq.eq.0) then
      moji = 'ini'
      open(2,file='gnbflu.'//moji,status='old')
      end if
      if (istat.eq.1) then
      moji = 'las'
      open(2,file='gnbflu.'//moji,status='old')
      end if
      if (istat.eq.2) then
      moji = 'nxt'
      open(2,file='gnbflu.'//moji,status='old')
      end if
c
c -------------
c --- Read. ---
c -------------
c
      if (istat.eq.0) then
c
c --- Fluid variables
c
      do 498 ii = 1, 7
 498  read(2,5000) idum
      read(2,5001)  dum
      read(2,5000) idum
c
      read(2,4000) ome, ber, radi, orbc
      do 100 ip = 0, np
      do 100 it = 0, nt
      read(2,4000) (emd(ir,it,ip), ir = 0, nr)
      read(2,4000) (vep(ir,it,ip), ir = 0, nr)
 100  continue
      do 110 ip = 0, np
      read(2,4000) (rs(it,ip), it = 0, nt)
 110  continue
c
      end if
c
c --------------
c --- Write. ---
c --------------
c
      if (istat.ne.0) then
c
c --- Fluid variables
c
      write(2,5000) nrf, ntf, npf
      write(2,5000) nl, nla, nbou, msym
      write(2,5005) nnn, nrout, rvout
      write(2,5000) ntg, npg, nlg, msymg
      write(2,5002) ngdin, pinx, cutfac
      write(2,5002) itmx, eps, convf
      write(2,5000) iddd, iswl
      write(2,5001) fffac,ffvep 
      write(2,5004) itype, iwrite, char
c
      write(2,4000) ome, ber, radi, orbc
      do 400 ip = 0, np
      do 400 it = 0, nt
      write(2,4000) (emd(ir,it,ip), ir = 0, nr)
      write(2,4000) (vep(ir,it,ip), ir = 0, nr)
 400  continue
      do 410 ip = 0, np
      write(2,4000) (rs(it,ip), it = 0, nt)
 410  continue
c
      end if
c
      close(2)
c
c
 4000 format(1p,6e12.4)
 4999 format(' ')
c
 5000 format( 5i5)
 5001 format( 1p,2e10.3)
 5002 format( 1i5, 1p,2e10.3)
 5003 format( 1p,1e10.3, 1i4)
 5004 format( 2i5, 3x, a3)
 5005 format( 2i5, 1p,1e10.3)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subiors(istat,iseq,char)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_alps_grav.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      character*3 char
      character*3 moji
c
      pi = 3.14159265358979d+0
c
      if (iseq.eq.1) then
      open(14,file='gnbrs.dat',status='old')
      open(15,file='gnbemd.dat',status='old')
      end if
c
c --------------
c --- Write. ---
c --------------
c
c --- Fluid variables
c
      write(14,4000) (rs(ntf,ipf), ipf = 0, npf) 
      do 414 ip = 0, np, np
      write(14,4000) (rs(itf,ip), itf = 0, ntf) 
      write(15,4000) (emd(ir,nt,ip), ir = 0, nr)
 414  continue
      write(15,4000) (psi(irg,ntg,0), irg = 0, nrtot)
c
 4000 format(1p,6e12.4)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine fl2gr_rns(flv,grv,rs,hhrg,rrrg,isw,isym)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension grv(0:nnrg,0:nntg,0:nnpg), flv(0:nnr,0:nnt,0:nnp)
      dimension flvex(0:nnr,0:nnt,0:2*nnp),rsex(0:nnt,0:2*nnp)
      dimension rs(0:nnt,0:nnp),hhrg(nnrg),rrrg(0:nnrg),rrgg(0:nnrg)
      dimension x(4),y(4)
c
c ---
c
      small = 1.0d-10
c
      if (isw.eq.0) then
      rrgg(0)   = 0.0d0
      do 9000 irg = 1, nrtot
      rrgg(irg) = hhrg(irg)
 9000 continue
      end if
c
      if (isw.ne.0) then
      do 9001 irg = 0, nrtot
      rrgg(irg) = rrrg(irg)
 9001 continue
      end if
c
c --- Find gravity coodinate values on fluid coordinate, cfg. 
c --- Interpolation of quantity on fluid to gravity coordinate. 
c
c --  phif in [0,pi]
c --  phig in [-pi/2,3pi/2]
c --  isym = +1 (sym) or -1 (anti-sym)
c
      facsym = dble(isym)
      do 88 ipf = 0, npf
      ipg = npgxz + ipf
      ipgex = mod(npg+mod(npgxz - ipf,npg),npg)
      do 88 itf = 0, ntf
      rsex(itf,ipg)   = rs(itf,ipf)
      rsex(itf,ipgex) = rs(itf,ipf)
      do 88 irf = 0, nrf
      flvex(irf,itf,ipg)   =        flv(irf,itf,ipf)
 88   flvex(irf,itf,ipgex) = facsym*flv(irf,itf,ipf)
      do 87 itf = 0, ntf
      rsex(itf,npg) = rs(itf,npfyz)
      do 87 irf = 0, nrf
 87   flvex(irf,itf,npg) = facsym*flv(irf,itf,npfyz)
c
      do 89 ipg = 0, npg
      do 89 itg = 0, ntg
      do 89 irg = 0, nrtot
 89   grv(irg,itg,ipg) = 0.0d0
c
      tiny = 1.0d-10
caho
      nrgmax = 2*nrf
caho
c
      do 101 ipg = 0, npg
      do 101 itg = 0, ntg
      itf = itg
      ipf = ipg
      drs = rsex(itf,ipf)/dble(nrf)
      grv(0,itg,ipg) = flvex(0,itf,ipf)
      do 100 irg = 1, nrgmax
      rr = rrgg(irg)
      if (rr.ge.rsex(itf,ipf)+tiny) go to 101
      ir0 = min0(max0(idint(rr/drs)-1,0),nr-3)
      do 1 ii = 1, 4
      irf0 = ir0 + ii -1 
       x(ii)=rsex(itf,ipf)*rf(irf0)
       y(ii)=flvex(irf0,itf,ipf)
 1    continue
      grv(irg,itg,ipg) = fn_lagint(x,y,rr)
 100  continue
 101  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine gr2fl_rns(grv,flv,rs)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      dimension grv(0:nnrg,0:nntg,0:nnpg), flv(0:nnr,0:nnt,0:nnp)
      dimension rs(0:nnt,0:nnp)
      dimension x(4),y(4)
c
c --- Interpolation of quantity on gravity to fluid coordinate. 
c
      do 89 ipf = 0, npf
      do 89 itf = 0, ntf
      do 89 irf = 0, nrf
 89   flv(irf,itf,ipf) = 0.0d0
c
      drdrinv = drginv(0)
      tiny = 1.0d-10
      do 101 ipf = 0, npf
      do 101 itf = 0, ntf
      itg = itf
      ipg = ipf + npgxz
      flv(0,itf,ipf) = grv(0,itg,ipg)
      do 101 irf = 1, nrf
      rr = rs(itf,ipf)*rf(irf)
      ir0 = min0(max0(idint(rr*drdrinv)-1,0),nrf*nnn-3)
      do 1 ii = 1, 4
      irg0 = ir0 + ii -1 
       x(ii)=rg(irg0)
       y(ii)=grv(irg0,itg,ipg)
 1    continue
      flv(irf,itf,ipf) = fn_lagint(x,y,rr)
 101  continue
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine vgr2vfl_rns(rs)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metfl.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / cdivb / cdivbv(0:nnrg,0:nntg,0:nnpg)
      common / cdivbf/ cdvbvf(0:nnr,0:nnt,0:nnp)
c
      dimension rs(0:nnt,0:nnp)
c
c
c --- Interpolation of the Cartesian component, 
c     from GR to fluid coordinate.  
c
ck      call gr2fl_rns(bvxu,bvxuf,rs,1,0)
ck      call gr2fl_rns(bvyu,bvyuf,rs,0,0)
ck      call gr2fl_rns(bvzu,bvzuf,rs,1,1)
ck      call gr2fl_rns(cdivbv,cdvbvf,rs,0,0)
      call gr2fl_rns(bvxu,bvxuf,rs)
      call gr2fl_rns(bvyu,bvyuf,rs)
      call gr2fl_rns(bvzu,bvzuf,rs)
      call gr2fl_rns(cdivbv,cdvbvf,rs)
c
c --- 
c
      do 20 ip = 0, npf
      do 20 it = 0, ntf
      do 20 ir = 0, nrf
c## BHNS
      vphif(ir,it,ip,1) = - rs(it,ip)*rf(ir)*sinthef(it)*sinphif(ip)
      vphif(ir,it,ip,2) = - orbc 
     &                    + rs(it,ip)*rf(ir)*sinthef(it)*cosphif(ip)
      vphif(ir,it,ip,3) = 0.0d0
c
 20   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine vfl2vgr_rns(gradf,gradg,rs,hhrg,rrrg,isw)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      dimension grv(0:nnrg,0:nntg,0:nnpg), flv(0:nnr,0:nnt,0:nnp)
      dimension gradf(0:nnr,0:nnt,0:nnp,1:3),
     &          gradg(0:nnrg,0:nntg,0:nnpg,1:3)
      dimension rs(0:nnt,0:nnp),hhrg(nnrg),rrrg(0:nnrg),rrgg(0:nnrg)
c
      dimension xx(2*nnr+1),yy(2*nnr+1),cc(2*nnr+1,3),
     &          xf(2*nnr+1),ff(2*nnr+1),df(2),iopt(2)
      dimension fr4(4), r4(4)
c --- 
c
      if (isw.eq.0) then
      rrgg(0)   = 0.0d0
      do 9000 irg = 1, nrtot
      rrgg(irg) = hhrg(irg)
 9000 continue
      end if
c
      if (isw.ne.0) then
      do 9001 irg = 0, nrtot
      rrgg(irg) = rrrg(irg)
 9001 continue
      end if
c
c --- Interpolation of the Cartesian component, 
c     from fluid to GR coordinate.  
c
      do 8 ii = 1, 3
      if (ii.eq.1) isym = -1
      if (ii.eq.2) isym =  1
      if (ii.eq.3) isym = -1
      do 9 ipg = 0, npg
      do 9 itg = 0, ntg
      do 9 irg = 0, nrtot
      gradg(irg,itg,ipg,ii) = 0.0d0
      grv(irg,itg,ipg) = 0.0d0
 9    continue
      do 7 ipf = 0, npf
      do 7 itf = 0, ntf
      do 7 irf = 0, nrf
      flv(irf,itf,ipf) = gradf(irf,itf,ipf,ii)
 7    continue
      call fl2gr_rns(flv,grv,rs,hhrg,rrrg,isw,isym)
      do 4 ip = 0, npg
      do 4 it = 0, ntg
      nrgmax = nnn*nrf
      do 4 ir = 0, nrgmax
      gradg(ir,it,ip,ii) = grv(ir,it,ip)
 4    continue
 8    continue
c
c --  SKIP
      go to 100
c --  
c
c --  for phi velocity on x-axis. 
c
      dis = sepato
      do 900 irf = 0, nrf-1
      xx(irf+1) = dis - rf(nrf-irf)*rs(ntf,npf)
 900  yy(irf+1) = gradf(nrf-irf,ntf,npf,2)
      irf = nrf
      xx(irf+1) = dis
cmachigai      yy(irf+1) = gradf(0,ntf,npf/2,1)
      yy(irf+1) = gradf(0,ntf,npfyz,2)
      do 901 irf = nrf+1, 2*nrf
      xx(irf+1) = dis + rf(irf-nrf)*rs(ntf,0)
 901  yy(irf+1) = gradf(irf-nrf,ntf,0,2)
c
      small = 1.0d-8 
      nrgmin1 = max0(0,nrgmin-1)
      do 902 irg = nrgmin1, nrgmax
      ir0 = 1
      if (rrgg(irg).le.xx(1)-small) go to 902
      if (rrgg(irg).ge.xx(2*nrf+1)+small) go to 905
      do 903 irf = 1, 2*nrf + 1
      if (rrgg(irg).ge.xx(irf).and.rrgg(irg).lt.xx(irf+1)+small) then
      ir0 = min0(max0(irf-2,1),2*nrf+1-3)
      go to 904
      end if
 903  continue
 904  continue
      rv = rrgg(irg)
      do 90 ii = 1, 4
      irf0 = ir0 + ii - 1
      r4(ii) = xx(irf0)
      fr4(ii) = yy(irf0)
 90   continue
      gradg(irg,ntg,0,2) = fn_lagint(r4,fr4,rv)
 902  continue
 905  continue
c
c --  for phi=0 plane. 
c
      do 21 it = ntgmin, ntg
      do 21 ir = nrgmin, nrgmax
      gradg(ir,it,0,1) = 0.0d0
c --- y sokudo ha itsumo sei (kidou kaiten ookii).
      gradg(ir,it,0,2) = dabs(gradg(ir,it,0,2))
      gradg(ir,it,0,3) = 0.0d0
c
 21   continue
c
c      if (it.eq.ntg)write(24,*) gradg(ir,it,0,2),yy(ir-nrgmin+1)
cc      write(6,*) gradf(nr,nt,np,2), gradf(0,nt,npfyz,2),
cc     &            gradf(nr,nt,0,2)
cc       stop ' aho '
c
 100  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine flimpro(back,rnew,fffac,epsmax,irerr,iterr,iperr,isw)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension rnew(0:nnr,0:nnt,0:nnp),
     &          back(0:nnr,0:nnt,0:nnp)
c
c --- Set improved values for quantities on fluid-coordinate and 
c --- convergence check.  
c
      epsmax = 0.0d0
      do 401 ip = 0, np
      do 401 it = 0, nt
      do 401 ir = 0, nr - isw
      rnew(ir,it,ip) = 
     &   fffac*rnew(ir,it,ip) + (1.d0-fffac)*back(ir,it,ip)
      edet  = rnew(ir,it,ip)
      edetb = back(ir,it,ip)
      devi  = dabs(rnew(ir,it,ip)) + dabs(back(ir,it,ip))
      if (dabs(edet+edetb).ge.1.0d-8) then
      error = dabs(2.d0*(edet - edetb))/devi
      if(error .gt. epsmax) then
      epsmax = error
      irerr = ir
      iterr = it
      iperr = ip
      end if
      end if
 401  continue
c
      end 
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine rsimpro(back,rnew,fffac,epsmax,iterr,iperr)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension rnew(0:nnt,0:nnp),
     &          back(0:nnt,0:nnp)
c
c --- Set improved values for quantities on fluid-coordinate and 
c --- convergence check.  
c
      epsmax = 0.0d0
      do 401 ip = 0, np
      do 401 it = 0, nt
      rnew(it,ip) = 
     &   fffac*rnew(it,ip) + (1.d0-fffac)*back(it,ip)
      edet  = rnew(it,ip)
      edetb = back(it,ip)
      devi  = dabs(rnew(it,ip)) + dabs(back(it,ip))
      if (dabs(edet+edetb).ge.1.0d-8) then
      error = dabs(2.d0*(edet - edetb))/devi
      if(error .gt. epsmax) then
      epsmax = error
      iterr = it
      iperr = ip
      end if
      end if
cz      if (rnew(it,ip).ge.1.0d0) rnew(it,ip) = 1.0d0
 401  continue
c
      end 
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine paimpro_bhns(ome,ber,radi,convf,iter,fmax0,isw)
c
c --- Improve parameters
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metfl.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/CB_alps_bh.f'
c
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      dimension sgg(10), gg(10,10)
      dimension gradv(0:nnr,0:nnt,0:nnp,1:3)
      dimension x(10),y(10),df(2),iopt(2),c(10,3), f(1)
c
c --- parameter eq.
c
      do 2001 ii = 1, 10
      sgg(ii) = 0.0d0
      do 2001 jj = 1, 10
      gg(ii,jj) = 0.0d0
 2001  continue
c
c
      do 595 jj = 1, 3
      if (jj.eq.1) then
      irg = nrgsf
      itg = ntgeq
      ipg = npgxz
      end if
      if (jj.eq.2) then
      irg = 0
      itg = ntgeq
      ipg = npgyz
      end if
      if (jj.eq.3) then
      irg = nrgsf
      itg = ntgeq
      ipg = npgxzm
      end if
c
      fa1 = alph(irg,itg,ipg)
      fp1 = psi(irg,itg,ipg)
      fb1 = bvyu(irg,itg,ipg)
      a1 = dlog(fa1**(1.d0/radi**2))
      p1 = fp1**(-2.d0/radi**2)
      b1 = fb1
      h1 = 0.0d0
c
      if (jj.eq.1) then 
      ain = a1
      pin = p1
      bin = b1
      gin = h1 + 1.0d0
      end if
      if (jj.eq.2) then 
      amid = a1
      pmid = p1
      bmid = b1
      gmid = h1 + 1.0d0
      end if
      if (jj.eq.3) then
      aout = a1
      pout = p1
      bout = b1
      gout = h1 + 1.0d0
      end if
c
 595  continue
c
      emdmid = emdc
c
      call flgrad4(vep,gradv,rs,1,0)
c      call flgrad4(vep,gradv,rs,1,4)
c      call flgrad(vep,gradv,rs,1,0)
      gradvin  = gradv(nrf,ntf,npfxz,2)
      gradvmid = gradv(0,ntf,npfyz,2)
ctesttestaho      gradvmid = 0.5d0*(gradv(1,ntf,npfxz,2)+gradv(1,ntf,npfxzm,2))
      gradvout = gradv(nrf,ntf,npfxzm,2)
c
      fac1in  = gradvin**2*gin
      fac1mid = gradvmid**2*gmid
      fac1out = gradvout**2*gout
      fac2in  = gradvin
      fac2mid = gradvmid
      fac2out = gradvout
      facmm = (1.d0+(pinx+1.d0)*emdmid)**2  
c
      vphiyin  = vphif(nrf,ntf,npfxz,2)
      vphiymid = vphif(0,ntf,npfyz,2)
      vphiyout = vphif(nrf,ntf,npfxzm,2)
c
c -- For the star at the left...
c
c      bin  = - bin
c      bmid = - bmid
c      bout = - bout
c      fac2in  = - fac2in
c      fac2mid = - fac2mid
c      fac2out = - fac2out
c      vphiyin  = - vphiyin
c      vphiymid = - vphiymid
c      vphiyout = - vphiyout
c -- 
c
cz      write(6,*) ' step  p '
cz      write(6,789) ome,ber,radi
cz      write(6,789) ain, pin, bin, gin
cz      write(6,789) amid, pmid, bmid, gmid
cz      write(6,789) aout, pout, bout, gout
cz      write(6,789) gradvin, gradvmid, gradvout
cz      write(6,789) vphiyin, vphiymid, vphiyout
cz      write(6,789) ramin, rammid, ramout
cz 789  format(1p,4e12.4)
c
      omeb = ome
      berb = ber
      radib = radi
c
      numero = 0
c
 99   continue
c
      ramin = ber + (bin + ome*vphiyin)*fac2in
      rammid = ber + (bmid + ome*vphiymid)*fac2mid
      ramout = ber + (bout + ome*vphiyout)*fac2out
c
      sgg(1) = -(  radi**2*ain 
     &           + 0.5d0*dlog(1.0d0 + pin**(2.d0*radi**2)*fac1in)
     &           - dlog(ramin))
      sgg(2) = -(  radi**2*aout
     &           + 0.5d0*dlog(1.0d0 + pout**(2.d0*radi**2)*fac1out)
     &           - dlog(ramout))
      sgg(3) = -(  radi**2*amid
     &           + 0.5d0*dlog(facmm + pmid**(2.d0*radi**2)*fac1mid)
     &           - dlog(rammid))
c
      gg(1,1) = - vphiyin*fac2in/ramin
      gg(1,2) = -          1.0d0/ramin
      gg(1,3) = 2.0d0*radi*ain + 
     &          0.5d0/(1.0d0 + pin**(2.d0*radi**2)*fac1in)* 
     &          dlog(pin)*4.d0*radi*pin**(2.d0*radi**2)*fac1in
      gg(2,1) = - vphiyout*fac2out/ramout
      gg(2,2) = -             1.d0/ramout
      gg(2,3) = 2.0d0*radi*aout + 
     &          0.5d0/(1.0d0 + pout**(2.d0*radi**2)*fac1out)* 
     &          dlog(pout)*4.d0*radi*pout**(2.d0*radi**2)*fac1out
      gg(3,1) = - vphiymid*fac2mid/rammid
      gg(3,2) = -             1.d0/rammid
      gg(3,3) = 2.0d0*radi*amid + 
     &          0.5d0/(facmm + pmid**(2.d0*radi**2)*fac1mid)* 
     &          dlog(pmid)*4.d0*radi*pmid**(2.d0*radi**2)*fac1mid
c
      call minv(gg,sgg,3,10)
      ddome = sgg(1)
      ddber = sgg(2)
      ddradi = sgg(3)
      facfac = dmin1(dble(numero)/5.0d0,1.0d0)
      ome = ome + ddome*facfac
      ber = ber + ddber*facfac
      radi = radi + ddradi*facfac
      error = dmax1(dabs(ddome/ome),dabs(ddber/ber),dabs(ddradi/radi))
      numero = numero + 1
      if (numero.gt.1000)
     &write(6,*)' numero = ', numero, '   error =',error
      if (iter.le.10.and.numero.gt.10) go to 909
      if (numero.gt.1010) go to 909
      if (dabs(error).gt.1.0d-08) go to 99
c
 909  continue
c      write(6,*)' numero = ', numero, '  error = ',error
c
      if (radi.le.0.d0) write(6,*) ' ### radi minus ###'
      if (radi.le.0.d0) radi = - radi
      if (ome.le.0.d0) write(6,*) ' ### ome minus ###'
      if (ome.le.0.d0) ome = - ome
      if (ber.le.0.d0) write(6,*) ' ### ber minus ###'
      if (ber.le.0.d0) ber = - ber
      ome = convf*ome + (1.d0-convf)*omeb
      ber = convf*ber + (1.d0-convf)*berb
      radi = convf*radi + (1.d0-convf)*radib
c
      if (isw.eq.1) then
      write(6,4900)'  -- ome   --, error =', 
     &        2.0d0*dabs((ome - omeb)/(ome + omeb)), ome
      write(6,4900)'  -- ber   --, error =', 
     &        2.0d0*abs((ber - berb)/(ber + berb)), ber
      write(6,4900)'  -- radi  --, error =', 
     &        2.0d0*dabs((radi - radib)/(radi + radib)), radi
      end if
      fmax0 = dmax1(2.0d0*dabs((ome - omeb)/(ome + omeb)),
     &              2.0d0*dabs((ber - berb)/(ber + berb)),
     &              2.0d0*dabs((radi - radib)/(radi + radib)),fmax0)
c
c --  Improving alpha and psi.  
c
      do 470 ipg = 0, npg
      do 470 itg = 0, ntg
      do 470 irg = 0, nrtot
      alph(irg,itg,ipg) = alph(irg,itg,ipg)**((radi/radib)**2)
      psi(irg,itg,ipg) = psi(irg,itg,ipg)**((radi/radib)**2)
 470  continue
c
c SKIP
c      go to  472
c
      powrad = (radi/radib)**2
      do 471 ipb = 0, npb
      do 471 itb = 0, ntb
      do 471 irb = 1, nrb
      if (alphb(irb,itb,ipb).gt.0.0d0)
     &alphb(irb,itb,ipb) = alphb(irb,itb,ipb)**powrad
      if (psib(irb,itb,ipb).gt.0.0d0)
     & psib(irb,itb,ipb) = psib(irb,itb,ipb)**powrad
 471  continue
c 472  continue
c
 4900 format(a22,1p,e12.4,',  value =',e12.4)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine paimproco_bhns(ome,ber,radi,convf,iter,fmax0,isw)
c
c --- Improve parameters
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metfl.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      dimension sgg(10), gg(10,10)
      dimension gradv(0:nnr,0:nnt,0:nnp,1:3)
      dimension x(10),y(10),df(2),iopt(2),c(10,3), f(1), v(1)
c
c --- for interpolation.
c
      df(1) = 0.0d0
      df(2) = 0.0d0
      iopt(1) = 3
      iopt(2) = 3
      nc = 10
      kn = 6
      km = 1
c
c --- parameter eq.
c
      do 2001 ii = 1, 10
      sgg(ii) = 0.0d0
      do 2001 jj = 1, 10
      gg(ii,jj) = 0.0d0
 2001  continue
c
      rgin  = sepato - 1.0d0
      rgmid = sepato
      rgout = sepato + 1.0d0
c
      if (rgin.le.0.0d0) rgin = 0.0d0
      delrg = drg(2)
c
      do 595 jj = 1, 3
      if (jj.eq.1) then 
      irgini = idint(rgin/delrg) - kn/2 + 1
      rrrg = rgin
      end if
      if (jj.eq.2) then 
      irgini = idint(rgmid/delrg) - kn/2 + 1
      rrrg = rgmid
      end if
      if (jj.eq.3) then
      irgini = idint(rgout/delrg) - kn/2 + 1
      rrrg = rgout
      end if
      if (irgini.le.0) irgini = 0
c
      do 590 ii = 1, kn
      irg = irgini + ii-1
      x(ii) = rg(irg)
 590  continue
c
      do 7100 ii = 1, kn
      irg = irgini + ii-1
 7100 y(ii) = alph(irg,ntg,0)
      v(1) = rrrg
      call splc(x,kn,y,df,iopt,c,nc,ier)
      call splf(x,kn,y,c,nc,v,km,f,ier)
      a1 = dlog(f(1)**(1.d0/radi**2))
      a2 = f(1)
c
      do 7101 ii = 1, kn
      irg = irgini + ii-1
 7101 y(ii) = psi(irg,ntg,0)
      v(1) = rrrg
      call splc(x,kn,y,df,iopt,c,nc,ier)
      call splf(x,kn,y,c,nc,v,km,f,ier)
      pa1 = (f(1)**2/a2)**(1.d0/radi**2)
c
      do 7102 ii = 1, kn
      irg = irgini + ii-1
 7102 y(ii) = bvyu(irg,ntg,0)
      v(1) = rrrg
      call splc(x,kn,y,df,iopt,c,nc,ier)
      call splf(x,kn,y,c,nc,v,km,f,ier)
      b1 = f(1)
c
      do 7104 ii = 1, kn
      irg = irgini + ii-1
 7104 y(ii) = 0.0d0
      v(1) = rrrg
      call splc(x,kn,y,df,iopt,c,nc,ier)
      call splf(x,kn,y,c,nc,v,km,f,ier)
      h1 = f(1)
c
      if (jj.eq.1) then 
      ain = a1
      pain = pa1
      bin = b1
      gin = h1 + 1.0d0
      end if
      if (jj.eq.2) then 
      amid = a1
      pamid = pa1
      bmid = b1
      gmid = h1 + 1.0d0
      end if
      if (jj.eq.3) then
      aout = a1
      paout = pa1
      bout = b1
      gout = h1 + 1.0d0
      end if
c
 595  continue
c
      emdmid = emdc
c
      dloghh = dlog(1.d0+(pinx+1.d0)*emdmid)
c
      vphiyin = vphif(nr,nt,npfxzm,2)
      vphiymid = vphif(0,nt,npfyz,2)
      vphiyout = vphif(nr,nt,npfxz,2)
c
      omeb = ome
      berb = ber
      radib = radi
c
      numero = 0
c
 99   continue
c
      ovin  = bin  + ome*vphiyin
      ovmid = bmid + ome*vphiymid
      ovout = bout + ome*vphiyout
      ovovin  = gin*ovin**2
      ovovmid = gmid*ovmid**2
      ovovout = gout*ovout**2
c
      termin = 1.0d0 - pain**(2.d0*radi**2)*ovovin
      termmid = 1.0d0 - pamid**(2.d0*radi**2)*ovovmid
      termout = 1.0d0 - paout**(2.d0*radi**2)*ovovout
      dtermdoin = - pain**(2.d0*radi**2)*2.0d0*gin*ovin*vphiyin
      dtermdomid= - pamid**(2.d0*radi**2)*2.0d0*gmid*ovmid*vphiymid
      dtermdoout= - paout**(2.d0*radi**2)*2.0d0*gout*ovout*vphiyout
      dtermdrin =-dlog(pain)*4.d0*radi*pain**(2.d0*radi**2)*ovovin
      dtermdrmid=-dlog(pamid)*4.d0*radi*pamid**(2.d0*radi**2)*ovovmid
      dtermdrout=-dlog(paout)*4.d0*radi*paout**(2.d0*radi**2)*ovovout
c
      sgg(1) = -(radi**2*ain  + 0.5d0*dlog(termin)  - dlog(ber))
      sgg(2) = -(radi**2*aout + 0.5d0*dlog(termout) - dlog(ber))
      sgg(3) = -(radi**2*amid + 0.5d0*dlog(termmid) - dlog(ber)
     &           + dloghh)
c
      gg(1,1) =   0.5d0*dtermdoin/termin
      gg(1,2) = - 1.0d0/ber
      gg(1,3) = 2.0d0*radi*ain + 0.5d0*dtermdrin/termin
c
      gg(2,1) =   0.5d0*dtermdoout/termout
      gg(2,2) = - 1.0d0/ber
      gg(2,3) = 2.0d0*radi*aout + 0.5d0*dtermdrout/termout
c
      gg(3,1) =   0.5d0*dtermdomid/termmid
      gg(3,2) = - 1.0d0/ber
      gg(3,3) = 2.0d0*radi*amid + 0.5d0*dtermdrmid/termmid
c
      call minv(gg,sgg,3,10)
      ddome = sgg(1)
      ddber = sgg(2)
      ddradi = sgg(3)
      facfac = dmin1(dble(numero)/5.0d0,1.0d0)
      ome = ome + ddome*facfac
      ber = ber + ddber*facfac
      radi = radi + ddradi*facfac
      error = dmax1(dabs(ddome/ome),dabs(ddber/ber),dabs(ddradi/radi))
      numero = numero + 1
      if (numero.gt.1000)
     &write(6,*)' numero = ', numero, '   error =',error
      if (iter.le.10.and.numero.gt.10) go to 909
      if (numero.gt.1010) go to 909
      if (dabs(error).gt.1.0d-08) go to 99
c
 909  continue
c      write(6,*)' numero = ', numero, '  error = ',error
c
      if (radi.le.0.d0) write(6,*) ' ### radi minus ###'
      if (radi.le.0.d0) radi = - radi
      if (ome.le.0.d0) write(6,*) ' ### ome minus ###'
      if (ome.le.0.d0) ome = - ome
      if (ber.le.0.d0) write(6,*) ' ### ber minus ###'
      if (ber.le.0.d0) ber = - ber
      ome = convf*ome + (1.d0-convf)*omeb
      ber = convf*ber + (1.d0-convf)*berb
      radi = convf*radi + (1.d0-convf)*radib
c
      if (isw.eq.1) then
      write(6,4900)'  -- ome   --, error =', 
     &        2.0d0*dabs((ome - omeb)/(ome + omeb)), ome
      write(6,4900)'  -- ber   --, error =', 
     &        2.0d0*abs((ber - berb)/(ber + berb)), ber
      write(6,4900)'  -- radi  --, error =', 
     &        2.0d0*dabs((radi - radib)/(radi + radib)), radi
      end if
      fmax0 = dmax1(2.0d0*dabs((ome - omeb)/(ome + omeb)),
     &              2.0d0*dabs((ber - berb)/(ber + berb)),
     &              2.0d0*dabs((radi - radib)/(radi + radib)),fmax0)
c
c --  Improving alpha and psi.  
c
      do 470 ipg = 0, npg
      do 470 itg = 0, ntg
      do 470 irg = 0, nrtot
      alph(irg,itg,ipg) = alph(irg,itg,ipg)**((radi/radib)**2)
      psi(irg,itg,ipg) = psi(irg,itg,ipg)**((radi/radib)**2)
 470  continue
c
 4900 format(a22,1p,e12.4,',  value =',e12.4)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine fluid(iter,itmx,convf,cfvep,fmax0,ahores,emxemd,char)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metfl.f'
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
      include 'common_blocks/CB_weight_fluid.f'
c
      common / legen / spn(0:nnt,0:nnp,0:nnl), 
     &                 fsn(0:nnr,0:nnl,0:nnr)
      common / asleg / pna(0:nnla,0:nnla,0:nnt),
     &               dtpna(0:nnla,0:nnla,0:nnt), 
     &               facnm(0:nnla,0:nnla), epsi(0:nnla)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
      common / asylm / ypna(0:nnla,0:nnla,0:nnt),
     &               dtypna(0:nnla,0:nnla,0:nnt)
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / diffv / rsinv(0:nnt,0:nnp),
     &              dtrs(0:nnt,0:nnp),dprs(0:nnt,0:nnp)
c
      common / cdivbf/ cdvbvf(0:nnr,0:nnt,0:nnp)
c
      dimension backf(0:nnr,0:nnt,0:nnp), rsb(0:nnt,0:nnp)
      dimension hut(0:nnr,0:nnt,0:nnp), aloh(0:nnr,0:nnt,0:nnp),
     &        hutp6(0:nnr,0:nnt,0:nnp),psif4(0:nnr,0:nnt,0:nnp), 
     &        gradv(0:nnr,0:nnt,0:nnp,1:3),
     &       gradps(0:nnr,0:nnt,0:nnp,1:3),
     &       gradhu(0:nnr,0:nnt,0:nnp,1:3),
     &       gradah(0:nnr,0:nnt,0:nnp,1:3),
     &        grade(0:nnr,0:nnt,0:nnp,1:3)
c
      dimension surp(0:nnt,0:nnp), rs00(0:nnt,0:nnp)
      dimension vpot(0:nnr,0:nnt,0:nnp), souv(0:nnr,0:nnt,0:nnp)
      dimension vpotfc(0:nnr,0:nnt,0:nnp), souvfc(0:nnr,0:nnt,0:nnp)
c      dimension emdfc(0:nnr,0:nnt,0:nnp), potfc(0:nnr,0:nnt,0:nnp)
      dimension flag(0:nnr,0:nnt,0:nnp),   wgsf(0:nnr,0:nnt,0:nnp),
     &        wgrtpv(0:nnr,0:nnt,0:nnp), wgrtpp(0:nnr,0:nnt,0:nnp)
c
      dimension x(nnr),y(nnr),df(2),iopt(2),c(nnr,3),f(1)
      dimension dabvep(3,3)
      dimension ddvpot(0:nnt,0:nnp,1:3)
      dimension sgg(nnbou), gg(nnbou,nnbou)
c
      character*3 char
c
c ----------------------------------------------------------------------
c
      drinv=1.0d0/dr
      dtinv=1.0d0/dth
      dpinv=1.0d0/dphi
      pi = 3.14159265358979d+0
c
c ----------------------------------------------------------------------
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
c     Equations start. 
c
c ======================================================================
c
c     Generalized Bernoulli equation.
c
c ======================================================================
c
c --  Preparation.
cmark
cxx      call flgrad4(vep,gradv,rs,1,-1)
cfouri      call flgrad(vep,gradv,rs,1,np/4)
cx      call flgrad4(vep,gradv,rs,1,0)
      call flgrad(vep,gradv,rs,1,0)
      call ram_fluid(gradv,ram)
c
c --  Generalized Bernoulli equation.
c
      do 100 ip = 0, np
      do 100 it = 0, nt
      do 100 ir = 0, nr
c
      backf(ir,it,ip) = emd(ir,it,ip)
      gamxxu = 1.0d0
      gamxyu = 0.0d0
      gamxzu = 0.0d0
      gamyyu = 1.0d0
      gamyzu = 0.0d0
      gamzzu = 1.0d0
      gamyxu = gamxyu
      gamzxu = gamxzu
      gamzyu = gamyzu
      dxvp = gradv(ir,it,ip,1)
      dyvp = gradv(ir,it,ip,2)
      dzvp = gradv(ir,it,ip,3)
ctesttestaho
c      if (ir.eq.0) 
c     & dyvp = 0.5d0*(gradv(1,ntf,npfxz,2)+gradv(1,ntf,npfxzm,2))
c
c
      ramc  = ram(ir,it,ip)
      alphc = alphf(ir,it,ip)
      psic  = psif(ir,it,ip)
c
      emd(ir,it,ip) = 1.0d0/(pinx+1.0d0)*
     &  (((ramc/alphc)**2 - 1.0d0/psic**4*
     &  (gamxxu*dxvp*dxvp + gamxyu*dxvp*dyvp + gamxzu*dxvp*dzvp
     & + gamyxu*dyvp*dxvp + gamyyu*dyvp*dyvp + gamyzu*dyvp*dzvp
     & + gamzxu*dzvp*dxvp + gamzyu*dzvp*dyvp + gamzzu*dzvp*dzvp))**0.5
     & - 1.0d0)
c
ctesttest
cc      if (ir.le.3.and.it.eq.nt.and.ip.eq.0) then 
c      if (ip.eq.0.or.ip.eq.npfyz) then
cc      write(6,789) ir,it,ip,ramc,alphc,dyvp
cc 789   format(3i5,1p,6e12.4)
c        end if
cc        end if
ctesttest
c
  100 continue
c
      include 'fluid_plot2.f'
c
      do 42 ip = 0, np
      do 42 it = 0, nt
      emd(0,it,ip) = emd(0,ntfeq,npfyz)
 42   continue
c
      emdmx = 0.0d0
      do 44 ir = 0, nr
      emdmx = dmax1(emdmx,emd(ir,ntfeq,npfxz),emd(ir,ntfeq,npfxzm))
 44   continue
      do 440 ir = 0, nr
      if (emdmx.eq.emd(ir,ntfeq,npfxzm)) then 
      nrfdmx = ir
      npfdmx = npfxzm
      end if
      if (emdmx.eq.emd(ir,ntfeq,npfxz)) then 
      nrfdmx = ir
      npfdmx = npfxz
      end if
 440  continue
cc      write(6,*)'aho', nrfdmx, npfdmx, npfxzm, npfxz, emdmx
c
      nrgdmx = nrfdmx + nrgmid
cz      emd(nrfdmx,nt,0) = emdc
cz      if (nrfdmx.eq.0) then 
      do 45 ip = 0, np
      do 45 it = 0, nt
      emd(0,it,ip) = emdc
 45   continue
cz      end if
c
c --- For axis. 
c
      do 191 ir = 1, nr
      emem = emd(ir,0,npfyz)
      do 193 ip = 0, np
      emd(ir,0,ip) = emem
 193  continue
 191  continue
c
c --- For surface. 
c
      do 170 ip = 0, np
      do 170 it = 0, nt
      rsb(it,ip) = rs(it,ip)
      delx = dr*(surr - emd(nr,it,ip))/(emd(nr,it,ip) - emd(nr-1,it,ip))
      rs(it,ip) = rs(it,ip)*(1.0d0 + delx)
  170 continue
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
c
c     ### Iteration. ###
c     Set improved values for emden function and surface.
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
c
c --- For parameters. 
c
      rs(ntfeq,npfxz ) = 1.0d0
      rs(ntfeq,npfxzm) = 1.0d0
c
      do 4000 ip = 0, np
      do 4000 it = 0, nt
      emd(nr,it,ip) = surr
cz      if (emd(nr-1,it,ip).le.0.0d0) emd(nr-1,it,ip) = surr
cz      if (emd(nr-2,it,ip).le.0.0d0) emd(nr-2,it,ip) = surr
cz      if (emd(nr-3,it,ip).le.0.0d0) emd(nr-3,it,ip) = surr
ctesttest      if (rs(it,ip).ge.1.05d0) rs(it,ip) = 1.05d0
      do 4000 ir = 0, nr-1
      if (emd(ir,it,ip).le.0.0d0) emd(ir,it,ip) = surr
 4000 continue
c
      call flimpro(backf,emd,convf,emxemd,irerr,iterr,iperr,1)
      write(6,4901) '  == emd   ==, error =', emxemd,
     &              emd(irerr,iterr,iperr), irerr,iterr,iperr
      fmax0 = dmax1(emxemd,fmax0)
c
      call rsimpro(rsb,rs,convf,emxrs,iterr,iperr)
      write(6,4901) '  == rs    ==, error =', emxrs,
     &              rs(iterr,iperr),iterr,iperr
      fmax0 = dmax1(emxrs,fmax0)
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c --- Derivatives for variables ---
cmark
cx      call flgrad4(vep,gradv,rs,1,0)
cfouri      call flgrad(vep,gradv,rs,1,np/4)
      call flgrad(vep,gradv,rs,1,0)
      call ram_fluid(gradv,ram)
c
      do 79 ip = 0, np
      do 79 it = 0, nt
      ir = 0
      psic  = psif(ir,it,ip)
      alphc = alphf(ir,it,ip)
      emden  = emd(ir,it,ip)
      hhh = 1.0d0 + (pinx+1.0d0)*emden
      ramc  = ram(ir,it,ip)
      hut(ir,it,ip) = ramc/alphc**2
      hutp6(ir,it,ip) = ramc/alphc**2*psic**6
      aloh(ir,it,ip) = dlog(alphc/hhh)
      psif4(ir,it,ip) = psic**4
      do 79 ir = 1, nr
      psic  = psif(ir,it,ip)
      alphc = alphf(ir,it,ip)
      emden  = emd(ir,it,ip)
      hhh = 1.0d0 + (pinx+1.0d0)*emden
      ramc  = ram(ir,it,ip)
      hut(ir,it,ip) = ramc/alphc**2
      hutp6(ir,it,ip) = ramc/alphc**2*psic**6
      aloh(ir,it,ip) = dlog(alphc/hhh)
      psif4(ir,it,ip) = psic**4
 79   continue
c
      call flgrad4(psif,gradps,rs,2,0)
c      call flgrad(psif,gradps,rs,2,0)
cmark --
cx      call flgrad4(hutp6,gradhu,rs,2,0)
cfouri      call flgrad(hutp6,gradhu,rs,2,np/4)
      call flgrad(hutp6,gradhu,rs,2,0)
c --
      call flgrad4(aloh,gradah,rs,2,0)
      call flgrad4(emd,grade,rs,2,0)
      call flgrad4(psif,gradps,rs,2,0)
cc      call flgrad(hut,gradhu,rs,2,0)
cc      call flgrad(aloh,gradah,rs,2,0)
cc      call flgrad(emd,grade,rs,2,0)
cc      call flgrad(hhh,gradh,rs,2,0)
c
c ======================================================================
c
c     Equation of continuity.  
c     Homogeneous solution.
c
c ======================================================================
c
c ----
c     Source term.
c ----
      do 1099 ip = 0, np
      do 1099 it = 0, nt
      surp(it,ip) = 0.0d0
      do 1099 ir = 0, nr
      souv(ir,it,ip) = 0.0d0
      vpot(ir,it,ip) = 0.0d0
 1099 continue
c
      do 1100 ip = 0, np
      do 1100 it = 0, nt
      do 1100 ir = 0, nr
c
      hhxxu = 0.0d0
      hhxyu = 0.0d0
      hhxzu = 0.0d0
      hhyyu = 0.0d0
      hhyzu = 0.0d0
      hhzzu = 0.0d0
      hhyxu = hhxyu
      hhzxu = hhxzu
      hhzyu = hhyzu
      gamxxu = hhxxu + 1.0d0
      gamxyu = hhxyu
      gamxzu = hhxzu
      gamyyu = hhyyu + 1.0d0
      gamyzu = hhyzu
      gamzzu = hhzzu + 1.0d0
      gamyxu = gamxyu
      gamzxu = gamxzu
      gamzyu = gamyzu
      rotshx = bvxuf(ir,it,ip) + ome*vphif(ir,it,ip,1)
      rotshy = bvyuf(ir,it,ip) + ome*vphif(ir,it,ip,2)
      rotshz = bvzuf(ir,it,ip) + ome*vphif(ir,it,ip,3)
      gcx = 0.0d0
      gcy = 0.0d0
      gcz = 0.0d0
c
      dxpsi = gradps(ir,it,ip,1)
      dypsi = gradps(ir,it,ip,2)
      dzpsi = gradps(ir,it,ip,3)
      pfinv = 1.0d0/psif(ir,it,ip)
      pf2inv = pfinv**2
      pf4 = psif4(ir,it,ip)
      dxvpd = gradv(ir,it,ip,1)
      dyvpd = gradv(ir,it,ip,2)
      dzvpd = gradv(ir,it,ip,3)
      dxvpu = gamxxu*dxvpd + gamxyu*dyvpd + gamxzu*dzvpd
      dyvpu = gamyxu*dxvpd + gamyyu*dyvpd + gamyzu*dzvpd
      dzvpu = gamzxu*dxvpd + gamzyu*dyvpd + gamzzu*dzvpd
      hhut = hut(ir,it,ip)
      dxhutp6 = gradhu(ir,it,ip,1)
      dyhutp6 = gradhu(ir,it,ip,2)
      dzhutp6 = gradhu(ir,it,ip,3)
      dxlnarh = gradah(ir,it,ip,1)+pinx*grade(ir,it,ip,1)/emd(ir,it,ip)
      dylnarh = gradah(ir,it,ip,2)+pinx*grade(ir,it,ip,2)/emd(ir,it,ip)
      dzlnarh = gradah(ir,it,ip,3)+pinx*grade(ir,it,ip,3)/emd(ir,it,ip)
      divbvf = cdvbvf(ir,it,ip)
c
c      if (it.eq.nt.and.ip.eq.np/2) write(6,*)divbvf,bvyuf(ir,it,ip)
c --- DaDb vep
c
      call dadbscalarf(vep,dabvep,ir,it,ip)
c
      souv(ir,it,ip) = 
     &  -(hhxxu*dabvep(1,1) + hhxyu*dabvep(1,2) + hhxzu*dabvep(1,3)
     &  + hhyxu*dabvep(2,1) + hhyyu*dabvep(2,2) + hhyzu*dabvep(2,3)
     &  + hhzxu*dabvep(3,1) + hhzyu*dabvep(3,2) + hhzzu*dabvep(3,3))
     &  + gcx*dxvpd + gcy*dyvpd + gcz*dzvpd
     &  - 2.0d0*pfinv*(dxvpu*dxpsi + dyvpu*dypsi + dzvpu*dzpsi)
     &  + pf2inv*(rotshx*dxhutp6 + rotshy*dyhutp6 + rotshz*dzhutp6)
     &  + pf4*hhut*divbvf
     &  -(dxvpu - pf4*hhut*rotshx)*dxlnarh
     &  -(dyvpu - pf4*hhut*rotshy)*dylnarh
     &  -(dzvpu - pf4*hhut*rotshz)*dzlnarh
c
 1100 continue
c
ctesttest
c        stop
ctesttest
c
      do 1101 ip = 0, np
      do 1101 it = 0, nt
      b1 = souv(nr-2,it,ip) - souv(nr-3,it,ip)
      b2 = souv(nr-1,it,ip) - souv(nr-2,it,ip)
      b3 = 2.0d0*b2 - b1
      souv(nr,it,ip) = b3 + souv(nr-1,it,ip)
ccc      souv(nr,it,ip) = 2.0d0*souv(nr-1,it,ip) - souv(nr-2,it,ip)
      souv(0,it,ip) = 0.0d0
 1101 continue
      do 1102 it = 0, nt
      do 1102 ir = 0, nr
      souv(ir,it, 0) = 0.0d0
      souv(ir,it,np) = 0.0d0
 1102 continue
c
c === START of fixed coordinate. ===
c
      call sf2fc(souv,souvfc,rs)
c
      do 448 ip = 0, np
      do 448 it = 0, nt
      iflag = 1
      irsf = idint(rs(it,ip)*dble(nr))
      drdr= (rs(it,ip) - r(irsf))/dr
      do 448 ir = 0, nr
c
      wgsf(ir,it,ip) = dble(iflag)
czcz      if (ir.eq.irsf-1.and.ir+1.ne.nr) then
czcz      wgsf(ir,it,ip) = 1.0d0 - 0.5d0*drdr**2
czcz      end if
      if (ir.eq.irsf.and.ir.ne.nr) then
czcz      wgsf(ir,it,ip) = 0.5d0 + drdr + 1.5d0*drdr**2
      wgsf(ir,it,ip) = 0.5d0 + drdr
czcz      wgsf(ir,it,ip) = 0.5d0
      iflag = 0
      end if
      wgrtpv(ir,it,ip) = wgsf(ir,it,ip)*wgdr(ir)*wgdt(it)*wgdp(ip)
ccc      wgrtpv(ir,it,ip) = wgdr(ir)*wgdt(it)*wgdp(ip)
      flag(ir,it,ip) = dble(iflag)
cahotest
c
cp      if(ip.eq.0.or .ip.eq.np) facp = 1.0d0/3.0d0
cp      if(ip.ne.0.and.ip.ne.np.and.mod(ip,2).eq.1) facp = 4.0d0/3.0d0 
cp      if(ip.ne.0.and.ip.ne.np.and.mod(ip,2).eq.0) facp = 2.0d0/3.0d0 
c
cp      if(it.eq.0.or .it.eq.nt) fact = 1.0d0/3.0d0
cp      if(it.ne.0.and.it.ne.nt.and.mod(it,2).eq.1) fact = 4.0d0/3.0d0 
cp      if(it.ne.0.and.it.ne.nt.and.mod(it,2).eq.0) fact = 2.0d0/3.0d0 
c
cp      if(ir.eq.0.or .ir.eq.nr) facr = 1.0d0/3.0d0
cp      if(ir.ne.0.and.ir.ne.nr.and.mod(ir,2).eq.1) facr = 4.0d0/3.0d0
cp      if(ir.ne.0.and.ir.ne.nr.and.mod(ir,2).eq.0) facr = 2.0d0/3.0d0
c
cp      fac = facr*fact*facp
cp      wgrtpv(ir,it,ip) = fac*r(ir)**2*dr*sinthe(it)*dth*dphi
c
 448  continue
c
      call gravep(souvfc,vpotfc,wgrtpv,sinmp)
      call fc2sf(vpotfc,vpot,rs)
c
c === END of fixed coordinate. ===
c
      call gravpot(souvfc,ddvpot,wgrtpv,sinmp,rs)
c
c      call flfcgrad4(vpotfc,gradv,3)
c
      ir = nr
      nc = nnr
      n = nr+1
c
      do 1104 ip = 0, np
      do 1104 it = 0, nt
c
      irsf = idnint(rs(it,ip)*dble(nr))
      if (irsf.eq.nr) irsf = nr - 1
      delr = rs(it,ip) - r(irsf)
      ddvpot(it,ip,1) = 0.5d0*drinv**2*
     &         ((2.0d0*delr - dr)*vpotfc(irsf-1,it,ip) 
     &        + (2.0d0*delr + dr)*vpotfc(irsf+1,it,ip) 
     &        -  4.0d0*delr*      vpotfc(irsf  ,it,ip) )
      if (rs(it,ip).ge.1.0d0) then 
      ddvpot(it,ip,1) = 0.5d0*drinv*(3.0d0*vpotfc(nr  ,it,ip)  
     &                             - 4.0d0*vpotfc(nr-1,it,ip) 
     &                             +       vpotfc(nr-2,it,ip) )
      end if
c
      hhxxu = 0.0d0
      hhxyu = 0.0d0
      hhxzu = 0.0d0
      hhyyu = 0.0d0
      hhyzu = 0.0d0
      hhzzu = 0.0d0
      hhyxu = hhxyu
      hhzxu = hhxzu
      hhzyu = hhyzu
      gamxxu = hhxxu + 1.0d0
      gamxyu = hhxyu
      gamxzu = hhxzu
      gamyyu = hhyyu + 1.0d0
      gamyzu = hhyzu
      gamzzu = hhzzu + 1.0d0
      gamyxu = gamxyu
      gamzxu = gamxzu
      gamzyu = gamyzu
      gr1 = ddvpot(it,ip,1)
      gr2 = ddvpot(it,ip,2)
      gr3 = ddvpot(it,ip,3)
      dxvep = gr1*sinthe(it)*cosphi(ip)
     &      + gr2*costhe(it)*cosphi(ip)  
     &      - gr3*sinphi(ip) 
      dyvep = gr1*sinthe(it)*sinphi(ip)
     &      + gr2*costhe(it)*sinphi(ip)
     &      + gr3*cosphi(ip) 
      dzvep = gr1*costhe(it)
     &      - gr2*sinthe(it)
c
      rnr = 1.0d0
      rnth = - rsinv(it,ip)*dtrs(it,ip)
      rnphi = - rsinv(it,ip)*cosec(it)*dprs(it,ip)
      erx = sinthe(it)*cosphi(ip)
      ery = sinthe(it)*sinphi(ip)
      erz = costhe(it)
      ethx = costhe(it)*cosphi(ip)
      ethy = costhe(it)*sinphi(ip)
      ethz = - sinthe(it)
      ephix = - sinphi(ip)
      ephiy =   cosphi(ip)
      ephiz = 0.0d0
      rnx = rnr*erx + rnth*ethx + rnphi*ephix
      rny = rnr*ery + rnth*ethy + rnphi*ephiy
      rnz = rnr*erz + rnth*ethz + rnphi*ephiz
c
      surp(it,ip) = (gamxxu*dxvep + gamxyu*dyvep + gamxzu*dzvep)*rnx
     &            + (gamyxu*dxvep + gamyyu*dyvep + gamyzu*dzvep)*rny
     &            + (gamzxu*dxvep + gamzyu*dyvep + gamzzu*dzvep)*rnz
c
 1104 continue
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c     Coefficients of harmonic solution is computed. 
c      write(6,*)' surf  '
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
      do 2000 ii = 1, nbou
      sgg(ii) = 0.
      do 2000 jj = 1, nbou
      gg(ii,jj) = 0.0d0
      alm(ii,jj) = 0.0d0
 2000 continue
c
c --- Boundary equations are solved. 
c
      ieqs = 0
      do 85 il = 1, nla
      do 85 im = 2-mod(il,2), il, 2
      ieqs = ieqs + 1
c
      do 80 ip = 0, np
      do 80 it = 1, nt
c
      ir = nr
c
      rnr = 1.0d0
      rnth = - rsinv(it,ip)*dtrs(it,ip)
      rnphi = - rsinv(it,ip)*cosec(it)*dprs(it,ip)
      erx = sinthe(it)*cosphi(ip)
      ery = sinthe(it)*sinphi(ip)
      erz = costhe(it)
      ethx = costhe(it)*cosphi(ip)
      ethy = costhe(it)*sinphi(ip)
      ethz = - sinthe(it)
      ephix = - sinphi(ip)
      ephiy =   cosphi(ip)
      ephiz = 0.0d0
      rnx = rnr*erx + rnth*ethx + rnphi*ephix
      rny = rnr*ery + rnth*ethy + rnphi*ephiy
      rnz = rnr*erz + rnth*ethz + rnphi*ephiz
      rotshx = bvxuf(ir,it,ip) + ome*vphif(ir,it,ip,1)
      rotshy = bvyuf(ir,it,ip) + ome*vphif(ir,it,ip,2)
      rotshz = bvzuf(ir,it,ip) + ome*vphif(ir,it,ip,3)
c
      flm = 
     & dble(il)*rs(it,ip)**(il-1)*ypna(il,im,it)*sinmp(im,ip) - 
     & rs(it,ip)**(il-2)*dtrs(it,ip)*dtypna(il,im,it)*sinmp(im,ip) - 
     & rs(it,ip)**(il-2)*cosec(it)**2*dprs(it,ip)*ypna(il,im,it)*
     & dble(im)*cosmp(im,ip)
c
      sgg(ieqs) = sgg(ieqs) + 
     &  ( - surp(it,ip) + hut(ir,it,ip)*psif4(ir,it,ip)*
     &       (rotshx*rnx + rotshy*rny + rotshz*rnz) )*flm
c
      ivec = 0
      do 87 ill = 1, nla
      do 87 imm = 2-mod(ill,2), ill, 2
      ivec = ivec + 1
c
      fllmm = 
     & dble(ill)*rs(it,ip)**(ill-1)*ypna(ill,imm,it)*sinmp(imm,ip) - 
     & rs(it,ip)**(ill-2)*dtrs(it,ip)*dtypna(ill,imm,it)*sinmp(imm,ip) - 
     & rs(it,ip)**(ill-2)*cosec(it)**2*dprs(it,ip)*ypna(ill,imm,it)*
     & dble(imm)*cosmp(imm,ip)
c
      gg(ieqs,ivec) = gg(ieqs,ivec) + fllmm*flm
c
   87 continue
c
      if(ivec.ne.nbou) write(6,*) ' harmonic ivec wrong ', ivec, nbou
c
   80 continue
c
   85 continue
c
      if(ieqs.ne.nbou) write(6,*) ' harmonic ieqs wrong ', ieqs, nbou
c
ctesttest
c      do ii = 0, ieqs
c      write(24,99)sgg(ii)
c      end do
c      stop
c
      call minv(gg,sgg,nbou,nnbou)
c
      ieqs = 0
      do 88 il = 1, nla
      do 88 im = 2-mod(il,2), il, 2
      ieqs = ieqs + 1
      alm(il,im) = sgg(ieqs)
   88 continue
      if(ieqs.ne.nbou) write(6,*) ' harmonic alm wrong ', ieqs, nbou
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
      do 110 irtp = 1, (nr+1)*(nt+1)*(np+1)
c
      ip = (irtp-1)/((nr+1)*(nt+1))
      it = (irtp-1)/ (nr+1) - ip*(nt+1)
      ir = irtp-1 - it*(nr+1) - ip*(nr+1)*(nt+1)
c
      surf = 0.d0
      do 140 il = 1, nla
ccc      do 140 il = 1, nla-2
      do 140 im = 2-mod(il,2), il, 2
      surf = surf + alm(il,im)*(r(ir)*rs(it,ip))**il*
     &              ypna(il,im,it)*sinmp(im,ip)
  140 continue
c
      backf(ir,it,ip) = vep(ir,it,ip)
      vep(ir,it,ip) = vpot(ir,it,ip) + surf
c
  110 continue
c
ctesttest
c      do ir = 0, nr
c      write(24,99)r(ir),vep(ir,nt-2,2),vpot(ir,nt-2,2),
c     &   vep(ir,nt-2,2)-vpot(ir,nt-2,2)
c       end do
c 99   format(1p,7e14.6)
c        stop
ctesttest
c
      if (iter.eq.itmx) then
      do 141 il = 1, nla
      do 141 im = 2-mod(il,2), il, 2
      write(24,*)il,im,alm(il,im)
 141  continue
      end if
c
c --- For x-z plane. 
c
      do 1197 ip = 0, np
      do 1197 ir = 0, nr
      vep(ir,0,ip) = 0.0d0
 1197 continue
      do 1198 it = 1, nt
      do 1198 ir = 0, nr
      vep(ir,it,0 ) = 0.0d0
      vep(ir,it,np) = 0.0d0
 1198 continue
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
c
c     ### Iteration. ###
c     Set improved values for velocity potential.
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
c
c --- Set improved variables. 
c
      call flimpro(backf,vep,cfvep,emxvep,irerr,iterr,iperr,0)
      write(6,4901) '  == vep   ==, error =', emxvep,
     &              vep(irerr,iterr,iperr), irerr,iterr,iperr
      fmax0 = dmax1(emxvep,fmax0)
c
c --  Improving parameters and alpha and psi.  
c
      call paimpro_bhns(ome,ber,radi,convf,iter,fmax0,1)
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
cmark
      call flgrad4(vep,gradv,rs,1,0)
c      call flgrad(vep,gradv,rs,1,0)
      ahores = 0.0d0
      do 500 ip = 0, np
      do 500 it = 0, nt
      do 500 ir = 0, nr
c
      alpfc = alphf(ir,it,ip)
      psifc = psif(ir,it,ip)
      emdfc = emd(ir,it,ip)
      if (emdfc.le.1.0d-14) emdfc = 1.0d-14
      rhofc = emdfc**pinx
      hhfc  = 1.0d0 + (pinx+1.0d0)*emdfc
      bvxfc = bvxuf(ir,it,ip)
      bvyfc = bvyuf(ir,it,ip)
      bvzfc = bvzuf(ir,it,ip)
      vphix = vphif(ir,it,ip,1)
      vphiy = vphif(ir,it,ip,2)
      vphiz = vphif(ir,it,ip,3)
      ram(ir,it,ip) = ber + (bvxfc + ome*vphix)*gradv(ir,it,ip,1)
     &                    + (bvyfc + ome*vphiy)*gradv(ir,it,ip,2)
     &                    + (bvzfc + ome*vphiz)*gradv(ir,it,ip,3)
      ramfc = ram(ir,it,ip)
c
      utfc  = ramfc/(alpfc**2*hhfc)
c
      weiflu = rs(it,ip)**3*wahop(ir,it,ip)
      ahores = ahores + rhofc*alpfc*utfc*psifc**6*weiflu
c
 500  continue
      ahores = radi**3*ahores*8.0d0/2.0d0
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
 4901 format(a22,1p,e12.4,',  value =',e12.4,2x,3i4)
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine gravep(sou,pot,wgrtp,scmp)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / legen / spn(0:nnt,0:nnp,0:nnl), 
     &                 fsn(0:nnr,0:nnl,0:nnr)
      common / asleg / pna(0:nnla,0:nnla,0:nnt),
     &               dtpna(0:nnla,0:nnla,0:nnt), 
     &               facnm(0:nnla,0:nnla), epsi(0:nnla)
c
      dimension  sou(0:nnr,0:nnt,0:nnp), pot(0:nnr,0:nnt,0:nnp)
      dimension  scmp(0:nnla,0:nnp)
      dimension  wgrtp(0:nnr,0:nnt,0:nnp)
      dimension work1(0:nnt,0:nnr,0:nnl), 
     &          work2(0:nnr,0:nnl,0:nnl), 
     &          work3(0:nnl,0:nnl,0:nnr),
     &          work4(0:nnl,0:nnr,0:nnt)
c
c --- Gravitational and Velocity potential is caluculated.
c      write(6,*)' gravep  '
c
c    fsn(irr,nn,id,ir) --> id =  0 for r'< r
c                          id = +1 for r < r'
c
      do 1001 im = 0, nl, msym
      do 1001 irr = 0, nr
      do 1001 itt = 0, nt
      work1(itt,irr,im) = 0.0d0
      do 1001 ipp = 0, np
      work1(itt,irr,im) = work1(itt,irr,im) + 
     &                    wgrtp(irr,itt,ipp)*
     &                    sou(irr,itt,ipp)*scmp(im,ipp)
 1001 continue
c
      do 1002 il = 0, nl
      do 1002 im = 0, nl, msym
      pari = 1.0d0 + (-1.0d0)**(il+im)
      do 1002 irr = 0, nr
      work2(irr,il,im) = 0.0d0
      do 1002 itt = 0, nt
      work2(irr,il,im) = work2(irr,il,im) + 
     &                   pari*epsi(im)*facnm(il,im)*
     &                   work1(itt,irr,im)*pna(il,im,itt)
 1002 continue
c
      do 1003 ir = 0, nr
      do 1003 il = 0, nl
      do 1003 im = 0, nl, msym
      work3(il,im,ir) = 0.0d0
      do 1003 irr = 0, nr
      work3(il,im,ir) = work3(il,im,ir) + 
     &                  work2(irr,il,im)*fsn(irr,il,ir)
 1003 continue
c
      do 1004 it = 0, nt
      do 1004 ir = 0, nr
      do 1004 im = 0, nl, msym
      work4(im,ir,it) = 0.0d0
      do 1004 il = 0, nl
      work4(im,ir,it) = work4(im,ir,it) + 
     &                  work3(il,im,ir)*pna(il,im,it)
 1004 continue
c
      do 1000 ip = 0, np
      do 1000 it = 0, nt
      do 1000 ir = 0, nr
      pot(ir,it,ip) = 0.0d0
      do 1000 im = 0, nl, msym
      pot(ir,it,ip) = pot(ir,it,ip) +
     &                work4(im,ir,it)*scmp(im,ip)
 1000 continue
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      pi4aho = pi4inv*2.0d0*dble(msym)
      do 100 ip = 0, np
      do 100 it = 0, nt
      do 100 ir = 0, nr
 100  pot(ir,it,ip) = - pi4aho*pot(ir,it,ip)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine gravpot(sou,ddvpot,wgrtp,scmp,rs)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / legen / spn(0:nnt,0:nnp,0:nnl), 
     &                 fsn(0:nnr,0:nnl,0:nnr)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
      common / asleg / pna(0:nnla,0:nnla,0:nnt),
     &               dtpna(0:nnla,0:nnla,0:nnt), 
     &               facnm(0:nnla,0:nnla), epsi(0:nnla)
c
      dimension  sou(0:nnr,0:nnt,0:nnp), pot(0:nnr,0:nnt,0:nnp,2:3)
      dimension  scmp(0:nnla,0:nnp)
      dimension  wgrtp(0:nnr,0:nnt,0:nnp)
      dimension work1(0:nnt,0:nnr,0:nnl), 
     &          work2(0:nnr,0:nnl,0:nnl), 
     &          work3(0:nnl,0:nnl,0:nnr),
     &          work42(0:nnl,0:nnr,0:nnt),
     &          work43(0:nnl,0:nnr,0:nnt)
c
      dimension ddvpot(0:nnt,0:nnp,1:3), rs(0:nnt,0:nnp)
      dimension x(nnr),y(nnr),df(2),iopt(2),c(nnr,3),f(1),v(1)
c
c --- Gravitational and Velocity potential is caluculated.
c      write(6,*)' gravep  '
c
c    fsn(irr,nn,id,ir) --> id =  0 for r'< r
c                          id = +1 for r < r'
      do 1001 im = 0, nl, msym
      do 1001 irr = 0, nr
      do 1001 itt = 0, nt
      work1(itt,irr,im) = 0.0d0
      do 1001 ipp = 0, np
      work1(itt,irr,im) = work1(itt,irr,im) + 
     &                    wgrtp(irr,itt,ipp)*
     &                    sou(irr,itt,ipp)*scmp(im,ipp)
 1001 continue
c
      do 1002 il = 0, nl
      do 1002 im = 0, nl, msym
      pari = 1.0d0 + (-1.0d0)**(il+im)
      do 1002 irr = 0, nr
      work2(irr,il,im) = 0.0d0
      do 1002 itt = 0, nt
      work2(irr,il,im) = work2(irr,il,im) + 
     &                   pari*epsi(im)*facnm(il,im)*
     &                   work1(itt,irr,im)*pna(il,im,itt)
 1002 continue
c
      do 1003 ir = 0, nr
      do 1003 il = 0, nl
      do 1003 im = 0, nl, msym
      work3(il,im,ir) = 0.0d0
      do 1003 irr = 0, nr
      work3(il,im,ir) = work3(il,im,ir) + 
     &                  work2(irr,il,im)*fsn(irr,il,ir)
 1003 continue
c
      do 1004 it = 0, nt
      do 1004 ir = 0, nr
      do 1004 im = 0, nl, msym
      work42(im,ir,it) = 0.0d0
      work43(im,ir,it) = 0.0d0
      do 1004 il = 0, nl
      work42(im,ir,it) = work42(im,ir,it) + 
     &                    work3(il,im,ir)*dtpna(il,im,it)
      work43(im,ir,it) = work43(im,ir,it) + 
     &                    work3(il,im,ir)*pna(il,im,it)
 1004 continue
c
      do 1000 ip = 0, np
      do 1000 it = 0, nt
      do 1000 ir = 0, nr
      pot(ir,it,ip,2) = 0.0d0
      pot(ir,it,ip,3) = 0.0d0
      do 1000 im = 0, nl, msym
      pot(ir,it,ip,2) = pot(ir,it,ip,2) +
     &                  work42(im,ir,it)*sinmp(im,ip)
      pot(ir,it,ip,3) = pot(ir,it,ip,3) +
     &                  work43(im,ir,it)*dble(im)*cosmp(im,ip)
 1000 continue
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      pi4aho = pi4inv*2.0d0*dble(msym)
      do 100 ii = 2, 3
      do 100 ip = 0, np
      do 100 it = 0, nt
      do 100 ir = 0, nr
      pot(ir,it,ip,ii) = - pi4aho*pot(ir,it,ip,ii)
 100  continue
c
      nc = nnr
      n = nr+1
c
      do 9 iii = 2, 3 
      do 9 ip = 0, np
      do 9 it = 0, nt
      ddvpot(it,ip,iii) = 0.0d0
      if (iii.eq.1) go to 9
c
      do 10 ir=0,nr
       x(ir+1)=r(ir)
   10  y(ir+1)=pot(ir,it,ip,iii)
      iopt(1)=3
      iopt(2)=3
cccp      iopt(1)=1
cccp      iopt(2)=1
      df(1) = 0.d0
      df(2) = 0.d0
      call splc(x,n,y,df,iopt,c,nc,ier)
      v(1)=rs(it,ip)
      if (rs(it,ip).ge.1.0d0) v(1) = 1.0d0
      call splf(x,n,y,c,nc,v,1,f,ier)
      ddvpot(it,ip,iii) = f(1)
 9    continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine sf2fc(sfv,fcv,rs)
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension rs(0:nnt,0:nnp)
      dimension sfv(0:nnr,0:nnt,0:nnp), fcv(0:nnr,0:nnt,0:nnp)
c
       dimension x(nnr),y(nnr),df(2),iopt(2),c(nnr,3),f(nnr),v(nnr)
c
      nc = nnr
      n = nr+1
      do 4 ip = 0, np
      do 4 it = 0, nt
      do 10 ir=0,nr
       x(ir+1)=r(ir)*rs(it,ip)
   10  y(ir+1)=sfv(ir,it,ip)
      iopt(1)=3
c --- important, iopt(2)=1 is better than iopt(2)=3
      iopt(2)=1
cccp      iopt(1)=1
cccp      iopt(2)=1
      df(1) = 0.d0
      df(2) = 0.d0
      call splc(x,n,y,df,iopt,c,nc,ier)
      irsf = idint(rs(it,ip)*dble(nr))
      do 20 ir=1,irsf
   20  v(ir)=r(ir)
      call splf(x,n,y,c,nc,v,irsf,f,ier)
      fcv(0,it,ip) = sfv(0,it,ip) 
      do 25 ir=1,irsf
   25  fcv(ir,it,ip) = f(ir)
      do 26 ir=irsf+1,nr
   26  fcv(ir,it,ip) = 0.0d0
    4 continue
c
      do 15 ir = 0, nr
      fcv(ir,nt, 0) = sfv(ir,nt, 0)
      fcv(ir,nt,np) = sfv(ir,nt,np)
 15   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine fc2sf(fcv,sfv,rs)
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension rs(0:nnt,0:nnp)
      dimension sfv(0:nnr,0:nnt,0:nnp), fcv(0:nnr,0:nnt,0:nnp)
c
       dimension x(nnr),y(nnr),df(2),iopt(2),c(nnr,3),f(nnr),v(nnr)
c
      nc = nnr
      nro = nr
      do 4 ip = 0, np
      do 4 it = 0, nt
      if((ip.eq.0.and.it.eq.nt).or.(ip.eq.np.and.it.eq.nt)) go to 4
ckk      nro = idint(rs(it,ip)*dble(nr))
      n = nro+1
ckk      n = nro+2
czz      do 10 ir=0,nro
ckk      do 10 ir=0,nro+1
      do 10 ir=0,nro
       x(ir+1)=r(ir)
   10  y(ir+1)=fcv(ir,it,ip)
      iopt(1)=3
      iopt(2)=3
ccccc      iopt(2)=1
      df(1) = 0.d0
      df(2) = 0.d0
      call splc(x,n,y,df,iopt,c,nc,ier)
czz      do 20 ir=1,nr-1
      do 20 ir=1,nr
   20  v(ir)=r(ir)*rs(it,ip)
      call splf(x,n,y,c,nc,v,nr,f,ier)
      sfv(0,it,ip) = fcv(0,it,ip) 
cccc      do 25 ir=1,nr-1
      do 25 ir=1,nr
   25 sfv(ir,it,ip) = f(ir)
cccc      sfv(nr,it,ip) = 2.0d0*f(nr-1) - f(nr-2)
    4 continue
c
      do 15 ir = 0, nr
      sfv(ir,nt, 0) = fcv(ir,nt, 0)
      sfv(ir,nt,np) = fcv(ir,nt,np)
 15   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine flgrad(fnc,grad,rs,isw,iswx)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / diffv / rsinv(0:nnt,0:nnp),
     &              dtrs(0:nnt,0:nnp),dprs(0:nnt,0:nnp)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
c
      dimension  fnc(0:nnr,0:nnt,0:nnp), rs(0:nnt,0:nnp), 
     &          grad(0:nnr,0:nnt,0:nnp,1:3)
      dimension  fp(0:nnp), dfp(0:nnp)
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c     Derivatives for variables.
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      drinv=1.0d0/dr
      dtinv=1.0d0/dth
      dpinv=1.0d0/dphi
      pi = 3.14159265358979d+0
c
c --- Clear.
c
      do 40 ip = 0, np
      do 40 it = 0, nt
      rsinv(it,ip)=1.0d0/rs(it,ip)
      dtrs(it,ip) = 0.0d0
      dprs(it,ip) = 0.0d0
      do 40 ir = 0, nr
      grad(ir,it,ip,1) = 0.0d0
      grad(ir,it,ip,2) = 0.0d0
      grad(ir,it,ip,3) = 0.0d0
 40   continue
c
c --- r-direction.
c
      do 41 ip = 0, np
      do 41 it = 0, nt
      grad( 0,it,ip,1) = 0.5d0*drinv*rsinv(it,ip)*
     & (-3.0d0*fnc( 0,it,ip)+4.0d0*fnc(   1,it,ip)-fnc(   2,it,ip))
      grad(nr,it,ip,1) = 0.5d0*drinv*rsinv(it,ip)*
     & ( 3.0d0*fnc(nr,it,ip)-4.0d0*fnc(nr-1,it,ip)+fnc(nr-2,it,ip))
      do 41 ir = 1, nr-1
      grad(ir,it,ip,1) = (fnc(ir+1,it,ip) - fnc(ir-1,it,ip))*
     &                  0.5d0*drinv*rsinv(it,ip)
 41   continue
c
c --- theta-direction.
c
      do 42 ip = 0, np
      dtrs( 0,ip) = 0.5d0*dtinv*
     & (-3.0d0*rs(0,ip)+4.0d0*rs(1,ip)-rs(2,ip))
      dtrs(nt,ip) = 0.5d0*dtinv*
     & (3.0d0*rs(nt,ip)-4.0d0*rs(nt-1,ip)+rs(nt-2,ip))
      do 43 ir = 1, nr
      grad(ir,0,ip,2) = 0.5d0*dtinv*
     & (-3.0d0*fnc(ir,0,ip)+4.0d0*fnc(ir,1,ip)-fnc(ir,2,ip))
     &                - r(ir)*dtrs(0,ip)*grad(ir,0,ip,1)
      grad(ir,nt,ip,2) = 0.5d0*dtinv*
     & (3.0d0*fnc(ir,nt,ip)-4.0d0*fnc(ir,nt-1,ip)+fnc(ir,nt-2,ip))
     &                 - r(ir)*dtrs(nt,ip)*grad(ir,nt,ip,1)
 43   continue
      do 44 it = 1, nt-1
      dtrs(it,ip) = 0.5d0*dtinv*(rs(it+1,ip) - rs(it-1,ip))
      do 44 ir = 1, nr
      grad(ir,it,ip,2) = (fnc(ir,it+1,ip)-fnc(ir,it-1,ip))*0.5d0*dtinv
     &                 - r(ir)*dtrs(it,ip)*grad(ir,it,ip,1)
 44   continue
 42   continue
c
c --- phi-direction.
c
      do 45 it = 0, nt
      dprs(it,0) = 0.5d0*dpinv*
     & (-3.0d0*rs(it,0)+4.0d0*rs(it,1)-rs(it,2))
caho      if(iswx.eq.-1) dprs(it,0) = dpinv*(rs(it,1)-rs(it,0))
caho      if(iswx.eq.-1) dprs(it,0) = 0.0d0
      dprs(it,np) = 0.5d0*dpinv*
     & (3.0d0*rs(it,np)-4.0d0*rs(it,np-1)+rs(it,np-2))
caho      if(iswx.eq.-1) dprs(it,np) = dpinv*(rs(it,np) - rs(it,np-1))
      do 46 ir = 1, nr
      grad(ir,it, 0,3) = 0.5d0*dpinv*
     & (-3.0d0*fnc(ir,it,0)+4.0d0*fnc(ir,it, 1)-fnc(ir,it,2))
     &                 - r(ir)*dprs(it,0)*grad(ir,it,0,1)
       if (iswx.eq.-1) 
     & grad(ir,it, 0,3) = dpinv*
     & (fnc(ir,it,1) - fnc(ir,it,0))
     &                 - r(ir)*dprs(it,0)*grad(ir,it,0,1)
      grad(ir,it,np,3) = 0.5d0*dpinv*
     & (3.0d0*fnc(ir,it,np)-4.0d0*fnc(ir,it,np-1)+fnc(ir,it,np-2))
     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
caho       if (iswx.eq.-1) 
caho     & grad(ir,it,np,3) = dpinv*
caho     & (fnc(ir,it,np) - fnc(ir,it,np-1))
caho     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
clast
ck       if (isw.eq.1) 
ck     & grad(ir,it,np,3) = dpinv*
ck     & (fnc(ir,it,np) - fnc(ir,it,np-1))
ck     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
clast
 46   continue
      do 47 ip = 1, np-1
      dprs(it,ip) = (rs(it,ip+1) - rs(it,ip-1))*0.5d0*dpinv
      do 47 ir = 1, nr
      grad(ir,it,ip,3) = (fnc(ir,it,ip+1)-fnc(ir,it,ip-1))*0.5d0*dpinv
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 47   continue
 45   continue
c
      if (iswx.ge.1) then
c
      error = 0.0d0
      do 400 it = nt/2, nt
c
cz      do 4001 ip = 0, np
cz 4001 fp(ip) = rs(it,ip)
cz      call fouri(fp,dfp,cosmp,sinmp,2)
cz      do 4002 ip = 0, 5
czz       ip = 0
cz      oldv = dprs(it,ip)
cz      dprs(it,ip) = 0.0d0
cz      dprs(it,ip) = dfp(ip)
cz 4002 error = 
cz     &  dmax1(error,dabs(dprs(it,ip) - oldv)/
cz     &              dabs(dprs(it,ip) + oldv))
czz      write(6,*) dprs(it,ip) , oldv
c      
      do 401 ir = nr/2, nr
c
      do 4004 ip = 0, np
 4004 fp(ip) = fnc(ir,it,ip)
      if (isw.eq.1) call fouri(fp,dfp,sinmp,cosmp,isw)
      if (isw.eq.2) call fouri(fp,dfp,cosmp,sinmp,isw)
      do 4005 ip = 0, iswx
      oldv = grad(ir,it,ip,3)
      grad(ir,it,ip,3) = 0.0d0
      grad(ir,it,ip,3) = dfp(ip)
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 4005 error = 
     &  dmax1(error,dabs(grad(ir,it,ip,3) - oldv)/
     &              dabs(grad(ir,it,ip,3) + oldv))
c
 401  continue
 400  continue
      if (error.ge.0.1d0) 
     & write(6,*) ' relative error for derivative ', error
c
      end if
c
      do 49 ip = 0, np
      do 49 it = 0, nt
      do 49 ir = 0, nr
      grad(ir,it,ip,1)=grad(ir,it,ip,1)
      grad(ir,it,ip,2)=grad(ir,it,ip,2)*rinv(ir)*rsinv(it,ip)
      grad(ir,it,ip,3)=grad(ir,it,ip,3)*rinv(ir)*rsinv(it,ip)*cosec(it)
 49   continue
c
c --- On theta=0 axis and the center for velocity.
c
      if (isw.eq.1) then
      do 58 ip = 0, np
      do 58 ir = 0, nr
      grad(ir,0,ip,3)=grad(ir,0,np/2,2)*cosphi(ip)
 58   continue
      do 59 ip = 0, np
      do 59 it = 0, nt
      grad(0,it,ip,2)=grad(0,nt,np/2,1)*costhe(it)*sinphi(ip)
      grad(0,it,ip,3)=grad(0,nt,np/2,1)*cosphi(ip)
 59   continue
      end if
c
      do 141 ip = 0, np
      do 141 it = 0, nt
      do 141 ir = 0, nr
      gr1=grad(ir,it,ip,1)
      gr2=grad(ir,it,ip,2)
      gr3=grad(ir,it,ip,3)
      grad(ir,it,ip,1) = gr1*sinthe(it)*cosphi(ip)
     &                 + gr2*costhe(it)*cosphi(ip)  
     &                 - gr3*sinphi(ip) 
      grad(ir,it,ip,2) = gr1*sinthe(it)*sinphi(ip)
     &                 + gr2*costhe(it)*sinphi(ip)
     &                 + gr3*cosphi(ip) 
      grad(ir,it,ip,3) = gr1*costhe(it)
     &                 - gr2*sinthe(it)
 141  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine flgrad4(fnc,grad,rs,isw,iswx)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / diffv / rsinv(0:nnt,0:nnp),
     &              dtrs(0:nnt,0:nnp),dprs(0:nnt,0:nnp)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
c
      dimension  fnc(0:nnr,0:nnt,0:nnp), rs(0:nnt,0:nnp), 
     &          grad(0:nnr,0:nnt,0:nnp,1:3)
      dimension  fp(0:nnp), dfp(0:nnp)
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c     Derivatives for variables.
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      drinv=1.0d0/dr
      dtinv=1.0d0/dth
      dpinv=1.0d0/dphi
      drinv12=1.0d0/dr/12.0d0
      dtinv12=1.0d0/dth/12.0d0
      dpinv12=1.0d0/dphi/12.0d0
      pi = 3.14159265358979d+0
c
c --- Clear.
c
      do 40 ip = 0, np
      do 40 it = 0, nt
      rsinv(it,ip)=1.0d0/rs(it,ip)
      dtrs(it,ip) = 0.0d0
      dprs(it,ip) = 0.0d0
      do 40 ir = 0, nr
      grad(ir,it,ip,1) = 0.0d0
      grad(ir,it,ip,2) = 0.0d0
      grad(ir,it,ip,3) = 0.0d0
 40   continue
c
c --- r-direction.
c
      do 41 ip = 0, np
      do 41 it = 0, nt
      grad(   0,it,ip,1) = drinv12*rsinv(it,ip)*
     & ( - 25.0d0*fnc(   0,it,ip) + 48.0d0*fnc(   1,it,ip) 
     &   - 36.0d0*fnc(   2,it,ip) + 16.0d0*fnc(   3,it,ip) 
     &   -  3.0d0*fnc(   4,it,ip) )
      grad(   1,it,ip,1) = drinv12*rsinv(it,ip)*
     & ( -  3.0d0*fnc(   0,it,ip) - 10.0d0*fnc(   1,it,ip) 
     &   + 18.0d0*fnc(   2,it,ip) -  6.0d0*fnc(   3,it,ip) 
     &   +        fnc(   4,it,ip) )
      grad(nr  ,it,ip,1) = drinv12*rsinv(it,ip)*
     & (   25.0d0*fnc(nr  ,it,ip) - 48.0d0*fnc(nr-1,it,ip)
     &   + 36.0d0*fnc(nr-2,it,ip) - 16.0d0*fnc(nr-3,it,ip)
     &   +  3.0d0*fnc(nr-4,it,ip) )
      if (isw.eq.3) then
cc      grad(nr  ,it,ip,1) = drinv*rsinv(it,ip)*
cc     & ( fnc(nr,it,ip) - fnc(nr-1,it,ip) )
      grad(nr  ,it,ip,1) = 0.5d0*drinv*rsinv(it,ip)*
     & (3.0d0*fnc(nr,it,ip)-4.0d0*fnc(nr-1,it,ip)+fnc(nr-2,it,ip))
      end if
      grad(nr-1,it,ip,1) = drinv12*rsinv(it,ip)*
     & (    3.0d0*fnc(nr  ,it,ip) + 10.0d0*fnc(nr-1,it,ip)
     &   - 18.0d0*fnc(nr-2,it,ip) +  6.0d0*fnc(nr-3,it,ip)
     &   -        fnc(nr-4,it,ip) )
      do 41 ir = 2, nr-2
      grad(ir,it,ip,1) = drinv12*rsinv(it,ip)*
     & ( -        fnc(ir+2,it,ip) +  8.0d0*fnc(ir+1,it,ip)
     &   -  8.0d0*fnc(ir-1,it,ip) +        fnc(ir-2,it,ip) )
 41   continue
c
c --- theta-direction.
c
      do 42 ip = 0, np
      dtrs(   0,ip) = dtinv12*
     & ( - 25.0d0*rs(   0,ip) + 48.0d0*rs(   1,ip) 
     &   - 36.0d0*rs(   2,ip) + 16.0d0*rs(   3,ip) 
     &   -  3.0d0*rs(   4,ip) )
      dtrs(   1,ip) = dtinv12*
     & ( -  3.0d0*rs(   0,ip) - 10.0d0*rs(   1,ip) 
     &   + 18.0d0*rs(   2,ip) -  6.0d0*rs(   3,ip) 
     &   +        rs(   4,ip) )
      dtrs(nt  ,ip) = dtinv12*
     & (   25.0d0*rs(nt  ,ip) - 48.0d0*rs(nt-1,ip)
     &   + 36.0d0*rs(nt-2,ip) - 16.0d0*rs(nt-3,ip)
     &   +  3.0d0*rs(nt-4,ip) )
      dtrs(nt-1,ip) = dtinv12*
     & (    3.0d0*rs(nt  ,ip) + 10.0d0*rs(nt-1,ip)
     &   - 18.0d0*rs(nt-2,ip) +  6.0d0*rs(nt-3,ip)
     &   -        rs(nt-4,ip) )
      do 43 ir = 1, nr
      grad(ir,   0,ip,2) = dtinv12*
     & ( - 25.0d0*fnc(ir,   0,ip) + 48.0d0*fnc(ir,   1,ip) 
     &   - 36.0d0*fnc(ir,   2,ip) + 16.0d0*fnc(ir,   3,ip) 
     &   -  3.0d0*fnc(ir,   4,ip) )
     &                - r(ir)*dtrs(0,ip)*grad(ir,0,ip,1)
      grad(ir,   1,ip,2) = dtinv12*
     & ( -  3.0d0*fnc(ir,   0,ip) - 10.0d0*fnc(ir,   1,ip) 
     &   + 18.0d0*fnc(ir,   2,ip) -  6.0d0*fnc(ir,   3,ip) 
     &   +        fnc(ir,   4,ip) )
     &                - r(ir)*dtrs(1,ip)*grad(ir,1,ip,1)
      grad(ir,nt  ,ip,2) = dtinv12*
     & (   25.0d0*fnc(ir,nt  ,ip) - 48.0d0*fnc(ir,nt-1,ip)
     &   + 36.0d0*fnc(ir,nt-2,ip) - 16.0d0*fnc(ir,nt-3,ip)
     &   +  3.0d0*fnc(ir,nt-4,ip) )
     &                 - r(ir)*dtrs(nt,ip)*grad(ir,nt,ip,1)
      grad(ir,nt-1,ip,2) = dtinv12*
     & (    3.0d0*fnc(ir,nt  ,ip) + 10.0d0*fnc(ir,nt-1,ip)
     &   - 18.0d0*fnc(ir,nt-2,ip) +  6.0d0*fnc(ir,nt-3,ip)
     &   -        fnc(ir,nt-4,ip) )
     &                 - r(ir)*dtrs(nt-1,ip)*grad(ir,nt-1,ip,1)
 43   continue
      do 44 it = 2, nt-2
      dtrs(it,ip) = dtinv12*
     & ( -        rs(it+2,ip) +  8.0d0*rs(it+1,ip)
     &   -  8.0d0*rs(it-1,ip) +        rs(it-2,ip) )
      do 44 ir = 1, nr
      grad(ir,it,ip,2) = dtinv12*
     & ( -        fnc(ir,it+2,ip) +  8.0d0*fnc(ir,it+1,ip)
     &   -  8.0d0*fnc(ir,it-1,ip) +        fnc(ir,it-2,ip) )
     &                 - r(ir)*dtrs(it,ip)*grad(ir,it,ip,1)
 44   continue
 42   continue
c
c --- phi-direction.
c
      do 45 it = 0, nt
      dprs(it,   0) = dpinv12*
     & ( - 25.0d0*rs(it,   0) + 48.0d0*rs(it,   1) 
     &   - 36.0d0*rs(it,   2) + 16.0d0*rs(it,   3) 
     &   -  3.0d0*rs(it,   4) )
      dprs(it,   1) = dpinv12*
     & ( -  3.0d0*rs(it,   0) - 10.0d0*rs(it,   1) 
     &   + 18.0d0*rs(it,   2) -  6.0d0*rs(it,   3) 
     &   +        rs(it,   4) )
      dprs(it,np  ) = dpinv12*
     & (   25.0d0*rs(it,np  ) - 48.0d0*rs(it,np-1)
     &   + 36.0d0*rs(it,np-2) - 16.0d0*rs(it,np-3)
     &   +  3.0d0*rs(it,np-4) )
      dprs(it,np-1) = dpinv12*
     & (    3.0d0*rs(it,np  ) + 10.0d0*rs(it,np-1)
     &   - 18.0d0*rs(it,np-2) +  6.0d0*rs(it,np-3)
     &   -        rs(it,np-4) )
caho      if(iswx.eq.-1) 
caho     & dprs(it,0) = 0.5d0*dpinv*
caho     & (-3.0d0*rs(it,0)+4.0d0*rs(it,1)-rs(it,2))
      do 46 ir = 1, nr
      grad(ir,it,   0,3) = dpinv12*
     & ( - 25.0d0*fnc(ir,it,   0) + 48.0d0*fnc(ir,it,   1) 
     &   - 36.0d0*fnc(ir,it,   2) + 16.0d0*fnc(ir,it,   3) 
     &   -  3.0d0*fnc(ir,it,   4) )
     &                - r(ir)*dprs(it,0)*grad(ir,it,0,1)
      grad(ir,it,   1,3) = dpinv12*
     & ( -  3.0d0*fnc(ir,it,   0) - 10.0d0*fnc(ir,it,   1) 
     &   + 18.0d0*fnc(ir,it,   2) -  6.0d0*fnc(ir,it,   3) 
     &   +        fnc(ir,it,   4) )
     &                - r(ir)*dprs(it,1)*grad(ir,it,1,1)
      grad(ir,it,np  ,3) = dpinv12*
     & (   25.0d0*fnc(ir,it,np  ) - 48.0d0*fnc(ir,it,np-1)
     &   + 36.0d0*fnc(ir,it,np-2) - 16.0d0*fnc(ir,it,np-3)
     &   +  3.0d0*fnc(ir,it,np-4) )
     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
      grad(ir,it,np-1,3) = dpinv12*
     & (    3.0d0*fnc(ir,it,np  ) + 10.0d0*fnc(ir,it,np-1)
     &   - 18.0d0*fnc(ir,it,np-2) +  6.0d0*fnc(ir,it,np-3)
     &   -        fnc(ir,it,np-4) )
     &                 - r(ir)*dprs(it,np-1)*grad(ir,it,np-1,1)
caho       if (iswx.eq.-1) 
caho     & grad(ir,it, 0,3) = 0.5d0*dpinv*
caho     & (-3.0d0*fnc(ir,it,0)+4.0d0*fnc(ir,it, 1)-fnc(ir,it,2))
caho     &                 - r(ir)*dprs(it,0)*grad(ir,it,0,1)
 46   continue
      do 47 ip = 2, np-2
      dprs(it,ip) = dpinv12*
     & ( -        rs(it,ip+2) +  8.0d0*rs(it,ip+1)
     &   -  8.0d0*rs(it,ip-1) +        rs(it,ip-2) )
      do 47 ir = 1, nr
      grad(ir,it,ip,3) = dpinv12*
     & ( -        fnc(ir,it,ip+2) +  8.0d0*fnc(ir,it,ip+1)
     &   -  8.0d0*fnc(ir,it,ip-1) +        fnc(ir,it,ip-2) )
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 47   continue
 45   continue
c
cx      if (isw.eq.1) then
cx      do 490 ip = 0, np, np
cx      do 490 it = 0, nt
cx      do 490 ir = 0, nr
cx      grad(ir,it,ip,3)=0.0d0
cx 490  continue
cx      end if
c
      if (iswx.ge.1) then
c
      error = 0.0d0
      do 400 it = nt/2, nt
c
      do 401 ir = nr/2, nr
c
      do 4004 ip = 0, np
 4004 fp(ip) = fnc(ir,it,ip)
      if (isw.eq.1) call fouri(fp,dfp,sinmp,cosmp,isw)
      if (isw.eq.2) call fouri(fp,dfp,cosmp,sinmp,isw)
c
      do 4005 ip = 0, iswx 
      oldv = grad(ir,it,ip,3)
      grad(ir,it,ip,3) = 0.0d0
      grad(ir,it,ip,3) = dfp(ip)
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 4005 error = 
     &  dmax1(error,dabs(grad(ir,it,ip,3) - oldv)/
     &              dabs(grad(ir,it,ip,3) + oldv))
c
 401  continue
 400  continue
      if (error.ge.0.1d0) 
     & write(6,*) ' relative error for derivative ', error
c
      end if
c
      do 49 ip = 0, np
      do 49 it = 0, nt
      do 49 ir = 0, nr
      grad(ir,it,ip,1)=grad(ir,it,ip,1)
      grad(ir,it,ip,2)=grad(ir,it,ip,2)*rinv(ir)*rsinv(it,ip)
      grad(ir,it,ip,3)=grad(ir,it,ip,3)*rinv(ir)*rsinv(it,ip)*cosec(it)
 49   continue
c
c --- On theta=0 axis and the center for velocity.
c
      if (isw.eq.1) then
      do 58 ip = 0, np
      do 58 ir = 0, nr
      grad(ir,0,ip,3)=grad(ir,0,np/2,2)*cosphi(ip)
 58   continue
      do 59 ip = 0, np
      do 59 it = 0, nt
      grad(0,it,ip,2)=grad(0,nt,np/2,1)*costhe(it)*sinphi(ip)
      grad(0,it,ip,3)=grad(0,nt,np/2,1)*cosphi(ip)
 59   continue
      end if
c
      do 141 ip = 0, np
      do 141 it = 0, nt
      do 141 ir = 0, nr
      gr1=grad(ir,it,ip,1)
      gr2=grad(ir,it,ip,2)
      gr3=grad(ir,it,ip,3)
      grad(ir,it,ip,1) = gr1*sinthe(it)*cosphi(ip)
     &                 + gr2*costhe(it)*cosphi(ip)  
     &                 - gr3*sinphi(ip) 
      grad(ir,it,ip,2) = gr1*sinthe(it)*sinphi(ip)
     &                 + gr2*costhe(it)*sinphi(ip)
     &                 + gr3*cosphi(ip) 
      grad(ir,it,ip,3) = gr1*costhe(it)
     &                 - gr2*sinthe(it)
 141  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine dadbscalarf(fnc,dabfnc,ir,it,ip)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension  fnc(0:nnr,0:nnt,0:nnp), dabfnc(1:3,1:3),
     &           r5(5), th5(5), phi5(5), grad1(3),
     &           dfdx_r(5), dfdx_th(5), dfdx_phi(5),
     &           dfdy_r(5), dfdy_th(5), dfdy_phi(5),
     &           dfdz_r(5), dfdz_th(5), dfdz_phi(5)
c
c --- Compute second derivative of a scalar D_b D_a f,   
c     whose value is assigned on the grid points. 
c     Derivative is computed by that of Catesian coordinate for 
c --- r=0 or theta=0, and by that of spherical coordinate for elsewhere.
c
      ir0 = min0(max0(ir-2,0),nr-4)
      it0 = min0(max0(it-2,0),nt-4)
      ip0 = min0(max0(ip-2,0),np-4)
c
      rv = r(ir)
      tv = th(it)
      pv = phi(ip)
      rrinvb = rinv(ir)
      cosecb = cosec(it)
c
      do 27 ii = 1, 5
      irf0 = ir0 + ii - 1
      itf0 = it0 + ii - 1
      ipf0 = ip0 + ii - 1
      r5(ii) = r(irf0)
      th5(ii) = th(itf0)
      phi5(ii) = phi(ipf0)
   27 continue
c
      if (ir.eq.0) then
c
      do 28 ii = 1, 5
c
      irf0 = ir0 + ii - 1
      itf0 = it0 + ii - 1
      ipf0 = ip0 + ii - 1
c
      call flgrad1f(fnc,irf0,nt,npfxz,grad1)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call flgrad1f(fnc,irf0,nt,npfyz,grad1)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call flgrad1f(fnc,irf0,0,0,grad1)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   28 continue
c
      dabfnc(1,1) = dfncdx(r5,dfdx_r,rv)
      dabfnc(1,2) = dfncdx(r5,dfdx_th,rv)
      dabfnc(1,3) = dfncdx(r5,dfdx_phi,rv)
      dabfnc(2,1) = dfncdx(r5,dfdy_r,rv)
      dabfnc(2,2) = dfncdx(r5,dfdy_th,rv)
      dabfnc(2,3) = dfncdx(r5,dfdy_phi,rv)
      dabfnc(3,1) = dfncdx(r5,dfdz_r,rv)
      dabfnc(3,2) = dfncdx(r5,dfdz_th,rv)
      dabfnc(3,3) = dfncdx(r5,dfdz_phi,rv)
c
      else if (ir.ne.0.and.it.eq.0) then
c
      do 38 ii = 1, 5
c
      irf0 = ir0 + ii - 1
      itf0 = it0 + ii - 1
      ipf0 = ip0 + ii - 1
c
      call flgrad1f(fnc,ir,itf0,npfxz,grad1)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call flgrad1f(fnc,ir,itf0,npfyz,grad1)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call flgrad1f(fnc,irf0,0,0,grad1)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   38 continue
c
      dabfnc(1,1) = dfncdx(th5,dfdx_r,tv)*rrinvb
      dabfnc(1,2) = dfncdx(th5,dfdx_th,tv)*rrinvb
      dabfnc(1,3) = dfncdx(r5,dfdx_phi,rv)
      dabfnc(2,1) = dfncdx(th5,dfdy_r,tv)*rrinvb
      dabfnc(2,2) = dfncdx(th5,dfdy_th,tv)*rrinvb
      dabfnc(2,3) = dfncdx(r5,dfdy_phi,rv)
      dabfnc(3,1) = dfncdx(th5,dfdz_r,tv)*rrinvb
      dabfnc(3,2) = dfncdx(th5,dfdz_th,tv)*rrinvb
      dabfnc(3,3) = dfncdx(r5,dfdz_phi,rv)
c
      else
c
      do 48 ii = 1, 5
c
      irf0 = ir0 + ii - 1
      itf0 = it0 + ii - 1
      ipf0 = ip0 + ii - 1
c
      call flgrad1f(fnc,irf0,it,ip,grad1)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call flgrad1f(fnc,ir,itf0,ip,grad1)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call flgrad1f(fnc,ir,it,ipf0,grad1)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   48 continue
c
      ddfdxdr = dfncdx(r5,dfdx_r,rv)
      ddfdxdt = dfncdx(th5,dfdx_th,tv)
      ddfdxdp = dfncdx(phi5,dfdx_phi,pv)
      ddfdydr = dfncdx(r5,dfdy_r,rv)
      ddfdydt = dfncdx(th5,dfdy_th,tv)
      ddfdydp = dfncdx(phi5,dfdy_phi,pv)
      ddfdzdr = dfncdx(r5,dfdz_r,rv)
      ddfdzdt = dfncdx(th5,dfdz_th,tv)
      ddfdzdp = dfncdx(phi5,dfdz_phi,pv)
c
      dabfnc(1,1) = ddfdxdr*sinthe(it)*cosphi(ip)
     &            + ddfdxdt*costhe(it)*cosphi(ip)  
     &            - ddfdxdp*sinphi(ip)
      dabfnc(1,2) = ddfdxdr*sinthe(it)*sinphi(ip)
     &            + ddfdxdt*costhe(it)*sinphi(ip)
     &            + ddfdxdp*cosphi(ip)
      dabfnc(1,3) = ddfdxdr*costhe(it)
     &            - ddfdxdt*sinthe(it)
      dabfnc(2,1) = ddfdydr*sinthe(it)*cosphi(ip)
     &            + ddfdydt*costhe(it)*cosphi(ip)  
     &            - ddfdydp*sinphi(ip)
      dabfnc(2,2) = ddfdydr*sinthe(it)*sinphi(ip)
     &            + ddfdydt*costhe(it)*sinphi(ip)
     &            + ddfdydp*cosphi(ip)
      dabfnc(2,3) = ddfdydr*costhe(it)
     &            - ddfdydt*sinthe(it)
      dabfnc(3,1) = ddfdzdr*sinthe(it)*cosphi(ip)
     &            + ddfdzdt*costhe(it)*cosphi(ip)  
     &            - ddfdzdp*sinphi(ip)
      dabfnc(3,2) = ddfdzdr*sinthe(it)*sinphi(ip)
     &            + ddfdzdt*costhe(it)*sinphi(ip)
     &            + ddfdzdp*cosphi(ip)
      dabfnc(3,3) = ddfdzdr*costhe(it)
     &            - ddfdzdt*sinthe(it)
c
      end if
c
ctesttest 
c      dabfnc(2,1) = dabfnc(1,2)
c      dabfnc(3,1) = dabfnc(1,3)
c      dabfnc(3,2) = dabfnc(2,3)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine flgrad1f(fnc,ir,it,ip,grad1)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension fnc(0:nnr,0:nnt,0:nnp), fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(ir-2,0),nr-4)
      it0 = min0(max0(it-2,0),nt-4)
      ip0 = min0(max0(ip-2,0),np-4)
c
      do 8 ii = 1, 5
      irf0 = ir0 + ii - 1
      itf0 = it0 + ii - 1
      ipf0 = ip0 + ii - 1
      r5(ii) = r(irf0)
      th5(ii) = th(itf0)
      phi5(ii) = phi(ipf0)
      if (ir.eq.0) then
      fr5(ii) = fnc(irf0,nt,npfxz)
      ft5(ii) = fnc(irf0,nt,npfyz)
      fp5(ii) = fnc(irf0,0,0)
      else if (ir.ne.0.and.it.eq.0) then
      fr5(ii) = fnc(ir,itf0,npfxz)
      ft5(ii) = fnc(ir,itf0,npfyz)
      fp5(ii) = fnc(irf0,0,0)
      else
      fr5(ii) = fnc(irf0,it,ip)
      ft5(ii) = fnc(ir,itf0,ip)
      fp5(ii) = fnc(ir,it,ipf0)
      end if
    8 continue
c
      rv = r(ir)
      tv = th(it)
      pv = phi(ip)
      rrinv = rinv(ir)
c
c --- To cartesian component.  
c
      if (ir.eq.0) then
      grad1(1) = dfncdx(r5,fr5,rv)
      grad1(2) = dfncdx(r5,ft5,rv) 
      grad1(3) = dfncdx(r5,fp5,rv)
      else if (ir.ne.0.and.it.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tv)*rrinv
      grad1(2) = dfncdx(th5,ft5,tv)*rrinv
      grad1(3) = dfncdx(r5,fp5,rv)
      else
      gr1 = dfncdx(r5,fr5,rv)
      gr2 = dfncdx(th5,ft5,tv)*rrinv
      gr3 = dfncdx(phi5,fp5,pv)*rrinv*cosec(it)
      grad1(1) = gr1*sinthe(it)*cosphi(ip)
     &         + gr2*costhe(it)*cosphi(ip)  
     &         - gr3*sinphi(ip) 
      grad1(2) = gr1*sinthe(it)*sinphi(ip)
     &         + gr2*costhe(it)*sinphi(ip)
     &         + gr3*cosphi(ip) 
      grad1(3) = gr1*costhe(it)
     &         - gr2*sinthe(it)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine flfcgrad4(fnc,grad,isw)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension  fnc(0:nnr,0:nnt,0:nnp), 
     &          grad(0:nnr,0:nnt,0:nnp,1:3)
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c     Derivatives for variables.
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      drinv=1.0d0/dr
      dtinv=1.0d0/dth
      dpinv=1.0d0/dphi
      drinv12=1.0d0/dr/12.0d0
      dtinv12=1.0d0/dth/12.0d0
      dpinv12=1.0d0/dphi/12.0d0
      pi = 3.14159265358979d+0
c
c --- Clear.
c
      do 40 ip = 0, np
      do 40 it = 0, nt
      do 40 ir = 0, nr
      grad(ir,it,ip,1) = 0.0d0
      grad(ir,it,ip,2) = 0.0d0
      grad(ir,it,ip,3) = 0.0d0
 40   continue
c
c --- r-direction.
c
      do 41 ip = 0, np
      do 41 it = 0, nt
      grad(   0,it,ip,1) = drinv12*
     & ( - 25.0d0*fnc(   0,it,ip) + 48.0d0*fnc(   1,it,ip) 
     &   - 36.0d0*fnc(   2,it,ip) + 16.0d0*fnc(   3,it,ip) 
     &   -  3.0d0*fnc(   4,it,ip) )
      grad(   1,it,ip,1) = drinv12*
     & ( -  3.0d0*fnc(   0,it,ip) - 10.0d0*fnc(   1,it,ip) 
     &   + 18.0d0*fnc(   2,it,ip) -  6.0d0*fnc(   3,it,ip) 
     &   +        fnc(   4,it,ip) )
      grad(nr  ,it,ip,1) = drinv12*
     & (   25.0d0*fnc(nr  ,it,ip) - 48.0d0*fnc(nr-1,it,ip)
     &   + 36.0d0*fnc(nr-2,it,ip) - 16.0d0*fnc(nr-3,it,ip)
     &   +  3.0d0*fnc(nr-4,it,ip) )
      if (isw.eq.3) then
cc      grad(nr  ,it,ip,1) = drinv*
cc     & ( fnc(nr,it,ip) - fnc(nr-1,it,ip) )
      grad(nr  ,it,ip,1) = 0.5d0*drinv*
     & (3.0d0*fnc(nr,it,ip)-4.0d0*fnc(nr-1,it,ip)+fnc(nr-2,it,ip))
      end if
      grad(nr-1,it,ip,1) = drinv12*
     & (    3.0d0*fnc(nr  ,it,ip) + 10.0d0*fnc(nr-1,it,ip)
     &   - 18.0d0*fnc(nr-2,it,ip) +  6.0d0*fnc(nr-3,it,ip)
     &   -        fnc(nr-4,it,ip) )
      do 41 ir = 2, nr-2
      grad(ir,it,ip,1) = drinv12*
     & ( -        fnc(ir+2,it,ip) +  8.0d0*fnc(ir+1,it,ip)
     &   -  8.0d0*fnc(ir-1,it,ip) +        fnc(ir-2,it,ip) )
 41   continue
c
c --- theta-direction.
c
      do 42 ip = 0, np
      do 43 ir = 1, nr
      grad(ir,   0,ip,2) = dtinv12*
     & ( - 25.0d0*fnc(ir,   0,ip) + 48.0d0*fnc(ir,   1,ip) 
     &   - 36.0d0*fnc(ir,   2,ip) + 16.0d0*fnc(ir,   3,ip) 
     &   -  3.0d0*fnc(ir,   4,ip) )
      grad(ir,   1,ip,2) = dtinv12*
     & ( -  3.0d0*fnc(ir,   0,ip) - 10.0d0*fnc(ir,   1,ip) 
     &   + 18.0d0*fnc(ir,   2,ip) -  6.0d0*fnc(ir,   3,ip) 
     &   +        fnc(ir,   4,ip) )
      grad(ir,nt  ,ip,2) = dtinv12*
     & (   25.0d0*fnc(ir,nt  ,ip) - 48.0d0*fnc(ir,nt-1,ip)
     &   + 36.0d0*fnc(ir,nt-2,ip) - 16.0d0*fnc(ir,nt-3,ip)
     &   +  3.0d0*fnc(ir,nt-4,ip) )
      grad(ir,nt-1,ip,2) = dtinv12*
     & (    3.0d0*fnc(ir,nt  ,ip) + 10.0d0*fnc(ir,nt-1,ip)
     &   - 18.0d0*fnc(ir,nt-2,ip) +  6.0d0*fnc(ir,nt-3,ip)
     &   -        fnc(ir,nt-4,ip) )
 43   continue
      do 44 it = 2, nt-2
      do 44 ir = 1, nr
      grad(ir,it,ip,2) = dtinv12*
     & ( -        fnc(ir,it+2,ip) +  8.0d0*fnc(ir,it+1,ip)
     &   -  8.0d0*fnc(ir,it-1,ip) +        fnc(ir,it-2,ip) )
 44   continue
 42   continue
c
c --- phi-direction.
c
      do 45 it = 0, nt
      do 46 ir = 1, nr
      grad(ir,it,   0,3) = dpinv12*
     & ( - 25.0d0*fnc(ir,it,   0) + 48.0d0*fnc(ir,it,   1) 
     &   - 36.0d0*fnc(ir,it,   2) + 16.0d0*fnc(ir,it,   3) 
     &   -  3.0d0*fnc(ir,it,   4) )
      grad(ir,it,   1,3) = dpinv12*
     & ( -  3.0d0*fnc(ir,it,   0) - 10.0d0*fnc(ir,it,   1) 
     &   + 18.0d0*fnc(ir,it,   2) -  6.0d0*fnc(ir,it,   3) 
     &   +        fnc(ir,it,   4) )
      grad(ir,it,np  ,3) = dpinv12*
     & (   25.0d0*fnc(ir,it,np  ) - 48.0d0*fnc(ir,it,np-1)
     &   + 36.0d0*fnc(ir,it,np-2) - 16.0d0*fnc(ir,it,np-3)
     &   +  3.0d0*fnc(ir,it,np-4) )
      grad(ir,it,np-1,3) = dpinv12*
     & (    3.0d0*fnc(ir,it,np  ) + 10.0d0*fnc(ir,it,np-1)
     &   - 18.0d0*fnc(ir,it,np-2) +  6.0d0*fnc(ir,it,np-3)
     &   -        fnc(ir,it,np-4) )
 46   continue
      do 47 ip = 2, np-2
      do 47 ir = 1, nr
      grad(ir,it,ip,3) = dpinv12*
     & ( -        fnc(ir,it,ip+2) +  8.0d0*fnc(ir,it,ip+1)
     &   -  8.0d0*fnc(ir,it,ip-1) +        fnc(ir,it,ip-2) )
 47   continue
 45   continue
c
      if (isw.eq.1) then
      do 490 ip = 0, np, np
      do 490 it = 0, nt
      do 490 ir = 0, nr
      grad(ir,it,ip,3)=0.0d0
 490  continue
      end if
c
      do 49 ip = 0, np
      do 49 it = 0, nt
      do 49 ir = 0, nr
      grad(ir,it,ip,1)=grad(ir,it,ip,1)
      grad(ir,it,ip,2)=grad(ir,it,ip,2)*rinv(ir)
      grad(ir,it,ip,3)=grad(ir,it,ip,3)*rinv(ir)*cosec(it)
 49   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine fouri(fp,dfp,scfn,scdf,isw)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/CB_weight_fluid.f'
c
      dimension fp(0:nnp), dfp(0:nnp), al(0:nnla)
      dimension scfn(0:nnla,0:nnp),  scdf(0:nnla,0:nnp)
c
      write(6,*) ' ## aho ## --- fouri is used '
c
      pi = 3.14159265358979d+0
      do 100 il = 0, nla
      aaa = 0.0d0
      do 200 ip = 0, np
      aaa = aaa + fp(ip)*scfn(il,ip)*wgdp(ip)
 200  continue
      fac = 2.0d0
      if (isw.eq.2.and.il.eq.0) fac = 1.0d0
      al(il) = aaa*fac/pi
 100  continue
c
      fac = (- 1.0d0)**(isw+1)
      do 110 ip = 0, np
      dfp(ip) = 0.0d0
cxxx      do 120 il = 0, nla
      do 120 il = 0, 4
      dfp(ip) = dfp(ip) + fac*dble(il)*al(il)*scdf(il,ip)
 120  continue
 110  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine fluidco(iter,itmx,convf,cfvep,fmax0,ahores,emxemd,char)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metfl.f'
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
      include 'common_blocks/CB_weight_fluid.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / diffv / rsinv(0:nnt,0:nnp),
     &              dtrs(0:nnt,0:nnp),dprs(0:nnt,0:nnp)
c
      common / cdivbf/ cdvbvf(0:nnr,0:nnt,0:nnp)
c
      dimension backf(0:nnr,0:nnt,0:nnp), rsb(0:nnt,0:nnp)
      dimension hut(0:nnr,0:nnt,0:nnp), aloh(0:nnr,0:nnt,0:nnp),
     &        hutp6(0:nnr,0:nnt,0:nnp),psif4(0:nnr,0:nnt,0:nnp), 
     &        gradv(0:nnr,0:nnt,0:nnp,1:3),
     &       gradps(0:nnr,0:nnt,0:nnp,1:3),
     &       gradhu(0:nnr,0:nnt,0:nnp,1:3),
     &       gradah(0:nnr,0:nnt,0:nnp,1:3),
     &        grade(0:nnr,0:nnt,0:nnp,1:3)
c
      dimension flag(0:nnr,0:nnt,0:nnp),   wgsf(0:nnr,0:nnt,0:nnp),
     &        wgrtpv(0:nnr,0:nnt,0:nnp), wgrtpp(0:nnr,0:nnt,0:nnp)
c
      dimension x(nnr),y(nnr),df(2),iopt(2),c(nnr,3),f(1)
      dimension dabvep(3,3)
      dimension ddvpot(0:nnt,0:nnp,1:3)
      dimension sgg(nnbou), gg(nnbou,nnbou)
c
      character*3 char
c
c ----------------------------------------------------------------------
c
      drinv=1.0d0/dr
      dtinv=1.0d0/dth
      dpinv=1.0d0/dphi
      pi = 3.14159265358979d+0
c
c ----------------------------------------------------------------------
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
c     Equations start. 
c
c ======================================================================
c
c     First integral of Euler equation.
c
c ======================================================================
c
c --  First integral of Euler equation.
c
      do 100 ip = 0, np
      do 100 it = 0, nt
      do 100 ir = 0, nr
c
      backf(ir,it,ip) = emd(ir,it,ip)
c
      alphc = alphf(ir,it,ip)
      psic  = psif(ir,it,ip)
      gmxxdf = 1.0d0 + 0.0d0
      gmxydf =         0.0d0
      gmxzdf =         0.0d0
      gmyydf = 1.0d0 + 0.0d0
      gmyzdf =         0.0d0
      gmzzdf = 1.0d0 + 0.0d0
      gmyxdf = gmxydf
      gmzxdf = gmxzdf
      gmzydf = gmyzdf
      bvxfc = bvxuf(ir,it,ip)
      bvyfc = bvyuf(ir,it,ip)
      bvzfc = bvzuf(ir,it,ip)
      vphix = vphif(ir,it,ip,1)
      vphiy = vphif(ir,it,ip,2)
      vphiz = vphif(ir,it,ip,3)
c
      ovxfc = bvxfc + ome*vphix
      ovyfc = bvyfc + ome*vphiy
      ovzfc = bvzfc + ome*vphiz
      ovxdf = gmxxdf*ovxfc + gmxydf*ovyfc + gmxzdf*ovzfc
      ovydf = gmyxdf*ovxfc + gmyydf*ovyfc + gmyzdf*ovzfc
      ovzdf = gmzxdf*ovxfc + gmzydf*ovyfc + gmzzdf*ovzfc
c
      ovovf = ovxfc*ovxdf + ovyfc*ovydf + ovzfc*ovzdf
c
      emd(ir,it,ip) = 1.0d0/(pinx+1.0d0)
     &              * (ber/dsqrt(alphc**2 - psic**4*ovovf) - 1.0d0)
c
  100 continue
c
      do 42 ip = 0, np
      do 42 it = 0, nt
      emd(0,it,ip) = emd(0,nt,np/2)
 42   continue
c
      emdmx = 0.0d0
      do 44 ir = 0, nr
      emdmx = dmax1(emdmx,emd(ir,nt,0))
      if (emdmx.eq.emd(ir,nt,0)) nrfdmx = ir
 44   continue
c
      nrgdmx = nrfdmx + nrgmid
cz      emd(nrfdmx,nt,0) = emdc
cz      if (nrfdmx.eq.0) then 
      do 45 ip = 0, np
      do 45 it = 0, nt
      emd(0,it,ip) = emdc
 45   continue
cz      end if
c
c --- For axis. 
c
      do 191 ir = 1, nr
      emem = emd(ir,0,np/2)
      do 193 ip = 0, np
      emd(ir,0,ip) = emem
 193  continue
 191  continue
c
c --- For surface. 
c
      do 170 ip = 0, np
      do 170 it = 0, nt
      rsb(it,ip) = rs(it,ip)
      delx = dr*(surr - emd(nr,it,ip))/(emd(nr,it,ip) - emd(nr-1,it,ip))
      rs(it,ip) = rs(it,ip)*(1.0d0 + delx)
  170 continue
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
c
c     ### Iteration. ###
c     Set improved values for emden function and surface.
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
c
c --- For parameters. 
c
      rs(nt, 0) = 1.0d0
      rs(nt,np) = 1.0d0
c
      do 4000 ip = 0, np
      do 4000 it = 0, nt
      emd(nr,it,ip) = surr
cz      if (emd(nr-1,it,ip).le.0.0d0) emd(nr-1,it,ip) = surr
cz      if (emd(nr-2,it,ip).le.0.0d0) emd(nr-2,it,ip) = surr
cz      if (emd(nr-3,it,ip).le.0.0d0) emd(nr-3,it,ip) = surr
      if (rs(it,ip).ge.1.05d0) rs(it,ip) = 1.05d0
      do 4000 ir = 0, nr-1
      if (emd(ir,it,ip).le.0.0d0) emd(ir,it,ip) = surr
 4000 continue
c
      call flimpro(backf,emd,convf,emxemd,irerr,iterr,iperr,1)
      write(6,4901) '  == emd   ==, error =', emxemd,
     &              emd(irerr,iterr,iperr), irerr,iterr,iperr
      fmax0 = dmax1(emxemd,fmax0)
c
      call rsimpro(rsb,rs,convf,emxrs,iterr,iperr)
      write(6,4901) '  == rs    ==, error =', emxrs,
     &              rs(iterr,iperr),iterr,iperr
      fmax0 = dmax1(emxrs,fmax0)
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c --  Improving parameters and alpha and psi.  
c
      call paimproco_bhns(ome,ber,radi,convf,iter,fmax0,1)
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
cmark
      ahores = 0.0d0
      do 500 ip = 0, np
      do 500 it = 0, nt
      do 500 ir = 0, nr
c
      emd(nr,it,ip) = 1.0d-14
      if (emd(ir,it,ip).le.0.0d0) emd(ir,it,ip) = 1.0d-14
      emdfc = emd(ir,it,ip)
      rhofc = emd(ir,it,ip)**pinx
      alpfc = alphf(ir,it,ip)
      psifc = psif(ir,it,ip)
      hhfc  = 1.0d0 + (pinx+1.0d0)*emdfc
      utfc  = hhfc/ber
c
      weiflu = rs(it,ip)**3*wahop(ir,it,ip)
      ahores = ahores + rhofc*alpfc*utfc*psifc**6*weiflu
c
 500  continue
      ahores = radi**3*ahores*8.0d0/2.0d0
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
 4901 format(a22,1p,e12.4,',  value =',e12.4,2x,3i4)
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      end
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
      subroutine maxden(emd,emdmx,ddmax)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      dimension emd(0:nnr,0:nnt,0:nnp), re(0:nnr+4)
      dimension x(nnr*2),y(nnr*2),df(2),iopt(2),c(nnr*2,3),f(1),v(1)
c
      pi = 3.14159265358979d+0
c
      nc = nnr*2
      n = nr+4
      iopt(1)=3
      iopt(2)=3
c
      re(1) = emd(3,nt,np)
      re(2) = emd(2,nt,np)
      re(3) = emd(1,nt,np)
      do 19 ir = 0, nr
      re(ir+4) = emd(ir,nt,0)
 19   continue
c
      do 20 ir = 3, n-1
      if (re(ir).gt.re(ir+1)) then
      ini = ir - 2
      if (ir.eq.3) then
      write(6,*) ' WARNING maximum density '
      ini = ini+1
      end if
      go to 21
      end if
 20   continue
 21   continue
c
      do 16 ii = 1, n
      x(ii)=dble(ii)
 16   y(ii)=re(ii)
      call splc(x,n,y,df,iopt,c,nc,ier)
c
      dini = dble(ini)
      delta = 1.0d0
c
 41   continue
c     write(6,*) dini,delta*0.2d0
      v(1) = dini
      call splf(x,n,y,c,nc,v,1,f,ier)
      fb = f(1)
c
 40   continue
      v(1) = v(1) + 0.2d0*delta
      call splf(x,n,y,c,nc,v,1,f,ier)
      fn = f(1)
      if (dabs((fn-fb)/fn).le.1.0d-10) then
      emdmx = fn
      ddmax = (v(1) - 4.0d0)/dble(nr)
      go to 100
      end if
      if (fb.gt.fn) then
      dini = v(1) - 0.2d0*delta*2.0d0
      delta = 0.2d0*delta
      go to 41
      end if
      if (fb.le.fn) then
      fb = fn
      go to 40
      end if
c
 100  continue
c
      end
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
c ______________________________________________________________________
c ______________________________________________________________________
c
c  Usage for subroutine of spline interpolation 
c
c  for x_1, IOPT(1) = 1 => DF(1) = d^2 f(x_1)/ dx^2
c           IOPT(1) = 2 => DF(1) = d f(x_1)/ dx
c           IOPT(1) = 3 => DF(1) is not needed, but the same as  
c                          IOPT(1) = 2. (d f(x_1)/ dx is automatically
c                          calculated, using the Lagrange interpolation.)     
c
c   for x_N, similar to x_1, but IOPT(2) and DF(2) are used.
c
************************************************************************
      SUBROUTINE SPLC(X, N, Y, DF, IOPT, C, NC, IER)
************************************************************************
*  COMPUTE THE COEFFICIENTS OF THE CUBIC SPLINE.                       *
*  PARAMETERS                                                          *
*    (1) X: 1-DIM. ARRAY FOR KNOWN POINTS                              *
*    (2) N: NUMBER OF KNOWN POINTS                                     *
*    (3) Y: 1-DIM. ARRAY FOR FUNCTION'S VALUES ON KNOWN POINTS         *
*    (4) DF: 1-DIM. ARRAY FOR DIFFERENTIALS AT END POINTS              *
*    (5) IOPT: 1-DIM. ARRAY SPECIFYING THE CONTENT OF DF               *
*    (6) C: 2-DIM. WORKING ARRAY                                       *
*    (7) NC: ROW SIZE OF THE ARRAY (C)                                 *
*    (8) IER: ERROR CODE                                               *
*  COPYRIGHT   T. OGUNI   JUNE 30 1989    VERSION 1.0                  *
************************************************************************
       IMPLICIT REAL*8(A-H,O-Z)
       DIMENSION X(N), Y(N), DF(2), IOPT(2), C(NC,3), EC(4), D(2)
C
      IF (N.LT.2 .OR. NC.LT.N-1 .OR. IOPT(1).LT.1 .OR. IOPT(1).GT.3
     *    .OR. IOPT(2).LT.1 .OR. IOPT(2).GT.3) THEN
       IER = 2
       WRITE(*,*) '(SUBR. SPLC) INVALID ARGUMENT.',N,NC,IOPT(1),IOPT(2)
       RETURN
      ENDIF
      DO 5 I=1,N-1
       IF (X(I) .GE. X(I+1)) THEN
        IER = 1
        WRITE(*,*) '(SUBR. SPLC) X SHOULD SATISFY UPWARD ORDER.'
        RETURN
       ENDIF
    5 CONTINUE
      IER = 0
C  SET THE END CONDITIONS.
      II = 2
      KS = 1
      KE = MIN0(4,N)
      IDER = 1
      DO 70 I=1,2
       I1 = 2 * I - 1
       I2 = 2 * I
       IB = IOPT(I)
       GO TO (10, 20, 30), IB
   10  EC(I1) = 0.0D0
       EC(I2) = 2.0D0 * DF(I)
       GO TO 70
   20  D(I) = DF(I)
   25  IF (I .EQ. 2) II = N
       H = X(II) - X(II-1)
       EC(I1) = 1.0D0
       HY = Y(II) - Y(II-1)
       EC(I2) = 6.0D0 * (HY / H - D(I)) / H
       IF (I .EQ. 2) EC(I2) = - EC(I2)
       GO TO 70
   30  IF (I .NE. 1) THEN
        KS = MAX0(1,N-3)
        KE = N
        IDER = N
       ENDIF
       A2 = 0.0D0
       D(I) = 0.0D0
       DO 60 K=KS,KE
        IF (IDER .NE. K) THEN
         A1 = 1.0D0
         DO 50 J=KS,KE
          IF (J .NE. IDER .AND. J .NE. K) THEN
           X1 = X(IDER) - X(J)
           X2 = X(K) - X(J)
           A1 = A1 * X1 / X2
          ENDIF
   50    CONTINUE
         X3 = X(K) - X(IDER)
         D(I) = D(I) + A1 * Y(K) / X3
         A2 = A2 - 1.0D0 / X3
        ENDIF
   60  CONTINUE
       D(I) = D(I) + Y(IDER) * A2
       GO TO 25
   70 CONTINUE
C  SET THE ELEMENTS FOR THE SYMMETRIC TRIDIAGONAL EQUATION.
      IF (N .NE. 2) THEN
       H1 = X(2) - X(1)
       Y1 = Y(2) - Y(1)
       DO 80 I=2,N-1
        H2 = X(I+1) - X(I)
        Y2 = Y(I+1) - Y(I)
        HH = H1 + H2
        C(I,1) = H2 / HH
        C(I,2) = 1.0D0 - C(I,1)
        C(I,3) = 6.0D0 * (Y2 / H2 - Y1 / H1) / HH
        H1 = H2
   80   Y1 = Y2
      ENDIF
C  SOLVE THE EQUATION
      C(1,1) = - EC(1) * 0.5D0
      C(1,2) =   EC(2) * 0.5D0
      IF (N .NE. 2) THEN
       DO 100 K=2,N-1
        PIV = 2.0D0 + C(K,2) * C(K-1,1)
        C(K,1) = - C(K,1) / PIV
  100   C(K,2) = (C(K,3) - C(K,2) * C(K-1,2)) / PIV
      ENDIF
      DY1 = (EC(4) - EC(3) * C(N-1,2)) / (2.0D0 + EC(3) * C(N-1,1))
      DO 120 I=1,N-1
       K = N - I
       DY2 = C(K,1) * DY1 + C(K,2)
       H = X(K+1) - X(K)
       C(K,3) = (DY1 - DY2) / (6.0D0 * H)
       C(K,2) = 0.5D0 * DY2
       C(K,1) = (Y(K+1) - Y(K)) / H - (C(K,2) + C(K,3) * H) * H
  120  DY1 = DY2
C
      RETURN
      END
c
************************************************************************
      SUBROUTINE SPLF(X, N, Y, C, NC, V, M, F, IER)
************************************************************************
*  INTERPOLATION BY THE CUBIC SPLINE.                                  *
*  PARAMETERS                                                          *
*    (1) X: 1-DIM. ARRAY FOR KNOWN POINTS                              *
*    (2) N: NUMBER OF KNOWN POINTS                                     *
*    (3) Y: 1-DIM. ARRAY FOR FUNCTION'S VALUES ON KNOWN POINTS         *
*    (4) C: 2-DIM. WORKING ARRAY                                       *
*    (5) NC: ROW SIZE OF THE ARRAY (C)                                 *
*    (6) V: 1-DIM. ARRAY FOR POINTS WHICH INTERPOLATION MUST BE MADE   *
*    (7) M: NUMBER OF POINTS FOR WHICH INTERPOLATION MUST BE MADE      *
*    (8) F: 1-DIM. WORKING ARRAY                                       *
*    (9) IER: ERROR CODE                                               *
*  COPYRIGHT   T. OGUNI   JUNE 30 1989   VERSION 1.0                   *
************************************************************************
       IMPLICIT REAL*8(A-H,O-Z)
       DIMENSION X(N), Y(N), C(NC,3), V(M), F(M)
C
      IF (N .LT. 2 .OR. M .LT. 1 .OR. NC .LT. N-1) THEN
       IER = 2
       WRITE(*,*) '(SUBR. SPLF) INVALID ARGUMENT. ', N, NC, M
       RETURN
      ENDIF
      IER = 0
      I = 1
      DO 90 K=1,M
       V1 = V(K) - X(I)
       IF (V1) 10, 30, 40
   10  IF (I .GT. 1) GO TO 20
       IER = 1
       GO TO 80
   20  I = I - 1
       V1 = V(K) - X(I)
       IF (V1) 10, 30, 80
   30  F(K) = Y(I)
       GO TO 90
   40  IF (I .LT. N) GO TO 50
       IER = 1
       I = N - 1
       GO TO 80
   50  V2 = V(K) - X(I+1)
       IF (V2) 80, 60, 70
   60  I = I + 1
       GO TO 30
   70  I = I + 1
       V1 = V2
       GO TO 40
   80  F(K) = Y(I) + V1 * (C(I,1) + V1 * (C(I,2) + V1 * C(I,3)))
   90 CONTINUE
C
      RETURN
      END
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subioca
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
      include 'common_blocks/CB_param_bhphy.f'
      include 'common_blocks/CB_param_flphy.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, iwrite
      common / trmpg / sinmpg(0:nnlg,0:nnpg), cosmpg(0:nnlg,0:nnpg)
c
      common / cutsw / cutfac
c
      dimension gradv(0:nnr,0:nnt,0:nnp,1:3),
     &         emdg(0:nnrg,0:nntg,0:nnpg), 
     &        grada(0:nnrg,0:nntg,0:nnpg,1:3)
c
      character*3 chpr
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
c      open(21,file='gnbcart.dat',status='old')
c
c --  Interpolation to Cartesian coordinate.
c
c      read(21,2400) nx, ny, nz, nstar
c      read(21,2401) chpr
      ifl = 2
c      close(21)
c 2400 format(4i5)
c 2401 format(2x,a3)
c
c ---- nstar = grid points per a radius (half diameter) of a star. 
c ---- edge of computational domain would be nxout = nx/nstar.  
c
      call flgrad4(vep,gradv,rs,1,0)
cx      call flgrad(vep,gradv,rs,1,0)
c
      call fl2gr_rns(emd,emdg,rs,hrg,rg,1,1)
      call vfl2vgr_rns(gradv,grada,rs,hrg,rg,1)
c
c --------------
c --- Write. ---
c --------------
c
cshibata      rkappa = 200.d0/pi
      rkappa = 1.d0
      rkapmn = rkappa**(-pinx)
      rkapn2 = rkappa**(pinx/2.0d0)
      romega = ome/rkapn2/radi
      rradi = radi*rkapn2
c
c
c --- OUTPUT Shibata spheircal data.
c
      if (ifl.eq.2.or.ifl.eq.4.or.ifl.eq.5) then
      open(20,file='gnb_shi_sph.dat',status='unknown')
c
      write(20,5000) nrf, ntf, npf
      write(20,5000) nl, nla, nbou, msym
      write(20,5005) nnn, nrout, rvout
      write(20,5000) ntg, npg, nlg, msymg
      write(20,5002) ngdin, pinx, cutfac
c
      write(20,4000) ahores, ahoang, ahoadm
      write(20,4000) ome, ber, radi, orbc
      write(20,4000) (rg(irg), irg = 0, nrtot)
c
      do 400 ip = 0, np
      do 400 it = 0, nt
      write(20,4000) (emd(ir,it,ip), ir = 0, nr)
      write(20,4000) (vep(ir,it,ip), ir = 0, nr)
 400  continue
      do 410 ip = 0, np
      write(20,4000) (rs(it,ip), it = 0, nt)
 410  continue
c
      do 500 ipg = 0, npg
      do 500 itg = 0, ntg
c
      write(20,4000) (rkapmn*emdg(irg,itg,ipg)**pinx, irg = 0, nrtot)
      write(20,4000)
     & (grada(irg,itg,ipg,1)/(1.0d0 + (pinx+1.0d0)*emdg(irg,itg,ipg)),
     &  irg = 0, nrtot)
      write(20,4000)
     & (grada(irg,itg,ipg,2)/(1.0d0 + (pinx+1.0d0)*emdg(irg,itg,ipg)),
     &  irg = 0, nrtot)
      write(20,4000)
     & (grada(irg,itg,ipg,3)/(1.0d0 + (pinx+1.0d0)*emdg(irg,itg,ipg)),
     &  irg = 0, nrtot)
c
      write(20,4000) (psi(irg,itg,ipg)-1.0d0, irg = 0, nrtot)
      write(20,4000) (alph(irg,itg,ipg)-1.0d0, irg = 0, nrtot)
      write(20,4000) (bvxu(irg,itg,ipg), irg = 0, nrtot)
      write(20,4000) (bvyu(irg,itg,ipg), irg = 0, nrtot)
      write(20,4000) (bvzu(irg,itg,ipg), irg = 0, nrtot)
c
 500  continue
c
      close(20)
      end if
c
c --- END
c
 100  format(4i5)
 200  format(1p,5e21.13)
 4000 format(1p,4e19.11)
 5000 format( 5i5)
 5001 format( 1p,2e10.3)
 5002 format( 1i5, 1p,2e10.3)
 5003 format( 1p,1e10.3, 1i4)
 5004 format( 2i5, 3x, a3)
 5005 format( 2i5, 1p,1e10.3)
c
      end
