c ==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+=
      program grbhns
c ==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+=
c
c     Black hole - neutron star binary initial data.
c     
c ### N.B. phig is taken from -pi/2 to 3 pi/2.
c ###      phig(0) = - pi/2 and phig(npg) = 3 pi/2.
c ###      phib   is taken from 0 to 2 pi.
c ###      phif   is taken from 0 to   pi.
c ###      phifex is taken from 0 to 2 pi.
c
c ==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+==+=
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metfl.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_bwvec_grav.f'
      include 'common_blocks/CB_bwvec_bh.f'
      include 'common_blocks/CB_bbvec_grav.f'
      include 'common_blocks/CB_bbvec_bh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_bhphy.f'
      include 'common_blocks/CB_param_flphy.f'
c
cref  common / cordp / dis,orbc,radint,radext,ding,rvout,radmid,ngdin,
cref &                 disinc
crefaho  common / cordp / dis,orbc,radint,radext,ding,rvout,radmid,ngdin
crefaho  common / cordis/ disinc
cref  common / bhpar / bhrad, bhspin, bhmass, bhdis, pat, patfac, bhfac
cref  common / punpa /apmass, pmomy
cref  common / calcp / ome, ber, radi
cref  common / bhbou / psibh, alphbh
cref  common / phisp / pinx, surr, ratio, ratmas, sepato, 
cref &                 g, pi, emdc, ipolar
cref  CB_param_bhphy.f 
cref      common / intms / ahoadm, ahokom, ahoang, aholin
cref      common / fitms / fitadm, fitkom, fitang, fitpy, fitvir
cref      common / homas / aharea, ahmass
cref      common / punve / omephi, bvyubh, dipole
cref  CB_param_flphy.f 
cref      common / flmas / ahores
cref      common / seqmas/ restmass, gravmass 
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, iwrite
      common / flusw / swflu
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
      common / augfn / emdg(0:nnrg,0:nntg,0:nnpg),
     &                 ramg(0:nnrg,0:nntg,0:nnpg), 
     &               gradvg(0:nnrg,0:nntg,0:nnpg,1:3)
c
      dimension gradv(0:nnr,0:nnt,0:nnp,3)
c
      dimension sousfpb(0:nntb,0:nnpb),dsousfpb(0:nntb,0:nnpb),
     &          sousfpg(0:nntb,0:nnpb),dsousfpg(0:nntb,0:nnpb),
     &          soupsbh(0:nntb,0:nnpb),dsoupsbh(0:nntb,0:nnpb),
     &          soupsou(0:nntg,0:nnpg),dsoupsou(0:nntg,0:nnpg),
     &    soupsb(0:nnrb,0:nntb,0:nnpb),  soupsg(0:nnrg,0:nntg,0:nnpg),
     &          sousfab(0:nntb,0:nnpb),dsousfab(0:nntb,0:nnpb),
     &          sousfag(0:nntb,0:nnpb),dsousfag(0:nntb,0:nnpb),
     &          souapbh(0:nntb,0:nnpb),dsouapbh(0:nntb,0:nnpb),
     &          souapou(0:nntg,0:nnpg),dsouapou(0:nntg,0:nnpg),
     &    souapb(0:nnrb,0:nntb,0:nnpb),  souapg(0:nnrg,0:nntg,0:nnpg)
c
      dimension sousfwxb(0:nntb,0:nnpb),dsousfwxb(0:nntb,0:nnpb),
     &          sousfwxg(0:nntb,0:nnpb),dsousfwxg(0:nntb,0:nnpb),
     &          souwxbh(0:nntb,0:nnpb), dsouwxbh(0:nntb,0:nnpb),
     &          souwxou(0:nntg,0:nnpg), dsouwxou(0:nntg,0:nnpg),
     &     souwxb(0:nnrb,0:nntb,0:nnpb),souwxg(0:nnrg,0:nntg,0:nnpg),
     &          sousfwyb(0:nntb,0:nnpb),dsousfwyb(0:nntb,0:nnpb),
     &          sousfwyg(0:nntb,0:nnpb),dsousfwyg(0:nntb,0:nnpb),
     &          souwybh(0:nntb,0:nnpb), dsouwybh(0:nntb,0:nnpb),
     &          souwyou(0:nntg,0:nnpg), dsouwyou(0:nntg,0:nnpg),
     &     souwyb(0:nnrb,0:nntb,0:nnpb),souwyg(0:nnrg,0:nntg,0:nnpg),
     &          sousfwzb(0:nntb,0:nnpb),dsousfwzb(0:nntb,0:nnpb),
     &          sousfwzg(0:nntb,0:nnpb),dsousfwzg(0:nntb,0:nnpb),
     &          souwzbh(0:nntb,0:nnpb), dsouwzbh(0:nntb,0:nnpb),
     &          souwzou(0:nntg,0:nnpg), dsouwzou(0:nntg,0:nnpg),
     &     souwzb(0:nnrb,0:nntb,0:nnpb),souwzg(0:nnrg,0:nntg,0:nnpg),
     &          sousfwsb(0:nntb,0:nnpb),dsousfwsb(0:nntb,0:nnpb),
     &          sousfwsg(0:nntb,0:nnpb),dsousfwsg(0:nntb,0:nnpb),
     &          souwsbh(0:nntb,0:nnpb), dsouwsbh(0:nntb,0:nnpb),
     &          souwsou(0:nntg,0:nnpg), dsouwsou(0:nntg,0:nnpg),
     &    souwsb(0:nnrb,0:nntb,0:nnpb),  souwsg(0:nnrg,0:nntg,0:nnpg)
c
      dimension sousfxb(0:nntb,0:nnpb),dsousfxb(0:nntb,0:nnpb),
     &          sousfxg(0:nntb,0:nnpb),dsousfxg(0:nntb,0:nnpb),
     &          soubxbh(0:nntb,0:nnpb),dsoubxbh(0:nntb,0:nnpb),
     &          soubxou(0:nntg,0:nnpg),dsoubxou(0:nntg,0:nnpg),
     &    soubxb(0:nnrb,0:nntb,0:nnpb),  soubxg(0:nnrg,0:nntg,0:nnpg),
     &          sousfyb(0:nntb,0:nnpb),dsousfyb(0:nntb,0:nnpb),
     &          sousfyg(0:nntb,0:nnpb),dsousfyg(0:nntb,0:nnpb),
     &          soubybh(0:nntb,0:nnpb),dsoubybh(0:nntb,0:nnpb),
     &          soubyou(0:nntg,0:nnpg),dsoubyou(0:nntg,0:nnpg),
     &    soubyb(0:nnrb,0:nntb,0:nnpb),  soubyg(0:nnrg,0:nntg,0:nnpg),
     &          sousfzb(0:nntb,0:nnpb),dsousfzb(0:nntb,0:nnpb),
     &          sousfzg(0:nntb,0:nnpb),dsousfzg(0:nntb,0:nnpb),
     &          soubzbh(0:nntb,0:nnpb),dsoubzbh(0:nntb,0:nnpb),
     &          soubzou(0:nntg,0:nnpg),dsoubzou(0:nntg,0:nnpg),
     &    soubzb(0:nnrb,0:nntb,0:nnpb),  soubzg(0:nnrg,0:nntg,0:nnpg),
     &          sousfsb(0:nntb,0:nnpb),dsousfsb(0:nntb,0:nnpb),
     &          sousfsg(0:nntb,0:nnpb),dsousfsg(0:nntb,0:nnpb),
     &          soubsbh(0:nntb,0:nnpb),dsoubsbh(0:nntb,0:nnpb),
     &          soubsou(0:nntg,0:nnpg),dsoubsou(0:nntg,0:nnpg),
     &    soubsb(0:nnrb,0:nntb,0:nnpb),  soubsg(0:nnrg,0:nntg,0:nnpg)
c
c
      dimension potb(0:nnrb,0:nntb,0:nnpb),backb(0:nnrb,0:nntb,0:nnpb),
     &          potg(0:nnrg,0:nntg,0:nnpg),backg(0:nnrg,0:nntg,0:nnpg)
      dimension poxb(0:nnrb,0:nntb,0:nnpb),bakxb(0:nnrb,0:nntb,0:nnpb),
     &          poyb(0:nnrb,0:nntb,0:nnpb),bakyb(0:nnrb,0:nntb,0:nnpb),
     &          pozb(0:nnrb,0:nntb,0:nnpb),bakzb(0:nnrb,0:nntb,0:nnpb),
     &          poxg(0:nnrg,0:nntg,0:nnpg),bakxg(0:nnrg,0:nntg,0:nnpg),
     &          poyg(0:nnrg,0:nntg,0:nnpg),bakyg(0:nnrg,0:nntg,0:nnpg),
     &          pozg(0:nnrg,0:nntg,0:nnpg),bakzg(0:nnrg,0:nntg,0:nnpg)
      dimension emdcc(100), sepaseq(100)
      integer   ngdinc(100)
c
      character*4 char
      character*1 chrot,chbhs,chgra, chope
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      open(1,file='bbhpar.dat',status='old')
      open(14,file='bbhseq.dat',status='old')
      open(24,file='bbhaux.dat',status='old')
      open(26,file='bbhaux2.dat',status='unknown')
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c --- Constants.  
c
      g = 6.6726d-8
      pi = 3.14159265358979d+0
c
c --- Parameters
c ==  bbhpar.dat
      read(1,5000) nrb, ntb, npb, nlb
      read(1,5000) nrbov, msymb
      read(1,5000) ntg, npg, nlg, msymg
      read(1,5005) ngdin, nrout, rvout
      read(1,5001) ding, radint
      read(1,5002) itmx, eps, convini
      read(1,5005) iddd, numseq, bhcop
      read(1,5001) ffgra,ffbh
      read(1,5004) itype, itbh, chrot, chbhs, chgra, chope
 5000 format( 5i5)
 5001 format( 2f10.5)
 5002 format( 1i5, 2f10.5)
 5003 format( 1f10.5, 1i4)
 5004 format( 2i5, 3x, 4a1)
 5005 format( 2i5, 1f10.5)
c
      iwrite = itbh
c
c ==  bbhseq.dat
c
      read(14,5010) bhrad, bhmass, apmass
      read(14,5010) omebh, spinbh, patfac
      read(14,5010) dis, orbc, ratmas
      read(14,5010) psibh, alphbh, pmomy
      read(14,5011) disinc, bhfac, numseq
 5010 format(3f10.5)
 5011 format(2f10.5,2i5)
c
      orbcbak = orbc
      close(1)
      close(14)
c
c ==  gnbpar.dat
c
      open(1,file='gnbpar.dat',status='old')
      open(25,file='gnbseq.dat',status='old')
c
      read(1,5000) nrf, ntf, npf
      read(1,5000) nl, nla, nbou, msym
      read(1,5005) nnn
      read(1,5000) ndum
      read(1,5002) ngdin, pinx, cutfac
      read(1,5002) ndum
      read(1,5000) iteflu, iswl
      read(1,5001) ffden,ffvep 
c      read(1,5004) itype, iwrite, chrot, chgra, chope
c
c ==  gnbseq.dat
c
      read(25,3) numseq, restmass, gravmass
 3    format(1i5,1p,2e14.6)
      read(25,2) emdcc(1), ngdinc(1), incr
 2    format(1f10.5,2i5)
      read(25,1) emddiff, rmeps
 1    format(2f10.5)
      rmepsbak = rmeps
c
      close(1)
      close(25)
c
c
c +++ Coordinates
c
      call coord_grid_size
c
      write(6,*)' step 1 = nonv'
      write(6,*)' coordinates etc. '
      call nonvgr
      call nonvbh
      call nonvgb
c
c
c --- Switch for fluid source term.  
c                                                                              
      if (chrot.eq.'c') then
      write(6,*) ' ### Co-rotating solutions. ###'
      else if (chrot.eq.'i') then
      write(6,*) ' ### Irrotating solutions. ###'
      else
      write(6,*) ' ### INVARID PARAMETER --- chrot. ###'
      stop
      end if
      swflu = 1.0d0
      if (chrot.eq.'c') swflu = 0.0d0
c
c
      char = chrot//chbhs//chgra//chope
      bhspin = spinbh
      pat = bhrad + patfac*(radint - bhrad)
c
c
c ----------------------------------------------------------------------
c --- Initial.
c ----------------------------------------------------------------------
c
c --  For itype = -1, initial data is psi=1, alpha=1, beta^a=0.  
c
      if (iabs(itype).ge.2) stop ' wrong itype '
      if (itype.eq.0)  write(6,*) ' == Read from initial data file == ' 
      if (itype.eq.-1) write(6,*) ' == CONSTANT INITIAL == ' 
      if (itype.eq.1)  write(6,*) 
     & ' == Read from initial data file -- iterate GR on CCS only == ' 
c
      if (itype.eq.-1) istat = -1
      if (itype.eq. 0) istat = 0
      if (itype.eq. 1) istat = 0
      if (itype.eq.-1) itbh = -1
      if (itype.eq. 0) itbh = -1
      if (itype.eq. 1) itbh = -1
c
      inicond = 0
      if (itype.eq.0) inicond = 1
c
      call subio(istat,0,char)
c
      iseq = 0
      call subio_fluid(0,iseq,char)
c
      if (itype.eq.-1) orbc = orbcbak
      if (itbh.ge.1) orbc = orbcbak
c
c --  modify constant of the first integral for co-rotating case.
c
      if (chrot.eq.'c') then
c      nrtmp = ngdinc(1) + nrf
      nrtmp = 0
      emdgc = emd(0,0,0)
      hhgc  = 1.0d0 + (pinx+1.0d0)*emdgc
      psigc =  psi(nrtmp,0,0)
      alpgc = alph(nrtmp,0,0)
      ovygc = ovyu(nrtmp,0,0)
      gmyyd = 1.0d0 + 0.0d0
      utgc  = 1.0d0/dsqrt(alpgc**2 - psigc**4*gmyyd*ovygc*ovygc)
      ber = hhgc/utgc
c
      do 810 ip = 0, np
      do 810 it = 0, nt
      do 810 ir = 0, nr
 810  vep(ir,it,ip) = 0.0d0
c
      end if
c
c ----------------------------------------------------------------------
c --- Calcuration of a sequence.
c ----------------------------------------------------------------------
c
      iseq = 0
      bhradini = bhrad
c
      do 1400 iseq = 1, numseq
c
c --  Sequence is computed by changing the separation.  
c
      bhrad = bhrad*bhfac
c
      if (iseq.gt.1) then
      nrtotbak = nrtot
      dis = dis + dble(iseq-1)*disinc
      call coord_grid_size
      if (nrtotbak.ne.nrtot) call change_grsize(nrtotbak)
      write(6,*)' coordinates etc. '
      call nonvgr
      call nonvbh
      call nonvgb
      end if
c
c --- Set nonvariables, s.t. mesh, trigonometric fn.,
c --- weight for integration, legendre polynomials.
c
      if (iseq.eq.1) then
      write(6,*)' coordinates etc. '
      call nonvfl(iddd)
c
c --- Preparation for other index
c
      call bvd2u
cc      call bvu2d
      call bv2ov
c
      end if
c
      if (iseq.eq.1) emdc = emdcc(iseq)
      if (rmeps.lt.eps.and.incr.eq.0) emdc = emdcc(iseq)
      surr = 10.0d0**(idnint(dlog10(1.0d-04*emdc)))
c
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c     Iteration starts.  
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      iter = 0
      imascond = 1
      ibhmcond = 1
      iapmcond = 1
      ibypcond = 1
      ipmocond = 1
      iorbcond = 1
      rmeps = rmepsbak
      epsmax = 0.0d0
      ii_adj = 0
c
 2444 continue 
c 
      if (inicond.eq.1.and.iter.eq.50) then
      iter = 0
      itbh = 0
      inicond = 0
      ii_adj = 0
      end if
c
      iter = iter + 1 
c
      ermax0 = 0.0d0 
      epsmax = 0.0d0
      epsmax_bh = 0.0d0
      epsmax_adj = 0.0d0
      epsmax_par = 0.0d0
      fmax0 = 0.0d0
      fmigra = ffgra
      fmibh  = ffbh
      fmiden = ffden
      fmivep = ffvep
      fcon = convini*dble(iter)
      fconbh = fcon
      fconfl = fcon
      fconvp = fcon
cz      if (iter.gt.50) fconbh = convini*dble(iter-50)
cz      if (iter.gt.50) fconfl = convini*dble(iter-50)
cz      if (iter.gt.50) fconvp = convini*dble(iter-50)
      fffac = dmin1( fmigra, fcon)
      fffbh = dmin1( fmibh , fconbh)
      convf = dmin1( fmiden, fconfl)
      cfvep = dmin1( fmivep, fconvp)
c
c --- Start computation.  
c
      write(6,*) ' #### Iteration NO. = ', iter
c
c --- Compute source terms.
c
      call al2alps
c
      if (itbh.eq.-1.and.iter.eq.1) call clear_wvec
cc      call clear_shift
c
      write(6,*)' step 2 = interface'
c
      call interfacec(psib,psi,sousfpb,sousfpg,dsousfpb,dsousfpg)
      call interfacec(alpsb,alps,sousfab,sousfag,dsousfab,dsousfag)
      call interfacec(bwxdb,bwxd,sousfwxb,sousfwxg,dsousfwxb,dsousfwxg)
      call interfacec(bwydb,bwyd,sousfwyb,sousfwyg,dsousfwyb,dsousfwyg)
      call interfacec(bwzdb,bwzd,sousfwzb,sousfwzg,dsousfwzb,dsousfwzg)
      call interfacec(bwsdb,bwsd,sousfwsb,sousfwsg,dsousfwsb,dsousfwsg)
      call interfacec(bbxdb,bbxd,sousfxb,sousfxg,dsousfxb,dsousfxg)
      call interfacec(bbydb,bbyd,sousfyb,sousfyg,dsousfyb,dsousfyg)
      call interfacec(bbzdb,bbzd,sousfzb,sousfzg,dsousfzb,dsousfzg)
      call interfacec(bbsdb,bbsd,sousfsb,sousfsg,dsousfsb,dsousfsg)
c
cvv      call interfacec(bvxdb,bvxd,sousfxb,sousfxg,dsousfxb,dsousfxg)
cvv      call interfacec(bvydb,bvyd,sousfyb,sousfyg,dsousfyb,dsousfyg)
cvv      call interfacec(bvzdb,bvzd,sousfzb,sousfzg,dsousfzb,dsousfzg)
cvv      call interfacec(bbbb,bbbg,sousfbb,sousfbg,dsousfbb,dsousfbg)
c
      write(6,*)' step 3 = surface source'
cc      call bhboundary(soupsbh,souapbh,soubxbh,soubybh,soubzbh,
cc     &           dsoupsbh,dsouapbh,dsoubxbh,dsoubybh,dsoubzbh)
cc      call asymptopia(soupsou,souapou,soubxou,soubyou,soubzou,
cc     &           dsoupsou,dsouapou,dsoubxou,dsoubyou,dsoubzou)
c      call bhboundary(soupsbh,souapbh,soubxbh,soubybh,soubzbh,
c     &           dsoupsbh,dsouapbh,dsoubxbh,dsoubybh,dsoubzbh,chbhs)
c      call asymptopia(soupsou,souapou,soubxou,soubyou,soubzou,
c     &           dsoupsou,dsouapou,dsoubxou,dsoubyou,dsoubzou)
c
      call bhboundary_alps(soupsbh,souapbh,dsoupsbh,dsouapbh)
      call asymptopia_alps(soupsou,souapou,dsoupsou,dsouapou)
      call bhboundary_wbvec(souwxbh, souwybh, souwzbh, souwsbh,
     &                     dsouwxbh,dsouwybh,dsouwzbh,dsouwsbh)
      call asymptopia_wbvec(souwxou, souwyou, souwzou, souwsou,
     &                     dsouwxou,dsouwyou,dsouwzou,dsouwsou)
      call bhboundary_wbvec(soubxbh, soubybh, soubzbh, soubsbh,
     &                     dsoubxbh,dsoubybh,dsoubzbh,dsoubsbh)
      call asymptopia_wbvec(soubxou, soubyou, soubzou, soubsou,
     &                     dsoubxou,dsoubyou,dsoubzou,dsoubsou)
c
c
      write(6,*)' step3.1= puncture correction'
      call puncturebd_bhns(sousfpb,sousfpg,dsousfpb,dsousfpg,bhmass)
      dmapmass = -2.0d0*apmass
      call puncturebd_bhns(sousfab,sousfag,dsousfab,dsousfag,dmapmass)
cpunc      call puncturebd(sousfpb,sousfpg,dsousfpb,dsousfpg)
cdbpunc      call puncturebd(sousfab,sousfag,dsousfab,dsousfag)
c
ck      call bhin2gr(psib,psi)
ck      call bhin2gr(alpsb,alps)
ck      call bhin2gr(alphb,alph)
ck      call bhin2gr(bvxdb,bvxd)
ck      call bhin2gr(bvydb,bvyd)
ck      call bhin2gr(bvzdb,bvzd)
c
cc      call divbeta
      call excurve_BY
c
c ==  Interpolations from fluid.
c
      call vgr2vfl_rns(rs)
      call flgrad4(vep,gradv,rs,1,0)
      call vfl2vgr_rns(gradv,gradvg,rs,hrg,rg,1)
      call fl2gr_rns(emd,emdg,rs,hrg,rg,1,1)
      call ram_fluid(gradv,ram)
      call fl2gr_rns(ram,ramg,rs,hrg,rg,1,1)
c
ck      include 'fluid_plot.f'
ck      include 'field_plot.f'
c
      write(6,*)' step4.1= source g'
      call sourcetermg(soupsg,souapg,soubxg,soubyg,soubzg,soubsg)
      write(6,*)' step4.2= source b'
      call sourcetermb(soupsb,souapb,soubxb,soubyb,soubzb,soubsb)
      write(6,*)' step4.3= source g wvec'
      call sourcetermg_wvec(souwxg,souwyg,souwzg,souwsg)
      write(6,*)' step4.4= source b wvec'
      call sourcetermb_wvec(souwxb,souwyb,souwzb,souwsb)
c
ctesttest
ctest      call bh2gr(soubxb,soubxg)
ctest      call bh2gr(soubyb,soubyg)
ctest      call bh2gr(soubzb,soubzg)
ctesttest
c
c      include 'source_plot3.f'
cc      include 'source_plot2.f'
      include 'source_plot.f'
c
c
c --- Call Poisson solver to compute Green's formula.
c
      do 14 ii = 1, 4
c      
c
      do 3000 ipb = 0, npb
      do 3000 itb = 0, ntb
      do 3000 irb = 0, nrb
      potb(irb,itb,ipb) = 0.0d0
      poxb(irb,itb,ipb) = 0.0d0
      poyb(irb,itb,ipb) = 0.0d0
      pozb(irb,itb,ipb) = 0.0d0
      if (ii.eq.1) potb(irb,itb,ipb) = psib(irb,itb,ipb)
      if (ii.eq.2) potb(irb,itb,ipb) = alpsb(irb,itb,ipb)
      if (ii.eq.3) then 
      poxb(irb,itb,ipb) = bwxdb(irb,itb,ipb)
      poyb(irb,itb,ipb) = bwydb(irb,itb,ipb)
      pozb(irb,itb,ipb) = bwzdb(irb,itb,ipb)
      potb(irb,itb,ipb) = bwsdb(irb,itb,ipb)
      end if
      if (ii.eq.4) then
      poxb(irb,itb,ipb) = bbxdb(irb,itb,ipb)
      poyb(irb,itb,ipb) = bbydb(irb,itb,ipb)
      pozb(irb,itb,ipb) = bbzdb(irb,itb,ipb)
      potb(irb,itb,ipb) = bbsdb(irb,itb,ipb)
      end if
      backb(irb,itb,ipb) = potb(irb,itb,ipb)
      bakxb(irb,itb,ipb) = poxb(irb,itb,ipb)
      bakyb(irb,itb,ipb) = poyb(irb,itb,ipb)
      bakzb(irb,itb,ipb) = pozb(irb,itb,ipb)
 3000 continue
c
      do 3001 ipg = 0, npg
      do 3001 itg = 0, ntg
      do 3001 irg = 0, nrtot
      potg(irg,itg,ipg) = 0.0d0
      poxg(irg,itg,ipg) = 0.0d0
      poyg(irg,itg,ipg) = 0.0d0
      pozg(irg,itg,ipg) = 0.0d0
      if (ii.eq.1) potg(irg,itg,ipg) = psi(irg,itg,ipg)
      if (ii.eq.2) potg(irg,itg,ipg) = alps(irg,itg,ipg)
      if (ii.eq.3) then
      poxg(irg,itg,ipg) = bwxd(irg,itg,ipg)
      poyg(irg,itg,ipg) = bwyd(irg,itg,ipg)
      pozg(irg,itg,ipg) = bwzd(irg,itg,ipg)
      potg(irg,itg,ipg) = bwsd(irg,itg,ipg)
      end if
      if (ii.eq.4) then
      poxg(irg,itg,ipg) = bbxd(irg,itg,ipg)
      poyg(irg,itg,ipg) = bbyd(irg,itg,ipg)
      pozg(irg,itg,ipg) = bbzd(irg,itg,ipg)
      potg(irg,itg,ipg) = bbsd(irg,itg,ipg)
      end if
      backg(irg,itg,ipg) = potg(irg,itg,ipg)
      bakxg(irg,itg,ipg) = poxg(irg,itg,ipg)
      bakyg(irg,itg,ipg) = poyg(irg,itg,ipg)
      bakzg(irg,itg,ipg) = pozg(irg,itg,ipg)
 3001 continue
c 
c
      if (ii.eq.1) then
      call poisol(soupsbh,dsoupsbh,sousfpb,dsousfpb,
     &            sousfpg,dsousfpg,soupsou,dsoupsou,
     &            soupsb,soupsg,potb,potg,0,0,0,ii,'nd')
cexci     &            soupsb,soupsg,potb,potg,0,0,0,ii,'dd')
      end if
      if (ii.eq.2) then 
      call poisol(souapbh,dsouapbh,sousfab,dsousfab,
     &            sousfag,dsousfag,souapou,dsouapou,
     &            souapb,souapg,potb,potg,0,0,0,ii,'nd')
cexci     &            souapb,souapg,potb,potg,0,0,0,ii,'dd')
      end if
c
      if (ii.eq.3) then
      call poisol(souwxbh,dsouwxbh,sousfwxb,dsousfwxb,
     &            sousfwxg,dsousfwxg,souwxou,dsouwxou,
     &            souwxb,souwxg,poxb,poxg,0,1,0,ii,'nd')
cexci     &            souwxb,souwxg,poxb,poxg,0,1,0,ii,'dd')
      call poisol(souwybh,dsouwybh,sousfwyb,dsousfwyb,
     &            sousfwyg,dsousfwyg,souwyou,dsouwyou,
     &            souwyb,souwyg,poyb,poyg,0,1,0,ii,'nd')
cexci     &            souwyb,souwyg,poyb,poyg,0,1,0,ii,'dd')
      call poisol(souwzbh,dsouwzbh,sousfwzb,dsousfwzb,
     &            sousfwzg,dsousfwzg,souwzou,dsouwzou,
     &            souwzb,souwzg,pozb,pozg,1,0,0,ii,'nd')
cexci     &            souwzb,souwzg,pozb,pozg,1,0,0,ii,'dd')
      call poisol(souwsbh,dsouwsbh,sousfwsb,dsousfwsb,
     &            sousfwsg,dsousfwsg,souwsou,dsouwsou,
     &            souwsb,souwsg,potb,potg,0,0,0,ii,'nd')
cexci     &            souwsb,souwsg,potb,potg,0,0,0,ii,'dd')
      end if
c
      if (ii.eq.4) then
      call poisol(soubxbh,dsoubxbh,sousfxb,dsousfxb,
     &            sousfxg,dsousfxg,soubxou,dsoubxou,
     &            soubxb,soubxg,poxb,poxg,0,1,0,ii,'nd')
cexci     &            soubxb,soubxg,poxb,poxg,0,1,0,ii,'dd')
      call poisol(soubybh,dsoubybh,sousfyb,dsousfyb,
     &            sousfyg,dsousfyg,soubyou,dsoubyou,
     &            soubyb,soubyg,poyb,poyg,0,1,0,ii,'nd')
cexci     &            soubyb,soubyg,poyb,poyg,0,1,0,ii,'dd')
      call poisol(soubzbh,dsoubzbh,sousfzb,dsousfzb,
     &            sousfzg,dsousfzg,soubzou,dsoubzou,
     &            soubzb,soubzg,pozb,pozg,1,0,0,ii,'nd')
cexci     &            soubzb,soubzg,pozb,pozg,1,0,0,ii,'dd')
      call poisol(soubsbh,dsoubsbh,sousfsb,dsousfsb,
     &            sousfsg,dsousfsg,soubsou,dsoubsou,
     &            soubsb,soubsg,potb,potg,1,0,0,ii,'nd')
cexci     &            soubsb,soubsg,potb,potg,1,0,0,ii,'dd')
      end if
c
      if (ii.eq.1)write(6,*)'--- max error in BH and GR coordinate ---'
c
      if (ii.eq.3.or.ii.eq.4) then
c
      if (ii.eq.3) write(6,*) '=== bwvec_x === '
      if (ii.eq.4) write(6,*) '=== bbvec_x === '
      call bbherror(bakxb,poxb,bakxg,poxg,epsmaxb,epsmaxg,
     &                    irber,itber,ipber,irger,itger,ipger)
      potb0 = poxb(irber,itber,ipber)
      bakb0 = bakxb(irber,itber,ipber)
      potg0 = poxg(irger,itger,ipger)
      bakg0 = bakxg(irger,itger,ipger)
      epsmax = dmax1(epsmaxb,epsmaxg,epsmax)
      write(6,4904) irber, itber, ipber, bakb0, potb0, epsmaxb
      write(6,4905) irger, itger, ipger, bakg0, potg0, epsmaxg
c
      if (ii.eq.3) write(6,*) '=== bwvec_y === '
      if (ii.eq.4) write(6,*) '=== bbvec_y === '
      call bbherror(bakyb,poyb,bakyg,poyg,epsmaxb,epsmaxg,
     &                    irber,itber,ipber,irger,itger,ipger)
      potb0 = poyb(irber,itber,ipber)
      bakb0 = bakyb(irber,itber,ipber)
      potg0 = poyg(irger,itger,ipger)
      bakg0 = bakyg(irger,itger,ipger)
      epsmax = dmax1(epsmaxb,epsmaxg,epsmax)
      write(6,4904) irber, itber, ipber, bakb0, potb0, epsmaxb
      write(6,4905) irger, itger, ipger, bakg0, potg0, epsmaxg
      epsmax_bh = dmax1(epsmaxb,epsmax_bh)
c
      if (ii.eq.3) write(6,*) '=== bwvec_z === '
      if (ii.eq.4) write(6,*) '=== bbvec_z === '
      call bbherror(bakzb,pozb,bakzg,pozg,epsmaxb,epsmaxg,
     &                    irber,itber,ipber,irger,itger,ipger)
      potb0 = pozb(irber,itber,ipber)
      bakb0 = bakzb(irber,itber,ipber)
      potg0 = pozg(irger,itger,ipger)
      bakg0 = bakzg(irger,itger,ipger)
      epsmax = dmax1(epsmaxb,epsmaxg,epsmax)
      write(6,4904) irber, itber, ipber, bakb0, potb0, epsmaxb
      write(6,4905) irger, itger, ipger, bakg0, potg0, epsmaxg
c
      end if
c
      if (ii.eq.1) write(6,*) '=== psi     === '
      if (ii.eq.2) write(6,*) '=== alpha   === '
      if (ii.eq.3) write(6,*) '=== bwvec_s === '
      if (ii.eq.4) write(6,*) '=== bbvec_s === '
      call bbherror(backb,potb,backg,potg,epsmaxb,epsmaxg,
     &                    irber,itber,ipber,irger,itger,ipger)
      potb0 = potb(irber,itber,ipber)
      bakb0 = backb(irber,itber,ipber)
      potg0 = potg(irger,itger,ipger)
      bakg0 = backg(irger,itger,ipger)
      epsmax = dmax1(epsmaxb,epsmaxg,epsmax)
      write(6,4904) irber, itber, ipber, bakb0, potb0, epsmaxb
      write(6,4905) irger, itger, ipger, bakg0, potg0, epsmaxg
      if (ii.eq.1.or.ii.eq.2) epsmax_bh = dmax1(epsmaxb,epsmax_bh)
c
 4904 format(' BH error ',3i5,1p,3e12.4)
 4905 format(' GR error ',3i5,1p,3e12.4)
c
c --  Update variables.
c
      ffpot0 = fffbh
      ffpot  = fffbh
      if (itbh.eq.0) ffpot0 = fffac
      call potimpro(potb,potg,backb,backg,ffpot0,ffpot0)
      if (ii.eq.3.or.ii.eq.4) then
      call potimpro(poxb,poxg,bakxb,bakxg,ffpot,ffpot)
      call potimpro(poyb,poyg,bakyb,bakyg,ffpot,ffpot)
      call potimpro(pozb,pozg,bakzb,bakzg,ffpot,ffpot)
      end if
c
c --  Iterate GR on CCS only
      if (itype.eq.1) go to 3111
c
      do 3010 ipb = 0, npb
      do 3010 itb = 0, ntb
      do 3010 irb = 0, nrb
ctest      if (itbh.eq.0.and.ii.eq.1) psib(irb,itb,ipb) = potb(irb,itb,ipb)
ctest      if (itbh.eq.0.and.ii.eq.2) alpsb(irb,itb,ipb) = potb(irb,itb,ipb)
      if (ii.eq.1) psib(irb,itb,ipb) = potb(irb,itb,ipb)
      if (ii.eq.2) alpsb(irb,itb,ipb) = potb(irb,itb,ipb)
      if (ii.eq.3) then 
      bwxdb(irb,itb,ipb) = poxb(irb,itb,ipb)
      bwydb(irb,itb,ipb) = poyb(irb,itb,ipb)
      bwzdb(irb,itb,ipb) = pozb(irb,itb,ipb)
      bwsdb(irb,itb,ipb) = potb(irb,itb,ipb)
      end if
      if (ii.eq.4) then 
      bbxdb(irb,itb,ipb) = poxb(irb,itb,ipb)
      bbydb(irb,itb,ipb) = poyb(irb,itb,ipb)
      bbzdb(irb,itb,ipb) = pozb(irb,itb,ipb)
      bbsdb(irb,itb,ipb) = potb(irb,itb,ipb)
      end if
 3010 continue
c
 3111 continue
c
      do 3011 ipg = 0, npg
      do 3011 itg = 0, ntg
      do 3011 irg = 0, nrtot
ctest      if (itbh.eq.0.and.ii.eq.1) psi(irg,itg,ipg) = potg(irg,itg,ipg)
ctest      if (itbh.eq.0.and.ii.eq.2) alps(irg,itg,ipg) = potg(irg,itg,ipg)
      if (ii.eq.1) psi(irg,itg,ipg) = potg(irg,itg,ipg)
      if (ii.eq.2) alps(irg,itg,ipg) = potg(irg,itg,ipg)
      if (ii.eq.3) then 
      bwxd(irg,itg,ipg) = poxg(irg,itg,ipg)
      bwyd(irg,itg,ipg) = poyg(irg,itg,ipg)
      bwzd(irg,itg,ipg) = pozg(irg,itg,ipg)
      bwsd(irg,itg,ipg) = potg(irg,itg,ipg)
      end if
      if (ii.eq.4) then 
      bbxd(irg,itg,ipg) = poxg(irg,itg,ipg)
      bbyd(irg,itg,ipg) = poyg(irg,itg,ipg)
      bbzd(irg,itg,ipg) = pozg(irg,itg,ipg)
      bbsd(irg,itg,ipg) = potg(irg,itg,ipg)
      end if
 3011 continue
c 
      if (ii.eq.3) 
     & call shibata_bunkai(bwxdb,bwydb,bwzdb,bwsdb,bwxd,bwyd,bwzd,bwsd,
     &                     wxdb,wydb,wzdb,wxd,wyd,wzd)
      if (ii.eq.4)
     & call shibata_bunkai(bbxdb,bbydb,bbzdb,bbsdb,bbxd,bbyd,bbzd,bbsd,
     &                     bvxdb,bvydb,bvzdb,bvxd,bvyd,bvzd)
ctestest
      if (itbh.eq.-1) go to 14
ctesttest
c
c      write(6,*) 'step 3'
c --  Improving parameters and alpha and psi.  
c
      if (chrot.eq.'c') then 
      call paimproco_bhns(ome,ber,radi,convf,iter,fmax0,0)
      else
      call paimpro_bhns(ome,ber,radi,convf,iter,fmax0,0)
      end if
c
   14 continue
c
      call bvd2u
      call bv2ov
c
c --  reset BH boundary
c
cexci      call resetbhboundary_dirichlet(chbhs)
cc      call resetbhboundary
c
c --  set alpha
c
      call alps2al
c
cexci      call reset_alpha
c
c      write(6,*) 'step 6'
c --  For Corotational fluid, First integral of Euler eq.
c --  For Irrotational fluid, First integral of Euler eq. and eq. of conti.  
c
ctestest 
      if (itbh.eq.-1) then 
      if (iter.eq.itmx) then 
      call gr2fl_rns(psi,psif,rs)
      call gr2fl_rns(alph,alphf,rs)
      call vgr2vfl_rns(rs)
      end if
      include 'fluid_plot2.f'
      go to 3900
      end if
ctestest 
c
      call gr2fl_rns(psi,psif,rs)
      call gr2fl_rns(alph,alphf,rs)
      call vgr2vfl_rns(rs)
c
      do iex = 1, iteflu
      if (chrot.eq.'c') then 
      call fluidco(iter,itmx,convf,cfvep,fmax0,ahores,emxemd,char)
      else
c      write(6,*) 'step 7', convf
      call fluid(iter,itmx,convf,cfvep,fmax0,ahores,emxemd,char)
      end if
      end do
c
c
ck      include 'fluid_plot.f'
cc      include 'fluid_plot.f'
cc 252  format(1p,100e14.6)
cc
      if (iter.le.30) go to 3900
      call admmass(-1)
      call ahfind(0)
      call find_aharea(aharea,ahmass)
      call calc_mass
      call calc_mom
      call calc_dipole_psi
c
      epsmax_adj = dmax1(emxemd,epsmax_bh)
      rmeps_adj = rmeps
      if (ii_adj.eq.10) rmeps_adj = eps
      call adjust_all(epsmax_adj,iter,rmeps_adj,epsmax_par,ii_adj)
ctesttest
      epsmax = dmax1(epsmax_adj,epsmax_par)
ctesttest
cone      call adjust_BY_Py(ipmocond,emxemd,fitpy,pmomy,fmax0)
cone      call adjust_orb_center(iorbcond,emxemd,eps,fmax0)
cone      if (emxemd.le.1.0d-3) then
cone      call ahfind(0)
cone      call find_aharea(aharea,ahmass)
cone      call adjust_bhmass(ibhmcond,emxemd,emddiff,eps,fmax0)
cone      call adjust_apmass(iapmcond,emxemd,emddiff,eps,fmax0)
cone      end if
cone      call adjust_BY_Py(ibypcond,emxemd,emddiff,eps,fmax0)
cone      call adjust_restmass(imascond,emxemd,ahores,emdc,restmass,
cone     &                     emddiff,rmeps,eps,fmax0)
c
 3900 continue
c
 3400 format(1p,7e14.6)
 3401 format(1p,24e14.6)
c
      write(6,4902)'  -- epsmax --, error =', epsmax
 4902 format(a22,1p,2e12.4)
c
c --- Untill convergence is made, go to 2444.
c
      if (iter.eq.itmx.or.epsmax.le.eps) go to 2445
c
ccc      call adjustasymptopia_bh(0)
      write(6,*)' -- omega -- ', ome
      go to 2444
 2445 continue
c
c --- Print out the intermediate state.
      if (iter.eq.itmx.and.epsmax.gt.eps) istat = 2
c --- Print out the converged state.
      if (epsmax.le.eps) istat = 1
c
      call subio(istat,iseq,char)
      call subio_fluid(istat,iseq,char)
      call ahfind(1)
      call bhns_xaxis
      call physq_bh(istat,iseq)
cahotest
       call calc_mass
       call calc_mom
c
      call output_alldata(char)
c
c      if (iwrite.eq.1) call subioca
c
      if (iter.eq.itmx.and.epsmax.gt.eps) write(6,*) ' **iter** '
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Calcuration of deformation sequence.
c
      write(6,*)' Sequence No.= ',iseq
c
 1400 continue
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Formats
c
 4444 format(1p,25e12.4)
 4901 format(a22,1p,e12.4,',  value =',e12.4,2x,3i4)
 4000 format(1p, 6e12.4)
 4400 format(1p,17e12.4)
c
c --- end of the program
c
      end
c
      include 'GR_AHFIND_ver1s.f'
      include 'GR_BHNS_fluid.f'
      include 'GR_ADM_mass_ver1s.f'
      include 'IO_output_alldata.f'
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine sourcetermg(soupsg,souapg,soubxg,soubyg,soubzg,soubsg)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_grav.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      common / dbegr / divbg(0:nnrg,0:nntg,0:nnpg)
c
      common / augfn / emdg(0:nnrg,0:nntg,0:nnpg),
     &                 ramg(0:nnrg,0:nntg,0:nnpg), 
     &               gradvg(0:nnrg,0:nntg,0:nnpg,1:3)
      common / flusw / swflu
c
      dimension soupsg(0:nnrg,0:nntg,0:nnpg),
     &          souapg(0:nnrg,0:nntg,0:nnpg),
     &          soubxg(0:nnrg,0:nntg,0:nnpg),
     &          soubyg(0:nnrg,0:nntg,0:nnpg),
     &          soubzg(0:nnrg,0:nntg,0:nnpg),
     &          soubsg(0:nnrg,0:nntg,0:nnpg)
      dimension fnc0(0:nnrg,0:nntg,0:nnpg),
     &          fnc2(0:nnrg,0:nntg,0:nnpg)
c
      dimension trkij(0:nnrg,0:nntg,0:nnpg)
cz      dimension allog(0:nnrg,0:nntg,0:nnpg)
c
      dimension gamd(3,3),dgamd(3,3,3),dgamdet(3),dgdetinv(3),
     &          gamu(3,3),dgamu(3,3,3),d2gamd(3,3,3,3),
     &          crid(3,3,3),cri(3,3,3),trcri(3),gmcri(3),gdcri(3,3),
     &          ricci(3,3),dtrk(3),ddivom(3)
      dimension gradp(3),gradap(3),gradbx(3),gradby(3),gradbz(3),
     &          gradbv(3,3),cdbvd(3,3),dabfnc(3,3),grad0(3),grad2(3)
      dimension dabfnx(3,3),dabfny(3,3),dabfnz(3,3)
      dimension aij(3,3), baij(3,3), haij(3,3)
      dimension grada(3)
      dimension x5(5), f5(5)
c
c --- Compute source terms for volume integrals.
c
      intnum = 5
      intp = 2
      fac13 = 1.0d0/3.0d0
      fac23 = 2.0d0/3.0d0
      fac43 = 4.0d0/3.0d0
      fac512 = 5.0d0/12.0d0
c
c
      do 420 ipg = 0, npg
      do 420 itg = 0, ntg
      do 420 irg = 0, nrtot
      if (itg.gt.itgbi(irg,ipg)+intnum.and. 
     &    ipg.gt.ipgbiin(irg,itg)+intnum.and. 
     &    ipg.lt.ipgbiou(irg,itg)-intnum.and. 
     &    irg.gt.irgbiin(itg,ipg)+intnum.and. 
     &    irg.lt.irgbiou(itg,ipg)-intnum) go to 420
c      if (irg.gt.irgbiin(itg,ipg)+intnum.and.
c     &    irg.lt.irgbiou(itg,ipg)-intnum) go to 420
c
      x1 = rg(irg)*sintheg(itg)*cosphig(ipg) - bhdis
      y1 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z1 = rg(irg)*costheg(itg)
      x2 = rg(irg)*sintheg(itg)*cosphig(ipg) + bhdis
      y2 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z2 = rg(irg)*costheg(itg)
c
      call confflatcri(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                   gamd,gamu,dgamd,cri,crid,pat,pat)
c
      bvxdw = bvxd(irg,itg,ipg)
      bvydw = bvyd(irg,itg,ipg)
      bvzdw = bvzd(irg,itg,ipg)
      bvxuw = bvxu(irg,itg,ipg)
      bvyuw = bvyu(irg,itg,ipg)
      bvzuw = bvzu(irg,itg,ipg)
      ovxuw = ovxu(irg,itg,ipg)
      ovyuw = ovyu(irg,itg,ipg)
      ovzuw = ovzu(irg,itg,ipg)
c
c
      rgc = rg(irg)
      st = sintheg(itg)
      cp = cosphig(ipg)
      rad1 = dsqrt(dis**2 + rgc**2 - 2.0d0*dis*rgc*st*cp)
      rad2 = dsqrt(dis**2 + rgc**2 + 2.0d0*dis*rgc*st*cp)
      bm1 = bhmass
      bm2 = bhmass
      psiBL = 1.0d0 + 0.5d0*bm1/rad1 + 0.5d0*bm2/rad2
c 
clogalpha      call grgrad1g(alph,grada,irg,itg,ipg)
clogalpha      alphw = alph(irg,itg,ipg)
c1+log      faca = 0.5d0/alphw
c1+log      call grgrad1g(allog,grada,irg,itg,ipg)
c1+log      faca = 0.5d0
c      faca = 0.5d0/(alphw*psiBL**4)
cpunc      trkij(irg,itg,ipg) = 
cpunc     &    faca*(ovxuw*grada(1) + ovyuw*grada(2) + ovzuw*grada(3))
      trkij(irg,itg,ipg) = 0.0d0
c
      fnc0(irg,itg,ipg) = divbg(irg,itg,ipg)
ctest      psim6 = - 6.0d0/psi(irg,itg,ipg)
ctest      call grgrad1g(psi,grad0,irg,itg,ipg)
ctest      fnc0(irg,itg,ipg) =
ctest     &       psim6*(ovxuw*grad0(1)+ovyuw*grad0(2)+ovzuw*grad0(3))
c
      fnc2(irg,itg,ipg) = alph(irg,itg,ipg)/psi(irg,itg,ipg)**6
c      if (alph(irg,itg,ipg).ne.0.0d0)
c     &fnc2(irg,itg,ipg) = dlog(psi(irg,itg,ipg)**6/alph(irg,itg,ipg))
c     &fnc2(irg,itg,ipg) = psi(irg,itg,ipg)**6/alph(irg,itg,ipg)
 420  continue
c
c --  GR coordinate
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      if (irg.gt.irgbiin(itg,ipg)+intp.and.
     &    irg.lt.irgbiou(itg,ipg)-intp) go to 100
      x1 = rg(irg)*sintheg(itg)*cosphig(ipg) - bhdis
      y1 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z1 = rg(irg)*costheg(itg)
      x2 = rg(irg)*sintheg(itg)*cosphig(ipg) + bhdis
      y2 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z2 = rg(irg)*costheg(itg)
c
      call confflat(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                gamd,gamu,dgamd,gamdet,cri,crid,trcri,gmcri,
     &                gdcri,ricci,ricsca,trk,dtrk,divom,ddivom,
     &                pat,pat)
c
      hxxu = gamu(1,1) - 1.0d0
      hxyu = gamu(1,2)
      hxzu = gamu(1,3)
      hyxu = gamu(2,1)
      hyyu = gamu(2,2) - 1.0d0
      hyzu = gamu(2,3)
      hzxu = gamu(3,1)
      hzyu = gamu(3,2)
      hzzu = gamu(3,3) - 1.0d0
c
      psiw = psi(irg,itg,ipg)
      alphw = alph(irg,itg,ipg)
      alpsw = alps(irg,itg,ipg)
ctest      afnc2inv = alphw/fnc2(irg,itg,ipg)
c
      bvxdw = bvxd(irg,itg,ipg)
      bvydw = bvyd(irg,itg,ipg)
      bvzdw = bvzd(irg,itg,ipg)
      bvxuw = bvxu(irg,itg,ipg)
      bvyuw = bvyu(irg,itg,ipg)
      bvzuw = bvzu(irg,itg,ipg)
      ovxuw = ovxu(irg,itg,ipg)
      ovyuw = ovyu(irg,itg,ipg)
      ovzuw = ovzu(irg,itg,ipg)
c
c --  Aij.
c
      call grgrad1g(bvxd,gradbx,irg,itg,ipg,1)
      call grgrad1g(bvyd,gradby,irg,itg,ipg,1)
      call grgrad1g(bvzd,gradbz,irg,itg,ipg,-1)
c
      gradbv(1,1) = gradbx(1)
      gradbv(1,2) = gradbx(2)
      gradbv(1,3) = gradbx(3)
      gradbv(2,1) = gradby(1)
      gradbv(2,2) = gradby(2)
      gradbv(2,3) = gradby(3)
      gradbv(3,1) = gradbz(1)
      gradbv(3,2) = gradbz(2)
      gradbv(3,3) = gradbz(3)
      cdbvd(1,1) = gradbx(1)
     &        - cri(1,1,1)*bvxdw - cri(2,1,1)*bvydw - cri(3,1,1)*bvzdw
      cdbvd(1,2) = gradbx(2)
     &        - cri(1,2,1)*bvxdw - cri(2,2,1)*bvydw - cri(3,2,1)*bvzdw
      cdbvd(1,3) = gradbx(3)
     &        - cri(1,3,1)*bvxdw - cri(2,3,1)*bvydw - cri(3,3,1)*bvzdw
      cdbvd(2,1) = gradby(1)
     &        - cri(1,1,2)*bvxdw - cri(2,1,2)*bvydw - cri(3,1,2)*bvzdw
      cdbvd(2,2) = gradby(2)
     &        - cri(1,2,2)*bvxdw - cri(2,2,2)*bvydw - cri(3,2,2)*bvzdw
      cdbvd(2,3) = gradby(3)
     &        - cri(1,3,2)*bvxdw - cri(2,3,2)*bvydw - cri(3,3,2)*bvzdw
      cdbvd(3,1) = gradbz(1)
     &        - cri(1,1,3)*bvxdw - cri(2,1,3)*bvydw - cri(3,1,3)*bvzdw
      cdbvd(3,2) = gradbz(2)
     &        - cri(1,2,3)*bvxdw - cri(2,2,3)*bvydw - cri(3,2,3)*bvzdw
      cdbvd(3,3) = gradbz(3)
     &        - cri(1,3,3)*bvxdw - cri(2,3,3)*bvydw - cri(3,3,3)*bvzdw
c
      diver = fac23*fnc0(irg,itg,ipg)
c
c --  baij = 2\alpha aij
c --   aij = psi^{-6} haij
c
      haij(1,1) = haxxd(irg,itg,ipg)
      haij(2,2) = hayyd(irg,itg,ipg)
      haij(3,3) = hazzd(irg,itg,ipg)
      haij(1,2) = haxyd(irg,itg,ipg)
      haij(1,3) = haxzd(irg,itg,ipg)
      haij(2,3) = hayzd(irg,itg,ipg)
      haij(2,1) = haij(1,2)
      haij(3,1) = haij(1,3)
      haij(3,2) = haij(2,3)
      facap6 = 2.0d0*alphw/psiw**6
      baij(1,1) = facap6*haxxd(irg,itg,ipg)
      baij(2,2) = facap6*hayyd(irg,itg,ipg)
      baij(3,3) = facap6*hazzd(irg,itg,ipg)
      baij(1,2) = facap6*haxyd(irg,itg,ipg)
      baij(1,3) = facap6*haxzd(irg,itg,ipg)
      baij(2,3) = facap6*hayzd(irg,itg,ipg)
      baij(2,1) = baij(1,2)
      baij(3,1) = baij(1,3)
      baij(3,2) = baij(2,3)
      facp6 = 1.0d0/psiw**6
      aij(1,1) = facp6*haxxd(irg,itg,ipg)
      aij(2,2) = facp6*hayyd(irg,itg,ipg)
      aij(3,3) = facp6*hazzd(irg,itg,ipg)
      aij(1,2) = facp6*haxyd(irg,itg,ipg)
      aij(1,3) = facp6*haxzd(irg,itg,ipg)
      aij(2,3) = facp6*hayzd(irg,itg,ipg)
      aij(2,1) = aij(1,2)
      aij(3,1) = aij(1,3)
      aij(3,2) = aij(2,3)
c
      baijbaij = 0.0d0
      do 80 id = 1, 3
      do 80 ic = 1, 3
      do 80 ib = 1, 3
      do 80 ia = 1, 3
      baijbaij=baijbaij+gamu(ia,ic)*gamu(ib,id)*baij(ia,ib)*baij(ic,id)
   80 continue
c
      aijaij = 0.0d0
      do 8 id = 1, 3
      do 8 ic = 1, 3
      do 8 ib = 1, 3
      do 8 ia = 1, 3
      aijaij = aijaij + gamu(ia,ic)*gamu(ib,id)*aij(ia,ib)*aij(ic,id)
    8 continue
c
c
c --  1 + log slice to compute Lie K
c
      trk = trkij(irg,itg,ipg)
      call grgrad1g(trkij,dtrk,irg,itg,ipg,1)
c
c --  For fluid terms
c
      emdgc = emdg(irg,itg,ipg)
      ramgc = ramg(irg,itg,ipg)
      psigc =  psi(irg,itg,ipg)
      alpgc = alph(irg,itg,ipg)
      rhogc = emdgc**pinx
      pregc = rhogc*emdgc
      hhgc  = 1.0d0 + (pinx+1.0d0)*emdgc
c
      utgc  =       swflu *ramg(irg,itg,ipg)/(alpgc**2*hhgc)
     &      +(1.0d0-swflu)*hhgc/ber
c
      zfac = 1.0d0
      if (emdgc.le.0.0d0) zfac = 0.0d0
      rhoHc = hhgc*rhogc*(alpgc*utgc)**2 - pregc
      if (irg.le.2.and.itg.eq.ntg.and.ipg.eq.npgxzm)
     & write(6,*) ' ****', rhoHc,hhgc,rhogc,alpgc,utgc, pregc
      rp2s = 3.0d0*hhgc*rhogc*(alpgc*utgc)**2 
     &     - 2.0d0*hhgc*rhogc + 5.0d0*pregc
c
c --  For psi.
c
cc      call dadbscalarg(psi,dabfnc,irg,itg,ipg)
cc      call grgrad1g(psi,gradp,irg,itg,ipg)
      hd2p = 0.0d0
      gcdp = 0.0d0
cc      hd2p = hxxu*dabfnc(1,1) + hxyu*(dabfnc(1,2) + dabfnc(2,1))
cc     &     + hyyu*dabfnc(2,2) + hxzu*(dabfnc(1,3) + dabfnc(3,1))
cc     &     + hzzu*dabfnc(3,3) + hyzu*(dabfnc(2,3) + dabfnc(3,2))
cc      gcdp = gmcri(1)*gradp(1) + gmcri(2)*gradp(2) + gmcri(3)*gradp(3)
c
      soupsg(irg,itg,ipg) = - hd2p + gcdp + 0.125d0*psiw*ricsca
cc     &                      - 0.125d0*psiw**5/(4.0d0*alpsw**2)*baijbaij
cc     &                      + 0.125d0*psiw**5*fac23*trk**2
     &                      - 0.125d0*psiw**5*(aijaij - fac23*trk**2)
     &    - radi**2*2.0d0*pi*psigc**5*rhoHc*zfac
c
c --  For alpha*psi.
c
cc      call dadbscalarg(alps,dabfnc,irg,itg,ipg)
cc      call grgrad1g(alps,gradap,irg,itg,ipg)
      hd2p = 0.0d0
      gcdp = 0.0d0
cc      hd2p = hxxu*dabfnc(1,1) + hxyu*(dabfnc(1,2) + dabfnc(2,1))
cc     &     + hyyu*dabfnc(2,2) + hxzu*(dabfnc(1,3) + dabfnc(3,1))
cc     &     + hzzu*dabfnc(3,3) + hyzu*(dabfnc(2,3) + dabfnc(3,2))
cc      gcdp = gmcri(1)*gradap(1)+gmcri(2)*gradap(2)+gmcri(3)*gradap(3)
c
      souapg(irg,itg,ipg) = - hd2p + gcdp + 0.125d0*alpsw*ricsca
     &     + psiw**5*(ovxuw*dtrk(1) + ovyuw*dtrk(2) + ovzuw*dtrk(3))
cc     &     + 0.875d0*psiw**5/(4.0d0*alpsw)*baijbaij
cc     &     + 0.875d0*alpsw*psiw**5*fac512*trk**2
     &     + 0.875d0*alpsw*psiw**5*(aijaij + fac512*trk**2)
     &    + radi**2*2.0d0*pi*alpgc*psigc**5*rp2s*zfac
c
c
c --  For shift.
c
c      call grgrad1g(fnc0,grad0,irg,itg,ipg)
      call grgrad1g(fnc2,grad2,irg,itg,ipg,1)
c
      do 9 ia = 1, 3
c
c --- terms from tilded laplacian.
c
cc      if (ia.eq.1) then 
cc      call dadbscalarg(bvxd,dabfnc,irg,itg,ipg)
cc      end if
cc      if (ia.eq.2) then 
cc      call dadbscalarg(bvyd,dabfnc,irg,itg,ipg)
cc      end if
cc      if (ia.eq.3) then 
cc      call dadbscalarg(bvzd,dabfnc,irg,itg,ipg)
cc      end if
ctesttest
caho      call dadbscalarg(bvxd,dabfnx,irg,itg,ipg)
caho      call dadbscalarg(bvyd,dabfny,irg,itg,ipg)
caho      call dadbscalarg(bvzd,dabfnz,irg,itg,ipg)
caho      grad0(ia) = dabfnx(1,ia) + dabfny(2,ia) + dabfnz(3,ia)
dtesttest
c
      hddw = 0.0d0
      gdcw = 0.0d0
cc      hddw = hxxu*dabfnc(1,1) + hxyu*dabfnc(1,2) + hxzu*dabfnc(1,3)
cc     &     + hyxu*dabfnc(2,1) + hyyu*dabfnc(2,2) + hyzu*dabfnc(2,3)
cc     &     + hzxu*dabfnc(3,1) + hzyu*dabfnc(3,2) + hzzu*dabfnc(3,3)
c
cc      gdcw = gdcri(1,ia)*bvxdw + gdcri(2,ia)*bvydw + gdcri(3,ia)*bvzdw
c
      gcfdw = 0.0d0
      gccdw2 = 0.0d0
      do 7 ic = 1, 3
      do 7 ib = 1, 3
      do 7 id = 1, 3
      gcfdw = gcfdw + gamu(ib,ic)*cri(id,ic,ia)*gradbv(id,ib)
      gccdw2 = gccdw2 + gamu(ib,ic)*cri(id,ib,ia)*cdbvd(id,ic)
    7 continue
c
      gccdw1 = gmcri(1)*cdbvd(ia,1) + gmcri(2)*cdbvd(ia,2)
     &       + gmcri(3)*cdbvd(ia,3)
c
      haijdfn2 = 0.0d0
      do 4 ib = 1, 3
      haijdfn2 = haijdfn2 + haij(ia,ib)*(gamu(ib,1)*grad2(1)
     &         +   gamu(ib,2)*grad2(2) + gamu(ib,3)*grad2(3))
    4 continue
c
c --  Fluid
c
      if (ia.eq.1) oterm = swflu *gradvg(irg,itg,ipg,1)
     &             +(1.0d0-swflu)*  ovxd(irg,itg,ipg)
      if (ia.eq.2) oterm = swflu *gradvg(irg,itg,ipg,2)
     &             +(1.0d0-swflu)*  ovyd(irg,itg,ipg)
      if (ia.eq.3) oterm = swflu *gradvg(irg,itg,ipg,3)
     &             +(1.0d0-swflu)*  ovzd(irg,itg,ipg)
c
c      if (itg.eq.ntg.and.ipg.eq.npgxz) then
c      if (irg.eq.0.or.irg.eq.1.or.irg.eq.2) then
c      write(6,*) gradvg(irg,ntg,npgxz,2), oterm
c      end if
c      end if
c
      zfac = 1.0d0
      if (emdgc.le.0.0d0) zfac = 0.0d0
      rjj =       swflu *rhogc*alpgc*utgc*oterm 
     &    +(1.0d0-swflu)*hhgc*rhogc*alpgc*utgc**2*psigc**4*oterm
c
       souvec = 
ccc     &    - hddw + gdcw + gcfdw + gccdw1 + gccdw2
ccc     &    - fac13*grad0(ia)
ccc     &    -(ricci(ia,1)*bvxuw + ricci(ia,2)*bvyuw + ricci(ia,3)*bvzuw)
     &    + 2.0d0*haijdfn2
ccc     &    - baijdfn2 + fac43*alphw*dtrk(ia)
     &    + radi**2*16.0d0*pi*alpgc*rjj*zfac
c     
      if (ia.eq.1) soubxg(irg,itg,ipg) = souvec
      if (ia.eq.2) soubyg(irg,itg,ipg) = souvec
      if (ia.eq.3) soubzg(irg,itg,ipg) = souvec
c
    9 continue
c
      soux = soubxg(irg,itg,ipg)
      souy = soubyg(irg,itg,ipg)
      souz = soubzg(irg,itg,ipg)
      xxx = rg(irg)*sintheg(itg)*cosphig(ipg) - orbc
      yyy = rg(irg)*sintheg(itg)*sinphig(ipg)
      zzz = rg(irg)*costheg(itg)
      soubsg(irg,itg,ipg) = xxx*soux + yyy*souy + zzz*souz
c
  100 continue
c
c 3400 format(1p,12e14.6) 
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine sourcetermb(soupsb,souapb,soubxb,soubyb,soubzb,soubsb)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_bh.f'
c
      common / dbebh / divbb(nnrb0:nnrb,0:nntb,0:nnpb)
c
      dimension soupsb(0:nnrb,0:nntb,0:nnpb),
     &          souapb(0:nnrb,0:nntb,0:nnpb),
     &          soubxb(0:nnrb,0:nntb,0:nnpb),
     &          soubyb(0:nnrb,0:nntb,0:nnpb),
     &          soubzb(0:nnrb,0:nntb,0:nnpb),
     &          soubsb(0:nnrb,0:nntb,0:nnpb)
      dimension fnc0(nnrb0:nnrb,0:nntb,0:nnpb),
     &          fnc2(nnrb0:nnrb,0:nntb,0:nnpb)
c
      dimension trkij(nnrb0:nnrb,0:nntb,0:nnpb)
      dimension allog(nnrb0:nnrb,0:nntb,0:nnpb)
c
      dimension gamd(3,3),dgamd(3,3,3),dgamdet(3),dgdetinv(3),
     &          gamu(3,3),dgamu(3,3,3),d2gamd(3,3,3,3),
     &          crid(3,3,3),cri(3,3,3),trcri(3),gmcri(3),gdcri(3,3),
     &          ricci(3,3),dtrk(3),ddivom(3)
      dimension gradp(3),gradap(3),gradbx(3),gradby(3),gradbz(3),
     &          gradbv(3,3),cdbvd(3,3),dabfnc(3,3),grad0(3),grad2(3)
      dimension aij(3,3), baij(3,3), haij(3,3)
      dimension grada(3)
      dimension x5(5), f5(5)
c
c --- Compute source terms for volume integrals.
c
      fac13 = 1.0d0/3.0d0
      fac23 = 2.0d0/3.0d0
      fac43 = 4.0d0/3.0d0
      fac512 = 5.0d0/12.0d0
c
c      do 410 ipb = 0, npb
c      do 410 itb = 0, ntb
ccqq      do 410 irb = 0, nrb
c      do 410 irb = nrb0, nrb
c      allog(irb,itb,ipb) = dlog(alphb(irb,itb,ipb))
c 410  continue
c
      do 420 ipb = 0, npb
      do 420 itb = 0, ntb
cqq      do 420 irb = 0, nrb
      do 420 irb = nrb0, nrb
c
      x1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - bhdis
      y1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z1 = rb(irb)*costheb(itb)
      x2 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis + bhdis
      y2 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z2 = rb(irb)*costheb(itb)
      xx1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis
      yy1 = rb(irb)*sintheb(itb)*sinphib(ipb)
c
      call confflatcri(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                   gamd,gamu,dgamd,cri,crid,pat,pat)
c
      bvxdw = bvxdb(irb,itb,ipb)
      bvydw = bvydb(irb,itb,ipb)
      bvzdw = bvzdb(irb,itb,ipb)
      bvxuw = bvxub(irb,itb,ipb)
      bvyuw = bvyub(irb,itb,ipb)
      bvzuw = bvzub(irb,itb,ipb)
      ovxuw = ovxub(irb,itb,ipb)
      ovyuw = ovyub(irb,itb,ipb)
      ovzuw = ovzub(irb,itb,ipb)
c
c
      rbc = rb(irb)
      st = sintheb(itb)
      cp = cosphib(ipb)
      rad1 = rbc
      rad2 = dsqrt((2.0d0*dis)**2 + rbc**2 + 4.0d0*dis*rbc*st*cp)
      bm1 = bhmass
      bm2 = bhmass
      psiBL = 1.0d0 + 0.5d0*bm1/rad1 + 0.5d0*bm2/rad2
c
clogalpha      call grgrad1b(alphb,grada,irb,itb,ipb,nrb0)
clogalpha      alphw = alphb(irb,itb,ipb)
c1+log      faca = 0.5d0/alphw
c1+log      call grgrad1b(allog,grada,irb,itb,ipb,nrb0)
c1+log      faca = 0.5d0
c      faca = 0.5d0/(alphw*psiBL**4)
cpunc      trkij(irb,itb,ipb) = 
cpunc     &    faca*(ovxuw*grada(1) + ovyuw*grada(2) + ovzuw*grada(3))
      trkij(irb,itb,ipb) = 0.0d0
c
      fnc0(irb,itb,ipb) = divbb(irb,itb,ipb)
ctest      psim6 = - 6.0d0/psib(irb,itb,ipb)
ctest      call grgrad1b(psib,grad0,irb,itb,ipb,nrb0)
ctest      fnc0(irb,itb,ipb) = 
ctest     &       psim6*(ovxuw*grad0(1)+ovyuw*grad0(2)+ovzuw*grad0(3))
c
      fnc2(irb,itb,ipb) = alphb(irb,itb,ipb)/psib(irb,itb,ipb)**6
ctest      fnc2(irb,itb,ipb) = psib(irb,itb,ipb)**6/alphb(irb,itb,ipb)
corg      fnc2(irb,itb,ipb) = dlog(psib(irb,itb,ipb)**6/alphb(irb,itb,ipb))
c      fnc2(irb,itb,ipb)
c     &      = dlog(dabs(psib(irb,itb,ipb)**6/alphb(irb,itb,ipb)))
 420  continue
c
c --  BH coordinate
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
      do 100 irb = 0, nrb
      x1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - bhdis
      y1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z1 = rb(irb)*costheb(itb)
      x2 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis + bhdis
      y2 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z2 = rb(irb)*costheb(itb)
c
      call confflat(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                gamd,gamu,dgamd,gamdet,cri,crid,trcri,gmcri,
     &                gdcri,ricci,ricsca,trk,dtrk,divom,ddivom,
     &                pat,pat)
c
      hxxu = gamu(1,1) - 1.0d0
      hxyu = gamu(1,2)
      hxzu = gamu(1,3)
      hyxu = gamu(2,1)
      hyyu = gamu(2,2) - 1.0d0
      hyzu = gamu(2,3)
      hzxu = gamu(3,1)
      hzyu = gamu(3,2)
      hzzu = gamu(3,3) - 1.0d0
c
      psiw = psib(irb,itb,ipb)
      alphw = alphb(irb,itb,ipb)
      alpsw = alpsb(irb,itb,ipb)
ctest      afnc2inv = alphw/fnc2(irb,itb,ipb)
c
      bvxdw = bvxdb(irb,itb,ipb)
      bvydw = bvydb(irb,itb,ipb)
      bvzdw = bvzdb(irb,itb,ipb)
      bvxuw = bvxub(irb,itb,ipb)
      bvyuw = bvyub(irb,itb,ipb)
      bvzuw = bvzub(irb,itb,ipb)
      ovxuw = ovxub(irb,itb,ipb)
      ovyuw = ovyub(irb,itb,ipb)
      ovzuw = ovzub(irb,itb,ipb)
c
c --  Aij.
c
      call grgrad1b(bvxdb,gradbx,irb,itb,ipb,1)
      call grgrad1b(bvydb,gradby,irb,itb,ipb,1)
      call grgrad1b(bvzdb,gradbz,irb,itb,ipb,-1)
      gradbv(1,1) = gradbx(1)
      gradbv(1,2) = gradbx(2)
      gradbv(1,3) = gradbx(3)
      gradbv(2,1) = gradby(1)
      gradbv(2,2) = gradby(2)
      gradbv(2,3) = gradby(3)
      gradbv(3,1) = gradbz(1)
      gradbv(3,2) = gradbz(2)
      gradbv(3,3) = gradbz(3)
      cdbvd(1,1) = gradbx(1)
     &        - cri(1,1,1)*bvxdw - cri(2,1,1)*bvydw - cri(3,1,1)*bvzdw
      cdbvd(1,2) = gradbx(2)
     &        - cri(1,2,1)*bvxdw - cri(2,2,1)*bvydw - cri(3,2,1)*bvzdw
      cdbvd(1,3) = gradbx(3)
     &        - cri(1,3,1)*bvxdw - cri(2,3,1)*bvydw - cri(3,3,1)*bvzdw
      cdbvd(2,1) = gradby(1)
     &        - cri(1,1,2)*bvxdw - cri(2,1,2)*bvydw - cri(3,1,2)*bvzdw
      cdbvd(2,2) = gradby(2)
     &        - cri(1,2,2)*bvxdw - cri(2,2,2)*bvydw - cri(3,2,2)*bvzdw
      cdbvd(2,3) = gradby(3)
     &        - cri(1,3,2)*bvxdw - cri(2,3,2)*bvydw - cri(3,3,2)*bvzdw
      cdbvd(3,1) = gradbz(1)
     &        - cri(1,1,3)*bvxdw - cri(2,1,3)*bvydw - cri(3,1,3)*bvzdw
      cdbvd(3,2) = gradbz(2)
     &        - cri(1,2,3)*bvxdw - cri(2,2,3)*bvydw - cri(3,2,3)*bvzdw
      cdbvd(3,3) = gradbz(3)
     &        - cri(1,3,3)*bvxdw - cri(2,3,3)*bvydw - cri(3,3,3)*bvzdw
c
      diver = fac23*fnc0(irb,itb,ipb)
c
c --  baij = 2\alpha aij
c --   aij = psi^{-6} haij
c
      haij(1,1) = haxxdb(irb,itb,ipb)
      haij(2,2) = hayydb(irb,itb,ipb)
      haij(3,3) = hazzdb(irb,itb,ipb)
      haij(1,2) = haxydb(irb,itb,ipb)
      haij(1,3) = haxzdb(irb,itb,ipb)
      haij(2,3) = hayzdb(irb,itb,ipb)
      haij(2,1) = haij(1,2)
      haij(3,1) = haij(1,3)
      haij(3,2) = haij(2,3)
      facap6 = 2.0d0*alphw/psiw**6
      baij(1,1) = facap6*haxxdb(irb,itb,ipb)
      baij(2,2) = facap6*hayydb(irb,itb,ipb)
      baij(3,3) = facap6*hazzdb(irb,itb,ipb)
      baij(1,2) = facap6*haxydb(irb,itb,ipb)
      baij(1,3) = facap6*haxzdb(irb,itb,ipb)
      baij(2,3) = facap6*hayzdb(irb,itb,ipb)
      baij(2,1) = baij(1,2)
      baij(3,1) = baij(1,3)
      baij(3,2) = baij(2,3)
      facp6 = 1.0d0/psiw**6
      aij(1,1) = facp6*haxxdb(irb,itb,ipb)
      aij(2,2) = facp6*hayydb(irb,itb,ipb)
      aij(3,3) = facp6*hazzdb(irb,itb,ipb)
      aij(1,2) = facp6*haxydb(irb,itb,ipb)
      aij(1,3) = facp6*haxzdb(irb,itb,ipb)
      aij(2,3) = facp6*hayzdb(irb,itb,ipb)
      aij(2,1) = aij(1,2)
      aij(3,1) = aij(1,3)
      aij(3,2) = aij(2,3)
c
      baijbaij = 0.0d0
      do 80 id = 1, 3
      do 80 ic = 1, 3
      do 80 ib = 1, 3
      do 80 ia = 1, 3
      baijbaij=baijbaij+gamu(ia,ic)*gamu(ib,id)*baij(ia,ib)*baij(ic,id)
   80 continue
c
      aijaij = 0.0d0
      do 8 id = 1, 3
      do 8 ic = 1, 3
      do 8 ib = 1, 3
      do 8 ia = 1, 3
      aijaij = aijaij + gamu(ia,ic)*gamu(ib,id)*aij(ia,ib)*aij(ic,id)
    8 continue
c
c
c --  1 + log slice to compute Lie K
c
      trk = trkij(irb,itb,ipb)
      call grgrad1b(trkij,dtrk,irb,itb,ipb,1)
c
c
c --  For psi.
c
ccc      call dadbscalarb(psib,dabfnc,irb,itb,ipb)
ccc      call grgrad1b(psib,gradp,irb,itb,ipb,nrb0)
      hd2p = 0.0d0
      gcdp = 0.0d0
cc      hd2p = hxxu*dabfnc(1,1) + hxyu*(dabfnc(1,2) + dabfnc(2,1))
cc     &     + hyyu*dabfnc(2,2) + hxzu*(dabfnc(1,3) + dabfnc(3,1))
cc     &     + hzzu*dabfnc(3,3) + hyzu*(dabfnc(2,3) + dabfnc(3,2))
cc      gcdp = gmcri(1)*gradp(1) + gmcri(2)*gradp(2) + gmcri(3)*gradp(3)
c
      soupsb(irb,itb,ipb) = - hd2p + gcdp + 0.125d0*psiw*ricsca
cc     &                      - 0.125d0*psiw**5/(4.0d0*alpsw**2)*baijbaij
cc     &                      + 0.125d0*psiw**5*fac23*trk**2
     &                      - 0.125d0*psiw**5*(aijaij - fac23*trk**2)
c
ckk       if (itb.eq.0.and.ipg.eq.0) then
ckk       write(26,*) rb(irb), 
ckk     & soupsb(irb,itb,ipb), - hd2p, + gcdp, + 0.125d0*psiw*ricsca,
ckk     &        - 0.125d0*psiw**5/(4.0d0*alpsw**2)*baijbaij,
ckk     &                      + 0.125d0*psiw**5*fac23*trk**2
ckk      end if
c
c --  For alpha.
c
cc      call dadbscalarb(alpsb,dabfnc,irb,itb,ipb)
cc      call grgrad1b(alpsb,gradap,irb,itb,ipb,nrb0)
        hd2p = 0.0d0
        gcdp = 0.0d0
cc      hd2p = hxxu*dabfnc(1,1) + hxyu*(dabfnc(1,2) + dabfnc(2,1))
cc     &     + hyyu*dabfnc(2,2) + hxzu*(dabfnc(1,3) + dabfnc(3,1))
cc     &     + hzzu*dabfnc(3,3) + hyzu*(dabfnc(2,3) + dabfnc(3,2))
cc      gcdp = gmcri(1)*gradap(1)+gmcri(2)*gradap(2)+gmcri(3)*gradap(3)
c
      souapb(irb,itb,ipb) = - hd2p + gcdp + 0.125d0*alpsw*ricsca
     &     + psiw**5*(ovxuw*dtrk(1) + ovyuw*dtrk(2) + ovzuw*dtrk(3))
cc     &     + 0.875d0*psiw**5/(4.0d0*alpsw)*baijbaij
cc     &     + 0.875d0*alpsw*psiw**5*fac512*trk**2
     &     + 0.875d0*alpsw*psiw**5*(aijaij + fac512*trk**2)
c
c
c --  For shift.
c
ccc      call grgrad1b(fnc0,grad0,irb,itb,ipb,nrb0)
      call grgrad1b(fnc2,grad2,irb,itb,ipb,1)
c
      do 9 ia = 1, 3
c
c --- terms from tilded laplacian.
c
cc      if (ia.eq.1) then 
cc      call dadbscalarb(bvxdb,dabfnc,irb,itb,ipb)
cc      end if
cc      if (ia.eq.2) then 
cc      call dadbscalarb(bvydb,dabfnc,irb,itb,ipb)
cc      end if
cc      if (ia.eq.3) then 
cc      call dadbscalarb(bvzdb,dabfnc,irb,itb,ipb)
cc      end if
c
      hddw = 0.0d0
      gdcw = 0.0d0
cc      hddw = hxxu*dabfnc(1,1) + hxyu*dabfnc(1,2) + hxzu*dabfnc(1,3)
cc     &     + hyxu*dabfnc(2,1) + hyyu*dabfnc(2,2) + hyzu*dabfnc(2,3)
cc     &     + hzxu*dabfnc(3,1) + hzyu*dabfnc(3,2) + hzzu*dabfnc(3,3)
c
cc      gdcw = gdcri(1,ia)*bvxdw + gdcri(2,ia)*bvydw + gdcri(3,ia)*bvzdw
c
      gcfdw = 0.0d0
      gccdw2 = 0.0d0
      do 7 ic = 1, 3
      do 7 ib = 1, 3
      do 7 id = 1, 3
      gcfdw = gcfdw + gamu(ib,ic)*cri(id,ic,ia)*gradbv(id,ib)
      gccdw2 = gccdw2 + gamu(ib,ic)*cri(id,ib,ia)*cdbvd(id,ic)
    7 continue
c
      gccdw1 = gmcri(1)*cdbvd(ia,1) + gmcri(2)*cdbvd(ia,2)
     &       + gmcri(3)*cdbvd(ia,3)
c
      haijdfn2 = 0.0d0
      do 4 ib = 1, 3
      haijdfn2 = haijdfn2 + haij(ia,ib)*(gamu(ib,1)*grad2(1)
     &         +   gamu(ib,2)*grad2(2) + gamu(ib,3)*grad2(3))
    4 continue
c
c      souvec = 0.0d0
      souvec = 
ccc     &    - hddw + gdcw + gcfdw + gccdw1 + gccdw2
ccc     &    - fac13*grad0(ia)
ccc     &    -(ricci(ia,1)*bvxuw + ricci(ia,2)*bvyuw + ricci(ia,3)*bvzuw)
     &    + 2.0d0*haijdfn2
ccc     &    - baijdfn2 + fac43*alphw*dtrk(ia)
ctest     &    - 2.0d0*afnc2inv*aijdfn2 + fac43*alphw*dtrk(ia)
cahotest     &     + fac43*alphw*dtrk(ia)
c
      if (ia.eq.1) soubxb(irb,itb,ipb) = souvec
      if (ia.eq.2) soubyb(irb,itb,ipb) = souvec
      if (ia.eq.3) soubzb(irb,itb,ipb) = souvec
c
    9 continue
c
      soux = soubxb(irb,itb,ipb)
      souy = soubyb(irb,itb,ipb)
      souz = soubzb(irb,itb,ipb)
      xxx = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - orbc
      yyy = rb(irb)*sintheb(itb)*sinphib(ipb)
      zzz = rb(irb)*costheb(itb)
c
      soubsb(irb,itb,ipb) = xxx*soux + yyy*souy + zzz*souz
c
  100 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine sourcetermg_wvec(souwxg,souwyg,souwzg,souwsg)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_grav.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      common / augfn / emdg(0:nnrg,0:nntg,0:nnpg),
     &                 ramg(0:nnrg,0:nntg,0:nnpg), 
     &               gradvg(0:nnrg,0:nntg,0:nnpg,1:3)
      common / flusw / swflu
c
      dimension souwxg(0:nnrg,0:nntg,0:nnpg),
     &          souwyg(0:nnrg,0:nntg,0:nnpg),
     &          souwzg(0:nnrg,0:nntg,0:nnpg),
     &          souwsg(0:nnrg,0:nntg,0:nnpg)
c
      dimension gamd(3,3),dgamd(3,3,3),dgamdet(3),dgdetinv(3),
     &          gamu(3,3),dgamu(3,3,3),d2gamd(3,3,3,3),
     &          crid(3,3,3),cri(3,3,3),trcri(3),gmcri(3),gdcri(3,3),
     &          ricci(3,3),dtrk(3),ddivom(3)
      dimension gradp(3),gradap(3),gradbx(3),gradby(3),gradbz(3),
     &          gradbv(3,3),cdbvd(3,3),dabfnc(3,3),grad0(3),grad2(3)
      dimension dabfnx(3,3),dabfny(3,3),dabfnz(3,3)
      dimension x5(5), f5(5)
c
c --- Compute source terms for volume integrals.
c
      intnum = 5
      intp = 2
      fac13 = 1.0d0/3.0d0
      fac23 = 2.0d0/3.0d0
      fac43 = 4.0d0/3.0d0
      fac512 = 5.0d0/12.0d0
c
c --  GR coordinate
c
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      if (irg.gt.irgbiin(itg,ipg)+intp.and.
     &    irg.lt.irgbiou(itg,ipg)-intp) go to 100
      x1 = rg(irg)*sintheg(itg)*cosphig(ipg) - bhdis
      y1 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z1 = rg(irg)*costheg(itg)
      x2 = rg(irg)*sintheg(itg)*cosphig(ipg) + bhdis
      y2 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z2 = rg(irg)*costheg(itg)
c
      call confflat(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                gamd,gamu,dgamd,gamdet,cri,crid,trcri,gmcri,
     &                gdcri,ricci,ricsca,trk,dtrk,divom,ddivom,
     &                pat,pat)
c
      hxxu = gamu(1,1) - 1.0d0
      hxyu = gamu(1,2)
      hxzu = gamu(1,3)
      hyxu = gamu(2,1)
      hyyu = gamu(2,2) - 1.0d0
      hyzu = gamu(2,3)
      hzxu = gamu(3,1)
      hzyu = gamu(3,2)
      hzzu = gamu(3,3) - 1.0d0
c
      psiw = psi(irg,itg,ipg)
      alphw = alph(irg,itg,ipg)
      alpsw = alps(irg,itg,ipg)
ctest      afnc2inv = alphw/fnc2(irg,itg,ipg)
c
c --  For fluid terms
c
      emdgc = emdg(irg,itg,ipg)
      ramgc = ramg(irg,itg,ipg)
      psigc =  psi(irg,itg,ipg)
      alpgc = alph(irg,itg,ipg)
      rhogc = emdgc**pinx
      pregc = rhogc*emdgc
      hhgc  = 1.0d0 + (pinx+1.0d0)*emdgc
c
      utgc  =       swflu *ramg(irg,itg,ipg)/(alpgc**2*hhgc)
     &      +(1.0d0-swflu)*hhgc/ber
c
      zfac = 1.0d0
      if (emdgc.le.0.0d0) zfac = 0.0d0
c
c --  For wvec.
c
ccc      call grgrad1g(divwg,grad0,irg,itg,ipg)
c
      do 9 ia = 1, 3
c
c --- terms from tilded laplacian.
c
c      if (ia.eq.1) then 
c      call dadbscalarg(bvxd,dabfnc,irg,itg,ipg)
c      end if
c      if (ia.eq.2) then 
c      call dadbscalarg(bvyd,dabfnc,irg,itg,ipg)
c      end if
c      if (ia.eq.3) then 
c      call dadbscalarg(bvzd,dabfnc,irg,itg,ipg)
c      end if
ctesttest
caho      call dadbscalarg(bvxd,dabfnx,irg,itg,ipg)
caho      call dadbscalarg(bvyd,dabfny,irg,itg,ipg)
caho      call dadbscalarg(bvzd,dabfnz,irg,itg,ipg)
caho      grad0(ia) = dabfnx(1,ia) + dabfny(2,ia) + dabfnz(3,ia)
dtesttest
c
      hddw = 0.0d0
c      hddw = hxxu*dabfnc(1,1) + hxyu*dabfnc(1,2) + hxzu*dabfnc(1,3)
c     &     + hyxu*dabfnc(2,1) + hyyu*dabfnc(2,2) + hyzu*dabfnc(2,3)
c     &     + hzxu*dabfnc(3,1) + hzyu*dabfnc(3,2) + hzzu*dabfnc(3,3)
c
      gdcw = 0.0d0
c      gdcw = gdcri(1,ia)*bvxdw + gdcri(2,ia)*bvydw + gdcri(3,ia)*bvzdw
c
      gcfdw = 0.0d0
      gccdw2 = 0.0d0
c      do 7 ic = 1, 3
c      do 7 ib = 1, 3
c      do 7 id = 1, 3
c      gcfdw = gcfdw + gamu(ib,ic)*cri(id,ic,ia)*gradbv(id,ib)
c      gccdw2 = gccdw2 + gamu(ib,ic)*cri(id,ib,ia)*cdbvd(id,ic)
c    7 continue
c
      gccdw1 = 0.0d0
c      gccdw1 = gmcri(1)*cdbvd(ia,1) + gmcri(2)*cdbvd(ia,2)
c     &       + gmcri(3)*cdbvd(ia,3)
c
      baijdfn2 = 0.0d0
c      do 4 ib = 1, 3
c      baijdfn2 = baijdfn2 + baij(ia,ib)*(gamu(ib,1)*grad2(1)
c     &         +   gamu(ib,2)*grad2(2) + gamu(ib,3)*grad2(3))
c    4 continue
c
c --  Fluid
c
      if (ia.eq.1) oterm = swflu *gradvg(irg,itg,ipg,1)
     &             +(1.0d0-swflu)*  ovxd(irg,itg,ipg)
      if (ia.eq.2) oterm = swflu *gradvg(irg,itg,ipg,2)
     &             +(1.0d0-swflu)*  ovyd(irg,itg,ipg)
      if (ia.eq.3) oterm = swflu *gradvg(irg,itg,ipg,3)
     &             +(1.0d0-swflu)*  ovzd(irg,itg,ipg)
c
c
      zfac = 1.0d0
      if (emdgc.le.0.0d0) zfac = 0.0d0
      rjj =       swflu *rhogc*alpgc*utgc*oterm 
     &    +(1.0d0-swflu)*hhgc*rhogc*alpgc*utgc**2*psigc**4*oterm
c
       souvec = 
ccc     &    - hddw + gdcw + gcfdw + gccdw1 + gccdw2
ccc     &    - fac13*grad0(ia)
ccc     &    -(ricci(ia,1)*bvxuw + ricci(ia,2)*bvyuw + ricci(ia,3)*bvzuw)
     &    + radi**2*8.0d0*pi*psigc**6*rjj*zfac
c     
      if (ia.eq.1) souwxg(irg,itg,ipg) = souvec
      if (ia.eq.2) souwyg(irg,itg,ipg) = souvec
      if (ia.eq.3) souwzg(irg,itg,ipg) = souvec
c
    9 continue
c
      soux = souwxg(irg,itg,ipg)
      souy = souwyg(irg,itg,ipg)
      souz = souwzg(irg,itg,ipg)
      xxx = rg(irg)*sintheg(itg)*cosphig(ipg) - orbc
      yyy = rg(irg)*sintheg(itg)*sinphig(ipg)
      zzz = rg(irg)*costheg(itg)
c
      souwsg(irg,itg,ipg) = xxx*soux + yyy*souy + zzz*souz
c
  100 continue
c
c 3400 format(1p,12e14.6) 
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine sourcetermb_wvec(souwxb,souwyb,souwzb,souwsb)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      include 'common_blocks/CB_excurvBY_bh.f'
c
      dimension souwxb(0:nnrb,0:nntb,0:nnpb),
     &          souwyb(0:nnrb,0:nntb,0:nnpb),
     &          souwzb(0:nnrb,0:nntb,0:nnpb),
     &          souwsb(0:nnrb,0:nntb,0:nnpb)
c
      dimension gamd(3,3),dgamd(3,3,3),dgamdet(3),dgdetinv(3),
     &          gamu(3,3),dgamu(3,3,3),d2gamd(3,3,3,3),
     &          crid(3,3,3),cri(3,3,3),trcri(3),gmcri(3),gdcri(3,3),
     &          ricci(3,3),dtrk(3),ddivom(3)
      dimension gradp(3),gradap(3),gradbx(3),gradby(3),gradbz(3),
     &          gradbv(3,3),cdbvd(3,3),dabfnc(3,3),grad0(3),grad2(3)
      dimension x5(5), f5(5)
c
c --- Compute source terms for volume integrals.
c
      fac13 = 1.0d0/3.0d0
      fac23 = 2.0d0/3.0d0
      fac43 = 4.0d0/3.0d0
      fac512 = 5.0d0/12.0d0
c
c
c --  BH coordinate
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
      do 100 irb = 0, nrb
      x1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - bhdis
      y1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z1 = rb(irb)*costheb(itb)
      x2 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis + bhdis
      y2 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z2 = rb(irb)*costheb(itb)
c
      call confflat(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                gamd,gamu,dgamd,gamdet,cri,crid,trcri,gmcri,
     &                gdcri,ricci,ricsca,trk,dtrk,divom,ddivom,
     &                pat,pat)
c
      hxxu = gamu(1,1) - 1.0d0
      hxyu = gamu(1,2)
      hxzu = gamu(1,3)
      hyxu = gamu(2,1)
      hyyu = gamu(2,2) - 1.0d0
      hyzu = gamu(2,3)
      hzxu = gamu(3,1)
      hzyu = gamu(3,2)
      hzzu = gamu(3,3) - 1.0d0
c
      psiw = psib(irb,itb,ipb)
      alphw = alphb(irb,itb,ipb)
      alpsw = alpsb(irb,itb,ipb)
c
c
c --  For wvec.
c
ccc      call grgrad1b(divwb,grad0,irb,itb,ipb,nrb0)
c
      do 9 ia = 1, 3
c
c --- terms from tilded laplacian.
c
c      if (ia.eq.1) then 
c      call dadbscalarb(bvxdb,dabfnc,irb,itb,ipb)
c      end if
c      if (ia.eq.2) then 
c      call dadbscalarb(bvydb,dabfnc,irb,itb,ipb)
c      end if
c      if (ia.eq.3) then 
c      call dadbscalarb(bvzdb,dabfnc,irb,itb,ipb)
c      end if
c
      hddw = 0.0d0
c      hddw = hxxu*dabfnc(1,1) + hxyu*dabfnc(1,2) + hxzu*dabfnc(1,3)
c     &     + hyxu*dabfnc(2,1) + hyyu*dabfnc(2,2) + hyzu*dabfnc(2,3)
c     &     + hzxu*dabfnc(3,1) + hzyu*dabfnc(3,2) + hzzu*dabfnc(3,3)
c
      gdcw = 0.0d0
c      gdcw = gdcri(1,ia)*bvxdw + gdcri(2,ia)*bvydw + gdcri(3,ia)*bvzdw
c
      gcfdw = 0.0d0
      gccdw2 = 0.0d0
c      do 7 ic = 1, 3
c      do 7 ib = 1, 3
c      do 7 id = 1, 3
c      gcfdw = gcfdw + gamu(ib,ic)*cri(id,ic,ia)*gradbv(id,ib)
c      gccdw2 = gccdw2 + gamu(ib,ic)*cri(id,ib,ia)*cdbvd(id,ic)
c    7 continue
c
      gccdw1 = 0.0d0
c      gccdw1 = gmcri(1)*cdbvd(ia,1) + gmcri(2)*cdbvd(ia,2)
c     &       + gmcri(3)*cdbvd(ia,3)
c
c
      souvec = 0.0d0
ccc     &    - hddw + gdcw + gcfdw + gccdw1 + gccdw2
ccc     &    - fac13*grad0(ia)
ccc     &    -(ricci(ia,1)*bvxuw + ricci(ia,2)*bvyuw + ricci(ia,3)*bvzuw)
ctest     &    - 2.0d0*afnc2inv*aijdfn2 + fac43*alphw*dtrk(ia)
cahotest     &     + fac43*alphw*dtrk(ia)
c
      if (ia.eq.1) souwxb(irb,itb,ipb) = souvec
      if (ia.eq.2) souwyb(irb,itb,ipb) = souvec
      if (ia.eq.3) souwzb(irb,itb,ipb) = souvec
c
    9 continue
c
      soux = souwxb(irb,itb,ipb)
      souy = souwyb(irb,itb,ipb)
      souz = souwzb(irb,itb,ipb)
      xxx = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - orbc
      yyy = rb(irb)*sintheb(itb)*sinphib(ipb)
      zzz = rb(irb)*costheb(itb)
c
      souwsb(irb,itb,ipb) = xxx*soux + yyy*souy + zzz*souz
c
  100 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine excurve_BY
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      include 'common_blocks/CB_excurvBY_grav.f'
      include 'common_blocks/CB_excurvBY_bh.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      dimension gamu(3,3), haij(3,3), gradwx(3), gradwy(3), gradwz(3)
      dimension byij(3,3)
c
c --- Compute extringic curvature for Bowen-York.  
c
ctesttesttest
      info = 0
ctesttesttest
c
      fac23 = 2.0d0/3.0d0
      fac32 = 3.0d0/2.0d0
      intp = 2
c
      do 4 ipg = 0, npg
      do 4 itg = 0, ntg
      do 4 irg = 0, nrtot
      if (irg.gt.irgbiin(itg,ipg)+intp.and.
     &    irg.lt.irgbiou(itg,ipg)-intp) go to 4
c
      xxg = rg(irg)*sintheg(itg)*cosphig(ipg)
      yyg = rg(irg)*sintheg(itg)*sinphig(ipg)
      zzg = rg(irg)*costheg(itg)
      rBH = dsqrt(dabs((xxg - dis)**2 + yyg**2 + zzg**2))
      rBH2 = rBH**2
      rnx = (xxg - dis)/rBH
      rny = yyg/rBH
      rnz = zzg/rBH
c 
      call grgrad1g(wxd,gradwx,irg,itg,ipg,1)
      call grgrad1g(wyd,gradwy,irg,itg,ipg,1)
      call grgrad1g(wzd,gradwz,irg,itg,ipg,-1)
c
      gmxxd = 1.0d0
      gmxyd = 0.0d0
      gmxzd = 0.0d0
      gmyyd = 1.0d0
      gmyzd = 0.0d0
      gmzzd = 1.0d0
      gmyxd = gmxyd
      gmzxd = gmxzd
      gmzyd = gmyzd
      gmxxu = 1.0d0
      gmxyu = 0.0d0
      gmxzu = 0.0d0
      gmyyu = 1.0d0
      gmyzu = 0.0d0
      gmzzu = 1.0d0
      gmyxu = gmxyu
      gmzxu = gmxzu
      gmzyu = gmyzu
c
      divwg(irg,itg,ipg) = gradwx(1) + gradwy(2) + gradwz(3)
      diver = fac23*divwg(irg,itg,ipg)
c
      fxxd = 1.0d0
      fxyd = 0.0d0
      fxzd = 0.0d0
      fyxd = 0.0d0
      fyyd = 1.0d0
      fyzd = 0.0d0
      fzxd = 0.0d0
      fzyd = 0.0d0
      fzzd = 1.0d0
      px = 0.0d0
      py = pmomy
      pz = 0.0d0
      prn = px*rnx + py*rny + pz*rnz
c
      byij(1,1) = fac32/rBH2*(rnx*px + rnx*px - (fxxd - rnx*rnx)*prn)
      byij(1,2) = fac32/rBH2*(rnx*py + rny*px - (fxyd - rnx*rny)*prn)
      byij(1,3) = fac32/rBH2*(rnx*pz + rnz*px - (fxzd - rnx*rnz)*prn)
      byij(2,1) = fac32/rBH2*(rny*px + rnx*py - (fyxd - rny*rnx)*prn)
      byij(2,2) = fac32/rBH2*(rny*py + rny*py - (fyyd - rny*rny)*prn)
      byij(2,3) = fac32/rBH2*(rny*pz + rnz*py - (fyzd - rny*rnz)*prn)
      byij(3,1) = fac32/rBH2*(rnz*px + rnx*pz - (fzxd - rnz*rnx)*prn)
      byij(3,2) = fac32/rBH2*(rnz*py + rny*pz - (fzyd - rnz*rny)*prn)
      byij(3,3) = fac32/rBH2*(rnz*pz + rnz*pz - (fzzd - rnz*rnz)*prn)
c
      haxxd(irg,itg,ipg) = 2.0d0*gradwx(1)    -gmxxd*diver + byij(1,1)
      haxyd(irg,itg,ipg) = gradwx(2)+gradwy(1)-gmxyd*diver + byij(1,2)
      haxzd(irg,itg,ipg) = gradwx(3)+gradwz(1)-gmxzd*diver + byij(1,3)
      hayyd(irg,itg,ipg) = 2.0d0*gradwy(2)    -gmyyd*diver + byij(2,2)
      hayzd(irg,itg,ipg) = gradwy(3)+gradwz(2)-gmyzd*diver + byij(2,3)
      hazzd(irg,itg,ipg) = 2.0d0*gradwz(3)    -gmzzd*diver + byij(3,3)
c
      gamu(1,1) = gmxxu 
      gamu(1,2) = gmxyu 
      gamu(1,3) = gmxzu 
      gamu(2,1) = gmyxu 
      gamu(2,2) = gmyyu 
      gamu(2,3) = gmyzu 
      gamu(3,1) = gmzxu 
      gamu(3,2) = gmzyu 
      gamu(3,3) = gmzzu
      haij(1,1) = haxxd(irg,itg,ipg)
      haij(1,2) = haxyd(irg,itg,ipg)
      haij(1,3) = haxzd(irg,itg,ipg)
      haij(2,2) = hayyd(irg,itg,ipg)
      haij(2,3) = hayzd(irg,itg,ipg)
      haij(3,3) = hazzd(irg,itg,ipg)
      haij(2,1) = haij(1,2)
      haij(3,1) = haij(1,3)
      haij(3,2) = haij(2,3)
c 
      haijaij(irg,itg,ipg) = 0.0d0
      do 8 id = 1, 3
      do 8 ic = 1, 3
      do 8 ib = 1, 3
      do 8 ia = 1, 3
      haijaij(irg,itg,ipg) = haijaij(irg,itg,ipg)
     &       + gamu(ia,ic)*gamu(ib,id)*haij(ia,ib)*haij(ic,id)
    8 continue
c
      if (haijaij(irg,itg,ipg).ne.0.) info = 1
c
 4    continue
c
c
c --  BHCS
c
      small = 1.0d-10
      do 40 ipb = 0, npb
      do 40 itb = 0, ntb
      do 40 irb = 0, nrb
c
      xxb = rb(irb)*sintheb(itb)*cosphib(ipb)
      yyb = rb(irb)*sintheb(itb)*sinphib(ipb)
      zzb = rb(irb)*costheb(itb)
      rBH = rb(irb) + small
      rBH2 = rBH**2
      rnx = xxb/rBH
      rny = yyb/rBH
      rnz = zzb/rBH
c 
      call grgrad1b(wxdb,gradwx,irb,itb,ipb,1)
      call grgrad1b(wydb,gradwy,irb,itb,ipb,1)
      call grgrad1b(wzdb,gradwz,irb,itb,ipb,-1)
c
      gmxxd = 1.0d0
      gmxyd = 0.0d0
      gmxzd = 0.0d0
      gmyyd = 1.0d0
      gmyzd = 0.0d0
      gmzzd = 1.0d0
      gmyxd = gmxyd
      gmzxd = gmxzd
      gmzyd = gmyzd
      gmxxu = 1.0d0
      gmxyu = 0.0d0
      gmxzu = 0.0d0
      gmyyu = 1.0d0
      gmyzu = 0.0d0
      gmzzu = 1.0d0
      gmyxu = gmxyu
      gmzxu = gmxzu
      gmzyu = gmyzu
c
      divwb(irb,itb,ipb) = gradwx(1) + gradwy(2) + gradwz(3)
      diver = fac23*divwb(irb,itb,ipb)
c
      fxxd = 1.0d0
      fxyd = 0.0d0
      fxzd = 0.0d0
      fyxd = 0.0d0
      fyyd = 1.0d0
      fyzd = 0.0d0
      fzxd = 0.0d0
      fzyd = 0.0d0
      fzzd = 1.0d0
      px = 0.0d0
      py = pmomy
      pz = 0.0d0
      prn = px*rnx + py*rny + pz*rnz
c
      byij(1,1) = fac32/rBH2*(rnx*px + rnx*px - (fxxd - rnx*rnx)*prn)
      byij(1,2) = fac32/rBH2*(rnx*py + rny*px - (fxyd - rnx*rny)*prn)
      byij(1,3) = fac32/rBH2*(rnx*pz + rnz*px - (fxzd - rnx*rnz)*prn)
      byij(2,1) = fac32/rBH2*(rny*px + rnx*py - (fyxd - rny*rnx)*prn)
      byij(2,2) = fac32/rBH2*(rny*py + rny*py - (fyyd - rny*rny)*prn)
      byij(2,3) = fac32/rBH2*(rny*pz + rnz*py - (fyzd - rny*rnz)*prn)
      byij(3,1) = fac32/rBH2*(rnz*px + rnx*pz - (fzxd - rnz*rnx)*prn)
      byij(3,2) = fac32/rBH2*(rnz*py + rny*pz - (fzyd - rnz*rny)*prn)
      byij(3,3) = fac32/rBH2*(rnz*pz + rnz*pz - (fzzd - rnz*rnz)*prn)
c
      haxxdb(irb,itb,ipb) = 2.0d0*gradwx(1)    -gmxxd*diver + byij(1,1)
      haxydb(irb,itb,ipb) = gradwx(2)+gradwy(1)-gmxyd*diver + byij(1,2)
      haxzdb(irb,itb,ipb) = gradwx(3)+gradwz(1)-gmxzd*diver + byij(1,3)
      hayydb(irb,itb,ipb) = 2.0d0*gradwy(2)    -gmyyd*diver + byij(2,2)
      hayzdb(irb,itb,ipb) = gradwy(3)+gradwz(2)-gmyzd*diver + byij(2,3)
      hazzdb(irb,itb,ipb) = 2.0d0*gradwz(3)    -gmzzd*diver + byij(3,3)
c
      gamu(1,1) = gmxxu 
      gamu(1,2) = gmxyu 
      gamu(1,3) = gmxzu 
      gamu(2,1) = gmyxu 
      gamu(2,2) = gmyyu 
      gamu(2,3) = gmyzu 
      gamu(3,1) = gmzxu 
      gamu(3,2) = gmzyu 
      gamu(3,3) = gmzzu
      haij(1,1) = haxxdb(irb,itb,ipb)
      haij(1,2) = haxydb(irb,itb,ipb)
      haij(1,3) = haxzdb(irb,itb,ipb)
      haij(2,2) = hayydb(irb,itb,ipb)
      haij(2,3) = hayzdb(irb,itb,ipb)
      haij(3,3) = hazzdb(irb,itb,ipb)
      haij(2,1) = haij(1,2)
      haij(3,1) = haij(1,3)
      haij(3,2) = haij(2,3)
c 
      haijaijb(irb,itb,ipb) = 0.0d0
      do 80 id = 1, 3
      do 80 ic = 1, 3
      do 80 ib = 1, 3
      do 80 ia = 1, 3
      haijaijb(irb,itb,ipb) = haijaijb(irb,itb,ipb)
     &       + gamu(ia,ic)*gamu(ib,id)*haij(ia,ib)*haij(ic,id)
   80 continue
c
      if (haijaij(irg,itg,ipg).ne.0.) info = 1
c
 40   continue
c
      call bhin2gr(divwb,divwg)
c
      if (info.ne.1) write(6,*) ' ### Warning K_ij = 0 *** '
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine clear_wvec
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_wvec_grav.f'
      include 'common_blocks/CB_wvec_bh.f'
      include 'common_blocks/CB_excurvBY_grav.f'
      include 'common_blocks/CB_excurvBY_bh.f'
c
c --- clear divw
c
      do 4 ipg = 0, npg
      do 4 itg = 0, ntg
      do 4 irg = 0, nrtot
      wxd(irg,itg,ipg) = 0.0d0
      wyd(irg,itg,ipg) = 0.0d0
      wzd(irg,itg,ipg) = 0.0d0
      divwg(irg,itg,ipg) = 0.0d0
 4    continue
c
      do 40 ipb = 0, npb
      do 40 itb = 0, ntb
      do 40 irb = 0, nrb
      wxdb(irb,itb,ipb) = 0.0d0
      wydb(irb,itb,ipb) = 0.0d0
      wzdb(irb,itb,ipb) = 0.0d0
      divwb(irb,itb,ipb) = 0.0d0
 40   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine divbeta
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      common / dbegr / divbg(0:nnrg,0:nntg,0:nnpg)
      common / dbebh / divbb(nnrb0:nnrb,0:nntb,0:nnpb)
c
      common / cdivb / cdivbv(0:nnrg,0:nntg,0:nnpg)
c
      dimension gamd(3,3),dgamd(3,3,3),dgamdet(3),dgdetinv(3),
     &          gamu(3,3),dgamu(3,3,3),d2gamd(3,3,3,3),
     &          crid(3,3,3),cri(3,3,3),trcri(3),gmcri(3),gdcri(3,3),
     &          ricci(3,3),dtrk(3),ddivom(3)
      dimension gradbx(3),gradby(3),gradbz(3),
     &          cdbvd(3,3),grad0(3)
c
      do 420 ipb = 0, npb
      do 420 itb = 0, ntb
      do 420 irb = nrb0, nrb
c
      x1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - bhdis
      y1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z1 = rb(irb)*costheb(itb)
      x2 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis + bhdis
      y2 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z2 = rb(irb)*costheb(itb)
c
      call confflatcri(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                   gamd,gamu,dgamd,cri,crid,pat,pat)
c
      bvxdw = bvxdb(irb,itb,ipb)
      bvydw = bvydb(irb,itb,ipb)
      bvzdw = bvzdb(irb,itb,ipb)
      bvxuw = bvxub(irb,itb,ipb)
      bvyuw = bvyub(irb,itb,ipb)
      bvzuw = bvzub(irb,itb,ipb)
      ovxuw = ovxub(irb,itb,ipb)
      ovyuw = ovyub(irb,itb,ipb)
      ovzuw = ovzub(irb,itb,ipb)
c
      call grgrad1b(bvxdb,gradbx,irb,itb,ipb,1)
      call grgrad1b(bvydb,gradby,irb,itb,ipb,1)
      call grgrad1b(bvzdb,gradbz,irb,itb,ipb,-1)
      cdbvd(1,1) = gradbx(1)
     &        - cri(1,1,1)*bvxdw - cri(2,1,1)*bvydw - cri(3,1,1)*bvzdw
      cdbvd(1,2) = gradbx(2)
     &        - cri(1,2,1)*bvxdw - cri(2,2,1)*bvydw - cri(3,2,1)*bvzdw
      cdbvd(1,3) = gradbx(3)
     &        - cri(1,3,1)*bvxdw - cri(2,3,1)*bvydw - cri(3,3,1)*bvzdw
      cdbvd(2,1) = gradby(1)
     &        - cri(1,1,2)*bvxdw - cri(2,1,2)*bvydw - cri(3,1,2)*bvzdw
      cdbvd(2,2) = gradby(2)
     &        - cri(1,2,2)*bvxdw - cri(2,2,2)*bvydw - cri(3,2,2)*bvzdw
      cdbvd(2,3) = gradby(3)
     &        - cri(1,3,2)*bvxdw - cri(2,3,2)*bvydw - cri(3,3,2)*bvzdw
      cdbvd(3,1) = gradbz(1)
     &        - cri(1,1,3)*bvxdw - cri(2,1,3)*bvydw - cri(3,1,3)*bvzdw
      cdbvd(3,2) = gradbz(2)
     &        - cri(1,2,3)*bvxdw - cri(2,2,3)*bvydw - cri(3,2,3)*bvzdw
      cdbvd(3,3) = gradbz(3)
     &        - cri(1,3,3)*bvxdw - cri(2,3,3)*bvydw - cri(3,3,3)*bvzdw
      divbb(irb,itb,ipb) = 0.0d0
      do 421 ib = 1, 3
      do 421 ia = 1, 3
      divbb(irb,itb,ipb) = divbb(irb,itb,ipb) + gamu(ia,ib)*cdbvd(ia,ib)
 421  continue
 420  continue
c
c
c --- Compute source terms for volume integrals.
c
      intnum = 5
      intp = 2
c
      do 520 ipg = 0, npg
      do 520 itg = 0, ntg
      do 520 irg = 0, nrtot
      if (itg.gt.itgbi(irg,ipg)+intnum.and. 
     &    ipg.gt.ipgbiin(irg,itg)+intnum.and. 
     &    ipg.lt.ipgbiou(irg,itg)-intnum.and. 
     &    irg.gt.irgbiin(itg,ipg)+intnum.and. 
     &    irg.lt.irgbiou(itg,ipg)-intnum) go to 520
c      if (irg.gt.irgbiin(itg,ipg)+intnum.and.
c     &    irg.lt.irgbiou(itg,ipg)-intnum) go to 520
c
      x1 = rg(irg)*sintheg(itg)*cosphig(ipg) - bhdis
      y1 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z1 = rg(irg)*costheg(itg)
      x2 = rg(irg)*sintheg(itg)*cosphig(ipg) + bhdis
      y2 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z2 = rg(irg)*costheg(itg)
      xx1 = rg(irg)*sintheg(itg)*cosphig(ipg)
      yy1 = rg(irg)*sintheg(itg)*sinphig(ipg)
c
      call confflatcri(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
     &                   gamd,gamu,dgamd,cri,crid,pat,pat)
c
      bvxdw = bvxd(irg,itg,ipg)
      bvydw = bvyd(irg,itg,ipg)
      bvzdw = bvzd(irg,itg,ipg)
      bvxuw = bvxu(irg,itg,ipg)
      bvyuw = bvyu(irg,itg,ipg)
      bvzuw = bvzu(irg,itg,ipg)
      ovxuw = ovxu(irg,itg,ipg)
      ovyuw = ovyu(irg,itg,ipg)
      ovzuw = ovzu(irg,itg,ipg)
c
      call grgrad1g(bvxd,gradbx,irg,itg,ipg,1)
      call grgrad1g(bvyd,gradby,irg,itg,ipg,1)
      call grgrad1g(bvzd,gradbz,irg,itg,ipg,-1)
c
      cdbvd(1,1) = gradbx(1)
     &        - cri(1,1,1)*bvxdw - cri(2,1,1)*bvydw - cri(3,1,1)*bvzdw
      cdbvd(1,2) = gradbx(2)
     &        - cri(1,2,1)*bvxdw - cri(2,2,1)*bvydw - cri(3,2,1)*bvzdw
      cdbvd(1,3) = gradbx(3)
     &        - cri(1,3,1)*bvxdw - cri(2,3,1)*bvydw - cri(3,3,1)*bvzdw
      cdbvd(2,1) = gradby(1)
     &        - cri(1,1,2)*bvxdw - cri(2,1,2)*bvydw - cri(3,1,2)*bvzdw
      cdbvd(2,2) = gradby(2)
     &        - cri(1,2,2)*bvxdw - cri(2,2,2)*bvydw - cri(3,2,2)*bvzdw
      cdbvd(2,3) = gradby(3)
     &        - cri(1,3,2)*bvxdw - cri(2,3,2)*bvydw - cri(3,3,2)*bvzdw
      cdbvd(3,1) = gradbz(1)
     &        - cri(1,1,3)*bvxdw - cri(2,1,3)*bvydw - cri(3,1,3)*bvzdw
      cdbvd(3,2) = gradbz(2)
     &        - cri(1,2,3)*bvxdw - cri(2,2,3)*bvydw - cri(3,2,3)*bvzdw
      cdbvd(3,3) = gradbz(3)
     &        - cri(1,3,3)*bvxdw - cri(2,3,3)*bvydw - cri(3,3,3)*bvzdw
      divbg(irg,itg,ipg) = 0.0d0
      do 521 ib = 1, 3
      do 521 ia = 1, 3
      divbg(irg,itg,ipg) = divbg(irg,itg,ipg) + gamu(ia,ib)*cdbvd(ia,ib)
 521  continue
 520  continue
c
      call bhin2gr(divbb,divbg)
c
      do 530 ipg = 0, npg
      do 530 itg = 0, ntg
      do 530 irg = 0, nrtot
      cdivbv(irg,itg,ipg) = divbg(irg,itg,ipg)
  530 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine puncturebd(sousfpb,sousfpg,dsousfpb,dsousfpg)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension sousfpb(0:nntb,0:nnpb),dsousfpb(0:nntb,0:nnpb),
     &          sousfpg(0:nntb,0:nnpb),dsousfpg(0:nntb,0:nnpb)
c
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
      irb = nrb
      rbc = rb(irb)
      st = sintheb(itb)
      cp = cosphib(ipb)
      rad1 = rbc
      rad2 = dsqrt((2.0d0*dis)**2 + rbc**2 + 4.0d0*dis*rbc*st*cp)
      drad2dr = (rbc + 2.0d0*dis*st*cp)/rad2
      bm1 = bhmass
      bm2 = bhmass
      sousfpb(itb,ipb) =sousfpb(itb,ipb)-0.5d0*bm1/rad1-0.5d0*bm2/rad2
      dsousfpb(itb,ipb)= dsousfpb(itb,ipb)
     &                 + 0.5d0*bm1/rad1**2 - 0.5d0*bm2/rad2**2*drad2dr
c
      irb = nrbin
      rbc = rb(irb)
      st = sintheb(itb)
      cp = cosphib(ipb)
      rad1 = rbc
      rad2 = dsqrt((2.0d0*dis)**2 + rbc**2 + 4.0d0*dis*rbc*st*cp)
      drad2dr = (rbc + 2.0d0*dis*st*cp)/rad2
      bm1 = bhmass
      bm2 = bhmass
      sousfpg(itb,ipb) =sousfpg(itb,ipb)-0.5d0*bm1/rad1-0.5d0*bm2/rad2
      dsousfpg(itb,ipb)= dsousfpg(itb,ipb)
     &                 + 0.5d0*bm1/rad1**2 - 0.5d0*bm2/rad2**2*drad2dr
  100 continue
c
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine puncturebd_bhns(sousfpb,sousfpg,dsousfpb,dsousfpg,cm)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension sousfpb(0:nntb,0:nnpb),dsousfpb(0:nntb,0:nnpb),
     &          sousfpg(0:nntb,0:nnpb),dsousfpg(0:nntb,0:nnpb)
c
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
      irb = nrb
      rbc = rb(irb)
      rad1 = rbc
      bm1 = cm
      sousfpb(itb,ipb) =  sousfpb(itb,ipb) - 0.5d0*bm1/rad1
      dsousfpb(itb,ipb)= dsousfpb(itb,ipb) + 0.5d0*bm1/rad1**2
c
      irb = nrbin
      rbc = rb(irb)
      rad1 = rbc
      bm1 = cm
      sousfpg(itb,ipb) =  sousfpg(itb,ipb) - 0.5d0*bm1/rad1
      dsousfpg(itb,ipb)= dsousfpg(itb,ipb) + 0.5d0*bm1/rad1**2
  100 continue
c
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bhboundary_alps(soupsbh,souapbh,dsoupsbh,dsouapbh)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
c
      dimension soupsbh(0:nntb,0:nnpb),dsoupsbh(0:nntb,0:nnpb),
     &          souapbh(0:nntb,0:nnpb),dsouapbh(0:nntb,0:nnpb)
c
c -- For puncture
c
      irb = 0
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
c
      soupsbh(itb,ipb) = 0.0d0
      souapbh(itb,ipb) = 0.0d0
c
      dsoupsbh(itb,ipb) = 0.0d0
      dsouapbh(itb,ipb) = 0.0d0
c
 100   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bhboundary_wbvec(soubxbh, soubybh, soubzbh, soubsbh,
     &                           dsoubxbh,dsoubybh,dsoubzbh,dsoubsbh)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
c
      dimension soubxbh(0:nntb,0:nnpb),dsoubxbh(0:nntb,0:nnpb),
     &          soubybh(0:nntb,0:nnpb),dsoubybh(0:nntb,0:nnpb),
     &          soubzbh(0:nntb,0:nnpb),dsoubzbh(0:nntb,0:nnpb),
     &          soubsbh(0:nntb,0:nnpb),dsoubsbh(0:nntb,0:nnpb)
c
c --- For Puncture.
c
      irb = 0
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
c
      soubxbh(itb,ipb) = 0.0d0
      soubybh(itb,ipb) = 0.0d0
      soubzbh(itb,ipb) = 0.0d0
      soubsbh(itb,ipb) = 0.0d0
c
      dsoubxbh(itb,ipb) = 0.0d0
      dsoubybh(itb,ipb) = 0.0d0
      dsoubzbh(itb,ipb) = 0.0d0
      dsoubsbh(itb,ipb) = 0.0d0
c
 100   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bhboundary(soupsbh,souapbh,soubxbh,soubybh,soubzbh,
     &           dsoupsbh,dsouapbh,dsoubxbh,dsoubybh,dsoubzbh,chbhs)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
c
      dimension soupsbh(0:nntb,0:nnpb),dsoupsbh(0:nntb,0:nnpb),
     &          souapbh(0:nntb,0:nnpb),dsouapbh(0:nntb,0:nnpb),
     &          soubxbh(0:nntb,0:nnpb),dsoubxbh(0:nntb,0:nnpb),
     &          soubybh(0:nntb,0:nnpb),dsoubybh(0:nntb,0:nnpb),
     &          soubzbh(0:nntb,0:nnpb),dsoubzbh(0:nntb,0:nnpb)
c
      dimension r5(5), f5ps(5), f5ap(5)
      dimension gradbx(3), gradby(3)
      dimension gamd(3,3), gamu(3,3)
c
      character*1 chbhs
c
c --- For Dirichlet boundary.
c
      irb = 0
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
c
c -- Dirichlet boundary 
c
      gamd(1,1) = 1.0d0
      gamd(1,2) = 0.0d0
      gamd(1,3) = 0.0d0
      gamd(2,1) = 0.0d0
      gamd(2,2) = 1.0d0
      gamd(2,3) = 0.0d0
      gamd(3,1) = 0.0d0
      gamd(3,2) = 0.0d0
      gamd(3,3) = 1.0d0
      xxcs = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - orbc
      yycs = rb(irb)*sintheb(itb)*sinphib(ipb)
      xxbh = rb(irb)*sintheb(itb)*cosphib(ipb)
      yybh = rb(irb)*sintheb(itb)*sinphib(ipb)
c
      if (chbhs.eq.'i') omebh  =   ome
      if (chbhs.eq.'i') spinbh = - omebh
      if (chbhs.eq.'I') spinbh = - omebh
c
      ophixu = - omebh*yycs - spinbh*yybh
      ophiyu =   omebh*xxcs + spinbh*xxbh
      ophizu = 0.0d0
      ophixd = gamd(1,1)*ophixu + gamd(1,2)*ophiyu + gamd(1,3)*ophizu
      ophiyd = gamd(2,1)*ophixu + gamd(2,2)*ophiyu + gamd(2,3)*ophizu
      ophizd = gamd(3,1)*ophixu + gamd(3,2)*ophiyu + gamd(3,3)*ophizu
c
c
cexci      soupsbh(itb,ipb) = psibh
cexci      souapbh(itb,ipb) = alphbh*psibh
      soupsbh(itb,ipb) = 0.0d0
      souapbh(itb,ipb) = 0.0d0
      soubxbh(itb,ipb) = -ophixd
      soubybh(itb,ipb) = -ophiyd
      soubzbh(itb,ipb) = -ophizd
c
      dsoupsbh(itb,ipb) = 0.0d0
      dsouapbh(itb,ipb) = 0.0d0
      dsoubxbh(itb,ipb) = 0.0d0
      dsoubybh(itb,ipb) = 0.0d0
      dsoubzbh(itb,ipb) = 0.0d0
c
 100   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bhboundary_all(soupsbh,souapbh,soubxbh,soubybh,soubzbh,
     &                 dsoupsbh,dsouapbh,dsoubxbh,dsoubybh,dsoubzbh)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
c
      dimension soupsbh(0:nntb,0:nnpb),dsoupsbh(0:nntb,0:nnpb),
     &          souapbh(0:nntb,0:nnpb),dsouapbh(0:nntb,0:nnpb),
     &          soubxbh(0:nntb,0:nnpb),dsoubxbh(0:nntb,0:nnpb),
     &          soubybh(0:nntb,0:nnpb),dsoubybh(0:nntb,0:nnpb),
     &          soubzbh(0:nntb,0:nnpb),dsoubzbh(0:nntb,0:nnpb)
c
      dimension r5(5), f5ps(5), f5ap(5)
      dimension gradbx(3), gradby(3)
      dimension gamd(3,3), gamu(3,3)
c
c --- Compute source for BH boundary terms.
c
      sepa = 2.0d0*dis
ctest      bhmass = 2.0d0
ctest      bhmass = bhrad
      irb = 0
      rv = rb(irb)
      ir0 = 0
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
c
      do 20 ii = 1, 5
      irb0 = ir0 + ii - 1
      r5(ii) = rb(irb0)
      f5ps(ii) = psib(irb0,itb,ipb)
      f5ap(ii) = alpsb(irb0,itb,ipb)
calph      f5ap(ii) = alphb(irb0,itb,ipb)
   20 continue
c
      st = sintheb(itb)
      cp = cosphib(ipb)
      rad1 = bhrad
      rad2 = sqrt(rad1**2 + 2.0d0*rad1*sepa*st*cp + sepa**2)
      dr2dr1 = (rad1 + sepa*st*cp)/rad2
      psic  = 1.0d0 + 0.5d0*bhmass/rad1 + 0.5d0*bhmass/rad2
      alpsc = 1.0d0 - 0.5d0*bhmass/rad1 - 0.5d0*bhmass/rad2
      alphc = alpsc/psic
c
      dpsidr = - 0.5d0*bhmass/rad1**2
     &         - 0.5d0*bhmass/rad2**2*dr2dr1
      dalpsdr = - dpsidr
      dalphdr = dalpsdr/psic - dpsidr*alphc/psic
c
      soupsbh(itb,ipb) = psib(0,itb,ipb)
      souapbh(itb,ipb) = alpsb(0,itb,ipb)
calph      souapbh(itb,ipb) = alphb(0,itb,ipb)
      dsoupsbh(itb,ipb) = dpsidr
      dsouapbh(itb,ipb) = dalpsdr
calph      dsouapbh(itb,ipb) = dalphdr
c
ctoydir      soupsbh(itb,ipb) = psic
ctoydir      souapbh(itb,ipb) = alpsc
calph      souapbh(itb,ipb) = alphc
ctoydir      dsoupsbh(itb,ipb) = dfncdx(r5,f5ps,rv)
ctoydir      dsouapbh(itb,ipb) = dfncdx(r5,f5ap,rv)
c
c
c -- 1+log test
c
ccc      boubou = 0.5d0*bm1/rb(0)
ccc      soupsbh(itb,ipb) = boubou
      soupsbh(itb,ipb) = psibh
      souapbh(itb,ipb) = alphbh*psibh
ctest      soupsbh(itb,ipb) = 5.0d0
ctest      souapbh(itb,ipb) = 5.0d0
cpunc      soupsbh(itb,ipb) = 0.0d0
cpunc      souapbh(itb,ipb) = 0.0d0
      dsoupsbh(itb,ipb) = 0.0d0
      dsouapbh(itb,ipb) = 0.0d0
crobin      dsoupsbh(itb,ipb) = - psib(0,itb,ipb)/(2.0d0*rb(0))
crobin      dsouapbh(itb,ipb) = - alpsb(0,itb,ipb)/(2.0d0*rb(0))
c
      irb = 0
      gamu(1,1) = 1.0d0
      gamu(1,2) = 0.0d0
      gamu(1,3) = 0.0d0
      gamu(2,1) = 0.0d0
      gamu(2,2) = 1.0d0
      gamu(2,3) = 0.0d0
      gamu(3,1) = 0.0d0
      gamu(3,2) = 0.0d0
      gamu(3,3) = 1.0d0
      gamd(1,1) = 1.0d0
      gamd(1,2) = 0.0d0
      gamd(1,3) = 0.0d0
      gamd(2,1) = 0.0d0
      gamd(2,2) = 1.0d0
      gamd(2,3) = 0.0d0
      gamd(3,1) = 0.0d0
      gamd(3,2) = 0.0d0
      gamd(3,3) = 1.0d0
      xx1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis
      yy1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      bvxdw = bvxdb(irb,itb,ipb)
      bvydw = bvydb(irb,itb,ipb)
      bvzdw = bvzdb(irb,itb,ipb)
      bvxuw = gamu(1,1)*bvxdw + gamu(1,2)*bvydw + gamu(1,3)*bvzdw
      bvyuw = gamu(2,1)*bvxdw + gamu(2,2)*bvydw + gamu(2,3)*bvzdw
      bvzuw = gamu(3,1)*bvxdw + gamu(3,2)*bvydw + gamu(3,3)*bvzdw
      ovxuw = bvxuw - ome*yy1
      ovyuw = bvyuw + ome*xx1
      ovzuw = bvzuw
      ophixu = - ome*yy1
      ophiyu =   ome*xx1
      ophizu = 0.0d0
      ophixd = gamd(1,1)*ophixu + gamd(1,2)*ophiyu + gamd(1,3)*ophizu
      ophiyd = gamd(2,1)*ophixu + gamd(2,2)*ophiyu + gamd(2,3)*ophizu
      ophizd = gamd(3,1)*ophixu + gamd(3,2)*ophiyu + gamd(3,3)*ophizu
      call grgrad1b(bvxdb,gradbx,irb,itb,ipb,1)
      call grgrad1b(bvydb,gradby,irb,itb,ipb,1)
      ovdbx = ovxuw*gradbx(1) + ovxuw*gradbx(2) + ovxuw*gradbx(3)
      ovdby = ovxuw*gradby(1) + ovxuw*gradby(2) + ovxuw*gradby(3)
c
caho      if (ome.eq.0.0d0) then 
caho      soubxbh(itb,ipb) = 0.0d0
caho      soubybh(itb,ipb) = 0.0d0
caho      end if
caho      if (ome.ne.0.0d0) then 
cahoccc      soubxbh(itb,ipb) =   ovdby/ome
caho      soubxbh(itb,ipb) = 0.0d0
cahoccc      soubybh(itb,ipb) = - ovdbx/ome
cahoccc      soubybh(itb,ipb) = - 0.1d0*ome
caho      soubybh(itb,ipb) = 0.0d0
caho      end if
c
cpunc      soubxbh(itb,ipb) = 0.0d0
cpunc      soubybh(itb,ipb) = 0.0d0
cpunc      soubzbh(itb,ipb) = 0.0d0
      soubxbh(itb,ipb) = -ophixd
      soubybh(itb,ipb) = -ophiyd
      soubzbh(itb,ipb) = -ophizd
c
      dsoubxbh(itb,ipb) = 0.0d0
      dsoubybh(itb,ipb) = 0.0d0
      dsoubzbh(itb,ipb) = 0.0d0
c
  100 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine resetbhboundary_dirichlet(chbhs)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
c
      dimension gamd(3,3), gamu(3,3)
c
      character*1 chbhs
c
c --- For Dirichlet boundary.
c
      irb = 0
c
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
c
c -- Dirichlet boundary 
c
      gamd(1,1) = 1.0d0
      gamd(1,2) = 0.0d0
      gamd(1,3) = 0.0d0
      gamd(2,1) = 0.0d0
      gamd(2,2) = 1.0d0
      gamd(2,3) = 0.0d0
      gamd(3,1) = 0.0d0
      gamd(3,2) = 0.0d0
      gamd(3,3) = 1.0d0
      xxcs = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - orbc
      yycs = rb(irb)*sintheb(itb)*sinphib(ipb)
      xxbh = rb(irb)*sintheb(itb)*cosphib(ipb)
      yybh = rb(irb)*sintheb(itb)*sinphib(ipb)
c
      if (chbhs.eq.'i') omebh  =   ome
      if (chbhs.eq.'i') spinbh = - omebh
      if (chbhs.eq.'I') spinbh = - omebh
c
      ophixu = - omebh*yycs - spinbh*yybh
      ophiyu =   omebh*xxcs + spinbh*xxbh
      ophizu = 0.0d0
      ophixd = gamd(1,1)*ophixu + gamd(1,2)*ophiyu + gamd(1,3)*ophizu
      ophiyd = gamd(2,1)*ophixu + gamd(2,2)*ophiyu + gamd(2,3)*ophizu
      ophizd = gamd(3,1)*ophixu + gamd(3,2)*ophiyu + gamd(3,3)*ophizu
c
c
      psib(irb,itb,ipb) = psibh
      alphb(irb,itb,ipb) = alphbh
      alpsb(irb,itb,ipb) = alphbh*psibh
      bvxdb(irb,itb,ipb) = -ophixd
      bvydb(irb,itb,ipb) = -ophiyd
      bvzdb(irb,itb,ipb) = -ophizd
c
 100   continue
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine resetbhboundary
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension gamd(3,3), gamu(3,3)
c
c --- Compute source for BH boundary terms.
c
      fac112 = 1.0d0/12.0d0
      facm13 = -1.0d0/3.0d0
c
c --  For toy model
c
ctesttest      sepa = 2.0d0*dis
ctesttest      bhmass = 2.0d0*bhrad
      do 10 ipb = 0, npb
      do 10 itb = 0, ntb
c
      st = sintheb(itb)
      cp = cosphib(ipb)
      rad1 = bhrad
      rad2 = sqrt(rad1**2 + 2.0d0*rad1*sepa*st*cp + sepa**2)
      psic  = 1.0d0 + 0.5d0*bhmass/rad1 + 0.5d0*bhmass/rad2
      alpsc = 1.0d0 - 0.5d0*bhmass/rad1 - 0.5d0*bhmass/rad2
       psib(0,itb,ipb) = psic
      alphb(0,itb,ipb) = alpsc/psic
c
 10   continue
c
      return
      stop ' kerr reset '
c
c --  For Kerr-Schild
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
      do 100 irb = nrb0, 0
c
      x1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - bhdis
      y1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z1 = rb(irb)*costheb(itb)
      x2 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis + bhdis
      y2 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z2 = rb(irb)*costheb(itb)
c
ck      call kerrschildmet(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
ck     &  gamd,gamu,hm1,hm2,elx1,ely1,elz1,elx2,ely2,elz2,gksdet,pat,pat)
c
      bxd = 2.0d0*hm1*elx1 + 2.0d0*hm2*elx2
      byd = 2.0d0*hm1*ely1 + 2.0d0*hm2*ely2
      bzd = 2.0d0*hm1*elz1 + 2.0d0*hm2*elz2
      bvbv =(gamu(1,1)*bxd*bxd + gamu(1,2)*bxd*byd + gamu(1,3)*bxd*bzd
     &     + gamu(2,1)*byd*bxd + gamu(2,2)*byd*byd + gamu(2,3)*byd*bzd
     &     + gamu(3,1)*bzd*bxd + gamu(3,2)*bzd*byd + gamu(3,3)*bzd*bzd)
     &     * gksdet**(-1.0d0/3.0d0)
      alphks = dsqrt(1.0d0 - 2.0d0*(hm1+hm2) + bvbv)
c
cccc      psib(irb,itb,ipb) = 1.0d0
cccc      psib(irb,itb,ipb) =  psib(0,itb,ipb)
       psib(irb,itb,ipb) = gksdet**fac112
      alphb(irb,itb,ipb) = alphks
      alpsb(irb,itb,ipb) = alphks*gksdet**fac112
      bvxdb(irb,itb,ipb) = bxd*gksdet**facm13
      bvydb(irb,itb,ipb) = byd*gksdet**facm13
      bvzdb(irb,itb,ipb) = bzd*gksdet**facm13
c
  100 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine asymptopia_alps(soupsou,souapou,dsoupsou,dsouapou)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension soupsou(0:nntg,0:nnpg),dsoupsou(0:nntg,0:nnpg),
     &          souapou(0:nntg,0:nnpg),dsouapou(0:nntg,0:nnpg)
c
c
c --- Compute source for GR boundary terms.
c
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
c
      dsoupsou(itg,ipg) = 0.0d0
      dsouapou(itg,ipg) = 0.0d0
      soupsou(itg,ipg) = 1.0d0
      souapou(itg,ipg) = 1.0d0
c
  100 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine asymptopia_wbvec(souwxou, souwyou, souwzou, souwsou,
     &                           dsouwxou,dsouwyou,dsouwzou,dsouwsou)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension souwxou(0:nntg,0:nnpg),dsouwxou(0:nntg,0:nnpg),
     &          souwyou(0:nntg,0:nnpg),dsouwyou(0:nntg,0:nnpg),
     &          souwzou(0:nntg,0:nnpg),dsouwzou(0:nntg,0:nnpg),
     &          souwsou(0:nntg,0:nnpg),dsouwsou(0:nntg,0:nnpg)
c
c --- Compute source for GR boundary terms.
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
c
      souwxou(itg,ipg) = 0.0d0
      souwyou(itg,ipg) = 0.0d0
      souwzou(itg,ipg) = 0.0d0
      souwsou(itg,ipg) = 0.0d0
      dsouwxou(itg,ipg) = 0.0d0
      dsouwyou(itg,ipg) = 0.0d0
      dsouwzou(itg,ipg) = 0.0d0
      dsouwsou(itg,ipg) = 0.0d0
c
  100 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine asymptopia(soupsou,souapou,soubxou,soubyou,soubzou,
     &                 dsoupsou,dsouapou,dsoubxou,dsoubyou,dsoubzou)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension soupsou(0:nntg,0:nnpg),dsoupsou(0:nntg,0:nnpg),
     &          souapou(0:nntg,0:nnpg),dsouapou(0:nntg,0:nnpg),
     &          soubxou(0:nntg,0:nnpg),dsoubxou(0:nntg,0:nnpg),
     &          soubyou(0:nntg,0:nnpg),dsoubyou(0:nntg,0:nnpg),
     &          soubzou(0:nntg,0:nnpg),dsoubzou(0:nntg,0:nnpg)
c
      dimension x5(5), f5p(5), f5a(5), f5x(5), f5y(5), f5z(5)
      dimension gamd(3,3), gamu(3,3)
c
c --- Compute source for GR boundary terms.
c
      rmassadm = 0.0d0
      rmassadk = 0.0d0
      do 1 ipg = 0, npg
      do 1 itg = 0, ntg
      rmassadm = rmassadm +  psi(nrtot,itg,ipg) - 1.0d0
      rmassadk = rmassadk + alps(nrtot,itg,ipg) - 1.0d0
    1 continue
      rmassadm = rmassadm/dble((ntg+1)*(npg+1))
      rmassadk = rmassadk/dble((ntg+1)*(npg+1))
c
      rgv = rg(nrtot)
      do 10 ii = 1, 5
      x5(ii) = rg(nrtot-5+ii)
   10 continue
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 101 ii = 1, 5
      ii0 = nrtot - 5 + ii
      f5p(ii) = psi(ii0,itg,ipg)
      f5a(ii) = alps(ii0,itg,ipg)
calph      f5a(ii) = alph(ii0,itg,ipg)
      f5x(ii) = bvxd(ii0,itg,ipg)
      f5y(ii) = bvyd(ii0,itg,ipg)
      f5z(ii) = bvzd(ii0,itg,ipg)
  101 continue
c
      dsoupsou(itg,ipg) = dfncdx(x5,f5p,rgv)
      dsouapou(itg,ipg) = dfncdx(x5,f5a,rgv)
      dsoubxou(itg,ipg) = dfncdx(x5,f5x,rgv)
      dsoubyou(itg,ipg) = dfncdx(x5,f5y,rgv)
      dsoubzou(itg,ipg) = dfncdx(x5,f5z,rgv)
c
      x1 = rg(nrtot)*sintheg(itg)*cosphig(ipg) - bhdis
      y1 = rg(nrtot)*sintheg(itg)*sinphig(ipg)
      z1 = rg(nrtot)*costheg(itg)
      x2 = rg(nrtot)*sintheg(itg)*cosphig(ipg) + bhdis
      y2 = rg(nrtot)*sintheg(itg)*sinphig(ipg)
      z2 = rg(nrtot)*costheg(itg)
c
ck      call kerrschildmet(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
ck     &  gamd,gamu,hm1,hm2,elx1,ely1,elz1,elx2,ely2,elz2,gksdet,pat,pat)
c
      xx = rg(nrtot)*sintheg(itg)*cosphig(ipg)
      yy = rg(nrtot)*sintheg(itg)*sinphig(ipg)
c
ctoybbh
      st  = sintheg(itg)
      cp  = cosphig(ipg)
      rgo = rg(nrtot)
ctesttest      bhmass = 2.0d0*bhrad
ctesttest     bhmass = bhrad
      rad1 = sqrt(rgo**2 - 2.0d0*rgo*dis*st*cp + dis**2)
      rad2 = sqrt(rgo**2 + 2.0d0*rgo*dis*st*cp + dis**2)
      psic  = 1.0d0 + 0.5d0*bhmass/rad1 + 0.5d0*bhmass/rad2
      alpsc = 1.0d0 - 0.5d0*bhmass/rad1 - 0.5d0*bhmass/rad2
      soupsou(itg,ipg) = psic
      souapou(itg,ipg) = alpsc
calph      souapou(itg,ipg) = alpsc/psic
cc      soupsou(itg,ipg) = 1.0d0
cc      souapou(itg,ipg) = 1.0d0
      soubxou(itg,ipg) = gamd(1,1)*(- ome*yy) +  gamd(1,2)*ome*xx
      soubyou(itg,ipg) = gamd(2,1)*(- ome*yy) +  gamd(2,2)*ome*xx
      soubzou(itg,ipg) = gamd(3,1)*(- ome*yy) +  gamd(3,2)*ome*xx
c
c --  omega^i = (-y Omega, x Omega, 0) at infinity.
c
ctesttest
      dsoupsou(itg,ipg) = 0.0d0
      dsouapou(itg,ipg) = 0.0d0
      dsoubxou(itg,ipg) = 0.0d0
      dsoubyou(itg,ipg) = 0.0d0
      dsoubzou(itg,ipg) = 0.0d0
      soupsou(itg,ipg) = 1.0d0
      souapou(itg,ipg) = 1.0d0
      soubxou(itg,ipg) = 0.0d0
      soubyou(itg,ipg) = 0.0d0
      soubzou(itg,ipg) = 0.0d0
ctesttest
c
  100 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine poisol(sousft,dsousft,sousfb,dsousfb,sousfg,dsousfg,
     &    sousfo,dsousfo,soub,soug,potb,potg,iesy,irsy,imini,ieq,chgf)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      common / trmpg / sinmpg(0:nnlg,0:nnpg), cosmpg(0:nnlg,0:nnpg)
      common / grleg / pnag(0:nnlg,0:nnlg,0:nntg),
     &               facnmg(0:nnlg,0:nnlg), epsig(0:nnlg)
      common / trmpb / sinmpb(0:nnlb,0:nnpb), cosmpb(0:nnlb,0:nnpb)
      common / brleg / pnab(0:nnlb,0:nnlb,0:nntb),
     &               facnmb(0:nnlb,0:nnlb), epsib(0:nnlb)
      common / brfnv / hfnb_nb(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_di(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_hd(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_dd(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_nd(0:nnrb,0:nnlb,0:nnrb)
      common / bfnsf / fnbsf_nb(0:nnlb,0:nnrb,4),
     &                 fnbsf_di(0:nnlb,0:nnrb,4),
     &                 fnbsf_hd(0:nnlb,0:nnrb,4),
     &                 fnbsf_dd(0:nnlb,0:nnrb,4),
     &                 fnbsf_nd(0:nnlb,0:nnrb,4)
c
      dimension soub(0:nnrb,0:nntb,0:nnpb),potb(0:nnrb,0:nntb,0:nnpb)
      dimension soug(0:nnrg,0:nntg,0:nnpg),potg(0:nnrg,0:nntg,0:nnpg)
      dimension sousft(0:nntb,0:nnpb), dsousft(0:nntb,0:nnpb),
     &          sousfb(0:nntb,0:nnpb), dsousfb(0:nntb,0:nnpb),
     &          sousfg(0:nntb,0:nnpb), dsousfg(0:nntb,0:nnpb)
      dimension sousfo(0:nntg,0:nnpg), dsousfo(0:nntg,0:nnpg)
      dimension potb1(0:nnrb,0:nntb,0:nnpb),potb2(0:nnrb,0:nntb,0:nnpb),
     &          pott1(0:nnrb,0:nntb,0:nnpb),pott2(0:nnrb,0:nntb,0:nnpb)
      dimension potg1(0:nnrg,0:nntg,0:nnpg),
     &          poto1(0:nnrg,0:nntg,0:nnpg),poto2(0:nnrg,0:nntg,0:nnpg)
      dimension x5(5), f5(5)
      character*2 chgf
c
c --- Poisson solver : call volume and surface integrals.
c     iesy --> 0 for equatorially symmetric source.
c              1 for equatorially anti-symmetric source.
c     irsy --> 0 symmetric in pi-rotation.
c              1 anti-symmetric in pi-rotation.
c     imini--> depend on xy and xz-plane symmetry. 
c
c     sources for volume integral are on half integer points.
c     sources for surface integral are on half integer points.
c
c --- Call integral terms of Green's formula.
c
c      write(6,22)soug(8,8,8),soub(8,8,8)
c      write(6,22)sousfb(8,8),sousfg(8,8),sousft(8,8),sousfo(8,8)
c      write(6,22)dsousfb(8,8),dsousfg(8,8),dsousft(8,8),dsousfo(8,8)
c 22   format(1p,4e18.10)
c
      call halfsou(soug,soub)
c
      if (chgf.eq.'nb') then
      call grav4bh(   soub,potb , hfnb_nb,iesy,imini)
      call grav4sf(dsousft,pott1,fnbsf_nb,iesy,1,0,imini)
      call grav4sf( sousft,pott2,fnbsf_nb,iesy,2,0,imini)
      call grav4sf(dsousfb,potb1,fnbsf_nb,iesy,3,0,imini)
      call grav4sf( sousfb,potb2,fnbsf_nb,iesy,4,0,imini)
      end if
      if (chgf.eq.'di') then
      call grav4bh(   soub,potb , hfnb_di,iesy,imini)
      call grav4sf(dsousft,pott1,fnbsf_di,iesy,1,0,imini)
      call grav4sf( sousft,pott2,fnbsf_di,iesy,2,0,imini)
      call grav4sf(dsousfb,potb1,fnbsf_di,iesy,3,0,imini)
      call grav4sf( sousfb,potb2,fnbsf_di,iesy,4,0,imini)
      end if
      if (chgf.eq.'hd') then
      call grav4bh(   soub,potb , hfnb_hd,iesy,imini)
      call grav4sf(dsousft,pott1,fnbsf_hd,iesy,1,0,imini)
      call grav4sf( sousft,pott2,fnbsf_hd,iesy,2,0,imini)
      call grav4sf(dsousfb,potb1,fnbsf_hd,iesy,3,0,imini)
      call grav4sf( sousfb,potb2,fnbsf_hd,iesy,4,0,imini)
      end if
      if (chgf.eq.'dd') then
      call grav4bh(   soub,potb , hfnb_dd,iesy,imini)
      call grav4sf(dsousft,pott1,fnbsf_dd,iesy,1,0,imini)
      call grav4sf( sousft,pott2,fnbsf_dd,iesy,2,0,imini)
      call grav4sf(dsousfb,potb1,fnbsf_dd,iesy,3,0,imini)
      call grav4sf( sousfb,potb2,fnbsf_dd,iesy,4,0,imini)
      end if
      if (chgf.eq.'nd') then
      call grav4bh(   soub,potb , hfnb_nd,iesy,imini)
      call grav4sf(dsousft,pott1,fnbsf_nd,iesy,1,0,imini)
      call grav4sf( sousft,pott2,fnbsf_nd,iesy,2,0,imini)
      call grav4sf(dsousfb,potb1,fnbsf_nd,iesy,3,0,imini)
      call grav4sf( sousfb,potb2,fnbsf_nd,iesy,4,0,imini)
      end if
c
      call gravmid(   soug,potg ,iesy,    imini)
      call grav4sf2mid_right(sousfg,dsousfg,potg1,iesy,irsy)
      call grav4sfout(dsousfo,poto1,iesy,3,imini)
      call grav4sfout( sousfo,poto2,iesy,4,imini)
c
      if (ieq.eq.1) bm1 = bhmass
      if (ieq.eq.2) bm1 = -2.0d0*apmass
cbbh      bm2 = bhmass
      do 100 ipb = 0, npb
      do 100 itb = 0, ntb
      do 100 irb = 0, nrb
      if (ieq.eq.1.or.ieq.eq.2) then
cpunc      if (ieq.eq.1) then
cexci      if (ieq.eq.0) then
      rbc = rb(irb)
ctesttest      if (irb.eq.0) rbc = 1.0d-03
      st = sintheb(itb)
      cp = cosphib(ipb)
      rad1 = rbc
cbbh      rad2 = dsqrt((2.0d0*dis)**2 + rbc**2 + 4.0d0*dis*rbc*st*cp)
      potb(irb,itb,ipb) = potb(irb,itb,ipb)
cexci     &                  + pott1(irb,itb,ipb) + pott2(irb,itb,ipb)
     &                  + potb1(irb,itb,ipb) + potb2(irb,itb,ipb)
     &                  + 0.5d0*bm1/rad1
cbbh     &                  + 0.5d0*bm1/rad1 + 0.5d0*bm2/rad2
      else if (ieq.ne.1.and.ieq.ne.2) then
cpunc      else if (ieq.ne.1) then
cbbh      else if (ieq.ne.0) then
      potb(irb,itb,ipb) = potb(irb,itb,ipb)
cexci     &                  + pott1(irb,itb,ipb) + pott2(irb,itb,ipb)
     &                  + potb1(irb,itb,ipb) + potb2(irb,itb,ipb)
      end if
 100  continue
c
      do 110 ipg = 0, npg
      do 110 itg = 0, ntg
      do 110 irg = 0, nrtot
      if (ieq.eq.1.or.ieq.eq.2) then
cpunc      if (ieq.eq.1) then
cbbh      if (ieq.eq.0) then
      rgc = rg(irg)
      st = sintheg(itg)
      cp = cosphig(ipg)
      rad1 = dsqrt(dis**2 + rgc**2 - 2.0d0*dis*rgc*st*cp)
      if (dabs(rad1).le.1.0d-08) rad1 = 1.0d-08
cbbh      rad2 = dsqrt(dis**2 + rgc**2 + 2.0d0*dis*rgc*st*cp)
      potg(irg,itg,ipg) = potg(irg,itg,ipg)  + potg1(irg,itg,ipg)
     &                  + poto1(irg,itg,ipg) + poto2(irg,itg,ipg)
     &                  + 0.5d0*bm1/rad1
cbbh     &                  + 0.5d0*bm1/rad1 + 0.5d0*bm2/rad2
      else if (ieq.ne.1.and.ieq.ne.2) then
cpunc      else if (ieq.ne.1) then
cbbh      else if (ieq.ne.0) then
      potg(irg,itg,ipg) = potg(irg,itg,ipg)  + potg1(irg,itg,ipg)
     &                  + poto1(irg,itg,ipg) + poto2(irg,itg,ipg)
      end if
 110  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grav4bh(sou,pot,hfsnb,iesy,imini)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_weight_bh.f'
c
      common / trmpb / sinmpb(0:nnlb,0:nnpb), cosmpb(0:nnlb,0:nnpb)
      common / brleg / pnab(0:nnlb,0:nnlb,0:nntb),
     &               facnmb(0:nnlb,0:nnlb), epsib(0:nnlb)
c
      dimension hfsnb(0:nnrb,0:nnlb,0:nnrb)
      dimension    sou(0:nnrb,0:nntb,0:nnpb),pot(0:nnrb,0:nntb,0:nnpb)
      dimension work1c(0:nntb,0:nnrb,0:nnlb),
     &          work2c(0:nnrb,0:nnlb,0:nnlb),
     &          work3c(0:nnlb,0:nnlb,0:nnrb),
     &          work4c(0:nnlb,0:nnrb,0:nntb)
      dimension work1s(0:nntb,0:nnrb,0:nnlb),
     &          work2s(0:nnrb,0:nnlb,0:nnlb),
     &          work3s(0:nnlb,0:nnlb,0:nnrb),
     &          work4s(0:nnlb,0:nnrb,0:nntb)
c
c --- Gravitational and Velocity potential is caluculated. ---
c
c     L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(th) sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c
c     pi-rotation (anti-)symmetry.
c
c     iesy --> 0 for equatorially symmetric source.
c              1 for equatorially anti-symmetric source.
c     imini --> start of summation for index m. 
c              
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c   work1(itt,irr,im) = sum_ipp (scmp(im,ipp)*sou(irr,itt,ipp))
c   work2(irr,il,im) = sum_itt (pn(il,im,itt)*work1(itt,irr,im))
c   work3(il,im,ir) = sum_irr (hfn(irr,il,ir)*work2(irr,il,im))
c   work4(im,ir,it) = sum_il (pn(il,im,it)*work3(il,im,ir))
c   pot(ir,it,ip) = sum_im (scmp(im,ip)*work4(im,ir,it))
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c      write(6,*)' grav4  '
c
c    hfsn(irr,nn,ir) -->  for r'< r
c                         for r < r'
c
      do 1001 im = 0, nlb
      do 1001 irr = 1, nrb
      do 1001 itt = 0, ntb
      work1c(itt,irr,im) = 0.0d0
      work1s(itt,irr,im) = 0.0d0
      do 1001 ipp = 0, npb
      wok = wgrtpb(irr,itt,ipp)*sou(irr,itt,ipp)
      work1c(itt,irr,im) = work1c(itt,irr,im) + wok*cosmpb(im,ipp)
      work1s(itt,irr,im) = work1s(itt,irr,im) + wok*sinmpb(im,ipp)  
 1001 continue
c
      do 1002 il = 0, nlb
      do 1002 im = 0, nlb
      pari = 1.0d0 + (-1.0d0)**(il+im+iesy)
      pef = pari*epsib(im)*facnmb(il,im)
      do 1002 irr = 1, nrb
      work2c(irr,il,im) = 0.0d0
      work2s(irr,il,im) = 0.0d0
      do 1002 itt = 0, ntb
      wok = pef*pnab(il,im,itt)
      work2c(irr,il,im) = work2c(irr,il,im) + wok*work1c(itt,irr,im)
      work2s(irr,il,im) = work2s(irr,il,im) + wok*work1s(itt,irr,im)
 1002 continue
c
      do 1003 ir = 0, nrb
      do 1003 il = 0, nlb
ck      imini = (1 - (-1)**(il+iesy))/2
      do 1003 im = 0, nlb
      work3c(il,im,ir) = 0.0d0
      work3s(il,im,ir) = 0.0d0
      do 1003 irr = 1, nrb
      work3c(il,im,ir) = work3c(il,im,ir) + 
     &                   work2c(irr,il,im)*hfsnb(irr,il,ir)
      work3s(il,im,ir) = work3s(il,im,ir) + 
     &                   work2s(irr,il,im)*hfsnb(irr,il,ir)
 1003 continue
c
      do 1004 it = 0, ntb
      do 1004 ir = 0, nrb
      do 1004 im = 0, nlb
      work4c(im,ir,it) = 0.0d0
      work4s(im,ir,it) = 0.0d0
      do 1004 il = 0, nlb
      work4c(im,ir,it) = work4c(im,ir,it) + 
     &                   work3c(il,im,ir)*pnab(il,im,it)
      work4s(im,ir,it) = work4s(im,ir,it) + 
     &                   work3s(il,im,ir)*pnab(il,im,it)
 1004 continue
c
      do 1000 ip = 0, npb
      do 1000 it = 0, ntb
      do 1000 ir = 0, nrb
      pot(ir,it,ip) = 0.0d0
      do 1000 im = 0, nlb
      pot(ir,it,ip) = pot(ir,it,ip)
     &              + work4c(im,ir,it)*cosmpb(im,ip)
     &              + work4s(im,ir,it)*sinmpb(im,ip)
 1000 continue
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      pi4aho = pi4inv
      do 100 ip = 0, npb
      do 100 it = 0, ntb
      do 100 ir = 0, nrb
 100  pot(ir,it,ip) = - pi4aho*pot(ir,it,ip)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine gravmid(sou,pot,iesy,imini)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_intpp.f'
      include 'common_blocks/CB_weight_grav.f'
c
      common / trmpg / sinmpg(0:nnlg,0:nnpg), cosmpg(0:nnlg,0:nnpg)
      common / grfsn / hfsn(0:nnrg,0:nnlg,0:nnrg)
      common / grleg / pnag(0:nnlg,0:nnlg,0:nntg),
     &               facnmg(0:nnlg,0:nnlg), epsig(0:nnlg)
cccc     &               pnagco(0:nnlg,0:nnlg,0:nntg),
cccc     &               pnagsi(0:nnlg,0:nnlg,0:nntg)
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
      common / ifhgb / ihrgbiin(0:nntg,0:nnpg),
     &                 ihrgbiou(0:nntg,0:nnpg),
     &                 ihtgbi(0:nnrg,0:nnpg),
     &                 ihpgbiin(0:nnrg,0:nntg), 
     &                 ihpgbiou(0:nnrg,0:nntg) 
      common / gcifs / rgbifin(0:nntg,0:nnpg),
     &                 rgbifou(0:nntg,0:nnpg),
     &                  thgbif(0:nnrg,0:nnpg),
     &                 phigbifin(0:nnrg,0:nntg), 
     &                 phigbifou(0:nnrg,0:nntg) 
c
      dimension sou(0:nnrg,0:nntg,0:nnpg), pot(0:nnrg,0:nntg,0:nnpg)
      dimension souex(0:nnrg,0:nntg,0:nnpg)
      dimension work1c(0:nntg,0:nnrg,0:nnlg),
     &          work2c(0:nnrg,0:nnlg,0:nnlg),
     &          work3c(0:nnlg,0:nnlg,0:nnrg),
     &          work4c(0:nnlg,0:nnrg,0:nntg)
      dimension work1s(0:nntg,0:nnrg,0:nnlg),
     &          work2s(0:nnrg,0:nnlg,0:nnlg),
     &          work3s(0:nnlg,0:nnlg,0:nnrg),
     &          work4s(0:nnlg,0:nnrg,0:nntg)
      dimension wp2(0:nnpg)
c
c --- Gravitational and Velocity potential is caluculated. ---
c
c     L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(th) sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c
c     pi-rotation (anti-)symmetry.
c
c     iesy --> 0 for equatorially symmetric source.
c              1 for equatorially anti-symmetric source.
c     imini --> start of summation for index m. 
c              
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c   work1(itt,irr,im) = sum_ipp (scmp(im,ipp)*sou(irr,itt,ipp))
c   work2(irr,il,im) = sum_itt (pn(il,im,itt)*work1(itt,irr,im))
c   work3(il,im,ir) = sum_irr (hfn(irr,il,ir)*work2(irr,il,im))
c   work4(im,ir,it) = sum_il (pn(il,im,it)*work3(il,im,ir))
c   pot(ir,it,ip) = sum_im (scmp(im,ip)*work4(im,ir,it))
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c      write(6,*)' grav4  '
c
c    hfsn(irr,nn,ir) -->  for r'< r
c                         for r < r'
c
c --- ???????use 2nd order??????.
c
      do 9000 ipp = 0, npg
      wp2(ipp) = w4dpg(ipp)
 9000 continue
      san = 1.0d0/3.0d0
c
      do 1001 im = imini, nlg
      do 1001 irr = 1, nrtot
      do 1001 itt = 0, ntg
      work1c(itt,irr,im) = 0.0d0
      work1s(itt,irr,im) = 0.0d0
c
      ipin = ihpgbiin(irr,itt)
      ipou = ihpgbiou(irr,itt)
c
      if (ipou.eq.0) go to 1404
      do 1401 ipp = 0, ipin
      wok = wmrtpg(irr,itt,ipp)*sou(irr,itt,ipp)
      work1c(itt,irr,im) = work1c(itt,irr,im) + wok*cosmpg(im,ipp)
      work1s(itt,irr,im) = work1s(itt,irr,im) + wok*sinmpg(im,ipp)  
 1401 continue
 1404 continue
      do 1402 ipp = ipou, npg
      wok = wmrtpg(irr,itt,ipp)*sou(irr,itt,ipp)
      work1c(itt,irr,im) = work1c(itt,irr,im) + wok*cosmpg(im,ipp)
      work1s(itt,irr,im) = work1s(itt,irr,im) + wok*sinmpg(im,ipp)  
 1402 continue
c
 1001 continue
c
      do 1002 il = 0, nlg
      do 1002 im = 0, nlg
      pari = 1.0d0 + (-1.0d0)**(il+im+iesy)
      pef = pari*epsig(im)*facnmg(il,im)
      do 1002 irr = 1, nrtot
      work2c(irr,il,im) = 0.0d0
      work2s(irr,il,im) = 0.0d0
      do 1002 itt = 0, ntg
      wok = pef*pnag(il,im,itt)
      work2c(irr,il,im) = work2c(irr,il,im) + wok*work1c(itt,irr,im)
      work2s(irr,il,im) = work2s(irr,il,im) + wok*work1s(itt,irr,im)
 1002 continue
c
      do 1003 ir = 0, nrtot
      do 1003 il = 0, nlg
      do 1003 im = 0, nlg
      work3c(il,im,ir) = 0.0d0
      work3s(il,im,ir) = 0.0d0
      do 1003 irr = 1, nrtot
      work3c(il,im,ir) = work3c(il,im,ir) + 
     &                   work2c(irr,il,im)*hfsn(irr,il,ir)
      work3s(il,im,ir) = work3s(il,im,ir) + 
     &                   work2s(irr,il,im)*hfsn(irr,il,ir)
 1003 continue
c
      do 1004 it = 0, ntg
      do 1004 ir = 0, nrtot
      do 1004 im = 0, nlg
      work4c(im,ir,it) = 0.0d0
      work4s(im,ir,it) = 0.0d0
      do 1004 il = 0, nlg
      work4c(im,ir,it) = work4c(im,ir,it) + 
     &                   work3c(il,im,ir)*pnag(il,im,it)
      work4s(im,ir,it) = work4s(im,ir,it) + 
     &                   work3s(il,im,ir)*pnag(il,im,it)
 1004 continue
c
      do 1000 ip = 0, npg
      do 1000 it = 0, ntg
      do 1000 ir = 0, nrtot
      pot(ir,it,ip) = 0.0d0
      do 1000 im = 0, nlg
      pot(ir,it,ip) = pot(ir,it,ip)
     &              + work4c(im,ir,it)*cosmpg(im,ip)
     &              + work4s(im,ir,it)*sinmpg(im,ip)
 1000 continue
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      pi4aho = pi4inv
      do 100 ip = 0, npg
      do 100 it = 0, ntg
      do 100 ir = 0, nrtot
 100  pot(ir,it,ip) = - pi4aho*pot(ir,it,ip)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grav4sfout(sousf,pot,iesy,iaho,imini)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_weight_grav.f'
      common / trmpg / sinmpg(0:nnlg,0:nnpg), cosmpg(0:nnlg,0:nnpg)
      common / grleg / pnag(0:nnlg,0:nnlg,0:nntg),
     &               facnmg(0:nnlg,0:nnlg), epsig(0:nnlg)
c
      dimension  pot(0:nnrg,0:nntg,0:nnpg)
      dimension  sousf(0:nntg,0:nnpg)
      dimension work1c(0:nntg,0:nnlg), 
     &          work2c(0:nnlg,0:nnlg), 
     &          work3(0:nnlg,0:nnrg),
     &          work4c(0:nnlg,0:nnrg,0:nntg)
      dimension work1s(0:nntg,0:nnlg), 
     &          work2s(0:nnlg,0:nnlg), 
     &          work4s(0:nnlg,0:nnrg,0:nntg)
c
c --- Gravitational and Velocity potential is caluculated. ---
c
c     pi-rotation (anti-)symmetry.
c
c     iesy --> 0 for equatorially symmetric source.
c              1 for equatorially anti-symmetric source.
c     iaho --> 3 for d phi/dr condition (outward normal). 
c              4 for phi(r) condition (outward normal).
c     imini --> start of summation for index m. 
c              
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c   work1(itt,im) = sum_ipp (scmp(im,ipp)*sou(itt,ipp))
c   work2(il,im) = sum_itt (pn(il,im,itt)*work1(itt,im))
c   work3(il,ir) = n or rvout * (rvout/rg(ir))**il
c   work4(im,ir,it) = sum_il (pn(il,im,it)*work3(il,ir)*
c                             work2(il,im))
c   pot(ir,it,ip) = sum_im (scmp(im,ip)*work4(im,ir,it))
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
      do 1001 im = 0, nlg
      do 1001 itt = 0, ntg
      work1c(itt,im) = 0.0d0
      work1s(itt,im) = 0.0d0
      do 1001 ipp = 0, npg
      wok = w4dtg(itt)*w4dpg(ipp)*sousf(itt,ipp)
      work1c(itt,im) = work1c(itt,im) + wok*cosmpg(im,ipp)
      work1s(itt,im) = work1s(itt,im) + wok*sinmpg(im,ipp)
 1001 continue
c
      do 1002 il = 0, nlg
      do 1002 im = 0, nlg
      pari = 1.0d0 + (-1.0d0)**(il+im+iesy)
      pef  = pari*epsig(im)*facnmg(il,im)
      work2c(il,im) = 0.0d0
      work2s(il,im) = 0.0d0
      do 1002 itt = 0, ntg
      wok = pef*pnag(il,im,itt)
      work2c(il,im) = work2c(il,im) + wok*work1c(itt,im)
      work2s(il,im) = work2s(il,im) + wok*work1s(itt,im)
 1002 continue
c
      rvoutinv = 1.0d0/rvout
      do 1003 ir = 0, nrtot
      il = 0
      if (iaho.eq.3) enn = rvout
      if (iaho.eq.4) enn = - dble(il+1)
      work3(il,ir) = enn
      do 1003 il = 1, nlg
      if (iaho.eq.3) enn = rvout*(rg(ir)*rvoutinv)**il
      if (iaho.eq.4) enn = - dble(il+1)*(rg(ir)*rvoutinv)**il
      work3(il,ir) = enn
 1003 continue
c
      do 1004 it = 0, ntg
      do 1004 ir = 0, nrtot
      do 1004 im = 0, nlg
      work4c(im,ir,it) = 0.0d0
      work4s(im,ir,it) = 0.0d0
      do 1004 il = 0, nlg
      wok = work3(il,ir)*pnag(il,im,it)
      work4c(im,ir,it) = work4c(im,ir,it) + wok*work2c(il,im)
      work4s(im,ir,it) = work4s(im,ir,it) + wok*work2s(il,im)
 1004 continue
c
      do 1000 ip = 0, npg
      do 1000 it = 0, ntg
      do 1000 ir = 0, nrtot
      pot(ir,it,ip) = 0.0d0
      do 1000 im = imini, nlg, msymg
      pot(ir,it,ip) = pot(ir,it,ip)
     &              + work4c(im,ir,it)*cosmpg(im,ip)
     &              + work4s(im,ir,it)*sinmpg(im,ip)
 1000 continue
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      if (iaho.eq.1.or.iaho.eq.3) pi4aho = pi4inv
      if (iaho.eq.2.or.iaho.eq.4) pi4aho = - pi4inv
c
      do 100 ip = 0, npg
      do 100 it = 0, ntg
      do 100 ir = 0, nrtot
 100  pot(ir,it,ip) = pi4aho*pot(ir,it,ip)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grav4sf(sousf,pot,fnbsf,iesy,iaho,ilini,imini)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_weight_bh.f'
c
      common / trmpb / sinmpb(0:nnlb,0:nnpb), cosmpb(0:nnlb,0:nnpb)
      common / brleg / pnab(0:nnlb,0:nnlb,0:nntb),
     &               facnmb(0:nnlb,0:nnlb), epsib(0:nnlb)
c
      dimension  pot(0:nnrb,0:nntb,0:nnpb)
      dimension  sousf(0:nntb,0:nnpb)
      dimension work1c(0:nntb,0:nnlb), 
     &          work2c(0:nnlb,0:nnlb), 
     &          work3(0:nnlb,0:nnrb),
     &          work4c(0:nnlb,0:nnrb,0:nntb)
      dimension work1s(0:nntb,0:nnlb), 
     &          work2s(0:nnlb,0:nnlb), 
     &          work4s(0:nnlb,0:nnrb,0:nntb)
      dimension fnbsf(0:nnlb,0:nnrb,4)
c
c --- Gravitational and Velocity potential is caluculated. ---
c
c     L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(th) sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c
c     pi-rotation (anti-)symmetry.
c
c     iesy --> 0 for equatorially symmetric source.
c              1 for equatorially anti-symmetric source.
c     iaho --> 1 for d phi/dr condition at BH (inward normal). 
c              2 for phi(r) condition at BH (inward normal).
c              3 for d phi/dr at interface (outward normal). 
c              4 for phi(r) at interface (outward normal).
c     ilini --> start of summation for index l. 
c     imini --> start of summation for index m. 
c              
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c   work1(itt,im) = sum_ipp (scmp(im,ipp)*sou(itt,ipp))
c   work2(il,im) = sum_itt (pn(il,im,itt)*work1(itt,im))
c   work3(il,ir) = n or bhrad * (bhrad/rb(ir))**il
c   work4(im,ir,it) = sum_il (pn(il,im,it)*work3(il,ir)*
c                             work2(il,im))
c   pot(ir,it,ip) = sum_im (scmp(im,ip)*work4(im,ir,it))
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c      write(6,*)' grav4sf  '
c
      do 1001 im = 0, nlb
      do 1001 itt = 0, ntb
      work1c(itt,im) = 0.0d0
      work1s(itt,im) = 0.0d0
      do 1001 ipp = 0, npb
      wok = w4dtb(itt)*w4dpb(ipp)*sousf(itt,ipp)
      work1c(itt,im) = work1c(itt,im) + wok*cosmpb(im,ipp)
      work1s(itt,im) = work1s(itt,im) + wok*sinmpb(im,ipp)
 1001 continue
c
      do 1002 il = 0, nlb
      do 1002 im = 0, nlb
      pari = 1.0d0 + (-1.0d0)**(il+im+iesy)
      pef  = pari*epsib(im)*facnmb(il,im)
      work2c(il,im) = 0.0d0
      work2s(il,im) = 0.0d0
      do 1002 itt = 0, ntb
      wok = pef*pnab(il,im,itt)
      work2c(il,im) = work2c(il,im) + wok*work1c(itt,im)
      work2s(il,im) = work2s(il,im) + wok*work1s(itt,im)
 1002 continue
c
      do 1003 ir = 0, nrb
      do 1003 il = 0, nlb
      work3(il,ir) = fnbsf(il,ir,iaho)
 1003 continue
c
      do 1004 it = 0, ntb
      do 1004 ir = 0, nrb
      do 1004 im = 0, nlb
      work4c(im,ir,it) = 0.0d0
      work4s(im,ir,it) = 0.0d0
      do 1004 il = 0, nlb
      wok = work3(il,ir)*pnab(il,im,it)
      work4c(im,ir,it) = work4c(im,ir,it) + wok*work2c(il,im)
      work4s(im,ir,it) = work4s(im,ir,it) + wok*work2s(il,im)
 1004 continue
c
      do 1000 ip = 0, npb
      do 1000 it = 0, ntb
      do 1000 ir = 0, nrb
      pot(ir,it,ip) = 0.0d0
      do 1000 im = 0, nlb
      pot(ir,it,ip) = pot(ir,it,ip)
     &              + work4c(im,ir,it)*cosmpb(im,ip)
     &              + work4s(im,ir,it)*sinmpb(im,ip)
 1000 continue
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      if (iaho.eq.1.or.iaho.eq.3) pi4aho = pi4inv
      if (iaho.eq.2.or.iaho.eq.4) pi4aho = - pi4inv
c
      do 100 ip = 0, npb
      do 100 it = 0, ntb
      do 100 ir = 0, nrb
 100  pot(ir,it,ip) = pi4aho*pot(ir,it,ip)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grav4sf2mid_right(sousf1,dsousf1,pot,iesy,irsy)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_weight_bh.f'
c
      common / trmpb / sinmpb(0:nnlb,0:nnpb), cosmpb(0:nnlb,0:nnpb)
      common / brleg / pnab(0:nnlb,0:nnlb,0:nntb),
     &               facnmb(0:nnlb,0:nnlb), epsib(0:nnlb)
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
      common / gcfbc / rgb1(0:nnrg,0:nntg,0:nnpg),
     &                thgb1(0:nnrg,0:nntg,0:nnpg),
     &               phigb1(0:nnrg,0:nntg,0:nnpg),
     &                 rgb2(0:nnrg,0:nntg,0:nnpg),
     &                thgb2(0:nnrg,0:nntg,0:nnpg),
     &               phigb2(0:nnrg,0:nntg,0:nnpg)
c
      dimension pot(0:nnrg,0:nntg,0:nnpg)
      dimension sousf1(0:nntb,0:nnpb), 
     &          dsousf1(0:nntb,0:nnpb)
      dimension cosmp1(0:nnlb)
      dimension sinmp1(0:nnlb)
      dimension pna1(0:nnlb,0:nnlb), 
     &          fac(0:nnlb)
      dimension work11c(0:nntb,0:nnlb), 
     &          work21c(0:nnlb,0:nnlb), 
     &          work31(0:nnlb), 
     &          gwork11c(0:nntb,0:nnlb), 
     &          gwork21c(0:nnlb,0:nnlb), 
     &          gwork31(0:nnlb)
      dimension work11s(0:nntb,0:nnlb), 
     &          work21s(0:nnlb,0:nnlb), 
     &          gwork11s(0:nntb,0:nnlb), 
     &          gwork21s(0:nnlb,0:nnlb)
c
c --- Gravitational and Velocity potential is caluculated. ---
c
c     L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c     sin(th) sin(phi) L[p] = S --> p = 1/4pi Int[ S/r dV]
c
c     pi-rotation (anti-)symmetry.
c
c     iesy --> 0 for equatorially symmetric source.
c              1 for equatorially anti-symmetric source.
c     irsy --> 0 symmetric in pi-rotation.
c              1 anti-symmetric in pi-rotation.
c              
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c   work1(itt,im) = sum_ipp (scmp(im,ipp)*sou(itt,ipp))
c   work2(il,im) = sum_itt (pn(il,im,itt)*work1(itt,im))
c   work3(il,ir) = n or bhrad * (bhrad/rb(ir))**il
c   work4(im,ir,it) = sum_il (pn(il,im,it)*work3(il,ir)*
c                             work2(il,im))
c   pot(ir,it,ip) = sum_im (scmp(im,ip)*work4(im,ir,it))
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c      write(6,*)' grav4sf  '
c
      fac(0) = 1.0d0
      do 121 mm = 1, nlb
      fmm = dble(mm)
      fac(mm) = (2.0d0*fmm-1.0d0) * fac(mm-1)
  121 continue
c
      do 1001 im = 0, nlb
      do 1001 itt = 0, ntb
      work11c(itt,im) = 0.0d0
      gwork11c(itt,im) = 0.0d0
      work11s(itt,im) = 0.0d0
      gwork11s(itt,im) = 0.0d0
c
      do 1001 ipp = 0, npb
      wokc = w4dtb(itt)*w4dpb(ipp)*cosmpb(im,ipp)
      woks = w4dtb(itt)*w4dpb(ipp)*sinmpb(im,ipp)
      work11c(itt,im) = work11c(itt,im) + wokc*dsousf1(itt,ipp)
      gwork11c(itt,im) = gwork11c(itt,im) + wokc*sousf1(itt,ipp)
      work11s(itt,im) = work11s(itt,im) + woks*dsousf1(itt,ipp)
      gwork11s(itt,im) = gwork11s(itt,im) + woks*sousf1(itt,ipp)
 1001 continue
c
      do 1002 il = 0, nlb
      do 1002 im = 0, nlb
      pari = 1.0d0 + (-1.0d0)**(il+im+iesy)
      pef  = pari*epsib(im)*facnmb(il,im)
      work21c(il,im) = 0.0d0
      gwork21c(il,im) = 0.0d0
      work21s(il,im) = 0.0d0
      gwork21s(il,im) = 0.0d0
      do 1002 itt = 0, ntb
      wok = pef*pnab(il,im,itt)
      work21c(il,im) = work21c(il,im) + wok*work11c(itt,im)
      gwork21c(il,im) = gwork21c(il,im) + wok*gwork11c(itt,im)
      work21s(il,im) = work21s(il,im) + wok*work11s(itt,im)
      gwork21s(il,im) = gwork21s(il,im) + wok*gwork11s(itt,im)
 1002 continue
c
c
      pi = 3.14159265358979d+0
      pi4inv = 1.0d0/4.0d0/pi
      pi4aho = pi4inv
      pi4ahom = - pi4inv
c
      do 1000 ipg = 0, npg
      do 1000 itg = 0, ntg
      do 1000 irg = 0, nrtot
      pot(irg,itg,ipg) = 0.0d0
      if (irg.gt.irgbiin(itg,ipg).and.
     &    irg.lt.irgbiou(itg,ipg)) go to 1000
c
c
      do 120 nn = 0, nlb
      do 120 mm = 0, nlb
      pna1(nn,mm)  = 0.0d0
  120 continue
c
      cc1 = dcos(thgb1(irg,itg,ipg))
      ss1 = dsin(thgb1(irg,itg,ipg))
c
      pna1(0,0) = 1.d0
      do 122 mm = 1, nlb
        pna1(mm,mm) = fac(mm) * (-ss1)**mm 
  122 continue
c
      do 123 mm = 0, nlb-1
      fmm = dble(mm)
      pna1(mm+1,mm) = (2.d0*fmm + 1.d0)*cc1*pna1(mm,mm)
  123 continue
c
      do 124 mm = 0, nlb-2
      fmm = dble(mm)
      do 124 kk = 2, nlb-mm
      fkk = dble(kk)
      q1 = ( 2.0d0 * fmm + 2.0d0 * fkk - 1.0d0 ) / fkk
      q2 = ( 2.0d0 * fmm + fkk - 1.0d0 ) / fkk
      pna1(mm+kk,mm) = q1 * cc1 * pna1(mm+kk-1,mm)
     &               - q2       * pna1(mm+kk-2,mm)
  124 continue
c
      do 125 im = 0, nlb
      cosmp1(im) = dcos(dble(im)*phigb1(irg,itg,ipg))
  125 continue
      do 126 im = 0, nlb
      sinmp1(im) = dsin(dble(im)*phigb1(irg,itg,ipg))
  126 continue
c
c
      rra1 = radint/rgb1(irg,itg,ipg)
      rra1l = 1.0d0
      do 127 il = 0, nlb
      rra1l = rra1l*rra1
      work31(il) = - radint*rra1l
      gwork31(il) = - dble(il)*rra1l
  127 continue
c
      work41c = 0.0d0
      gwork41c = 0.0d0
      work41s = 0.0d0
      gwork41s = 0.0d0
      do 1005 im = 0, nlb
      w1c = 0.0d0
      gw1c = 0.0d0
      w1s = 0.0d0
      gw1s = 0.0d0
      do 1004 il = 0, nlb
      wok1 = work31(il)*pna1(il,im)
      gwok1 = gwork31(il)*pna1(il,im)
      w1c = w1c + wok1*work21c(il,im)
      gw1c = gw1c + gwok1*gwork21c(il,im)
      w1s = w1s + wok1*work21s(il,im)
      gw1s = gw1s + gwok1*gwork21s(il,im)
 1004 continue
      work41c = work41c + w1c*cosmp1(im)
      gwork41c = gwork41c + gw1c*cosmp1(im)
      work41s = work41s + w1s*sinmp1(im)
      gwork41s = gwork41s + gw1s*sinmp1(im)
 1005 continue
c
      pot(irg,itg,ipg) = pi4aho*(work41c + work41s)
     &               + pi4ahom*(gwork41c +gwork41s)
c
 1000 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine halfsou(soug,soub)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension soug(0:nnrg,0:nntg,0:nnpg), sougb(0:nnrg,0:nntg,0:nnpg),
     &          soub(0:nnrb,0:nntb,0:nnpb), soubb(0:nnrb,0:nntb,0:nnpb)
      dimension x4(4), f4(4)
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      sougb(irg,itg,ipg) = soug(irg,itg,ipg)
  100 continue
c
      do 101 irg = 1, nrtot
      hhrr = hrg(irg)
      irg0 = min0(max0(irg-2,0),nrtot-3) - 1
      do 102 ii = 1, 4
      x4(ii) = rg(irg0+ii)
  102 continue
      do 101 ipg = 0, npg
      do 101 itg = 0, ntg
      do 104 ii = 1, 4
      f4(ii) = sougb(irg0+ii,itg,ipg)
  104 continue
      soug(irg,itg,ipg) = fn_lagint(x4,f4,hhrr)
  101 continue
c
      do 105 ipg = 0, npg
      do 105 itg = 0, ntg
      soug(0,itg,ipg) = 0.0d0
  105 continue
c
      do 110 ipb = 0, npb
      do 110 itb = 0, ntb
      do 110 irb = 0, nrb
      soubb(irb,itb,ipb) = soub(irb,itb,ipb)
  110 continue
c
      do 111 irb = 1, nrb
      hhrr = hrb(irb)
      irb0 = min0(max0(irb-2,0),nrb-3) - 1
      do 112 ii = 1, 4
      x4(ii) = rb(irb0+ii)
  112 continue
      do 111 ipb = 0, npb
      do 111 itb = 0, ntb
      do 114 ii = 1, 4
      f4(ii) = soubb(irb0+ii,itb,ipb)
  114 continue
      soub(irb,itb,ipb) = fn_lagint(x4,f4,hhrr)
  111 continue
c
      do 115 ipb = 0, npb
      do 115 itb = 0, ntb
      soub(0,itb,ipb) = 0.0d0
  115 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine interfacec(potb,potg,sousfb,sousfg,dsousfb,dsousfg)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / bcing / rbing(5,0:nntb,0:nnpb), rbex(5),
     &                 thbing(5,0:nntb,0:nnpb),
     &                 phibing(5,0:nntb,0:nnpb)
      common / ifsgb / irgbiin(0:nntg,0:nnpg), 
     &                 irgbiou(0:nntg,0:nnpg), 
     &                 itgbi(0:nnrg,0:nnpg), 
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      dimension sousfb(0:nntb,0:nnpb),  sousfg(0:nntb,0:nnpb),
     &         dsousfb(0:nntb,0:nnpb), dsousfg(0:nntb,0:nnpb)
      dimension potb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          potg(0:nnrg,0:nntg,0:nnpg)
      dimension x4(4),f4(4),xa4(4),fa4(4),xb4(4),fb4(4)
      dimension x5(5),f5(5)
c
c --- Compute a quantity and its r-derivative on the interface.
c
c     Sources for interface surface integral term.
c     sousfb  --> potential interpolated from GR coordinate, 
c                 to use for computing potential on BH coordinate.  
c     sousfg  --> potential on BH coordinate, 
c                 to use for computing potential on GR coordinate.  
c     dsousfb --> derivative of potential using GR on surface.
c                 to use for computing potential on BH coordinate.  
c     dsousfg --> derivative of potential using BH on surface.
c                 to use for computing potential on GR coordinate.  
c
c --- PROCEDURE -> For source terms to compute potentials in GR region, 
c                  take potential near the inner fictitious boundary and 
c                  compute derivative using 4th order accurate formula. 
c               -> For source terms to compute BH region, 
c                  interpolate GR coordinate value to extended 
c                  BH coordinate near the outer fictitous boundary, 
c                  then apply 4th order accurate formula. 
c
c      write(6,*) 'Interface module C'
c === For surface terms to compute GR region.
c
      pi = 3.14159265358979d+0
c
      mm = 3
      if (nrbov.lt.2) mm = 5
      do 10 ipb = 0, npb
      do 10 itb = 0, ntb
      do 11 ii = 1, 5
      x5(ii) = rb(nrbin-mm+ii)
      f5(ii) = potb(nrbin-mm+ii,itb,ipb)
   11 continue
      rx = rb(nrbin)
      dsousfg(itb,ipb) = dfncdx(x5,f5,rx)
      sousfg(itb,ipb) = potb(nrbin,itb,ipb) 
   10 continue
c
c === For surface terms to compute BH region.
c --- Procedure 1. BH to GR
c
      intnum = 8
ccc      intnum = 12
c
c --  x-axis     
c
      small = 1.0d-10
      do 40 ii = 1, intnum
      irg = irgbiin(ntg,npgxz) + ii
      rginb = dis - rg(irg)
      do 41 irb = nrb, 1, -1
      if (rginb.le.rb(irb)+small.and.rginb.gt.rb(irb-1)+small) then
      irmin = min0(irb-2,nrb-3) - 1
      go to 42
      end if
   41 continue
   42 continue
      do 43 ii0 = 1, 4
      x4(ii0) = rb(irmin+ii0)
      f4(ii0) = potb(irmin+ii0,ntb,npbxzm)
   43 continue
      potg(irg,ntg,npgxz) = fn_lagint(x4,f4,rginb)
   40 continue
c
      do 44 ii = 1, intnum
      irg = irgbiou(ntg,npgxz) - ii
      rginb = rg(irg) - dis
      do 45 irb = nrb, 1, -1
      if (rginb.lt.rb(irb).and.rginb.ge.rb(irb-1)) then
      irmin = min0(irb-2,nrb-3) - 1
      go to 46
      end if
   45 continue
   46 continue
      do 47 ii0 = 1, 4
      x4(ii0) = rb(irmin+ii0)
      f4(ii0) = potb(irmin+ii0,ntb,0)
   47 continue
      potg(irg,ntg,npgxz) = fn_lagint(x4,f4,rginb)
   44 continue
c
c --  xz-plane
c
      ipg = npgxz
      do 50 irg = irgbiin(ntg,npgxz) + 1, irgbiou(ntg,npgxz) - 1 
      if (itgbi(irg,npgxz).eq.0.or.itgbi(irg,npgxz)+1.ge.ntg) go to 50
      do 51 itg = itgbi(irg,npgxz) + 1, ntg - 1
      if (itg.gt.itgbi(irg,npgxz)+intnum.and.
     &    irg.gt.irgbiin(itg,npgxz)+intnum.and.
     &    irg.lt.irgbiou(itg,npgxz)-intnum) go to 51
c
      x0 = rg(irg)*sintheg(itg) - dis
      y0 = 0.0d0 
      z0 = rg(irg)*costheg(itg)
      rginb = dsqrt(x0**2 + z0**2)
      thginb = datan2(dabs(x0),z0)
      phiginb = datan2(y0,x0)
ccc      phiginb = dmod(2.0d0*pi+datan2(y0,x0),2.0d0*pi)
c
checkcheck###
      ipb = idnint(phiginb/phib(npbxzm))*npbxzm
c
      do 52 irb = nrb, 1, -1
      if (rginb.lt.rb(irb).and.rginb.ge.rb(irb-1)) then
      irmin = min0(irb-2,nrb-3) - 1
      go to 53
      end if
   52 continue
   53 continue
      do 54 itb = 0, ntb - 1
      if (thginb.ge.thb(itb).and.thginb.lt.thb(itb+1)) then
      itmin = max0(min0(itb-1,ntb-3),0) - 1
      go to 55
      end if
   54 continue
   55 continue
c
      do 56 ii0 = 1, 4
      do 57 ii1 = 1, 4
      xa4(ii1) = thb(itmin+ii1)
      fa4(ii1) = potb(irmin+ii0,itmin+ii1,ipb)
ck      if (irg.eq.119)write(6,*) irmin+ii0,itmin+ii1,ipb,
ck     & potb(irmin+ii0,itmin+ii1,ipb)
   57 continue
      x4(ii0) = rb(irmin+ii0)
      f4(ii0) = fn_lagint(xa4,fa4,thginb)
   56 continue
      potg(irg,itg,npgxz) = fn_lagint(x4,f4,rginb)
ck      if (irg.eq.119)write(6,*) 'test'potg(irg,itg,npgxz)
c
   51 continue
   50 continue
c
c --  xy-plane
c
      itg = ntg
      do 60 irg = irgbiin(ntg,npgxz) + 1, irgbiou(ntg,npgxz) - 1 
      if (ipgbiou(irg,ntg).le.1) go to 60
      do 61 ipg = ipgbiin(irg,ntg) + 1, ipgbiou(irg,ntg) - 1
      if (ipg.eq.npgxz) go to 61
      if (ipg.gt.ipgbiin(irg,ntg)+intnum.and.
     &    ipg.lt.ipgbiou(irg,ntg)-intnum.and.
     &    irg.gt.irgbiin(ntg,ipg)+intnum.and.
     &    irg.lt.irgbiou(ntg,ipg)-intnum) go to 61
c
      x0 = rg(irg)*cosphig(ipg) - dis
      y0 = rg(irg)*sinphig(ipg)
      rginb = dsqrt(x0**2 + y0**2)
      phiginb = dmod(2.0d0*pi+datan2(y0,x0),2.0d0*pi)
c
      do 62 irb = nrb, 1, -1
      if (rginb.lt.rb(irb).and.rginb.ge.rb(irb-1)) then
      irmin = min0(irb-2,nrb-3) - 1
      go to 63
      end if
   62 continue
   63 continue
      do 64 ipb = 0, npb - 1
      if (phiginb.ge.phib(ipb).and.phiginb.lt.phib(ipb+1)) then
      ipmin = max0(min0(ipb-1,npb-3),0) - 1
      go to 65
      end if
   64 continue
   65 continue
c
      do 66 ii0 = 1, 4
      do 67 ii1 = 1, 4
      xa4(ii1) = phib(ipmin+ii1)
      fa4(ii1) = potb(irmin+ii0,ntb,ipmin+ii1)
   67 continue
      x4(ii0) = rb(irmin+ii0)
      f4(ii0) = fn_lagint(xa4,fa4,phiginb)
   66 continue
      potg(irg,ntg,ipg) = fn_lagint(x4,f4,rginb)
c
   61 continue
   60 continue
c
cccc       write(6,*)'a',potg(119,ntg-1,npgxz)
c --  xyz-volume
c
      do 70 irg = irgbiin(ntg,npgxz) + 1, irgbiou(ntg,npgxz) - 1 
      do 70 ipg = npgmin + 1, npgmax - 1
      do 70 itg = itgbi(irg,ipg) + 1, ntg - 1
      if (ipg.eq.npgxz) go to 70
      if (itg.gt.itgbi(irg,ipg)+intnum.and.
     &    ipg.gt.ipgbiin(irg,itg)+intnum.and.
     &    ipg.lt.ipgbiou(irg,itg)-intnum.and.
     &    irg.gt.irgbiin(itg,ipg)+intnum.and.
     &    irg.lt.irgbiou(itg,ipg)-intnum) go to 70
      if (itg.le.itgbi(irg,ipg).or.
     &    ipg.le.ipgbiin(irg,itg).or.
     &    ipg.ge.ipgbiou(irg,itg).or.
     &    irg.le.irgbiin(itg,ipg).or.
     &    irg.ge.irgbiou(itg,ipg)) go to 70
c
      x0 = rg(irg)*sintheg(itg)*cosphig(ipg) - dis
      y0 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z0 = rg(irg)*costheg(itg) 
      rginb = dsqrt(x0**2 + y0**2 + z0**2) 
caho      thginb = datan2(sqrt(x0**2 + y0**2),z0) 
      thginb = datan2(dsqrt(x0**2 + y0**2),z0) 
ccc      phiginb = dmod(2.0d0*pi+datan2(y0,x0),2.0d0*pi-small)
      phiginb = dmod(2.0d0*pi+datan2(y0,x0),6.2831853071795d0)
c
      do 71 irb = nrb, 1, -1
      if (rginb.lt.rb(irb).and.rginb.ge.rb(irb-1)) then
      irmin = min0(irb-2,nrb-3) - 1
      go to 72
      end if
   71 continue
   72 continue
      do 73 itb = 0, ntb - 1
      if (thginb.ge.thb(itb).and.thginb.lt.thb(itb+1)) then
      itmin = max0(min0(itb-1,ntb-3),0) - 1
      go to 74
      end if
   73 continue
   74 continue
      do 75 ipb = 0, npb - 1
      if (phiginb.ge.phib(ipb).and.phiginb.lt.phib(ipb+1)) then
ccc      ipmin = max0(min0(ipb-1,npb-3),0) - 1
      ipmin = ipb
      go to 76
      end if
   75 continue
   76 continue
c
      do 79 ii0 = 1, 4
      do 78 ii1 = 1, 4
      do 77 ii2 = 1, 4
ccc      xb4(ii2) = phib(ipmin+ii2)
ccc      fb4(ii2) = potb(irmin+ii0,itmin+ii1,ipmin+ii2)
      xb4(ii2) = phib(ipmin) + dphib*dble(ii2 - 2)
      ippp = mod(ipmin+ii2-2+npb,npb)
      fb4(ii2) = potb(irmin+ii0,itmin+ii1,ippp)
   77 continue
      xa4(ii1) = thb(itmin+ii1)
      fa4(ii1) = fn_lagint(xb4,fb4,phiginb)
   78 continue
      x4(ii0) = rb(irmin+ii0)
      f4(ii0) = fn_lagint(xa4,fa4,thginb)
   79 continue
      potg(irg,itg,ipg) = fn_lagint(x4,f4,rginb)
c
   70 continue
c
cccc       write(6,*)'b',potg(119,ntg-1,npgxz)
c --- GR to extended BH region and prepare source term.   
c
      rrbb = radext
      do 20 ii = 1, 5
      x5(ii) = rbex(ii)
   20 continue
c
c --  x-axis
c
      itg = ntg
      do 80 ipb = 0, npbxzm, npbxzm
      do 81 ii = 1, 5
      rbing0 = rbing(ii,ntb,ipb)
      do 82 irg = 0, nrtot - 1
      if (rbing0.ge.rg(irg).and.rbing0.lt.rg(irg+1)) then
      irmin = max0(min0(irg-1,nrtot-3),0) - 1
      go to 83
      end if
   82 continue
   83 continue
      do 84 ii0 = 1, 4
      x4(ii0) = rg(irmin+ii0)
      f4(ii0) = potg(irmin+ii0,ntg,npgxz)
   84 continue
      f5(ii) = fn_lagint(x4,f4,rbing0)
   81 continue
ccc      sousfb(ntb,ipb)  = f5(3)
      sousfb(ntb,ipb)  = fn_lagint5(x5,f5,rrbb)
      dsousfb(ntb,ipb) = dfncdx(x5,f5,rrbb)
   80 continue
c
      sousfb(ntb,npb)  = sousfb(ntb,0)
      dsousfb(ntb,npb) = dsousfb(ntb,0)
c
c --  xz-plane
c
      itg = ntg
      do 90 ipb = 0, npbxzm, npbxzm 
      do 90 itb = ipb/npbxzm, ntb - 1
c
      do 91 ii = 1, 5
      rbing0 = rbing(ii,itb,ipb)
      thbing0 = thbing(ii,itb,ipb)
c
      do 92 irg = 0, nrtot - 1
      if (rbing0.ge.rg(irg).and.rbing0.lt.rg(irg+1)) then
      irmin = max0(min0(irg-1,nrtot-3),0) - 1
      go to 93
      end if
   92 continue
   93 continue
      do 94 itg = 0, ntg - 1
      if (thbing0.ge.thg(itg).and.thbing0.lt.thg(itg+1)) then
      itmin = max0(min0(itg-1,ntg-3),0) - 1
      go to 95
      end if
   94 continue
   95 continue
      do 96 ii1 = 1, 4
      do 97 ii0 = 1, 4
      xa4(ii0) = rg(irmin+ii0)
      fa4(ii0) = potg(irmin+ii0,itmin+ii1,npgxz)
ctesttest
ck      write(6,*)irmin+ii0,itmin+ii1,fa4(ii0)
ck      if (ipb.eq.npb.and.itb.eq.ntb-2)  
ck     &   write(6,*)irmin+ii0,itmin+ii1,xa4(ii0),fa4(ii0)
   97 continue
      x4(ii1) = thg(itmin+ii1)
      f4(ii1) = fn_lagint(xa4,fa4,rbing0)
   96 continue
      f5(ii) = fn_lagint(x4,f4,thbing0)
ctesttest
ck      if (ipb.eq.npb.and.itb.eq.ntb-2)  write(6,*)x5(ii),f5(ii)
   91 continue
ctesttest
ck       stop
ck 2    format(3i5,1p2e17.9)
c      if (ipb.eq.npb.and.itb.eq.ntb-2) stop
c
ccc      sousfb(itb,ipb)  = f5(3)
      sousfb(itb,ipb)  = fn_lagint5(x5,f5,rrbb)
      dsousfb(itb,ipb) = dfncdx(x5,f5,rrbb)
c
   90 continue
c
ck      write(6,*)sousfb(ntb-2,npb)
ck      pause
      do 98 ipb = 1, npb
      sousfb(0,ipb)  = sousfb(0,0)
      dsousfb(0,ipb) = dsousfb(0,0)
   98 continue
      do 99 itb = 0, ntb
      sousfb(itb,npb)  = sousfb(itb,0)
      dsousfb(itb,npb) = dsousfb(itb,0)
   99 continue
c
c --  xy-plane
c
      itg = ntg
      itb = ntb
      do 100 ipb = 1, npb - 1
      if (ipb.eq.npbxzm) go to 100
c
      do 101 ii = 1, 5
      rbing0 = rbing(ii,itb,ipb)
      phibing0 = phibing(ii,itb,ipb)
      do 102 irg = 0, nrtot - 1
      if (rbing0.ge.rg(irg).and.rbing0.lt.rg(irg+1)) then
      irmin = max0(min0(irg-1,nrtot-3),0) - 1
      go to 103
      end if
  102 continue
  103 continue
      do 104 ipg = 0, npg - 1
      if (phibing0.ge.phig(ipg).and.phibing0.lt.phig(ipg+1)) then
      ipmin = max0(min0(ipg-1,npg-3),0) - 1
      go to 105
      end if
  104 continue
  105 continue
      do 106 ii1 = 1, 4
      do 107 ii0 = 1, 4
      xa4(ii0) = rg(irmin+ii0)
      fa4(ii0) = potg(irmin+ii0,ntg,ipmin+ii1)
  107 continue
      x4(ii1) = phig(ipmin+ii1)
      f4(ii1) = fn_lagint(xa4,fa4,rbing0)
  106 continue
      f5(ii) = fn_lagint(x4,f4,phibing0)
  101 continue
c
ccc      sousfb(itb,ipb)  = f5(3)
      sousfb(itb,ipb)  = fn_lagint5(x5,f5,rrbb)
      dsousfb(itb,ipb) = dfncdx(x5,f5,rrbb)
c
  100 continue
c
c --  xyz-volume
c
      do 110 ipb = 1, npb - 1
      if (ipb.eq.npbxzm) go to 110
      do 109 itb = 1, ntb - 1
c
      do 111 ii = 1, 5
      rbing0 = rbing(ii,itb,ipb)
      thbing0 = thbing(ii,itb,ipb)
      phibing0 = phibing(ii,itb,ipb)
      do 112 irg = 0, nrtot - 1
      if (rbing0.ge.rg(irg).and.rbing0.lt.rg(irg+1)) then
      irmin = max0(min0(irg-1,nrtot-3),0) - 1
      go to 113
      end if
  112 continue
  113 continue
      do 114 itg = 0, ntg - 1
      if (thbing0.ge.thg(itg).and.thbing0.lt.thg(itg+1)) then
      itmin = max0(min0(itg-1,ntg-3),0) - 1
      go to 115
      end if
  114 continue
  115 continue
      do 116 ipg = 0, npg - 1
      if (phibing0.ge.phig(ipg).and.phibing0.lt.phig(ipg+1)) then
      ipmin = max0(min0(ipg-1,npg-3),0) - 1
      go to 117
      end if
  116 continue
  117 continue

      do 120 ii2 = 1, 4
      do 119 ii1 = 1, 4
      do 118 ii0 = 1, 4
      xb4(ii0) = rg(irmin+ii0)
      fb4(ii0) = potg(irmin+ii0,itmin+ii1,ipmin+ii2)
  118 continue
      xa4(ii1) = thg(itmin+ii1)
      fa4(ii1) = fn_lagint(xb4,fb4,rbing0)
  119 continue
      x4(ii2) = phig(ipmin+ii2)
      f4(ii2) = fn_lagint(xa4,fa4,thbing0)
  120 continue
      f5(ii) = fn_lagint(x4,f4,phibing0)
  111 continue
c
ccc      sousfb(itb,ipb)  = f5(3)
      sousfb(itb,ipb)  = fn_lagint5(x5,f5,rrbb)
      dsousfb(itb,ipb) = dfncdx(x5,f5,rrbb)
c
c      if (itb.eq.ntb-1.and.ipb.eq.npb-1.or. 
c     &    itb.eq.ntb-1.and.ipb.eq.1) then 
c      do irr = 0, nrb
c      write(6,*) rb(irr),potb(irr,itb,ipb)
c      end do
c      do kk = 1,5
c      write(6,*) x5(kk),f5(kk)
c      end do
c      end if
  109 continue
  110 continue
c      stop
ctesttest
c    Use only values from BH region for comtputing BH region
c
ctesttest      mm = 5
ctesttest      do 1000 ipb = 0, npb
ctesttest      do 1000 itb = 0, ntb
ctesttest      do 1100 ii = 1, 5
ctesttest      x5(ii) = rb(nrb-mm+ii)
ctesttest      f5(ii) = potb(nrb-mm+ii,itb,ipb)
ctesttest 1100 continue
ctesttest      rx = rb(nrb)
ctesttest      dsousfb(itb,ipb) = dfncdx(x5,f5,rx)
ctesttestcccc      sousfb(itb,ipb)  = potb(nrb,itb,ipb)
ctesttest 1000 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bh2gr(fnb,fng)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / bcing / rbing(5,0:nntb,0:nnpb), rbex(5),
     &                 thbing(5,0:nntb,0:nnpb),
     &                 phibing(5,0:nntb,0:nnpb)
      common / ifsgb / irgbiin(0:nntg,0:nnpg), 
     &                 irgbiou(0:nntg,0:nnpg), 
     &                 itgbi(0:nnrg,0:nnpg), 
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      dimension fnb(0:nnrb,0:nntb,0:nnpb),
     &          fng(0:nnrg,0:nntg,0:nnpg)
      dimension r4(4),th4(4),phi4(4),fr4(4),ft4(4),fp4(4)
c
c --- Interpolate function value on the overlap region of 
c --  BH coordinate to GR coordinate. 
c
      pi = 3.14159265358979d+0
c
c --  x-axis     
c
      small = 1.0d-10
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = 0, nrtot
      rr = rg(irg)
      st = sintheg(itg)
      cp = cosphig(ipg)
c
      drbw = drb(nrb)
      if (rr.gt.dis+radext+drbw) go to 40
c
      x0 = rg(irg)*sintheg(itg)*cosphig(ipg) - dis
      y0 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z0 = rg(irg)*costheg(itg)
      rginb = dsqrt(x0**2 + y0**2 + z0**2)
      drbw = drb(nrb)
ctesttest      if (rginb.lt.radint-small.or.rginb.ge.radext) go to 40
      if (rginb.lt.radint/2.0d0-small.or.
     &    rginb.ge.(radext+radint)/2.0d0+drbw) go to 40
      thginb = datan2(dsqrt(x0**2 + y0**2),z0+small)
      phiginb = dmod(2.0d0*pi+datan2(y0,x0+small),6.2831853071795d0)
c
      irb = nrb
      do 41 ir = nrb-1, 1, -1
      rdet = (rginb - rb(ir+1))*(rginb - rb(ir))
      if (rdet.le.0.0d0) then
      irb = ir
      go to 410
      end if
   41 continue
  410 continue
c
      itb = 0
      do 42 it = 0, ntb-1
      thdet = (thginb - thb(it+1))*(thginb - thb(it))
      if (thdet.le.0.0d0) then
      itb = it
      go to 420
      end if
   42 continue
  420 continue
c
      ip = 0
      do 43 ip = 0, npb-1
      phidet = (phiginb - phib(ip+1))*(phiginb - phib(ip))
      if (phidet.le.0.0d0) then
      ipb = ip
      go to 430
      end if
   43 continue
  430 continue
c
      ir0 = min0(max0(irb-1,0),nrb-3)
      it0 = min0(max0(itb-1,0),ntb-3)
      ip0 = ipb
c
      do 8 ii = 1, 4
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r4(ii) = rb(irb0)
      th4(ii) = thb(itb0)
ccc      phi4(ii) = phib(ipb0)
c
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-2+npb,npb) 
      phi4(ii) = phib(ip0) + dphib*dble(ii-2)
 8    continue
c

      do 49 ii0 = 1, 4
      irb0 = ir0 + ii0 - 1
      do 48 ii1 = 1, 4
      itb0 = it0 + ii1 - 1
      do 47 ii2 = 1, 4
      ipb0 = mod(ip0+ii2-2+npb,npb)
      fp4(ii2) = fnb(irb0,itb0,ipb0)
   47 continue
      ft4(ii1) = fn_lagint(phi4,fp4,phiginb)
   48 continue
      fr4(ii0) = fn_lagint(th4,ft4,thginb)
   49 continue
      fng(irg,itg,ipg) = fn_lagint(r4,fr4,rginb)
c
   40 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bhin2gr(fnb,fng)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / bcing / rbing(5,0:nntb,0:nnpb), rbex(5),
     &                 thbing(5,0:nntb,0:nnpb),
     &                 phibing(5,0:nntb,0:nnpb)
      common / ifsgb / irgbiin(0:nntg,0:nnpg), 
     &                 irgbiou(0:nntg,0:nnpg), 
     &                 itgbi(0:nnrg,0:nnpg), 
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      dimension fnb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          fng(0:nnrg,0:nntg,0:nnpg)
      dimension r4(4),th4(4),phi4(4),fr4(4),ft4(4),fp4(4)
c
c --- Interpolate function value on the overlap region of 
c --  BH coordinate to GR coordinate. 
c
      pi = 3.14159265358979d+0
c
c --  x-axis     
c
      small = 1.0d-10
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = 0, nrtot
      rr = rg(irg)
      st = sintheg(itg)
      cp = cosphig(ipg)
c
      drbw = drb(nrb)
      if (rr.gt.dis+radext+drbw) go to 40
c
      x0 = rg(irg)*sintheg(itg)*cosphig(ipg) - dis
      y0 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z0 = rg(irg)*costheg(itg)
      rginb = dsqrt(x0**2 + y0**2 + z0**2)
ctest      if (rginb.lt.radint-small.or.rginb.ge.radext) go to 40
ctesttest      if (rginb.lt.radint/2.0d0-small.or.rginb.gt.radint+drbw) go to 40
      if (rginb.lt.radint/2.0d0-small.or.
     &    rginb.gt.(radint+radext)/2.0d0+drbw) go to 40
ctest     &    rginb.gt.radext+drbw) go to 40
      thginb = datan2(dsqrt(x0**2 + y0**2),z0+small)
      phiginb = dmod(2.0d0*pi+datan2(y0,x0+small),6.2831853071795d0)
c
      irb = nrb
      do 41 ir = nrb-1, 1, -1
      rdet = (rginb - rb(ir+1))*(rginb - rb(ir))
      if (rdet.le.0.0d0) then
      irb = ir
      go to 410
      end if
   41 continue
  410 continue
c
      itb = 0
      do 42 it = 0, ntb-1
      thdet = (thginb - thb(it+1))*(thginb - thb(it))
      if (thdet.le.0.0d0) then
      itb = it
      go to 420
      end if
   42 continue
  420 continue
c
      ip = 0
      do 43 ip = 0, npb-1
      phidet = (phiginb - phib(ip+1))*(phiginb - phib(ip))
      if (phidet.le.0.0d0) then
      ipb = ip
      go to 430
      end if
   43 continue
  430 continue
c
      ir0 = min0(max0(irb-1,0),nrb-3)
      it0 = min0(max0(itb-1,0),ntb-3)
      ip0 = ipb
c
      do 8 ii = 1, 4
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r4(ii) = rb(irb0)
      th4(ii) = thb(itb0)
ccc      phi4(ii) = phib(ipb0)
c
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-2+npb,npb) 
      phi4(ii) = phib(ip0) + dphib*dble(ii-2)
 8    continue
c

      do 49 ii0 = 1, 4
      irb0 = ir0 + ii0 - 1
      do 48 ii1 = 1, 4
      itb0 = it0 + ii1 - 1
      do 47 ii2 = 1, 4
      ipb0 = mod(ip0+ii2-2+npb,npb)
      fp4(ii2) = fnb(irb0,itb0,ipb0)
   47 continue
      ft4(ii1) = fn_lagint(phi4,fp4,phiginb)
   48 continue
      fr4(ii0) = fn_lagint(th4,ft4,thginb)
   49 continue
      fng(irg,itg,ipg) = fn_lagint(r4,fr4,rginb)
c
   40 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine coord_grid_size
c
c --- calcualte numbers of grids
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
c
      drdr = 1.0d0/dble(nrf)
      rbov = dble(nrbov)*drdr
      dis = drdr*dnint(dis/drdr)
      ding = 1.0d0 + 2.0d0*rbov
      radint = dis - ding
      radext = radint + rbov
      radmid = dis + radext + rbov
      nrin = idnint(radmid/drdr) 
      nrtot = nrin + nrout 
c
c###  BH coordinate, phib = 0 to 2 pi 
cexcise      nrb0 = - 4
cpuncture
      nrb0 = 0
      nrbin = nrb - nrbov
      ntbeq = ntb
      npbxz  = 0
      npbyz  = npb/4
      npbxzm = npb/2
      npbyzm = 3*npb/4
c
c###  GR coordinate, phig = -pi/4 to 3pi/4 
      nrgsf = nrf
      ntgeq = ntg
      npgxz  = npg/4
      npgyz  = npg/2
      npgxzm = 3*npg/4
      npgyzm = npg
c
c###  Fluid coordinate, phib = 0 to pi 
      nr = nrf
      nt = ntf
      np = npf
      ntfeq = ntf
      npfxz = 0
      npfyz = npf/2
      npfxzm= npf
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvbh
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_mesh_fluid.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_weight_bh.f'
c
      common / trmpb / sinmpb(0:nnlb,0:nnpb), cosmpb(0:nnlb,0:nnpb)
      common / brfnv / hfnb_nb(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_di(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_hd(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_dd(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_nd(0:nnrb,0:nnlb,0:nnrb)
      common / bfnsf / fnbsf_nb(0:nnlb,0:nnrb,4),
     &                 fnbsf_di(0:nnlb,0:nnrb,4),
     &                 fnbsf_hd(0:nnlb,0:nnrb,4),
     &                 fnbsf_dd(0:nnlb,0:nnrb,4),
     &                 fnbsf_nd(0:nnlb,0:nnrb,4)
      common / brleg / pnab(0:nnlb,0:nnlb,0:nntb),
     &               facnmb(0:nnlb,0:nnlb), epsib(0:nnlb)
c
      dimension fac(0:nnlb)
c
c- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Set up of meshes  ---  ( r(1) = dr ( not the center ) )
c --- The constatnt msym means the symmetry of the configuration.
c
      pi = 3.14159265358979d+0
c
      dthb  = pi/2.d0/dble(ntb)
      dphib = 2.0d0*pi/dble(npb)
c
      dthbinv=1.0d0/dthb
      dphibinv=1.0d0/dphib
      dthbinv2=1.0d0/dthb/2.0d0
      dphibinv2=1.0d0/dphib/2.0d0
      dthbinv12=1.0d0/dthb/12.0d0
      dphibinv12=1.0d0/dphib/12.0d0
c
c --- outermost mesh of bh-domain is the same size as mid-domain. 
c
      rbdom = radint - bhrad
c
cccc      drdr = ding/dble(ngdin) 
      drdr = 1.0d0/dble(nrf)
      drdrinv = 1.0d0/drdr 
c
      do 100 ii = nrbin, nrb
      drb(ii) = drdr
      drbinv(ii) = drdrinv
 100  continue
c
c --- For variable mesh.
c
      if (bhcop.eq.0.0d0) then
c
      ratrr = 0.5d0
c
 1400 continue
c
      ratrrb = ratrr
      alge = -(1.0d0-ratrr**nrbin-rbdom*drdrinv*(1.0d0-ratrr))
      dalge = -dble(nrbin)*ratrr**(nrbin-1) + rbdom*drdrinv
      ratrr = ratrr + alge/dalge
      error = 2.d0*(ratrr - ratrrb)/(ratrr + ratrrb)
c
      if (dabs(error).gt.1.d-14) go to 1400
c
c --  drb(irb), hrb(irb) are between rb(irb-1) and rb(irb).
c
      do 101 ir = nrbin - 1, nrb0, -1
      drb(ir) = ratrr*drb(ir+1)
      drbinv(ir) = 1.0d0/drb(ir)
 101  continue
c
      end if 
c
      if (bhcop.ne.0.0d0) then
c
      nbhcop = idnint(bhcop) 
      nnbb = nrbin - nbhcop
      rbdom = radint - bhrad - nnbb*drdr
      ratrr = 0.5d0
c
 1410 continue
c
      ratrrb = ratrr
      alge = -(1.0d0-ratrr**nbhcop-rbdom*drdrinv*(1.0d0-ratrr))
      dalge = -dble(nbhcop)*ratrr**(nbhcop-1) + rbdom*drdrinv
      ratrr = ratrr + alge/dalge
      error = 2.d0*(ratrr - ratrrb)/(ratrr + ratrrb)
c
      if (dabs(error).gt.1.d-14) go to 1410
c
      do 150 ir = nrbin, nbhcop, -1
      drb(ir) = drdr
      drbinv(ir) = 1.0d0/drb(ir)
 150  continue
      do 149 ir = nbhcop - 1, nrb0, -1
      drb(ir) = ratrr*drb(ir+1)
      drbinv(ir) = 1.0d0/drb(ir)
 149  continue
c
      end if 
c
c
      do 102 ir = nrb0 + 1, nrb - 1
      drbinv2(ir) = 1.0d0/(drb(ir)+drb(ir+1))
 102  continue
      drbinv2(nrb0) = 1.0d0/(drb(nrb0+1)+drb(nrb0+2))
      drbinv2(nrb) = 1.0d0/(drb(nrb)+drb(nrb-1))
c
      rb(0) = bhrad
      rbinv(0) = 1.0d0/rb(0)
      if (bhrad.ne.0.0d0) rbinv(0) = 1.0d0/bhrad
      do 110 ir = 1, nrb
      rb(ir) = rb(ir-1) + drb(ir)
      hrb(ir) = (rb(ir) + rb(ir-1))*0.5d0
      rbinv(ir) = 1.0d0/rb(ir)
      hrbinv(ir) = 1.0d0/hrb(ir)
  110 continue
      do 114 ir = -1, nrb0, -1
      rb(ir) = rb(ir+1) - drb(ir+1)
      hrb(ir+1) = (rb(ir+1) + rb(ir))*0.5d0
      rbinv(ir) = 1.0d0/rb(ir)
      hrbinv(ir+1) = 1.0d0/hrb(ir+1)
  114 continue
      do 111 it = 0, ntb
      thb(it) = dble(it)*dthb
  111 continue
      do 112 ip = 0, npb
      phib(ip) = dble(ip)*dphib
  112 continue
c
      write(6,12) error, ratrr
      write(6,14) bhrad, rb(0)
      write(6,14) radext, rb(nrb)
 12   format(' BH ',1p,4e23.15)
 14   format('    ',1p,4e23.15)
      rdet = dmax1(dabs(rb(nrb) - radext),dabs(rb(0)-bhrad))
      if(rdet.gt.1.d-10)then
      write(6,*) ' bad coordinate BH ', rdet
      stop
      end if
c
c
c --- cal. sine ,cosine and tange on grids of polar angle. ---
c --- notice ; tange diverge to infinity when agr=pi/2, j1=m
c
      do 121 it  = 0, ntb
      sintheb(it) = dsin(thb(it))
      costheb(it) = dcos(thb(it))
  121 continue
      cosecb( 0) = 0.0d0
      cotanb( 0) = 0.0d0
      do 122 it = 1, ntb - 1
      cosecb(it) = 1.0d0/dsin(thb(it))
      cotanb(it) = 1.0d0/dtan(thb(it))
  122 continue
      cosecb(ntb) = 1.0d0
      cotanb(ntb) = 0.0d0
c
      do 124 ip  = 0, npb
      sinphib(ip) = dsin(phib(ip))
      cosphib(ip) = dcos(phib(ip))
      if (ip.ne.0.and.ip.ne.npb/4.and.ip.ne.npb/2.and.
     &    ip.ne.3*npb/4.and.ip.ne.npb) then
      cotphib(ip) = 1.0d0/dtan(phib(ip))
      else
      cotphib(ip) = 0.0d0
      end if
      do 124 nn  = 0, nlb
      fnn = dble(nn)
      sinmpb(nn,ip) = dsin(fnn*phib(ip))
      cosmpb(nn,ip) = dcos(fnn*phib(ip))
  124 continue
c
c --- weight for integration.
c
      san1 = 1.0d0/3.0d0
      san4 = 4.0d0/3.0d0
      san2 = 2.0d0/3.0d0
c
      do 191 ip = 0, npb
      if(ip.eq.0.or .ip.eq.npb                   ) w4dpb(ip)=san1*dphib
      if(ip.ne.0.and.ip.ne.npb.and.mod(ip,2).eq.1) w4dpb(ip)=san4*dphib
      if(ip.ne.0.and.ip.ne.npb.and.mod(ip,2).eq.0) w4dpb(ip)=san2*dphib
c
      wgdpb(ip) = w4dpb(ip)
c
  191 continue
c
      do 192 it = 0, ntb
      if(it.eq.0.or .it.eq.ntb)
     &   w4dtb(it) = san1*sintheb(it)*dthb
      if(it.ne.0.and.it.ne.ntb.and.mod(it,2).eq.1)
     &   w4dtb(it) = san4*sintheb(it)*dthb
      if(it.ne.0.and.it.ne.ntb.and.mod(it,2).eq.0)
     &   w4dtb(it) = san2*sintheb(it)*dthb
c
      wgdtb(it) = w4dtb(it)
c
  192 continue
c
      do 194 ir = 1, nrb
      wgdrb(ir) = hrb(ir)**2*drb(ir)
  194 continue
c
      do 195 ip = 0, npb
      do 195 it = 0, ntb
      do 195 ir = 1, nrb
      wgrtpb(ir,it,ip)=wgdrb(ir)*wgdtb(it)*wgdpb(ip)
  195 continue
c
c ----------------------------------------------------------------------
c        The associated Legendre polynomials are computed.  
c 
c        nla : maximum value of n
c ----------------------------------------------------------------------
c
c --- computation of associated Legendre polynomials.
c
      do 2110 it = 0, ntb
c
      cc = dcos(dthb*dble(it))
      ss = dsin(dthb*dble(it))
c
      do 2120 nn = 0, nlb
      do 2120 mm = 0, nlb
      pnab(nn,mm,it)  = 0.0d0
 2120 continue
c
      fac(0) = 1.0d0
      do 2121 mm = 1, nlb
      fmm = dble(mm)
      fac(mm) = (2.0d0*fmm-1.0d0) * fac(mm-1)
 2121 continue
c
      pnab(0,0,it) = 1.d0
      do 2122 mm = 1, nlb
        pnab(mm,mm,it) = fac(mm) * (-ss)**mm 
 2122 continue
c
      do 2123 mm = 0, nlb-1
      fmm = dble(mm)
        pnab(mm+1,mm,it) = (2.0d0*fmm + 1.0d0)* cc*  pnab(mm,mm,it)
 2123 continue
c
      do 2124 mm = 0, nlb-2
      fmm = dble(mm)
      do 2124 kk = 2, nlb-mm
      fkk = dble(kk)
      q1 = ( 2.0d0 * fmm + 2.0d0 * fkk - 1.0d0 ) / fkk
      q2 = ( 2.0d0 * fmm + fkk - 1.0d0 ) / fkk
      pnab(mm+kk,mm,it) = q1 * cc * pnab(mm+kk-1,mm,it)
     &                  - q2      * pnab(mm+kk-2,mm,it)
 2124 continue
c
 2110 continue
c
c -------------------------------
c --- Computation of factors. ---
c -------------------------------
c
      do 2139 nn = 0, nlb
      do 2139 mm = 0, nlb
      facnmb(nn,mm) = 0.0d+0
 2139 continue
c
      facnmb(0,0) = 1.0d0
      do 2140 nn = 1, nlb
      fnn  = dble(nn)
      facnmb(nn,0) = 1.0d0
      do 2140 mm = 1, nn
      fmm  = dble(mm)
      fnmfm= fnn-fmm + 1.0d0 
      facnmb(nn,mm) = facnmb(nn,mm-1)/(fnn+fmm)/fnmfm
 2140 continue
c
      do 2141 mm = 0, nlb 
      epsib(mm) = 2.0d+0 
      if (mm.eq.0) epsib(mm) = 1.0d+0 
 2141 continue
c
c -------------------------------------
c --- Computation of functoin hfnb. ---
c -------------------------------------
c
c    hfsnb(irr,il,ir) --> for r' < r
c                         for r  < r'
c    N.B.  rb(0) = bhrad should not equal to zero.
c
      do 418 il  = 0, nlb
      do 418 ir  = 0, nrb
      do 418 irr = 0, nrb
      hfnb_nb(irr,il,ir) = 0.d0
      hfnb_di(irr,il,ir) = 0.d0
      hfnb_hd(irr,il,ir) = 0.d0
      hfnb_dd(irr,il,ir) = 0.d0
      hfnb_nd(irr,il,ir) = 0.d0
  418 continue
c
c --  No boundary Green's fn.
c
      do 419 ir  = 0, nrb
      do 4190 irr = 0, nrb
      if (hrb(irr).lt.rb(ir)) then
      do 4191 il  = 0, nlb
      hfnb_nb(irr,il,ir) = hrb(irr)**il/rb(ir)**(il+1)
 4191 continue
      end if
      if (hrb(irr).ge.rb(ir)) then
      do 4192 il  = 0, nlb
      hfnb_nb(irr,il,ir) = rb(ir)**il/hrb(irr)**(il+1)
 4192 continue
      end if
 4190 continue
 419  continue
c
c --  Dirichlet at BH
c
      bhradinv = 1.0d0/bhrad
      do 519 ir  = 0, nrb
      do 5190 irr = 0, nrb
      if (hrb(irr).lt.rb(ir)) then
      do 5191 il  = 0, nlb
      hfnb_di(irr,il,ir) =(hrb(irr)**il/rb(ir)**(il+1)
     &                    - bhrad**(2*il+1)/(hrb(irr)*rb(ir))**(il+1))
 5191 continue
      end if
      if (hrb(irr).ge.rb(ir)) then
      do 5192 il  = 0, nlb
      hfnb_di(irr,il,ir) =(rb(ir)**il/hrb(irr)**(il+1)
     &                    - bhrad**(2*il+1)/(hrb(irr)*rb(ir))**(il+1))
 5192 continue
      end if
 5190 continue
 519  continue
c
c --  1/2(No boundary + Half Dirichlet)
c
      bhradinv = 1.0d0/bhrad
      do 619 ir  = 0, nrb
      do 6190 irr = 0, nrb
      if (hrb(irr).lt.rb(ir)) then
      do 6191 il  = 0, nlb
      hfnb_hd(irr,il,ir) = 0.5d0*hrb(irr)**il/rb(ir)**(il+1)
     &                    + 0.5d0*(hrb(irr)**il/rb(ir)**(il+1)
     &                    - bhrad**(2*il+1)/(hrb(irr)*rb(ir))**(il+1))
 6191 continue
      end if
      if (hrb(irr).ge.rb(ir)) then
      do 6192 il  = 0, nlb
      hfnb_hd(irr,il,ir) = 0.5d0*rb(ir)**il/hrb(irr)**(il+1)
     &                    + 0.5d0*(rb(ir)**il/hrb(irr)**(il+1)
     &                    - bhrad**(2*il+1)/(hrb(irr)*rb(ir))**(il+1))
 6192 continue
      end if
 6190 continue
 619  continue
c
c --  Dirichlet at BH boundary and interface 
c
      bhradinv = 1.0d0/bhrad
      radextinv = 1.0d0/radext
      do 719 ir  = 0, nrb
      do 7190 irr = 0, nrb
      if (hrb(irr).lt.rb(ir)) then
      do 7191 il  = 0, nlb
      fac1 = 1.0d0/(1.0d0 - (bhrad*radextinv)**(2*il+1))
      fac2 = (bhrad*radextinv)**il*radextinv
      hfnb_dd(irr,il,ir) = fac1*fac2
     &        *((hrb(irr)*bhradinv)**il - (bhrad*hrbinv(irr))**(il+1))
     &        *((radext*rbinv(ir))**(il+1) - (rb(ir)*radextinv)**il)
 7191 continue
      end if
      if (hrb(irr).ge.rb(ir)) then
      do 7192 il  = 0, nlb
      fac1 = 1.0d0/(1.0d0 - (bhrad*radextinv)**(2*il+1))
      fac2 = (bhrad*radextinv)**il*radextinv
      hfnb_dd(irr,il,ir) = fac1*fac2
     &        *((rb(ir)*bhradinv)**il - (bhrad*rbinv(ir))**(il+1))
     &        *((radext*hrbinv(irr))**(il+1) - (hrb(irr)*radextinv)**il)
 7192 continue
      end if
 7190 continue
 719  continue
c
c --  Neumann at BH and Dirichlet at interface
c
      bhradinv = 1.0d0/bhrad
      radextinv = 1.0d0/radext
      do 819 ir  = 0, nrb
      do 8190 irr = 0, nrb
      if (hrb(irr).lt.rb(ir)) then
      do 8191 il  = 0, nlb
      dil1 = dble(il)/dble(il+1)
      fac1 = 1.0d0/(1.0d0 + dil1*(bhrad*radextinv)**(2*il+1))
      fac2 = (bhrad*radextinv)**il*radextinv
      hfnb_nd(irr,il,ir) = fac1*fac2
     &   *((hrb(irr)*bhradinv)**il + dil1*(bhrad*hrbinv(irr))**(il+1))
     &   *((radext*rbinv(ir))**(il+1) - (rb(ir)*radextinv)**il)
 8191 continue
      end if
      if (hrb(irr).ge.rb(ir)) then
      do 8192 il  = 0, nlb
      dil1 = dble(il)/dble(il+1)
      fac1 = 1.0d0/(1.0d0 + dil1*(bhrad*radextinv)**(2*il+1))
      fac2 = (bhrad*radextinv)**il*radextinv
      hfnb_nd(irr,il,ir) = fac1*fac2
     &   *((rb(ir)*bhradinv)**il + dil1*(bhrad*rbinv(ir))**(il+1))
     &   *((radext*hrbinv(irr))**(il+1) - (hrb(irr)*radextinv)**il)
 8192 continue
      end if
 8190 continue
 819  continue
c
c
c --- Green's functions for the surface term (TIMES R^2)
c
c     iaho --> 1 for d phi/dr condition at BH (inward normal). 
c              2 for phi(r) condition at BH (inward normal).
c              3 for d phi/dr at interface (outward normal). 
c              4 for phi(r) at interface (outward normal).
c     fnbsf_hd(l,r,iaho)
c
      radextinv = 1.0d0/radext
      bhradinv = 1.0d0/bhrad
c
c --  No boundary Green's fn.
c
      do 1001 ir = 0, nrb
      il = 0
      fnbsf_nb(il,ir,1) = - bhrad*(bhrad*rbinv(ir))
      fnbsf_nb(il,ir,2) = 0.0d0
      fnbsf_nb(il,ir,3) = radext
      fnbsf_nb(il,ir,4) = - dble(il+1)
      do 1001 il = 1, nlb
      fnbsf_nb(il,ir,1) = - bhrad*(bhrad*rbinv(ir))**(il+1)
      fnbsf_nb(il,ir,2) = - dble(il)*(bhrad*rbinv(ir))**(il+1)
      fnbsf_nb(il,ir,3) = radext*(rb(ir)*radextinv)**il
      fnbsf_nb(il,ir,4) = - dble(il+1)*(rb(ir)*radextinv)**il
 1001 continue
c
c --  Dirichlet at BH
c
      do 1002 ir = 0, nrb
      il = 0
      fnbsf_di(il,ir,1) = - 0.0d0
      fnbsf_di(il,ir,2) = - bhrad*rbinv(ir)
      fnbsf_di(il,ir,3) = radext*(1.0d0-bhrad*rbinv(ir))
      fnbsf_di(il,ir,4) = - (1.0d0-bhrad*rbinv(ir))
      do 1002 il = 1, nlb
      fnbsf_di(il,ir,1) = - 0.0d0
      fnbsf_di(il,ir,2) = 
     &            - (2.0d0*dble(il)+1.0d0)*(bhrad*rbinv(ir))**(il+1)
      fnbsf_di(il,ir,3) = radext*(bhrad/radext)**il
     &             *((rb(ir)*bhradinv)**il-(bhrad*rbinv(ir))**(il+1))
      fnbsf_di(il,ir,4) = - dble(il+1)*(bhrad/radext)**il
     &             *((rb(ir)*bhradinv)**il-(bhrad*rbinv(ir))**(il+1))
 1002 continue
c
c --  1/2(No boundary + Half Dirichlet)
c
      do 1003 ir = 0, nrb
      il = 0
      fnbsf_hd(il,ir,1) = - 0.5d0*bhrad*(bhrad*rbinv(ir))
      fnbsf_hd(il,ir,2) = - 0.5d0*bhrad*rbinv(ir)
      fnbsf_hd(il,ir,3) = 0.5d0*radext
     &                  + 0.5d0*radext*(1.0d0-bhrad*rbinv(ir))
      fnbsf_hd(il,ir,4) = - 0.5d0*dble(il+1)
     &                    - 0.5d0*(1.0d0-bhrad*rbinv(ir))
      do 1003 il = 1, nlb
      fnbsf_hd(il,ir,1) = - 0.5d0*bhrad*(bhrad*rbinv(ir))**(il+1)
      fnbsf_hd(il,ir,2) = - 0.5d0*dble(il)*(bhrad*rbinv(ir))**(il+1)
     &      - 0.5d0*(2.0d0*dble(il)+1.0d0)*(bhrad*rbinv(ir))**(il+1)
      fnbsf_hd(il,ir,3) = 0.5d0*radext*(rb(ir)*radextinv)**il
     &                  + 0.5d0*radext*(bhrad/radext)**il
     &             *((rb(ir)*bhradinv)**il-(bhrad*rbinv(ir))**(il+1))
      fnbsf_hd(il,ir,4) = - 0.5d0*dble(il+1)*(rb(ir)*radextinv)**il
     &                    - 0.5d0*dble(il+1)*(bhrad/radext)**il
     &           *((rb(ir)*bhradinv)**il-(bhrad*rbinv(ir))**(il+1))
 1003 continue
c
c --  Dirichlet at BH boundary and interface
c
      bhsq = bhrad**2
      radsq = radext**2
      do 1004 ir = 0, nrb
      il = 0
      fac1 = 1.0d0/(1.0d0 - (bhrad*radextinv)**(2*il+1))
      fac2 = dble(2*il+1)*bhrad**(il-1)*radextinv**(il+1)
      fac3 = dble(2*il+1)*bhrad**il*radextinv**(il+2)
      fnbsf_dd(il,ir,1) = - 0.0d0
      fnbsf_dd(il,ir,2) = - fac1*fac2*(radext*rbinv(ir) - 1.0d0)*bhsq
      fnbsf_dd(il,ir,3) = 0.0d0
      fnbsf_dd(il,ir,4) = - fac1*fac3*(1.0d0 - bhrad*rbinv(ir))*radsq
      do 1004 il = 1, nlb
      fac1 = 1.0d0/(1.0d0 - (bhrad*radextinv)**(2*il+1))
      fac2 = dble(2*il+1)*bhrad**(il-1)*radextinv**(il+1)
      fac3 = dble(2*il+1)*bhrad**il*radextinv**(il+2)
      fnbsf_dd(il,ir,1) = - 0.0d0
      fnbsf_dd(il,ir,2) = - fac1*fac2
     &     *((radext*rbinv(ir))**(il+1)-(rb(ir)*radextinv)**il)*bhsq
      fnbsf_dd(il,ir,3) = 0.0d0
      fnbsf_dd(il,ir,4) = - fac1*fac3
     &     *((rb(ir)*bhradinv)**il-(bhrad*rbinv(ir))**(il+1))*radsq
 1004 continue
c
c --  Neumann at BH and Dirichlet at interface
c
      bhsq = bhrad**2
      radsq = radext**2
      do 1005 ir = 0, nrb
      il = 0
      dil1 = dble(il)/dble(il+1)
      dil2 = dble(2*il+1)/dble(il+1)
      fac1 = 1.0d0/(1.0d0 + dil1*(bhrad*radextinv)**(2*il+1))
      fac2 = dil2*(bhrad*radextinv)**il*radextinv
      fac3 = dble(2*il+1)*bhrad**il*radextinv**(il+2)
      fnbsf_nd(il,ir,1) = - fac1*fac2*(radext*rbinv(ir) - 1.0d0)*bhsq
      fnbsf_nd(il,ir,2) = - 0.0d0
      fnbsf_nd(il,ir,3) = 0.0d0
      fnbsf_nd(il,ir,4) = - fac1*fac3
     &                  *(1.0d0 + dil1*bhrad*rbinv(ir))*radsq
      do 1005 il = 1, nlb
      dil1 = dble(il)/dble(il+1)
      dil2 = dble(2*il+1)/dble(il+1)
      fac1 = 1.0d0/(1.0d0 + dil1*(bhrad*radextinv)**(2*il+1))
      fac2 = dil2*(bhrad*radextinv)**il*radextinv
      fac3 = dble(2*il+1)*bhrad**il*radextinv**(il+2)
      fnbsf_nd(il,ir,1) = - fac1*fac2
     &   *((radext*rbinv(ir))**(il+1)-(rb(ir)*radextinv)**il)*bhsq
      fnbsf_nd(il,ir,2) = - 0.0d0
      fnbsf_nd(il,ir,3) = 0.0d0
      fnbsf_nd(il,ir,4) = - fac1*fac3
     &   *((rb(ir)*bhradinv)**il+dil1*(bhrad*rbinv(ir))**(il+1))*radsq
 1005 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvgr
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_mesh_fluid.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_weight_grav.f'
c
      common / trmpg / sinmpg(0:nnlg,0:nnpg), cosmpg(0:nnlg,0:nnpg)
      common / grfsn / hfsn(0:nnrg,0:nnlg,0:nnrg)
      common / grleg / pnag(0:nnlg,0:nnlg,0:nntg),
     &               facnmg(0:nnlg,0:nnlg), epsig(0:nnlg)
c
      dimension fac(0:nnlg)
c
c- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Set up of meshes  ---  ( r(1) = dr ( not the center ) )
c --- The constatnt msym means the symmetry of the configuration.
c
      pi = 3.14159265358979d+0
c
      dthg  = pi/2.d0/dble(ntg)
      dphig = 2.0d0*pi/dble(npg)
c
      dthginv=1.0d0/dthg
      dphiginv=1.0d0/dphig
      dthginv2=1.0d0/dthg/2.0d0
      dphiginv2=1.0d0/dphig/2.0d0
      dthginv12=1.0d0/dthg/12.0d0
      dphiginv12=1.0d0/dphig/12.0d0
c
cccc      drdr = ding/dble(ngdin)
      drdr = 1.0d0/dble(nrf)
      drdrinv = 1.0d0/drdr
      rvdom = rvout - radmid
c
      do 100 ir = 0, nrin
      drg(ir)   = drdr
      drginv(ir) = drdrinv
      drginv2(ir) = 0.5d0*drdrinv
 100  continue
c
c --- For variable mesh.
c
      ratrr = 1.2d0
c
 1400 continue
c
      ratrrb = ratrr
      alge = -(ratrr**(nrout+1)-ratrr-rvdom*drdrinv*(ratrr-1.0d0))
      dalge = dble(nrout+1)*ratrr**nrout - 1.0d0 - rvdom*drdrinv
      ratrr = ratrr + alge/dalge
      error = 2.d0*(ratrr - ratrrb)/(ratrr + ratrrb)
c 
      if (dabs(error).gt.1.d-14) go to 1400 
c
      do 101 ir = nrin+1, nrtot
      drg(ir) = ratrr*drg(ir-1)
      drginv(ir) = 1.0d0/drg(ir)
 101  continue
      do 102 ir = nrin+1, nrtot - 1
      drginv2(ir) = 1.0d0/(drg(ir)+drg(ir+1))
 102  continue
      drginv2(nrtot) = 1.0d0/(drg(nrtot)+drg(nrtot-1))
c
      rg(0) = 0.0d0
      rginv(0) = 0.0d0
      do 110 ir = 1, nrtot
      rg(ir) = rg(ir-1) + drg(ir)
      hrg(ir) = (rg(ir) + rg(ir-1))*0.5d0
      rginv(ir) = 1.0d0/rg(ir)
      hrginv(ir) = 1.0d0/hrg(ir)
  110 continue
      do 111 it = 0, ntg
      thg(it) = dble(it)*dthg
  111 continue
      phig(0) = - pi/2.0d0
      do 112 ip = 1, npg
      phig(ip) = dble(ip)*dphig + phig(0) 
  112 continue
c
      write(6,12) error, ratrr
      write(6,14) rvout, rg(nrtot)
 12   format(' GR ', 1p,4e23.15)
 14   format('    ', 1p,4e23.15)
      rdet = (rg(nrtot) - rvout)/rvout
      if(rdet.gt.1.d-10)then
      write(6,*) ' bad coordinate GR ', rdet
      stop
      end if
c
c --- cal. sine ,cosine and tange on grids of polar angle. ---
c --- notice ; tange diverge to infinity when agr=pi/2, j1=m
c
      do 121 it  = 0, ntg
      sintheg(it) = dsin(thg(it))
      costheg(it) = dcos(thg(it))
  121 continue
      cosecg( 0) = 0.0d0
      cotang( 0) = 0.0d0
      do 122 it = 1, ntg - 1
      cosecg(it) = 1.0d0/dsin(thg(it))
      cotang(it) = 1.0d0/dtan(thg(it))
  122 continue
      cosecg(ntg) = 1.0d0
      cotang(ntg) = 0.0d0
c
      do 124 ip  = 0, npg
      sinphig(ip) = dsin(phig(ip))
      cosphig(ip) = dcos(phig(ip))

      if (ip.ne.0.and.ip.ne.npg/4.and.ip.ne.npg/2.and.
     &    ip.ne.3*npg/4.and.ip.ne.npg) then
      cotphig(ip) = 1.0d0/dtan(phig(ip))
      else
      cotphig(ip) = 0.0d0
      end if
      do 124 nn  = 0, nlg
      fnn = dble(nn)
      sinmpg(nn,ip) = dsin(fnn*phig(ip))
      cosmpg(nn,ip) = dcos(fnn*phig(ip))
  124 continue
c
c --- weight for integration.
c
      san1 = 1.0d0/3.0d0
      san4 = 4.0d0/3.0d0
      san2 = 2.0d0/3.0d0
c
      do 191 ip = 0, npg
      if(ip.eq.0.or .ip.eq.npg) wgdpg(ip) = 0.5d0*dphig
      if(ip.ne.0.and.ip.ne.npg) wgdpg(ip) = 1.0d0*dphig
      if(ip.eq.0.or .ip.eq.npg                   ) w4dpg(ip)=san1*dphig
      if(ip.ne.0.and.ip.ne.npg.and.mod(ip,2).eq.1) w4dpg(ip)=san4*dphig
      if(ip.ne.0.and.ip.ne.npg.and.mod(ip,2).eq.0) w4dpg(ip)=san2*dphig
c
czzz      wgdpg(ip) = w4dpg(ip)
c
  191 continue
c
      do 192 it = 0, ntg
      if(it.eq.0.or .it.eq.ntg) wgdtg(it) = 0.5d0*sintheg(it)*dthg
      if(it.ne.0.and.it.ne.ntg) wgdtg(it) = 1.0d0*sintheg(it)*dthg
      if(it.eq.0.or .it.eq.ntg)
     &   w4dtg(it) = san1*sintheg(it)*dthg
      if(it.ne.0.and.it.ne.ntg.and.mod(it,2).eq.1)
     &   w4dtg(it) = san4*sintheg(it)*dthg
      if(it.ne.0.and.it.ne.ntg.and.mod(it,2).eq.0)
     &   w4dtg(it) = san2*sintheg(it)*dthg
c
czzz      wgdtg(it) = w4dtg(it)
c
  192 continue
c
      do 194 ir = 1, nrtot
      wgdrg(ir) = hrg(ir)**2*drg(ir)
      w4drg(ir) = wgdrg(ir)
  194 continue
c
      do 195 ip = 0, npg
      do 195 it = 0, ntg
      do 195 ir = 1, nrtot
      wgrtpg(ir,it,ip)=w4drg(ir)*w4dtg(it)*w4dpg(ip)
  195 continue
c
c ----------------------------------------------------------------------
c        The associated Legendre polynomials are computed.  
c 
c        nla : maximum value of n
c ----------------------------------------------------------------------
c
c --- computation of associated Legendre polynomials.
c
      do 2110 it = 0, ntg
c
      cc = dcos(dthg*dble(it))
      ss = dsin(dthg*dble(it))
c
      do 2120 nn = 0, nlg
      do 2120 mm = 0, nlg
      pnag(nn,mm,it)  = 0.0d0
 2120 continue
c
      fac(0) = 1.0d0
      do 2121 mm = 1, nlg
      fmm = dble(mm)
      fac(mm) = (2.0d0*fmm-1.0d0) * fac(mm-1)
 2121 continue
c
      pnag(0,0,it) = 1.d0
      do 2122 mm = 1, nlg
        pnag(mm,mm,it) = fac(mm) * (-ss)**mm 
 2122 continue
c
      do 2123 mm = 0, nlg-1
      fmm = dble(mm)
        pnag(mm+1,mm,it) = (2.0d0*fmm + 1.0d0)* cc*  pnag(mm,mm,it)
 2123 continue
c
      do 2124 mm = 0, nlg-2
      fmm = dble(mm)
      do 2124 kk = 2, nlg-mm
      fkk = dble(kk)
      q1 = ( 2.0d0 * fmm + 2.0d0 * fkk - 1.0d0 ) / fkk
      q2 = ( 2.0d0 * fmm + fkk - 1.0d0 ) / fkk
      pnag(mm+kk,mm,it) = q1 * cc * pnag(mm+kk-1,mm,it)
     &                  - q2      * pnag(mm+kk-2,mm,it)
 2124 continue
c
 2110 continue
c
c -------------------------------
c --- Computation of factors. ---
c -------------------------------
c
      do 2139 nn = 0, nlg
      do 2139 mm = 0, nlg
      facnmg(nn,mm) = 0.0d+0
 2139 continue
c
      facnmg(0,0) = 1.0d0
      do 2140 nn = 1, nlg
      fnn  = dble(nn)
      facnmg(nn,0) = 1.0d0
      do 2140 mm = 1, nn
      fmm  = dble(mm)
      fnmfm= fnn-fmm + 1.0d0 
      facnmg(nn,mm) = facnmg(nn,mm-1)/(fnn+fmm)/fnmfm
 2140 continue
c
      do 2141 mm = 0, nlg 
      epsig(mm) = 2.0d+0 
      if (mm.eq.0) epsig(mm) = 1.0d+0 
 2141 continue
c
c -------------------------------------
c --- Computation of functoin hfsn. ---
c -------------------------------------
c
c    hfsn(irr,nn,id,ir) --> for r' < r
c                           for r < r'
c
      do 418 nn  = 0, nlg
      do 418 ir  = 0, nrtot
      do 418 irr = 0, nrtot
        hfsn(irr,nn,ir) = 0.d0
  418 continue
c
      do 419 ir  = 1, nrtot
      do 4190 irr = 1, nrtot
      if (hrg(irr).lt.rg(ir)) then
      do 4191 nn  = 0, nlg
        hfsn(irr,nn,ir) = hrg(irr)**nn/rg(ir)**(nn+1)
 4191 continue
      end if
      if (hrg(irr).ge.rg(ir)) then
      do 4192 nn  = 0, nlg
        hfsn(irr,nn,ir) = rg(ir)**nn/hrg(irr)**(nn+1)
 4192 continue
      end if
 4190 continue
 419  continue
c
      ir  = 0
      nn  = 0
      do 4200 irr = 1, nrtot
        hfsn(irr,nn,ir) = 1.0d0/hrg(irr)
 4200 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvgb
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_intpp.f'
      include 'common_blocks/CB_weight_grav.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg),
     &                 ipgbiou(0:nnrg,0:nntg)
      common / gcifs / rgbifin(0:nntg,0:nnpg),
     &                 rgbifou(0:nntg,0:nnpg),
     &                  thgbif(0:nnrg,0:nnpg),
     &                 phigbifin(0:nnrg,0:nntg),
     &                 phigbifou(0:nnrg,0:nntg)
      common / ifhgb / ihrgbiin(0:nntg,0:nnpg),
     &                 ihrgbiou(0:nntg,0:nnpg),
     &                 ihtgbi(0:nnrg,0:nnpg),
     &                 ihpgbiin(0:nnrg,0:nntg),
     &                 ihpgbiou(0:nnrg,0:nntg)
      common / gcifh / hrgbifin(0:nntg,0:nnpg),
     &                 hrgbifou(0:nntg,0:nnpg),
     &                  hthgbif(0:nnrg,0:nnpg),
     &                 hphigbifin(0:nnrg,0:nntg),
     &                 hphigbifou(0:nnrg,0:nntg)
      common / gcfbc / rgb1(0:nnrg,0:nntg,0:nnpg),
     &                thgb1(0:nnrg,0:nntg,0:nnpg),
     &               phigb1(0:nnrg,0:nntg,0:nnpg),
     &                 rgb2(0:nnrg,0:nntg,0:nnpg),
     &                thgb2(0:nnrg,0:nntg,0:nnpg),
     &               phigb2(0:nnrg,0:nntg,0:nnpg)
      common / bcing / rbing(5,0:nntb,0:nnpb), rbex(5),
     &                 thbing(5,0:nntb,0:nnpb),
     &                 phibing(5,0:nntb,0:nnpb)
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
      pi = 3.14159265358979d+0
c
c --- Determin coordinates on interface between GR and BH coordinates.
c
      small = 1.0d-10
      do 10 ipg = 0, npg - 1
      do 10 itg = 1, ntg
      irgbiin(itg,ipg) = 0
      irgbiou(itg,ipg) = 0
      rgbifin(itg,ipg) = 0.0d0
      rgbifou(itg,ipg) = 0.0d0
      ihrgbiin(itg,ipg) = 0
      ihrgbiou(itg,ipg) = 0
      hrgbifin(itg,ipg) = 0.0d0
      hrgbifou(itg,ipg) = 0.0d0
      sth2 = (dis**2 - radint**2)/(dis**2*cosphig(ipg)**2)
      cphi2 = (dis**2 - radint**2)/(dis**2*sintheg(itg)**2)
      if (sintheg(itg)**2.gt.sth2.and.cosphig(ipg)**2.gt.cphi2) then
      rgbifin(itg,ipg) = 
     & dis*sintheg(itg)*cosphig(ipg) - 
     & dsqrt(radint**2-dis**2*(1.0d0-sintheg(itg)**2*cosphig(ipg)**2))
      rgbifou(itg,ipg) = 
     & dis*sintheg(itg)*cosphig(ipg) + 
     & dsqrt(radint**2-dis**2*(1.0d0-sintheg(itg)**2*cosphig(ipg)**2))
      hrgbifin(itg,ipg) = rgbifin(itg,ipg)
      hrgbifou(itg,ipg) = rgbifou(itg,ipg)
      do 11 irg = 0, nrtot-1
      if (rgbifin(itg,ipg).ge.rg(irg)-small.and.
     &    rgbifin(itg,ipg).lt.rg(irg+1)-small) irgbiin(itg,ipg)=irg 
      if (rgbifou(itg,ipg).gt.rg(irg)+small.and.
     &    rgbifou(itg,ipg).le.rg(irg+1)+small) irgbiou(itg,ipg)=irg+1
      if (hrgbifin(itg,ipg).ge.hrg(irg)-small.and.
     &    hrgbifin(itg,ipg).lt.hrg(irg+1)-small)ihrgbiin(itg,ipg)=irg 
      if (hrgbifou(itg,ipg).gt.hrg(irg)+small.and.
     &    hrgbifou(itg,ipg).le.hrg(irg+1)+small)ihrgbiou(itg,ipg)=irg+1
   11 continue
      end if
   10 continue
c
      do 20 ipg = 0, npg-1
      do 20 irg = 1, nrtot
      itgbi(irg,ipg) = 0
      thgbif(irg,ipg) = 0.0d0
      sth = (rg(irg)**2 + dis**2 - radint**2)
     &     /(2.0d0*dis*rg(irg)*cosphig(ipg))
      if (sth.le.1.0d0) then
      thgbif(irg,ipg) = dasin(sth)
      do 21 itg = 0, ntg-1
      if (thgbif(irg,ipg).ge.thg(itg).and.
     &    thgbif(irg,ipg).lt.thg(itg+1)) itgbi(irg,ipg) = itg
   21 continue
      end if
c
      ihtgbi(irg,ipg) = 0
      hthgbif(irg,ipg) = 0.0d0
      sth = (hrg(irg)**2 + dis**2 - radint**2)
     &     /(2.0d0*dis*hrg(irg)*cosphig(ipg))
      if (sth.le.1.0d0) then
      hthgbif(irg,ipg) = dasin(sth)
      do 22 itg = 0, ntg-1
      if (hthgbif(irg,ipg).ge.thg(itg).and.
     &    hthgbif(irg,ipg).lt.thg(itg+1)) ihtgbi(irg,ipg) = itg
   22 continue
      end if
   20 continue
c
      do 30 itg = 1, ntg
      do 30 irg = 1, nrtot
      ipgbiin(irg,itg) = 0
      ipgbiou(irg,itg) = 0
      phigbifin(irg,itg) = 0.0d0
      phigbifou(irg,itg) = 0.0d0
      cphi = (rg(irg)**2 + dis**2 - radint**2)
     &      /(2.0d0*dis*rg(irg)*sintheg(itg))
ctest      if (cphi.le.1.0d0) then
      if (cphi.lt.1.0d0) then
      phigbifou(irg,itg) = dacos(cphi)
      phigbifin(irg,itg) = - dacos(cphi)
      do 31 ipg = 0, npg-1
      if (phigbifou(irg,itg).gt.phig(ipg).and.
     &    phigbifou(irg,itg).le.phig(ipg+1)) ipgbiou(irg,itg)=ipg+1
      if (phigbifin(irg,itg).ge.phig(ipg).and.
     &    phigbifin(irg,itg).lt.phig(ipg+1)) ipgbiin(irg,itg)=ipg
   31 continue
      end if
c
      ihpgbiin(irg,itg) = 0
      ihpgbiou(irg,itg) = 0
      hphigbifin(irg,itg) = 0.0d0
      hphigbifou(irg,itg) = 0.0d0
      cphi = (hrg(irg)**2 + dis**2 - radint**2)
     &      /(2.0d0*dis*hrg(irg)*sintheg(itg))
ctest      if (cphi.le.1.0d0) then
      if (cphi.lt.1.0d0) then
      hphigbifou(irg,itg) = dacos(cphi)
      hphigbifin(irg,itg) = - dacos(cphi)
      do 32 ipg = 0, npg-1
      if (hphigbifou(irg,itg).gt.phig(ipg).and.
     &    hphigbifou(irg,itg).le.phig(ipg+1)) ihpgbiou(irg,itg)=ipg+1
      if (hphigbifin(irg,itg).ge.phig(ipg).and.
     &    hphigbifin(irg,itg).lt.phig(ipg+1)) ihpgbiin(irg,itg)=ipg
   32 continue
      end if
   30 continue
c
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = 0, nrtot
c
      rgb1(irg,itg,ipg) = 0.0d0
      thgb1(irg,itg,ipg) = 0.0d0
      phigb1(irg,itg,ipg) = 0.0d0
      rgb2(irg,itg,ipg) = 0.0d0
      thgb2(irg,itg,ipg) = 0.0d0
      phigb2(irg,itg,ipg) = 0.0d0
c
cz      if (irg.gt.irgbiin(itg,ipg).and.irg.lt.irgbiou(itg,ipg)) go to 41
      x0 = rg(irg)*sintheg(itg)*cosphig(ipg)
      y0 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z0 = rg(irg)*costheg(itg)
c
      small = 0.0d0
      if(rg(irg)**2+dis**2-2.0d0*rg(irg)*dis*sintheg(itg)*cosphig(ipg).
     &   le.0.0d0) small = 1.0d-14
      rgb1(irg,itg,ipg) = dsqrt(rg(irg)**2 + small + dis**2
     &                  - 2.0d0*rg(irg)*dis*sintheg(itg)*cosphig(ipg))
      thgb1(irg,itg,ipg) = datan2(sqrt((x0 - dis)**2 + y0**2),z0)
      if (x0-dis.ne.0.0d0)
     &phigb1(irg,itg,ipg) = dmod(2.0d0*pi+datan2(y0,x0 - dis),2.0d0*pi)
cxx      phigb1(irg,itg,ipg) = datan2(y0,x0 - dis)
c
      rgb2(irg,itg,ipg) = dsqrt(rg(irg)**2 + dis**2 
     &                  + 2.0d0*rg(irg)*dis*sintheg(itg)*cosphig(ipg))
      thgb2(irg,itg,ipg) = datan2(sqrt((x0 + dis)**2 + y0**2),z0)
      if (x0+dis.ne.0.0d0) 
     &phigb2(irg,itg,ipg) = dmod(2.0d0*pi+datan2(y0,x0 + dis),2.0d0*pi)
cxx      phigb2(irg,itg,ipg) = datan2(y0,x0 + dis)
c
   41 continue
   40 continue
c
cc      irg = 10
cc      do itg = 0, ntg
cc      do ipg = 0, npg
cc      write(6,999) irg,itg,ipg,
cc     & rgb1(irg,itg,ipg),thgb1(irg,itg,ipg),phigb1(irg,itg,ipg)
cc      end do 
cc      end do 
cc 999  format(3i5,1p,3e14.6)
cc       stop
c
      ntgmin = ntg
      do 48 irg = 0, nrtot
      if (itgbi(irg,0).gt.0) ntgmin = min0(itgbi(irg,0),ntgmin)
   48 continue
      npgmin = npg
      npgmax = 0
      do 49 irg = 0, nrtot
      if (ipgbiin(irg,ntg).gt.0) npgmin = min0(ipgbiin(irg,ntg),npgmin)
      npgmax = max0(ipgbiou(irg,ntg),npgmax)
   49 continue
      write(6,*) 'ntgmin = ', ntgmin
      write(6,*) 'npgmin = ', npgmin, ',     npgmax = ',npgmax
c
c --  weight of integlation for volume integral in GR coordinate.
c
      san = 1.0d0/3.0d0
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
c
      ir0in = ihrgbiin(itg,ipg)
      rvin = hrgbifin(itg,ipg)
      r0in = rg(ir0in)
      dr0in = rvin - r0in
      ir0ou = ihrgbiou(itg,ipg)
      rvou = hrgbifou(itg,ipg)
      r0ou = rg(ir0ou-1)
      dr0ou = r0ou - rvou
c
      do 100 irg = 1, nrtot
c
      wgr = w4drg(irg)
      wgt = w4dtg(itg)
      wgp = w4dpg(ipg)
      if(irg.gt.ihrgbiin(ntg,npgxz).and.irg.lt.ihrgbiou(ntg,npgxz))then
      wgr = wgdrg(irg)
      wgt = wgdtg(itg)
      wgp = wgdpg(ipg)
      end if
cxx      if (irg.gt.ihrgbiin(itg,ipg).and.irg.lt.ihrgbiou(itg,ipg).and.
cxx     &    itg.gt.ihtgbi(irg,ipg).and.ipg.lt.ihpgbi(irg,itg)) then
      if (irg.gt.ihrgbiin(itg,ipg).and.irg.lt.ihrgbiou(itg,ipg)) then
      wgr = 0.0d0
      wgt = 0.0d0
      wgp = 0.0d0
      go to 101
      end if
c
ctesttest
      go to 101
ctesttest
      itmod = mod(itg,2)
      it0 = ihtgbi(irg,ipg)
      thv = hthgbif(irg,ipg)
      th0 = thg(it0)
      dt0 = thv - th0
      ipmod = mod(ipg,2)
      ip0 = ihpgbi(irg,itg)
      phiv = hphigbif(irg,itg)
      phi0 = phig(ip0)
      dp0 = phi0 - phiv
c     
      if (irg.eq.ihrgbiin(itg,ipg).and.ihrgbiin(itg,ipg).ne.0) 
     &                              wgr = hrg(irg)**2*(drg(irg)+dr0in)
      if (irg.eq.ihrgbiou(itg,ipg).and.ihrgbiou(itg,ipg).ne.0) 
     &                              wgr = hrg(irg)**2*(drg(irg)+dr0ou)
      if (ihtgbi(irg,ipg).ne.0) then
      if (itg.eq.ihtgbi(irg,ipg).and.itmod.eq.0)
     &                              wgt = sintheg(itg)*(san*dthg+dt0)
      if (itg.eq.ihtgbi(irg,ipg).and.itmod.eq.1) 
     &                              wgt = sintheg(itg)*(0.5d0*dthg+dt0)
      if (itg.eq.ihtgbi(irg,ipg)-1.and.itmod.eq.0)
     &                              wgt = sintheg(itg)*(0.5d0+san)*dthg
      end if
      if (ihpgbi(irg,itg).ne.0) then
      if (ipg.eq.ihpgbi(irg,itg).and.ipmod.eq.0) wgp=san*dphig + dp0
      if (ipg.eq.ihpgbi(irg,itg).and.ipmod.eq.1) wgp=0.5d0*dphig + dp0
      if (ipg.eq.ihpgbi(irg,itg)+1.and.ipmod.eq.0)wgp=(0.5d0+san)*dphig
      end if
 101  continue
      wmrtpg(irg,itg,ipg) = wgr*wgt*wgp
cc      write(6,102) irg,itg,ipg,wmrtpg(irg,itg,ipg), wgrtpg(irg,itg,ipg)     
cc      if (irg.eq.2.and.itg.eq.13.and.ipg.eq.1)then
cc      write(6,104)  wgdrg(irg) , wgdtg(itg), wgdpg(ipg)  
cc      write(6,104)       wgr ,  wgt,    wgp
cc      write(6,*)ihpgbi(irg,itg)
cc       stop
cc       end if
 100  continue
cc 102  format(3i4,1p,2e17.9)
cc 104  format(1p,3e17.9)
c
c --- Values for extended BH coodinate in GR coordinate, bing. 
c --- bing(0,itb,ipb) is on the interface.  extend 2 points.
c
      do 50 ii = 1, 5
      rbex(ii) = radext + drb(nrb)*(dble(ii)-3.0d0)
ctest      rbex(ii) = rb(nrb) + 0.5d0*drb(nrb)*(dble(ii)-3.0d0)
ctest      rbex(ii) = radext + drb(nrb)*(dble(ii)-5.0d0)
ctest      rbex(ii) = rb(nrb) + drb(nrb)*(dble(ii)-1.0d0)
      rrbb = rbex(ii)
      do 50 ipb = 0, npb
      do 50 itb = 0, ntb
c
      xb = rrbb*sintheb(itb)*cosphib(ipb)
      yb = rrbb*sintheb(itb)*sinphib(ipb)
      zb = rrbb*costheb(itb)
c
      rbing(ii,itb,ipb) = dsqrt((xb + dis)**2 + yb**2 + zb**2)
      thbing(ii,itb,ipb) = datan2(sqrt((xb + dis)**2 + yb**2),zb)
      phibing(ii,itb,ipb) = datan2(yb,xb + dis)
c
   50 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bbherror(backb,rnewb,backg,rnewg,epsmaxb,epsmaxg,
     &                    irber,itber,ipber,irger,itger,ipger)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'common_blocks/GR_BHNS_cobh.f' 
      include 'common_blocks/GR_BHNS_cogra.f' 
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg), 
     &                 irgbiou(0:nntg,0:nnpg), 
     &                 itgbi(0:nnrg,0:nnpg), 
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      dimension rnewb(0:nnrb,0:nntb,0:nnpb),backb(0:nnrb,0:nntb,0:nnpb)
      dimension rnewg(0:nnrg,0:nntg,0:nnpg),backg(0:nnrg,0:nntg,0:nnpg)
c
c --- Set improved values for quantities on GR-coordinate and 
c --- convergence check.  
c
      epsmaxb = 0.0d0
      do 400 ipb = 0, npb
      do 400 itb = 0, ntb
      do 400 irb = 1, nrb
      edet  = rnewb(irb,itb,ipb)
      edetb = backb(irb,itb,ipb)
      devi  = dabs(rnewb(irb,itb,ipb)) + dabs(backb(irb,itb,ipb))
c      
      if (irb.le.nrb.and.devi.ge.1.0d-8) then
      error = dabs(2.d0*(edet - edetb))/devi
      if(error .gt. epsmaxb) then
      epsmaxb = error
      irber = irb
      itber = itb
      ipber = ipb
      end if
      end if
 400  continue
c
      epsmaxg = 0.0d0
      do 401 ipg = 0, npg
      do 401 itg = 0, ntg
      do 401 irg = 0, nrtot
      if(irg.gt.irgbiin(itg,ipg).and.irg.lt.irgbiou(itg,ipg))go to 401
      edet  = rnewg(irg,itg,ipg)
      edetb = backg(irg,itg,ipg)
      devi  = dabs(rnewg(irg,itg,ipg)) + dabs(backg(irg,itg,ipg))
c      
      if (irg.le.nrin.and.devi.ge.1.0d-8) then
      error = dabs(2.d0*(edet - edetb))/devi
      if(error .gt. epsmaxg) then
      epsmaxg = error
      irger = irg
      itger = itg
      ipger = ipg
      end if
      end if
 401  continue
c
      end 
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine clear_shift
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
c
      do 101 ipg = 0, npg
      do 101 itg = 0, ntg
      do 101 irg = 0, nrtot
      bvxd(irg,itg,ipg) = 0.0d0
      bvyd(irg,itg,ipg) = 0.0d0
      bvzd(irg,itg,ipg) = 0.0d0
 101  continue
      do 102 ipb = 0, npb
      do 102 itb = 0, ntb
      do 102 irb = nrb0, nrb
      bvxdb(irb,itb,ipb) = 0.0d0
      bvydb(irb,itb,ipb) = 0.0d0
      bvzdb(irb,itb,ipb) = 0.0d0
 102  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine al2alps
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
c --  set alps
c
      do 101 ipg = 0, npg
      do 101 itg = 0, ntg
      do 101 irg = 0, nrtot
      alps(irg,itg,ipg) = alph(irg,itg,ipg)*psi(irg,itg,ipg)
  101 continue
      do 102 ipb = 0, npb
      do 102 itb = 0, ntb
      do 102 irb = 0, nrb
      alpsb(irb,itb,ipb) = alphb(irb,itb,ipb)*psib(irb,itb,ipb)
  102 continue
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine alps2al
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg), 
     &                 irgbiou(0:nntg,0:nnpg), 
     &                 itgbi(0:nnrg,0:nnpg), 
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
c --  set alpha
c
      do 103 ipg = 0, npg
      do 103 itg = 0, ntg
      do 103 irg = 0, nrtot
      if (irg.gt.irgbiin(itg,ipg).and. 
     &    irg.lt.irgbiou(itg,ipg)) go to 103
      alph(irg,itg,ipg) = alps(irg,itg,ipg)/psi(irg,itg,ipg)
calph      alps(irg,itg,ipg) = alph(irg,itg,ipg)*psi(irg,itg,ipg)
  103 continue
      do 104 ipb = 0, npb
      do 104 itb = 0, ntb
      do 104 irb = 0, nrb
      alphb(irb,itb,ipb) = alpsb(irb,itb,ipb)/psib(irb,itb,ipb)
cexci      if (alphb(irb,itb,ipb).le.0.0d0) alphb(irb,itb,ipb) = 1.0d-8
calph      alpsb(irb,itb,ipb) = alphb(irb,itb,ipb)*psib(irb,itb,ipb)
 104  continue
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bvu2d
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_shift_grav.f'
c
c --- Lowering index of shift.  
c
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = 0, nrtot
      gmxxd = 1.0d0 + 0.0d0
      gmxyd =         0.0d0
      gmxzd =         0.0d0
      bvxd(irg,itg,ipg) = gmxxd*bvxu(irg,itg,ipg)
     &                  + gmxyd*bvyu(irg,itg,ipg)
     &                  + gmxzd*bvzu(irg,itg,ipg)
   40 continue
c
      do 41 ipg = 0, npg
      do 41 itg = 0, ntg
      do 41 irg = 0, nrtot
      gmyxd =         0.0d0
      gmyyd = 1.0d0 + 0.0d0
      gmyzd =         0.0d0
      bvyd(irg,itg,ipg) = gmyxd*bvxu(irg,itg,ipg)
     &                  + gmyyd*bvyu(irg,itg,ipg)
     &                  + gmyzd*bvzu(irg,itg,ipg)
   41 continue
c
      do 42 ipg = 0, npg
      do 42 itg = 0, ntg
      do 42 irg = 0, nrtot
      gmzxd =         0.0d0
      gmzyd =         0.0d0
      gmzzd = 1.0d0 + 0.0d0
      bvzd(irg,itg,ipg) = gmzxd*bvxu(irg,itg,ipg)
     &                  + gmzyd*bvyu(irg,itg,ipg)
     &                  + gmzzd*bvzu(irg,itg,ipg)
   42 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bvd2u
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_shift_grav.f'
      include 'common_blocks/CB_shift_bh.f'
c
c --- Rasing index of shift.  
c
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = 0, nrtot
      gmxxu = 1.0d0 + 0.0d0
      gmxyu =         0.0d0
      gmxzu =         0.0d0
      bvxu(irg,itg,ipg) = gmxxu*bvxd(irg,itg,ipg)
     &                  + gmxyu*bvyd(irg,itg,ipg)
     &                  + gmxzu*bvzd(irg,itg,ipg)
   40 continue
c
      do 41 ipg = 0, npg
      do 41 itg = 0, ntg
      do 41 irg = 0, nrtot
      gmyxu =         0.0d0
      gmyyu = 1.0d0 + 0.0d0
      gmyzu =         0.0d0
      bvyu(irg,itg,ipg) = gmyxu*bvxd(irg,itg,ipg)
     &                  + gmyyu*bvyd(irg,itg,ipg)
     &                  + gmyzu*bvzd(irg,itg,ipg)
   41 continue
c
      do 42 ipg = 0, npg
      do 42 itg = 0, ntg
      do 42 irg = 0, nrtot
      gmzxu =         0.0d0
      gmzyu =         0.0d0
      gmzzu = 1.0d0 + 0.0d0
      bvzu(irg,itg,ipg) = gmzxu*bvxd(irg,itg,ipg)
     &                  + gmzyu*bvyd(irg,itg,ipg)
     &                  + gmzzu*bvzd(irg,itg,ipg)
   42 continue
c
c
c --- Rasing index of shift BHCS.  
c
      do 400 ipb = 0, npb
      do 400 itb = 0, ntb
      do 400 irb = 0, nrb
      gmxxu = 1.0d0 + 0.0d0
      gmxyu =         0.0d0
      gmxzu =         0.0d0
      bvxub(irb,itb,ipb) = gmxxu*bvxdb(irb,itb,ipb)
     &                   + gmxyu*bvydb(irb,itb,ipb)
     &                   + gmxzu*bvzdb(irb,itb,ipb)
  400 continue
c
      do 410 ipb = 0, npb
      do 410 itb = 0, ntb
      do 410 irb = 0, nrb
      gmyxu =         0.0d0
      gmyyu = 1.0d0 + 0.0d0
      gmyzu =         0.0d0
      bvyub(irb,itb,ipb) = gmyxu*bvxdb(irb,itb,ipb)
     &                   + gmyyu*bvydb(irb,itb,ipb)
     &                   + gmyzu*bvzdb(irb,itb,ipb)
  410 continue
c
      do 420 ipb = 0, npb
      do 420 itb = 0, ntb
      do 420 irb = 0, nrb
      gmzxu =         0.0d0
      gmzyu =         0.0d0
      gmzzu = 1.0d0 + 0.0d0
      bvzub(irb,itb,ipb) = gmzxu*bvxdb(irb,itb,ipb)
     &                   + gmzyu*bvydb(irb,itb,ipb)
     &                   + gmzzu*bvzdb(irb,itb,ipb)
  420 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bv2ov
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
c
c --- shift to rotating shift.  
c
      do 39 ipg = 0, npg
      do 39 itg = 0, ntg
      do 39 irg = 0, nrtot
      vphixg = - rg(irg)*sintheg(itg)*sinphig(ipg)
      vphiyg = - orbc + rg(irg)*sintheg(itg)*cosphig(ipg)
      vphizg = 0.0d0
      bvxgc = bvxu(irg,itg,ipg)
      bvygc = bvyu(irg,itg,ipg)
      bvzgc = bvzu(irg,itg,ipg)
      ovxu(irg,itg,ipg) = bvxgc + ome*vphixg
      ovyu(irg,itg,ipg) = bvygc + ome*vphiyg
      ovzu(irg,itg,ipg) = bvzgc + ome*vphizg
   39 continue
c
c --- Lowering index of rotating shift.  
c
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = 0, nrtot
      gmxxd = 1.0d0 + 0.0d0
      gmxyd =         0.0d0
      gmxzd =         0.0d0
      ovxd(irg,itg,ipg) = gmxxd*ovxu(irg,itg,ipg)
     &                  + gmxyd*ovyu(irg,itg,ipg)
     &                  + gmxzd*ovzu(irg,itg,ipg)
   40 continue
c
      do 41 ipg = 0, npg
      do 41 itg = 0, ntg
      do 41 irg = 0, nrtot
      gmyxd =         0.0d0
      gmyyd = 1.0d0 + 0.0d0
      gmyzd =         0.0d0
      ovyd(irg,itg,ipg) = gmyxd*ovxu(irg,itg,ipg)
     &                  + gmyyd*ovyu(irg,itg,ipg)
     &                  + gmyzd*ovzu(irg,itg,ipg)
   41 continue
c
      do 42 ipg = 0, npg
      do 42 itg = 0, ntg
      do 42 irg = 0, nrtot
      gmzxd =         0.0d0
      gmzyd =         0.0d0
      gmzzd = 1.0d0 + 0.0d0
      ovzd(irg,itg,ipg) = gmzxd*ovxu(irg,itg,ipg)
     &                  + gmzyd*ovyu(irg,itg,ipg)
     &                  + gmzzd*ovzu(irg,itg,ipg)
   42 continue
c
c
c --- shift to rotating shift BHCS.  
c
      do 390 ipb = 0, npb
      do 390 itb = 0, ntb
      do 390 irb = 0, nrb
      vphixb = - rb(irb)*sintheb(itb)*sinphib(ipb)
      vphiyb = dis - orbc + rb(irb)*sintheb(itb)*cosphib(ipb)
      vphizb = 0.0d0
      bvxbc = bvxub(irb,itb,ipb)
      bvybc = bvyub(irb,itb,ipb)
      bvzbc = bvzub(irb,itb,ipb)
      ovxub(irb,itb,ipb) = bvxbc + ome*vphixb
      ovyub(irb,itb,ipb) = bvybc + ome*vphiyb
      ovzub(irb,itb,ipb) = bvzbc + ome*vphizb
  390 continue
c
c --- Lowering index of rotating shift.  
c
      do 400 ipb = 0, npb
      do 400 itb = 0, ntb
      do 400 irb = 0, nrb
      gmxxd = 1.0d0 + 0.0d0
      gmxyd =         0.0d0
      gmxzd =         0.0d0
      ovxdb(irb,itb,ipb) = gmxxd*ovxub(irb,itb,ipb)
     &                   + gmxyd*ovyub(irb,itb,ipb)
     &                   + gmxzd*ovzub(irb,itb,ipb)
  400 continue
c
      do 410 ipb = 0, npb
      do 410 itb = 0, ntb
      do 410 irb = 0, nrb
      gmyxd =         0.0d0
      gmyyd = 1.0d0 + 0.0d0
      gmyzd =         0.0d0
      ovydb(irb,itb,ipb) = gmyxd*ovxub(irb,itb,ipb)
     &                   + gmyyd*ovyub(irb,itb,ipb)
     &                   + gmyzd*ovzub(irb,itb,ipb)
  410 continue
c
      do 420 ipb = 0, npb
      do 420 itb = 0, ntb
      do 420 irb = 0, nrb
      gmzxd =         0.0d0
      gmzyd =         0.0d0
      gmzzd = 1.0d0 + 0.0d0
      ovzdb(irb,itb,ipb) = gmzxd*ovxub(irb,itb,ipb)
     &                   + gmzyd*ovyub(irb,itb,ipb)
     &                   + gmzzd*ovzub(irb,itb,ipb)
  420 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine physq_bh(istat,iseq,chgra)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_intpp.f'
      include 'common_blocks/CB_param_bhphy.f'
      include 'common_blocks/CB_param_flphy.f'
      include 'common_blocks/CB_weight_grav.f'
c
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, iwrite
      common / trmpg / sinmpg(0:nnlg,0:nnpg), cosmpg(0:nnlg,0:nnpg)
c
      common / flusw / swflu
c
      common / dbegr / divbg(0:nnrg,0:nntg,0:nnpg)
c
      dimension aij(3,3), gamd(3,3), gamu(3,3), ric(3,3), vphig(3), 
     &          dpsiu(3), dpsid(3), dalpd(3), dhu(3,3,3)
      dimension rna(3), gradpsi(3), gradalp(3), cri(3,3,3)
      dimension snvd(3), snvu(3), grad1(3)
      dimension gradbv(3,3), gradbx(3), gradby(3), gradbz(3),
     &          cdbvd(3,3), baij(3,3), aiju(3,3)
c
      character*1 chrot,chbhs,chgra, chope
c
      if (iseq.eq.1) then
      open(10,file='bbhphy.dat',status='old')
      open(11,file='bbhphydp.dat',status='old')
      open(31,file='bbhphyplot.dat',status='old')
      open(34,file='bbhasym.dat',status='old')
      end if
      if (istat.eq.2) write(10,*) ' == Solution does not converge. == '
c
      call admmass(1)
      call find_aharea(aharea,ahmass)
c
      call puncutre_velocity(0)
c      
      sepa = sepato
      write(10,4001) nrf, ngdin, dis, orbc, pinx, cutfac
      write(10,4000) ome/radi*fitadm, radi, ber, emdc, emdmx
      write(10,4000) fitvir, fitadm, fitkom, fitang, fitpy
      write(10,4000) omephi, bvyubh, ahores, restmass
      write(10,4000) aharea, ahmass, ahores/ahmass, ratmas
c
      write(6,4001) nrf, ngdin, dis, orbc, pinx, cutfac
      write(6,4000) ome/radi*fitadm, radi, ber, emdc, emdmx
      write(6,4000) fitvir, fitadm, fitkom, fitang, fitpy
      write(6,4000) omephi, bvyubh, ahores, restmass
      write(6,4000) aharea, ahmass, ahores/ahmass, ratmas
 4000 format(1p,6e14.6)
 4001 format(2i7, 1p,6e14.6)
 4002 format(3i7,7x,1p,e14.6)
c
      write(11,4005) nrf, ngdin, nrfdmx, za, sepa, pinx, cutfac
      write(11,4004) ome/radi, radi, ber
      write(11,4004) emdc, emdmx, ddmax
      write(11,4004) ahores, ahoadm, ahoang
      write(11,4004) ahokom, ahodgs, ahovc 
      write(11,4004) resmas, admmas, angmom
      write(11,4004) rkomas, dgsepa, virial
      write(11,4004) ahoafl, amomfl, ahokom2
      write(11,4004) fitadm, fitkom,  fitvir
      write(11,4004) aharea, ahmass, ratmas
      write(11,4004) restmass, gravmass
 4005 format(3i6, 1p,6e12.4)
 4004 format(1p,3e23.15)
c
      write(31,4045) nrf, ngdin, nrfdmx, 2.0d0*sepa, sepa, 
     &               ome/radi, ome/radi*2.0d0*gravmass, 
     &               radi, ber, 
     &               emdc, emdmx, ddmax,
     &               ahores, ahoadm, ahoang,
     &               ahokom, ahodgs, ahovc,
     &               resmas, admmas, angmom,
     &               rkomas, dgsepa, virial,
     &               ahoafl, amomfl, asyadm, asykom, ahokom2, 
     &               fitadm, fitkom, fitvir, 
     &               aharea, ahmass, ratmas
 4045 format(3i6, 1p,40e16.8)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subio(istat,iseq,char)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, iwrite
c
ctest
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
ctest
      dimension gamd(3,3), gamu(3,3)
c
      character*4 char
      character*3 moji
c
c ------------------------------------------------------------
c     istat = 0 and iseq 0 -> open ini file and close it. 
c     istat = 1            -> open las file and close it.
c     istat = 2            -> open nxt file and close it.
c ------------------------------------------------------------
c
      if (istat.eq.0.and.iseq.eq.0) then
      moji = 'ini'
      open(3,file='bbhgra.'//moji,status='old')
      end if
      if (istat.eq.1) then
      moji = 'las'
      open(3,file='bbhgra.'//moji,status='old')
      end if
      if (istat.eq.2) then
      moji = 'nxt'
      open(3,file='bbhgra.'//moji,status='old')
      end if
c
c -------------
c --- Test. ---
c -------------
c
      if (istat.eq.-1) then
c
ctest      call bhcenter
      bhdis = dis
      write(6,*) '   dis = ',dis
      write(6,*) ' bhdis = ',bhdis
c
      fac112 = 1.0d0/12.0d0
      facm13 = -1.0d0/3.0d0
      do 20 ipg = 0, npg
      do 20 itg = 0, ntg
      do 20 irg = 0, nrtot
c
      x1 = rg(irg)*sintheg(itg)*cosphig(ipg) - bhdis
      y1 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z1 = rg(irg)*costheg(itg)
      x2 = rg(irg)*sintheg(itg)*cosphig(ipg) + bhdis
      y2 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z2 = rg(irg)*costheg(itg)
c
       if (x1**2+y1**2+z1**2.le.rb(0)**2) go to 20
c
ck      call kerrschildmet(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
ck     &  gamd,gamu,hm1,hm2,elx1,ely1,elz1,elx2,ely2,elz2,gksdet,pat,pat)
c
ck      bxd = 2.0d0*hm1*elx1 + 2.0d0*hm2*elx2
ck      byd = 2.0d0*hm1*ely1 + 2.0d0*hm2*ely2
ck      bzd = 2.0d0*hm1*elz1 + 2.0d0*hm2*elz2
ck      bvbv =(gamu(1,1)*bxd*bxd + gamu(1,2)*bxd*byd + gamu(1,3)*bxd*bzd
ck     &     + gamu(2,1)*byd*bxd + gamu(2,2)*byd*byd + gamu(2,3)*byd*bzd
ck     &     + gamu(3,1)*bzd*bxd + gamu(3,2)*bzd*byd + gamu(3,3)*bzd*bzd)
ck     &     * gksdet**(-1.0d0/3.0d0)
c
      psi(irg,itg,ipg) = 1.0d0
      alph(irg,itg,ipg) = 1.0d0
      bvxd(irg,itg,ipg) = 0.0d0
      bvyd(irg,itg,ipg) = 0.0d0
      bvzd(irg,itg,ipg) = 0.0d0
c
   20 continue
c
      do 21 ipb = 0, npb
      do 21 itb = 0, ntb
      do 21 irb = nrb0, nrb
c
      x1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - bhdis
      y1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z1 = rb(irb)*costheb(itb)
      x2 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis + bhdis
      y2 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z2 = rb(irb)*costheb(itb)
c
ck      call kerrschildmet(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
ck     &  gamd,gamu,hm1,hm2,elx1,ely1,elz1,elx2,ely2,elz2,gksdet,pat,pat)
c
ck      bxd = 2.0d0*hm1*elx1 + 2.0d0*hm2*elx2
ck      byd = 2.0d0*hm1*ely1 + 2.0d0*hm2*ely2
ck      bzd = 2.0d0*hm1*elz1 + 2.0d0*hm2*elz2
ck      bvbv =(gamu(1,1)*bxd*bxd + gamu(1,2)*bxd*byd + gamu(1,3)*bxd*bzd
ck     &     + gamu(2,1)*byd*bxd + gamu(2,2)*byd*byd + gamu(2,3)*byd*bzd
ck     &     + gamu(3,1)*bzd*bxd + gamu(3,2)*bzd*byd + gamu(3,3)*bzd*bzd)
ck     &     * gksdet**facm13
c
      psib(irb,itb,ipb) = 1.0d0
      alphb(irb,itb,ipb) = 1.0d0
      bvxdb(irb,itb,ipb) = 0.0d0
      bvydb(irb,itb,ipb) = 0.0d0
      bvzdb(irb,itb,ipb) = 0.0d0
ck      if (ipb.eq.0.and.itb.eq.ntb.and.irb.le.0)
ck     &write(6,*)irb,  psib(irb,itb,ipb),elx1,ely1,elz1,gksdet
c
   21 continue
c
      end if
c
c -------------
c --- Read. ---
c -------------
c
      if (istat.eq.0) then
c
c --- Metric potentials.  
c
      read(3,5000) idum
      read(3,5000) idum,idum,nrtotcur
      read(3,5000) idum
      read(3,5000) idum
      read(3,5001)  dum
      read(3,5000) idum
      read(3,5000) idum
      read(3,5001)  dum
      read(3,5000) idum
      read(3,5001)  dum
      read(3,5001)  dum
      read(3,5001)  dum
c
      read(3,4000) ome, ber, radi, orbc
c
c --  BH coordinate
      do 200 ipb = 0, npb
      do 200 itb = 0, ntb
      read(3,4000) ( psib(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (alphb(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (bvxdb(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (bvydb(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (bvzdb(irb,itb,ipb), irb = 0, nrb)
 200  continue
c
c --  skip reading GR on CCS
      if (itype.eq.1) go to 2000
c
c --  GR coordinate
      do 201 ipg = 0, npg
      do 201 itg = 0, ntg
      read(3,4000) ( psi(irg,itg,ipg), irg = 0, nrtotcur)
      read(3,4000) (alph(irg,itg,ipg), irg = 0, nrtotcur)
      read(3,4000) (bvxd(irg,itg,ipg), irg = 0, nrtotcur)
      read(3,4000) (bvyd(irg,itg,ipg), irg = 0, nrtotcur)
      read(3,4000) (bvzd(irg,itg,ipg), irg = 0, nrtotcur)
 201  continue
c      
      if (nrtot.gt.nrtotcur) then
      do 211 ipg = 0, npg
      do 211 itg = 0, ntg
      do 211 irg = nrtotcur + 1, nrtot
      psi(irg,itg,ipg) = psi(nrtotcur,itg,ipg)
      alph(irg,itg,ipg) = alph(nrtotcur,itg,ipg)
      bvxd(irg,itg,ipg) = bvxd(nrtotcur,itg,ipg)
      bvyd(irg,itg,ipg) = bvyd(nrtotcur,itg,ipg)
      bvzd(irg,itg,ipg) = bvzd(nrtotcur,itg,ipg)
 211  continue
      end if
c
 2000 continue
c
      if (itype.eq.1) then
c
      do 209 ipg = 0, npg
      do 209 itg = 0, ntg
      do 209 irg = 0, nrtot
      psi(irg,itg,ipg) = 0.0d0
      alph(irg,itg,ipg) = 1.0d0
      bvxd(irg,itg,ipg) = 0.0d0
      bvyd(irg,itg,ipg) = 0.0d0
      bvzd(irg,itg,ipg) = 0.0d0
  209 continue
c
      end if
c
      do 202 ipb = 0, npb
      do 202 itb = 0, ntb
      do 202 irb = 0, nrb
      psib(irb,itb,ipb) = 1.0d0 + psib(irb,itb,ipb)
 202  continue
c
      do 204 ipg = 0, npg
      do 204 itg = 0, ntg
      do 204 irg = 0, nrtot
      psi(irg,itg,ipg) = 1.0d0 + psi(irg,itg,ipg)
 204  continue
c
      close(3)
c
      end if
c
c --------------
c --- Write. ---
c --------------
c
      if (istat.eq.1.or.istat.eq.2) then
c
c --- Metric potentials.  
c
      write(3,5000) nrb, ntb, npb, nlb
      write(3,5000) nrbov, msymb, nrtot
      write(3,5000) ntg, npg, nlg, msymg
      write(3,5005) ngdin, nrout, rvout
      write(3,5001) ding, radint
      write(3,5002) itmx, eps, convf
      write(3,5005) iddd, numseq, bhcop
      write(3,5001) fffac,ffvep 
      write(3,5004) itype, iwrite, char
      write(3,5010) bhrad, bhmass, bhspin
      write(3,5010) ome,   patfac
      write(3,5011) disinc, bhfac, numseq
c
      write(3,4000) ome, ber, radi, orbc
c
c --  BH coordinate
      do 500 ipb = 0, npb
      do 500 itb = 0, ntb
      write(3,4000) ( psib(irb,itb,ipb)-1.0d0, irb = 0, nrb)
      write(3,4000) (alphb(irb,itb,ipb), irb = 0, nrb)
      write(3,4000) (bvxdb(irb,itb,ipb), irb = 0, nrb)
      write(3,4000) (bvydb(irb,itb,ipb), irb = 0, nrb)
      write(3,4000) (bvzdb(irb,itb,ipb), irb = 0, nrb)
 500  continue
c
c --  GR coordinate
      do 501 ipg = 0, npg
      do 501 itg = 0, ntg
      write(3,4000) (psi(irg,itg,ipg)-1.0d0, irg = 0, nrtot)
      write(3,4000) (alph(irg,itg,ipg), irg = 0, nrtot)
      write(3,4000) (bvxd(irg,itg,ipg), irg = 0, nrtot)
      write(3,4000) (bvyd(irg,itg,ipg), irg = 0, nrtot)
      write(3,4000) (bvzd(irg,itg,ipg), irg = 0, nrtot)
 501  continue
c
      close(3)
c
      end if
c
 1000 continue
 4000 format(1p,6e12.4)
 4999 format(' ')
c
 5000 format( 5i5)
 5001 format( 1p,2e10.3)
 5002 format( 1i5, 1p,2e10.3)
 5003 format( 1p,1e10.3, 1i4)
 5004 format( 2i5, 3x, a4)
 5005 format( 2i5, 1p,1e10.3)
 5010 format(1p,3e10.3)
 5011 format(1p,2e10.3,2i5)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine change_grsize(nrtotcur)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/CB_bwvec_grav.f'
      include 'common_blocks/CB_bbvec_grav.f'
c
c      
      if (nrtot.gt.nrtotcur) then
      do 211 ipg = 0, npg
      do 211 itg = 0, ntg
      do 211 irg = nrtotcur + 1, nrtot
      psi(irg,itg,ipg) = psi(nrtotcur,itg,ipg)
      alph(irg,itg,ipg) = alph(nrtotcur,itg,ipg)
      alps(irg,itg,ipg) = alps(nrtotcur,itg,ipg)
      alps2(irg,itg,ipg) = alps2(nrtotcur,itg,ipg)
c
      bvxd(irg,itg,ipg) = bvxd(nrtotcur,itg,ipg)
      bvyd(irg,itg,ipg) = bvyd(nrtotcur,itg,ipg)
      bvzd(irg,itg,ipg) = bvzd(nrtotcur,itg,ipg)
      bvxu(irg,itg,ipg) = bvxu(nrtotcur,itg,ipg)
      bvyu(irg,itg,ipg) = bvyu(nrtotcur,itg,ipg)
      bvzu(irg,itg,ipg) = bvzu(nrtotcur,itg,ipg)
c
      ovxd(irg,itg,ipg) = ovxd(nrtotcur,itg,ipg)
      ovyd(irg,itg,ipg) = ovyd(nrtotcur,itg,ipg)
      ovzd(irg,itg,ipg) = ovzd(nrtotcur,itg,ipg)
      ovxu(irg,itg,ipg) = ovxu(nrtotcur,itg,ipg)
      ovyu(irg,itg,ipg) = ovyu(nrtotcur,itg,ipg)
      ovzu(irg,itg,ipg) = ovzu(nrtotcur,itg,ipg)
c
      wxd(irg,itg,ipg) = wxd(nrtotcur,itg,ipg)
      wyd(irg,itg,ipg) = wyd(nrtotcur,itg,ipg)
      wzd(irg,itg,ipg) = wzd(nrtotcur,itg,ipg)
c
      bwxd(irg,itg,ipg) = bwxd(nrtotcur,itg,ipg)
      bwyd(irg,itg,ipg) = bwyd(nrtotcur,itg,ipg)
      bwzd(irg,itg,ipg) = bwzd(nrtotcur,itg,ipg)
      bwsd(irg,itg,ipg) = bwsd(nrtotcur,itg,ipg)
      bbxd(irg,itg,ipg) = bbxd(nrtotcur,itg,ipg)
      bbyd(irg,itg,ipg) = bbyd(nrtotcur,itg,ipg)
      bbzd(irg,itg,ipg) = bbzd(nrtotcur,itg,ipg)
      bbsd(irg,itg,ipg) = bbsd(nrtotcur,itg,ipg)
c
 211  continue
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grimpro(back,rnew,fffac,epsmax,irerr,iterr,iperr)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/CB_mesh_grav.f'
c
      dimension rnew(0:nnrg,0:nntg,0:nnpg),
     &          back(0:nnrg,0:nntg,0:nnpg)
c
c --- Set improved values for quantities on GR-coordinate and 
c --- convergence check.  
c
      epsmax = 0.0d0
      do 401 ipg = 0, npg
      do 401 itg = 0, ntg
      do 401 irg = 0, nrtot
      rnew(irg,itg,ipg) = 
     & fffac*rnew(irg,itg,ipg) + (1.d0-fffac)*back(irg,itg,ipg)
      edet  = rnew(irg,itg,ipg)
      edetb = back(irg,itg,ipg)
      devi  = dabs(rnew(irg,itg,ipg)) + dabs(back(irg,itg,ipg))
c      
      if (irg.le.nrin.and.devi.ge.1.0d-8) then
      error = dabs(2.d0*(edet - edetb))/devi
      if(error .gt. epsmax) then
      epsmax = error
      irerr = irg
      iterr = itg
      iperr = ipg
      end if
      end if
 401  continue
c
      end 
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine minv(aa,bb,nn,nnz)
c
c --- linear equations solver.
c
      implicit real*8(a-h,o-z)
c
      dimension aa(nnz,nnz),bb(nnz)
c
c     solution of sm*aa=ss
      nnp1 = nn + 1
      do 100 ii = 1, nn
      aa(ii,nnp1) = bb(ii)
  100 continue
c
      nnm1 = nn - 1
      do 200 k = 1, nnm1
      kp1 = k + 1
c
      fmax = 1.e-10
cccp      fmax = 0.0
      ifmax = 1
c
      do 300 iia = k, nn
      aab = abs(aa(iia,k))
      if(aab.gt.fmax) then
         fmax = aab
         ifmax = iia
      end if
  300 continue
      if(ifmax.ne.k) then
        sig = 1.0d0
        if(aa(k,k)*aa(ifmax,k).lt.0.) sig = -1.0d0
        do 310 ii = 1, nnp1
        aa(k,ii) = aa(k,ii) + sig*aa(ifmax,ii)
  310   continue
      end if
c
      do 210 j = kp1, nnp1
      aa(k,j) = aa(k,j)/aa(k,k)
  210 continue
      do 220 i = kp1, nn
      do 220 j = kp1, nnp1
      aa(i,j) = aa(i,j) - aa(i,k)*aa(k,j)
  220 continue
c
  200 continue
c
      aa(nn,nnp1) = aa(nn,nnp1)/aa(nn,nn)
      do 250 l = 1, nnm1
      k   = nn - l
      kp1 = k + 1
      do 260 j = kp1, nn
      aa(k,nnp1) = aa(k,nnp1) - aa(k,j)*aa(j,nnp1)
  260 continue
  250 continue
c
      do 500 ii = 1, nn
      bb (ii) = aa(ii,nnp1)
  500 continue
c
      return
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1b(fnc,grad1,irb,itb,ipb,ixysym)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension fnc(nnrb0:nnrb,0:nntb,0:nnpb), 
     &          grad1(3),fr5(5),ft5(5),fp5(5),r5(5),th5(5),phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(irb-2,nrb-4)
      it0 = itb-2
      ip0 = ipb-2
c
      rv = rb(irb)
      tv = thb(itb)
      pv = phib(ipb)
      rrbbinv = rbinv(irb)
c
      tnsym = dble(ixysym)
c
      do 8 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
      ipb0 = ip0 + ii - 1
c
      if (irb.eq.0) then
c
      irba = iabs(irb0)
      irb0sg = isign(1,irb0)
      ipbax = (1-irb0sg)/2*npbxzm + (1+irb0sg)/2*npbxz
      ipbay = (1-irb0sg)/2*npbyzm + (1+irb0sg)/2*npbyz
      facp = dble((1-irb0sg)/2)*tnsym + dble((1+irb0sg)/2)
      r5(ii)  = rb(irba)*dble(irb0sg)
      fr5(ii) = fnc(irba,ntbeq,ipbax)      
      ft5(ii) = fnc(irba,ntbeq,ipbay)
      fp5(ii) = facp*fnc(irba,0,0)
c
      else if (irb.ne.0.and.itb.eq.0) then
c
      irba = iabs(irb0)
      itba = iabs(itb0)
      irb0sg = isign(1,irb0)
      itb0sg = isign(1,itb0)
      ipbax = (1-itb0sg)/2*npbxzm + (1+itb0sg)/2*npbxz
      ipbay = (1-itb0sg)/2*npbyzm + (1+itb0sg)/2*npbyz
      facp = dble((1-irb0sg)/2)*tnsym + dble((1+irb0sg)/2)
      r5(ii)  = rb(irba)*dble(irb0sg)
      th5(ii) = thb(itb) + dthb*dble(ii-3)
      fr5(ii) = fnc(irb,itba,ipbax)      
      ft5(ii) = fnc(irb,itba,ipbay)
      fp5(ii) = facp*fnc(irba,0,0)
c
      else 
c
      irba = iabs(irb0)
      itba = iabs(itb0) - 2*idim(itb0,ntb)
      ipba = mod(ipb0+npb,npb)
      irb0sg = isign(1,irb0)
      itb0sg = isign(1,itb0)
      itbnsg = isign(1,ntb-itb0)
      ipbcx = (1-irb0sg)/2*mod(ipb+npb/2+npb,npb) + (1+irb0sg)/2*ipb
      ipbax = (1-itb0sg)/2*mod(ipb+npb/2+npb,npb) + (1+itb0sg)/2*ipb
      facr = dble((1-irb0sg)/2)*tnsym + dble((1+irb0sg)/2)
      fact = dble((1-itbnsg)/2)*tnsym + dble((1+itbnsg)/2)
      r5(ii)  = rb(irba)*dble(irb0sg)
      th5(ii) = thb(itb) + dthb*dble(ii-3)
      phi5(ii)= phib(ipb) + dphib*dble(ii-3)
      fr5(ii) = facr*fnc(irba,itb,ipbcx)
      ft5(ii) = fact*fnc(irb,itba,ipbax)
      fp5(ii) = fnc(irb,itb,ipba)
c      
      end if
    8 continue
cc 22   format(1p,6e12.4)
cc      if (irb.eq.1.and.itb.eq.20.and.ipb.eq.20) stop
c
c --- To cartesian component.  
c
      if (irb.eq.0) then
      dfdx = dfncdx(r5,fr5,rv)
      dfdy = dfncdx(r5,ft5,rv) 
      dfdz = dfncdx(r5,fp5,rv)
      else if (irb.ne.0.and.itb.eq.0) then
      dfdx = dfncdx(th5,fr5,tv)*rrbbinv
      dfdy = dfncdx(th5,ft5,tv)*rrbbinv
      dfdz = dfncdx(r5,fp5,rv)
      else
      gr1 = dfncdx(r5,fr5,rv)
      gr2 = dfncdx(th5,ft5,tv)*rrbbinv
      gr3 = dfncdx(phi5,fp5,pv)*rrbbinv*cosecb(itb)
      dfdx = gr1*sintheb(itb)*cosphib(ipb)
     &     + gr2*costheb(itb)*cosphib(ipb)  
     &     - gr3*sinphib(ipb) 
      dfdy = gr1*sintheb(itb)*sinphib(ipb)
     &     + gr2*costheb(itb)*sinphib(ipb)
     &     + gr3*cosphib(ipb) 
      dfdz = gr1*costheb(itb)
     &     - gr2*sintheb(itb)
      end if
c
      grad1(1) = dfdx
      grad1(2) = dfdy
      grad1(3) = dfdz
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1g(fnc,grad1,irg,itg,ipg,ixysym)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension fnc(0:nnrg,0:nntg,0:nnpg), 
     &          grad1(3),fr5(5),ft5(5),fp5(5),r5(5),th5(5),phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(irg-2,nrtot-4)
      it0 = itg-2
      ip0 = ipg-2
c
      rv = rg(irg)
      tv = thg(itg)
      pv = phig(ipg)
      rrgginv = rginv(irg)
c
      tnsym = dble(ixysym)
c
      do 8 ii = 1, 5
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
      ipg0 = ip0 + ii - 1
c
      if (irg.eq.0) then
c
      irga = iabs(irg0)
      irg0sg = isign(1,irg0)
      ipgax = (1-irg0sg)/2*npgxzm + (1+irg0sg)/2*npgxz
      ipgay = (1-irg0sg)/2*npgyzm + (1+irg0sg)/2*npgyz
      facp = dble((1-irg0sg)/2)*tnsym + dble((1+irg0sg)/2)
      r5(ii)  = rg(irga)*dble(irg0sg)
      fr5(ii) = fnc(irga,ntgeq,ipgax)      
      ft5(ii) = fnc(irga,ntgeq,ipgay)
      fp5(ii) = facp*fnc(irga,0,0)
c
      else if (irg.ne.0.and.itg.eq.0) then
c
      irga = iabs(irg0)
      itga = iabs(itg0)
      irg0sg = isign(1,irg0)
      itg0sg = isign(1,itg0)
      ipgax = (1-itg0sg)/2*npgxzm + (1+itg0sg)/2*npgxz
      ipgay = (1-itg0sg)/2*npgyzm + (1+itg0sg)/2*npgyz
      facp = dble((1-irg0sg)/2)*tnsym + dble((1+irg0sg)/2)
      r5(ii)  = rg(irga)*dble(irg0sg)
      th5(ii) = thg(itg) + dthg*dble(ii-3)
      fr5(ii) = fnc(irg,itga,ipgax)      
      ft5(ii) = fnc(irg,itga,ipgay)
      fp5(ii) = facp*fnc(irga,0,0)
c
      else 
c
      irga = iabs(irg0)
      itga = iabs(itg0) - 2*idim(itg0,ntg)
      ipga = mod(ipg0+npg,npg)
      irg0sg = isign(1,irg0)
      itg0sg = isign(1,itg0)
      itgnsg = isign(1,ntg-itg0)
      ipgcx = (1-irg0sg)/2*mod(ipg+npg/2+npg,npg) + (1+irg0sg)/2*ipg
      ipgax = (1-itg0sg)/2*mod(ipg+npg/2+npg,npg) + (1+itg0sg)/2*ipg
      facr = dble((1-irg0sg)/2)*tnsym + dble((1+irg0sg)/2)
      fact = dble((1-itgnsg)/2)*tnsym + dble((1+itgnsg)/2)
      r5(ii)  = rg(irga)*dble(irg0sg)
      th5(ii) = thg(itg) + dthg*dble(ii-3)
      phi5(ii)= phig(ipg) + dphig*dble(ii-3)
      fr5(ii) = facr*fnc(irga,itg,ipgcx)      
      ft5(ii) = fact*fnc(irg,itga,ipgax)
      fp5(ii) = fnc(irg,itg,ipga)
c      
      end if
    8 continue
c      stop
cc 22   format(1p,6e12.4)
cc      if (irg.eq.1.and.itg.eq.20.and.ipg.eq.20) stop
c
c --- To cartesian component.  
c
      if (irg.eq.0) then
      dfdx = dfncdx(r5,fr5,rv)
      dfdy = dfncdx(r5,ft5,rv) 
      dfdz = dfncdx(r5,fp5,rv)
      else if (irg.ne.0.and.itg.eq.0) then
      dfdx = dfncdx(th5,fr5,tv)*rrgginv
      dfdy = dfncdx(th5,ft5,tv)*rrgginv
      dfdz = dfncdx(r5,fp5,rv)
      else
      gr1 = dfncdx(r5,fr5,rv)
      gr2 = dfncdx(th5,ft5,tv)*rrgginv
      gr3 = dfncdx(phi5,fp5,pv)*rrgginv*cosecg(itg)
      dfdx = gr1*sintheg(itg)*cosphig(ipg)
     &     + gr2*costheg(itg)*cosphig(ipg)  
     &     - gr3*sinphig(ipg) 
      dfdy = gr1*sintheg(itg)*sinphig(ipg)
     &     + gr2*costheg(itg)*sinphig(ipg)
     &     + gr3*cosphig(ipg) 
      dfdz = gr1*costheg(itg)
     &     - gr2*sintheg(itg)
      end if
c
      grad1(1) = dfdx
      grad1(2) = dfdy
      grad1(3) = dfdz
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine dadbscalarg(fnc,dabfnc,irg,itg,ipg)
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension  fnc(0:nnrg,0:nntg,0:nnpg), dabfnc(1:3,1:3),
     &           r5(5), th5(5), phi5(5), grad1(3), 
     &           dfdx_r(5), dfdx_th(5), dfdx_phi(5),
     &           dfdy_r(5), dfdy_th(5), dfdy_phi(5),
     &           dfdz_r(5), dfdz_th(5), dfdz_phi(5)
c
c --- Compute second derivative of a scalar D_b D_a f,   
c     whose value is assigned on the grid points. 
c     Derivative is computed by that of Catesian coordinate for 
c --- r=0 or theta=0, and by that of spherical coordinate for elsewhere.
c
      ir0 = min0(max0(irg-2,0),nrtot-4)
      it0 = min0(max0(itg-2,0),ntg-4)
      ip0 = min0(max0(ipg-2,0),npg-4)
c
      rv = rg(irg)
      tv = thg(itg)
      pv = phig(ipg)
      rrgginv = rginv(irg)
      cosecgb = cosecg(itg)
c ##  phig = -pi/2 to pi/2 
      npnp = npg
c      npnp = npg*msymg/2
c
      do 27 ii = 1, 5
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
      ipg0 = ip0 + ii - 1
      r5(ii) = rg(irg0)
      th5(ii) = thg(itg0)
      phi5(ii) = phig(ipg0)
   27 continue
c
      if (irg.eq.0) then
c
      do 28 ii = 1, 5
c
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
      ipg0 = ip0 + ii - 1
c
      call grgrad1g(fnc,grad1,irg0,ntg,0)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1g(fnc,grad1,irg0,ntg,npnp)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1g(fnc,grad1,irg0,0,0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   28 continue
c
      dabfnc(1,1) = dfncdx(r5,dfdx_r,rv)
      dabfnc(1,2) = dfncdx(r5,dfdx_th,rv)
      dabfnc(1,3) = dfncdx(r5,dfdx_phi,rv)
      dabfnc(2,1) = dfncdx(r5,dfdy_r,rv)
      dabfnc(2,2) = dfncdx(r5,dfdy_th,rv)
      dabfnc(2,3) = dfncdx(r5,dfdy_phi,rv)
      dabfnc(3,1) = dfncdx(r5,dfdz_r,rv)
      dabfnc(3,2) = dfncdx(r5,dfdz_th,rv)
      dabfnc(3,3) = dfncdx(r5,dfdz_phi,rv)
c
      else if (irg.ne.0.and.itg.eq.0) then
c
      do 38 ii = 1, 5
c
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
      ipg0 = ip0 + ii - 1
c
      call grgrad1g(fnc,grad1,irg,itg0,0)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1g(fnc,grad1,irg,itg0,npnp)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1g(fnc,grad1,irg0,0,0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   38 continue
c
      dabfnc(1,1) = dfncdx(th5,dfdx_r,tv)*rrgginv
      dabfnc(1,2) = dfncdx(th5,dfdx_th,tv)*rrgginv
      dabfnc(1,3) = dfncdx(r5,dfdx_phi,rv)
      dabfnc(2,1) = dfncdx(th5,dfdy_r,tv)*rrgginv
      dabfnc(2,2) = dfncdx(th5,dfdy_th,tv)*rrgginv
      dabfnc(2,3) = dfncdx(r5,dfdy_phi,rv)
      dabfnc(3,1) = dfncdx(th5,dfdz_r,tv)*rrgginv
      dabfnc(3,2) = dfncdx(th5,dfdz_th,tv)*rrgginv
      dabfnc(3,3) = dfncdx(r5,dfdz_phi,rv)
c
      else
c
      do 48 ii = 1, 5
c
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
      ipg0 = ip0 + ii - 1
c
      call grgrad1g(fnc,grad1,irg0,itg,ipg)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1g(fnc,grad1,irg,itg0,ipg)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1g(fnc,grad1,irg,itg,ipg0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   48 continue
c
      ddfdxdr = dfncdx(r5,dfdx_r,rv)
      ddfdxdt = dfncdx(th5,dfdx_th,tv)*rrgginv
      ddfdxdp = dfncdx(phi5,dfdx_phi,pv)*rrgginv*cosecgb
      ddfdydr = dfncdx(r5,dfdy_r,rv)
      ddfdydt = dfncdx(th5,dfdy_th,tv)*rrgginv
      ddfdydp = dfncdx(phi5,dfdy_phi,pv)*rrgginv*cosecgb
      ddfdzdr = dfncdx(r5,dfdz_r,rv)
      ddfdzdt = dfncdx(th5,dfdz_th,tv)*rrgginv
      ddfdzdp = dfncdx(phi5,dfdz_phi,pv)*rrgginv*cosecgb
c
      dabfnc(1,1) = ddfdxdr*sintheg(itg)*cosphig(ipg)
     &            + ddfdxdt*costheg(itg)*cosphig(ipg)  
     &            - ddfdxdp*sinphig(ipg)
      dabfnc(1,2) = ddfdxdr*sintheg(itg)*sinphig(ipg)
     &            + ddfdxdt*costheg(itg)*sinphig(ipg)
     &            + ddfdxdp*cosphig(ipg)
      dabfnc(1,3) = ddfdxdr*costheg(itg)
     &            - ddfdxdt*sintheg(itg)
      dabfnc(2,1) = ddfdydr*sintheg(itg)*cosphig(ipg)
     &            + ddfdydt*costheg(itg)*cosphig(ipg)  
     &            - ddfdydp*sinphig(ipg)
      dabfnc(2,2) = ddfdydr*sintheg(itg)*sinphig(ipg)
     &            + ddfdydt*costheg(itg)*sinphig(ipg)
     &            + ddfdydp*cosphig(ipg)
      dabfnc(2,3) = ddfdydr*costheg(itg)
     &            - ddfdydt*sintheg(itg)
      dabfnc(3,1) = ddfdzdr*sintheg(itg)*cosphig(ipg)
     &            + ddfdzdt*costheg(itg)*cosphig(ipg)  
     &            - ddfdzdp*sinphig(ipg)
      dabfnc(3,2) = ddfdzdr*sintheg(itg)*sinphig(ipg)
     &            + ddfdzdt*costheg(itg)*sinphig(ipg)
     &            + ddfdzdp*cosphig(ipg)
      dabfnc(3,3) = ddfdzdr*costheg(itg)
     &            - ddfdzdt*sintheg(itg)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1g_baka(fnc,grad1,irg,itg,ipg)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension fnc(0:nnrg,0:nntg,0:nnpg), fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(irg-2,0),nrtot-4)
      it0 = min0(max0(itg-2,0),ntg-4)
ccc      ip0 = min0(max0(ipg-2,0),npg-4)
c
c ##  phig = -pi/2, 3*pi/2
c
      npnp = npgyz
c
      do 8 ii = 1, 5
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
ccc      ipg0 = ip0 + ii - 1
      r5(ii) = rg(irg0)
      th5(ii) = thg(itg0)
ccc      phi5(ii) = phig(ipg0)
c
c ##  phig = -pi/2 to 3*pi/2, equidistant
      ipg0 = mod(ip0+ii-3+npg,npg)
      phi5(ii) = phig(ip0) + dphig*dble(ii-3)
c
c --  version r(0) > 0,  cf) subroutine grgrad1b0.
c
      if (itg.eq.0) then
      fr5(ii) = fnc(irg,itg0,npgxz)
      ft5(ii) = fnc(irg,itg0,npnp)
      fp5(ii) = fnc(irg0,0,0)
      else
      fr5(ii) = fnc(irg0,itg,ipg)
      ft5(ii) = fnc(irg,itg0,ipg)
      fp5(ii) = fnc(irg,itg,ipg0)
      end if
    8 continue
c
      rv = rg(irg)
      tv = thg(itg)
      pv = phig(ipg)
      rrgginv = rginv(irg)
c
c --- To cartesian component.  
c
      if (itg.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tv)*rrgginv
      grad1(2) = dfncdx(th5,ft5,tv)*rrgginv
      grad1(3) = dfncdx(r5,fp5,rv)
      else
      gr1 = dfncdx(r5,fr5,rv)
      gr2 = dfncdx(th5,ft5,tv)*rrgginv
      gr3 = dfncdx(phi5,fp5,pv)*rrgginv*cosecg(itg)
      grad1(1) = gr1*sintheg(itg)*cosphig(ipg)
     &         + gr2*costheg(itg)*cosphig(ipg)  
     &         - gr3*sinphig(ipg) 
      grad1(2) = gr1*sintheg(itg)*sinphig(ipg)
     &         + gr2*costheg(itg)*sinphig(ipg)
     &         + gr3*cosphig(ipg) 
      grad1(3) = gr1*costheg(itg)
     &         - gr2*sintheg(itg)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1g_original(fnc,grad1,irg,itg,ipg)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension fnc(0:nnrg,0:nntg,0:nnpg), fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(irg-2,0),nrtot-4)
      it0 = min0(max0(itg-2,0),ntg-4)
      ip0 = min0(max0(ipg-2,0),npg-4)
c
c ##  phig = -pi/2, 3*pi/2
c
      npnp = npgyz
c
      rv = rg(irg)
      tv = thg(itg)
      pv = phig(ipg)
      rrgginv = rginv(irg)
c
      do 8 ii = 1, 5
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
      ipg0 = ip0 + ii - 1
      r5(ii) = rg(irg0)
      th5(ii) = thg(itg0)
      phi5(ii) = phig(ipg0)
      if (irg.eq.0) then
      fr5(ii) = fnc(irg0,ntg,npgxz)
c##
      ft5(ii) = fnc(irg0,ntg,npnp)
      fp5(ii) = fnc(irg0,0,0)
      else if (irg.ne.0.and.itg.eq.0) then
      fr5(ii) = fnc(irg,itg0,npgxz)
c##
      ft5(ii) = fnc(irg,itg0,npnp)
      fp5(ii) = fnc(irg0,0,0)
      else
      fr5(ii) = fnc(irg0,itg,ipg)
      ft5(ii) = fnc(irg,itg0,ipg)
      fp5(ii) = fnc(irg,itg,ipg0)
      end if
    8 continue
c
c --- To cartesian component.  
c
      if (irg.eq.0) then
      grad1(1) = dfncdx(r5,fr5,rv)
      grad1(2) = dfncdx(r5,ft5,rv) 
      grad1(3) = dfncdx(r5,fp5,rv)
      else if (irg.ne.0.and.itg.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tv)*rrgginv
      grad1(2) = dfncdx(th5,ft5,tv)*rrgginv
      grad1(3) = dfncdx(r5,fp5,rv)
      else
      gr1 = dfncdx(r5,fr5,rv)
      gr2 = dfncdx(th5,ft5,tv)*rrgginv
      gr3 = dfncdx(phi5,fp5,pv)*rrgginv*cosecg(itg)
      grad1(1) = gr1*sintheg(itg)*cosphig(ipg)
     &         + gr2*costheg(itg)*cosphig(ipg)  
     &         - gr3*sinphig(ipg) 
      grad1(2) = gr1*sintheg(itg)*sinphig(ipg)
     &         + gr2*costheg(itg)*sinphig(ipg)
     &         + gr3*cosphig(ipg) 
      grad1(3) = gr1*costheg(itg)
     &         - gr2*sintheg(itg)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine dadbscalarb(fnc,dabfnc,irb,itb,ipb)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension  fnc(nnrb0:nnrb,0:nntb,0:nnpb), dabfnc(1:3,1:3),
     &           r5(5), th5(5), phi5(5), grad1(3), 
     &           dfdx_r(5), dfdx_th(5), dfdx_phi(5),
     &           dfdy_r(5), dfdy_th(5), dfdy_phi(5),
     &           dfdz_r(5), dfdz_th(5), dfdz_phi(5)
c
c --- Compute second derivative of a scalar D_b D_a f,   
c     whose value is assigned on the grid points. 
c     Derivative is computed by that of Catesian coordinate for 
c --- r=0 or theta=0, and by that of spherical coordinate for elsewhere.
c
      ir0 = min0(max0(irb-2,nrb0),nrb-4)
      it0 = min0(max0(itb-2,0),ntb-4)
ccc      ip0 = min0(max0(ipb-2,0),npb-4)
c ##  phib = 0 to 2pi       
      ip0 = ipb 
c
      rbv = rb(irb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinvb = rbinv(irb)
      cosecbb = cosecb(itb)
      npnp = npb*msymb/2
c
      do 27 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r5(ii) = rb(irb0)
      th5(ii) = thb(itb0)
ccc      phi5(ii) = phib(ipb0)
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-3+npb,npb) 
      phi5(ii) = phib(ip0) + dphib*dble(ii-3)
   27 continue
c
c
c --  version r(0) > 0,  cf) subroutine dadbscalarb0
c
      if (itb.eq.0) then
c
      do 38 ii = 1, 5
c
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
      ipb0 = ip0 + ii - 1
c
      call grgrad1b(fnc,grad1,irb,itb0,0,nrb0)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1b(fnc,grad1,irb,itb0,npnp,nrb0)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1b(fnc,grad1,irb0,0,0,nrb0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   38 continue
c
      dabfnc(1,1) = dfncdx(th5,dfdx_r,tbv)*rrbbinvb
      dabfnc(1,2) = dfncdx(th5,dfdx_th,tbv)*rrbbinvb
      dabfnc(1,3) = dfncdx(r5,dfdx_phi,rbv)
      dabfnc(2,1) = dfncdx(th5,dfdy_r,tbv)*rrbbinvb
      dabfnc(2,2) = dfncdx(th5,dfdy_th,tbv)*rrbbinvb
      dabfnc(2,3) = dfncdx(r5,dfdy_phi,rbv)
      dabfnc(3,1) = dfncdx(th5,dfdz_r,tbv)*rrbbinvb
      dabfnc(3,2) = dfncdx(th5,dfdz_th,tbv)*rrbbinvb
      dabfnc(3,3) = dfncdx(r5,dfdz_phi,rbv)
c
      else
c
      do 48 ii = 1, 5
c
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      ipb0 = mod(ip0+ii-3+npb,npb) 
c
      call grgrad1b(fnc,grad1,irb0,itb,ipb,nrb0)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1b(fnc,grad1,irb,itb0,ipb,nrb0)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1b(fnc,grad1,irb,itb,ipb0,nrb0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   48 continue
c
      ddfdxdr = dfncdx(r5,dfdx_r,rbv)
      ddfdxdt = dfncdx(th5,dfdx_th,tbv)*rrbbinvb
      ddfdxdp = dfncdx(phi5,dfdx_phi,pbv)*rrbbinvb*cosecbb
      ddfdydr = dfncdx(r5,dfdy_r,rbv)
      ddfdydt = dfncdx(th5,dfdy_th,tbv)*rrbbinvb
      ddfdydp = dfncdx(phi5,dfdy_phi,pbv)*rrbbinvb*cosecbb
      ddfdzdr = dfncdx(r5,dfdz_r,rbv)
      ddfdzdt = dfncdx(th5,dfdz_th,tbv)*rrbbinvb
      ddfdzdp = dfncdx(phi5,dfdz_phi,pbv)*rrbbinvb*cosecbb
c
      dabfnc(1,1) = ddfdxdr*sintheb(itb)*cosphib(ipb)
     &            + ddfdxdt*costheb(itb)*cosphib(ipb)  
     &            - ddfdxdp*sinphib(ipb)
      dabfnc(1,2) = ddfdxdr*sintheb(itb)*sinphib(ipb)
     &            + ddfdxdt*costheb(itb)*sinphib(ipb)
     &            + ddfdxdp*cosphib(ipb)
      dabfnc(1,3) = ddfdxdr*costheb(itb)
     &            - ddfdxdt*sintheb(itb)
      dabfnc(2,1) = ddfdydr*sintheb(itb)*cosphib(ipb)
     &            + ddfdydt*costheb(itb)*cosphib(ipb)  
     &            - ddfdydp*sinphib(ipb)
      dabfnc(2,2) = ddfdydr*sintheb(itb)*sinphib(ipb)
     &            + ddfdydt*costheb(itb)*sinphib(ipb)
     &            + ddfdydp*cosphib(ipb)
      dabfnc(2,3) = ddfdydr*costheb(itb)
     &            - ddfdydt*sintheb(itb)
      dabfnc(3,1) = ddfdzdr*sintheb(itb)*cosphib(ipb)
     &            + ddfdzdt*costheb(itb)*cosphib(ipb)  
     &            - ddfdzdp*sinphib(ipb)
      dabfnc(3,2) = ddfdzdr*sintheb(itb)*sinphib(ipb)
     &            + ddfdzdt*costheb(itb)*sinphib(ipb)
     &            + ddfdzdp*cosphib(ipb)
      dabfnc(3,3) = ddfdzdr*costheb(itb)
     &            - ddfdzdt*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1b_baka(fnc,grad1,irb,itb,ipb,nrb0p)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension fnc(nnrb0:nnrb,0:nntb,0:nnpb),
     &          fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(irb-2,0),nrb-4)
      it0 = min0(max0(itb-2,0),ntb-4)
ccc      ip0 = min0(max0(ipb-2,0),npb-4)
c
c ##  phib = 0 to 2pi
      ip0 = ipb
c
c ##  phib = 0 to 2pi
      npnp = npbyz
c
      rbv = rb(irb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinv = rbinv(irb)
c
      do 8 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r5(ii) = rb(irb0)
      th5(ii) = thb(itb0)
ccc      phi5(ii) = phib(ipb0)
c
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-3+npb,npb)
      phi5(ii) = phib(ip0) + dphib*dble(ii-3)
c
      if (irb.eq.0) then
      fr5(ii) = fnc(irb0,ntb,npbxz)
c##
      ft5(ii) = fnc(irb0,ntb,npnp)
      fp5(ii) = fnc(irb0,0,0)
      else if (irb.ne.0.and.itb.eq.0) then
      fr5(ii) = fnc(irb,itb0,npbxz)
c##
      ft5(ii) = fnc(irb,itb0,npnp)
      fp5(ii) = fnc(irb0,0,0)
      else
      fr5(ii) = fnc(irb0,itb,ipb)
      ft5(ii) = fnc(irb,itb0,ipb)
      fp5(ii) = fnc(irb,itb,ipb0)
      end if
    8 continue
c
c --- To cartesian component.  
c
      if (irb.eq.0) then
      grad1(1) = dfncdx(r5,fr5,rv)
      grad1(2) = dfncdx(r5,ft5,rv) 
      grad1(3) = dfncdx(r5,fp5,rv)
      else if (irb.ne.0.and.itb.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tv)*rrbbinv
      grad1(2) = dfncdx(th5,ft5,tv)*rrbbinv
      grad1(3) = dfncdx(r5,fp5,rv)
      else
      gr1 = dfncdx(r5,fr5,rv)
      gr2 = dfncdx(th5,ft5,tv)*rrbbinv
      gr3 = dfncdx(phi5,fp5,pv)*rrbbinv*cosecb(itb)
      grad1(1) = gr1*sintheb(itb)*cosphib(ipb)
     &         + gr2*costheb(itb)*cosphib(ipb)  
     &         - gr3*sinphib(ipb) 
      grad1(2) = gr1*sintheb(itb)*sinphib(ipb)
     &         + gr2*costheb(itb)*sinphib(ipb)
     &         + gr3*cosphib(ipb) 
      grad1(3) = gr1*costheb(itb)
     &         - gr2*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1b_original(fnc,grad1,irb,itb,ipb,nrb0p)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension fnc(nnrb0:nnrb,0:nntb,0:nnpb),
     &          fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(irb-2,nrb0p),nrb-4)
      it0 = min0(max0(itb-2,0),ntb-4)
ccc      ip0 = min0(max0(ipb-2,0),npb-4)
c ##  phib = 0 to 2pi      
      ip0 = ipb
c
c ##  phib = 0 to 2pi
      npnp = npbyz
c
      do 8 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r5(ii) = rb(irb0)
      th5(ii) = thb(itb0)
ccc      phi5(ii) = phib(ipb0)
c
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-3+npb,npb) 
      phi5(ii) = phib(ip0) + dphib*dble(ii-3)
c
c --  version r(0) > 0,  cf) subroutine grgrad1b0.
c
      if (itb.eq.0) then
      fr5(ii) = fnc(irb,itb0,0)
      ft5(ii) = fnc(irb,itb0,npnp)
      fp5(ii) = fnc(irb0,0,0)
      else
      fr5(ii) = fnc(irb0,itb,ipb)
      ft5(ii) = fnc(irb,itb0,ipb)
      fp5(ii) = fnc(irb,itb,ipb0)
      end if
    8 continue
c
      rbv = rb(irb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinv = rbinv(irb)
c
c --- To cartesian component.  
c
      if (itb.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tbv)*rrbbinv
      grad1(2) = dfncdx(th5,ft5,tbv)*rrbbinv
      grad1(3) = dfncdx(r5,fp5,rbv)
      else
      gr1 = dfncdx(r5,fr5,rbv)
      gr2 = dfncdx(th5,ft5,tbv)*rrbbinv
      gr3 = dfncdx(phi5,fp5,pbv)*rrbbinv*cosecb(itb)
      grad1(1) = gr1*sintheb(itb)*cosphib(ipb)
     &         + gr2*costheb(itb)*cosphib(ipb)  
     &         - gr3*sinphib(ipb) 
      grad1(2) = gr1*sintheb(itb)*sinphib(ipb)
     &         + gr2*costheb(itb)*sinphib(ipb)
     &         + gr3*cosphib(ipb) 
      grad1(3) = gr1*costheb(itb)
     &         - gr2*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grderiv1rg(fnc,deriv,irg,itg,ipg,ixysym,iyzsym,izxsym)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension fnc(0:nnrg,0:nntg,0:nnpg), fr5(5), r5(5)
c
c --- Compute r-derivative of a function.  
c --- The derivative is evaluated on grid points. 
c
      ir0 = min0(irg-2,nrtot-4)
      ir0sym = ixysym*iyzsym*izxsym
      r0sym = dble(ir0sym)
c
      rv = rg(irg)
c
      do 8 ii = 1, 5
      irg0 = ir0 + ii - 1
      r5(ii) = rg(irg0)
      rlsw = dble((irg0-1)/nrtot)
      rssw = dble((1-isign(1,irg0))/2)
      rmsw = 1.0d0 - rlsw - rssw
      iairg0 = (rssw + rmsw)*iabs(irg0) + rlsw*(2*nrtot-irg0)
      facr = rmsw + r0sym*rssw
      fr5(ii) = facr*fnc(iairg0,itg,ipg)
    8 continue
c
      deriv = dfncdx(r5,fr5,rv)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function d2fdx2_3rd(xg,fnc,rv)
      implicit real*8 (a-h,o-z), integer (i-n)
      dimension xg(5),fnc(5)
c
      ir0 = 1
      ir1 = 2
      ir2 = 3
      ir3 = 4
      ir4 = 5
      dr01 = xg(ir0) - xg(ir1)
      dr02 = xg(ir0) - xg(ir2)
      dr03 = xg(ir0) - xg(ir3)
      dr04 = xg(ir0) - xg(ir4)
      dr12 = xg(ir1) - xg(ir2)
      dr13 = xg(ir1) - xg(ir3)
      dr14 = xg(ir1) - xg(ir4)
      dr23 = xg(ir2) - xg(ir3)
      dr24 = xg(ir2) - xg(ir4)
      dr34 = xg(ir3) - xg(ir4)
      dr10 = - dr01
      dr20 = - dr02
      dr21 = - dr12
      dr30 = - dr03
      dr31 = - dr13
      dr32 = - dr23
      dr40 = - dr04
      dr41 = - dr14
      dr42 = - dr24
      dr43 = - dr34
      rrv0 = rv - xg(ir0)
      rrv1 = rv - xg(ir1)
      rrv2 = rv - xg(ir2)
      rrv3 = rv - xg(ir3)
      rrv4 = rv - xg(ir4)
      wer0 = 2.0d0*(rrv3*rrv4 + rrv2*rrv4 + rrv2*rrv3
     &            + rrv1*rrv4 + rrv1*rrv3 + rrv1*rrv2)
     &            /(dr01*dr02*dr03*dr04) 
      wer1 = 2.0d0*(rrv3*rrv4 + rrv2*rrv4 + rrv2*rrv3
     &            + rrv0*rrv4 + rrv0*rrv3 + rrv0*rrv2)
     &            /(dr10*dr12*dr13*dr14) 
      wer2 = 2.0d0*(rrv3*rrv4 + rrv1*rrv4 + rrv1*rrv3
     &            + rrv0*rrv4 + rrv0*rrv3 + rrv0*rrv1)
     &            /(dr20*dr21*dr23*dr24) 
      wer3 = 2.0d0*(rrv2*rrv4 + rrv1*rrv4 + rrv1*rrv2
     &            + rrv0*rrv4 + rrv0*rrv2 + rrv0*rrv1)
     &            /(dr30*dr31*dr32*dr34) 
      wer4 = 2.0d0*(rrv2*rrv3 + rrv1*rrv3 + rrv1*rrv2
     &            + rrv0*rrv3 + rrv0*rrv2 + rrv0*rrv1)
     &            /(dr40*dr41*dr42*dr43) 
c
      d2fdx2_3rd = wer0*fnc(ir0) + wer1*fnc(ir1) +
     &             wer2*fnc(ir2) + wer3*fnc(ir3) +
     &             wer4*fnc(ir4)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c ____NOT USED!!!_______________________________________________________
c
      subroutine dadbscalarb0(fnc,dabfnc,irb,itb,ipb)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension  fnc(nnrb0:nnrb,0:nntb,0:nnpb), dabfnc(1:3,1:3),
     &           r5(5), th5(5), phi5(5), grad1(3), 
     &           dfdx_r(5), dfdx_th(5), dfdx_phi(5),
     &           dfdy_r(5), dfdy_th(5), dfdy_phi(5),
     &           dfdz_r(5), dfdz_th(5), dfdz_phi(5)
c
c --- Compute second derivative of a scalar D_b D_a f,   
c     whose value is assigned on the grid points. 
c     Derivative is computed by that of Catesian coordinate for 
c --- r=0 or theta=0, and by that of spherical coordinate for elsewhere.
c
      ir0 = min0(max0(irb-2,0),nrb-4)
      it0 = min0(max0(itb-2,0),ntb-4)
      ip0 = min0(max0(ipb-2,0),npb-4)
c
      rbv = rb(irb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinvb = rbinv(irb)
      cosecbb = cosecb(itb)
      npnp = npb*msymb/2
c
      do 27 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
      ipb0 = ip0 + ii - 1
      r5(ii) = rb(irb0)
      th5(ii) = thb(itb0)
      phi5(ii) = phib(ipb0)
   27 continue
c
      if (irb.eq.0) then
c
      do 28 ii = 1, 5
c
      irb0 = ir0 + ii - 1
c
      call grgrad1b0(fnc,grad1,irb0,ntb,0)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1b0(fnc,grad1,irb0,ntb,npnp)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1b0(fnc,grad1,irb0,0,0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   28 continue
c
      dabfnc(1,1) = dfncdx(r5,dfdx_r,rbv)
      dabfnc(1,2) = dfncdx(r5,dfdx_th,rbv)
      dabfnc(1,3) = dfncdx(r5,dfdx_phi,rbv)
      dabfnc(2,1) = dfncdx(r5,dfdy_r,rbv)
      dabfnc(2,2) = dfncdx(r5,dfdy_th,rbv)
      dabfnc(2,3) = dfncdx(r5,dfdy_phi,rbv)
      dabfnc(3,1) = dfncdx(r5,dfdz_r,rbv)
      dabfnc(3,2) = dfncdx(r5,dfdz_th,rbv)
      dabfnc(3,3) = dfncdx(r5,dfdz_phi,rbv)
c
      else if (irb.ne.0.and.itb.eq.0) then
c
      do 38 ii = 1, 5
c
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
      ipb0 = ip0 + ii - 1
c
      call grgrad1b0(fnc,grad1,irb,itb0,0)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1b0(fnc,grad1,irb,itb0,npnp)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1b0(fnc,grad1,irb0,0,0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   38 continue
c
      dabfnc(1,1) = dfncdx(th5,dfdx_r,tbv)*rrbbinvb
      dabfnc(1,2) = dfncdx(th5,dfdx_th,tbv)*rrbbinvb
      dabfnc(1,3) = dfncdx(r5,dfdx_phi,rbv)
      dabfnc(2,1) = dfncdx(th5,dfdy_r,tbv)*rrbbinvb
      dabfnc(2,2) = dfncdx(th5,dfdy_th,tbv)*rrbbinvb
      dabfnc(2,3) = dfncdx(r5,dfdy_phi,rbv)
      dabfnc(3,1) = dfncdx(th5,dfdz_r,tbv)*rrbbinvb
      dabfnc(3,2) = dfncdx(th5,dfdz_th,tbv)*rrbbinvb
      dabfnc(3,3) = dfncdx(r5,dfdz_phi,rbv)
c
      else
c
      do 48 ii = 1, 5
c
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
      ipb0 = ip0 + ii - 1
c
      call grgrad1b0(fnc,grad1,irb0,itb,ipb)
      dfdx_r(ii) = grad1(1)
      dfdy_r(ii) = grad1(2)
      dfdz_r(ii) = grad1(3)
c
      call grgrad1b0(fnc,grad1,irb,itb0,ipb)
      dfdx_th(ii) = grad1(1)
      dfdy_th(ii) = grad1(2)
      dfdz_th(ii) = grad1(3)
c
      call grgrad1b0(fnc,grad1,irb,itb,ipb0)
      dfdx_phi(ii) = grad1(1)
      dfdy_phi(ii) = grad1(2)
      dfdz_phi(ii) = grad1(3)
c
   48 continue
c
      ddfdxdr = dfncdx(r5,dfdx_r,rbv)
      ddfdxdt = dfncdx(th5,dfdx_th,tbv)*rrbbinvb
      ddfdxdp = dfncdx(phi5,dfdx_phi,pbv)*rrbbinvb*cosecbb
      ddfdydr = dfncdx(r5,dfdy_r,rbv)
      ddfdydt = dfncdx(th5,dfdy_th,tbv)*rrbbinvb
      ddfdydp = dfncdx(phi5,dfdy_phi,pbv)*rrbbinvb*cosecbb
      ddfdzdr = dfncdx(r5,dfdz_r,rbv)
      ddfdzdt = dfncdx(th5,dfdz_th,tbv)*rrbbinvb
      ddfdzdp = dfncdx(phi5,dfdz_phi,pbv)*rrbbinvb*cosecbb
c
      dabfnc(1,1) = ddfdxdr*sintheb(itb)*cosphib(ipb)
     &            + ddfdxdt*costheb(itb)*cosphib(ipb)  
     &            - ddfdxdp*sinphib(ipb)
      dabfnc(1,2) = ddfdxdr*sintheb(itb)*sinphib(ipb)
     &            + ddfdxdt*costheb(itb)*sinphib(ipb)
     &            + ddfdxdp*cosphib(ipb)
      dabfnc(1,3) = ddfdxdr*costheb(itb)
     &            - ddfdxdt*sintheb(itb)
      dabfnc(2,1) = ddfdydr*sintheb(itb)*cosphib(ipb)
     &            + ddfdydt*costheb(itb)*cosphib(ipb)  
     &            - ddfdydp*sinphib(ipb)
      dabfnc(2,2) = ddfdydr*sintheb(itb)*sinphib(ipb)
     &            + ddfdydt*costheb(itb)*sinphib(ipb)
     &            + ddfdydp*cosphib(ipb)
      dabfnc(2,3) = ddfdydr*costheb(itb)
     &            - ddfdydt*sintheb(itb)
      dabfnc(3,1) = ddfdzdr*sintheb(itb)*cosphib(ipb)
     &            + ddfdzdt*costheb(itb)*cosphib(ipb)  
     &            - ddfdzdp*sinphib(ipb)
      dabfnc(3,2) = ddfdzdr*sintheb(itb)*sinphib(ipb)
     &            + ddfdzdt*costheb(itb)*sinphib(ipb)
     &            + ddfdzdp*cosphib(ipb)
      dabfnc(3,3) = ddfdzdr*costheb(itb)
     &            - ddfdzdt*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c ____NOT USED!!!_______________________________________________________
c
czzz      subroutine grgrad1b0(fnc,grad1,irb,itb,ipb)
czzz      end
      subroutine grgrad1b0(fnc,grad1,irb,itb,ipb)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension fnc(nnrb0:nnrb,0:nntb,0:nnpb),
     &          fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(irb-2,0),nrb-4)
      it0 = min0(max0(itb-2,0),ntb-4)
      ip0 = min0(max0(ipb-2,0),npb-4)
c
      npnp = npbyz
c
      do 8 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
      ipb0 = ip0 + ii - 1
      r5(ii) = rb(irb0)
      th5(ii) = thb(itb0)
      phi5(ii) = phib(ipb0)
      if (irb.eq.0) then
      fr5(ii) = fnc(irb0,ntb,0)
      ft5(ii) = fnc(irb0,ntb,npnp)
      fp5(ii) = fnc(irb0,0,0)
      else if (irb.ne.0.and.itb.eq.0) then
      fr5(ii) = fnc(irb,itb0,0)
      ft5(ii) = fnc(irb,itb0,npnp)
      fp5(ii) = fnc(irb0,0,0)
      else
      fr5(ii) = fnc(irb0,itb,ipb)
      ft5(ii) = fnc(irb,itb0,ipb)
      fp5(ii) = fnc(irb,itb,ipb0)
      end if
    8 continue
c
      rbv = rb(irb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinv = rbinv(irb)
c
c --- To cartesian component.  
c
      if (irb.eq.0) then
      grad1(1) = dfncdx(r5,fr5,rbv)
      grad1(2) = dfncdx(r5,ft5,rbv) 
      grad1(3) = dfncdx(r5,fp5,rbv)
      else if (irb.ne.0.and.itb.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tbv)*rrbbinv
      grad1(2) = dfncdx(th5,ft5,tbv)*rrbbinv
      grad1(3) = dfncdx(r5,fp5,rbv)
      else
      gr1 = dfncdx(r5,fr5,rbv)
      gr2 = dfncdx(th5,ft5,tbv)*rrbbinv
      gr3 = dfncdx(phi5,fp5,pbv)*rrbbinv*cosecb(itb)
      grad1(1) = gr1*sintheb(itb)*cosphib(ipb)
     &         + gr2*costheb(itb)*cosphib(ipb)  
     &         - gr3*sinphib(ipb) 
      grad1(2) = gr1*sintheb(itb)*sinphib(ipb)
     &         + gr2*costheb(itb)*sinphib(ipb)
     &         + gr3*cosphib(ipb) 
      grad1(3) = gr1*costheb(itb)
     &         - gr2*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function fn_linint(x1,x2,y1,y2,v)
      implicit real*8 (a-h,o-z), integer (i-n)
c
      dx12 = x1 - x2
      dx21 = - dx12
      xv1 = v - x1
      xv2 = v - x2
      wex1 = xv2/dx12
      wex2 = xv1/dx21
c
      fn_linint = wex1*y1 + wex2*y2
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function fn_lagint(x,y,v)
      implicit real*8 (a-h,o-z), integer (i-n)
      dimension x(4),y(4)
c
      dx12 = x(1) - x(2)
      dx13 = x(1) - x(3)
      dx14 = x(1) - x(4)
      dx23 = x(2) - x(3)
      dx24 = x(2) - x(4)
      dx34 = x(3) - x(4)
      dx21 = - dx12
      dx31 = - dx13
      dx32 = - dx23
      dx41 = - dx14
      dx42 = - dx24
      dx43 = - dx34
      xv1 = v - x(1)
      xv2 = v - x(2)
      xv3 = v - x(3)
      xv4 = v - x(4)
      wex1 = xv2*xv3*xv4/(dx12*dx13*dx14)
      wex2 = xv1*xv3*xv4/(dx21*dx23*dx24)
      wex3 = xv1*xv2*xv4/(dx31*dx32*dx34)
      wex4 = xv1*xv2*xv3/(dx41*dx42*dx43)
c
      fn_lagint = wex1*y(1) + wex2*y(2) + wex3*y(3) + wex4*y(4)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function fn_lagint5(x,y,v)
      implicit real*8 (a-h,o-z), integer (i-n)
      dimension x(5),y(5)
c
      dx12 = x(1) - x(2)
      dx13 = x(1) - x(3)
      dx14 = x(1) - x(4)
      dx15 = x(1) - x(5)
      dx23 = x(2) - x(3)
      dx24 = x(2) - x(4)
      dx25 = x(2) - x(5)
      dx34 = x(3) - x(4)
      dx35 = x(3) - x(5)
      dx45 = x(4) - x(5)
      dx21 = - dx12
      dx31 = - dx13
      dx32 = - dx23
      dx41 = - dx14
      dx42 = - dx24
      dx43 = - dx34
      dx51 = - dx15
      dx52 = - dx25
      dx53 = - dx35
      dx54 = - dx45
      xv1 = v - x(1)
      xv2 = v - x(2)
      xv3 = v - x(3)
      xv4 = v - x(4)
      xv5 = v - x(5)
      wex1 = xv2*xv3*xv4*xv5/(dx12*dx13*dx14*dx15)
      wex2 = xv1*xv3*xv4*xv5/(dx21*dx23*dx24*dx25)
      wex3 = xv1*xv2*xv4*xv5/(dx31*dx32*dx34*dx35)
      wex4 = xv1*xv2*xv3*xv5/(dx41*dx42*dx43*dx45)
      wex5 = xv1*xv2*xv3*xv4/(dx51*dx52*dx53*dx54)
c
      fn_lagint5 = wex1*y(1)+wex2*y(2)+wex3*y(3)+wex4*y(4)+wex5*y(5)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function dfncdx(xg,fnc,rb)
      implicit real*8 (a-h,o-z), integer (i-n)
      dimension xg(5),fnc(5)
c
      ir0 = 1
      ir1 = 2
      ir2 = 3
      ir3 = 4
      ir4 = 5
      dr01 = xg(ir0) - xg(ir1)
      dr02 = xg(ir0) - xg(ir2)
      dr03 = xg(ir0) - xg(ir3)
      dr04 = xg(ir0) - xg(ir4)
      dr12 = xg(ir1) - xg(ir2)
      dr13 = xg(ir1) - xg(ir3)
      dr14 = xg(ir1) - xg(ir4)
      dr23 = xg(ir2) - xg(ir3)
      dr24 = xg(ir2) - xg(ir4)
      dr34 = xg(ir3) - xg(ir4)
      dr10 = - dr01
      dr20 = - dr02
      dr21 = - dr12
      dr30 = - dr03
      dr31 = - dr13
      dr32 = - dr23
      dr40 = - dr04
      dr41 = - dr14
      dr42 = - dr24
      dr43 = - dr34
      rrb0 = rb - xg(ir0)
      rrb1 = rb - xg(ir1)
      rrb2 = rb - xg(ir2)
      rrb3 = rb - xg(ir3)
      rrb4 = rb - xg(ir4)
      wer0 = (rrb2*rrb3*rrb4 + rrb1*rrb3*rrb4 +
     &        rrb1*rrb2*rrb4 + rrb1*rrb2*rrb3)/(dr01*dr02*dr03*dr04)
      wer1 = (rrb2*rrb3*rrb4 + rrb0*rrb3*rrb4 +
     &        rrb0*rrb2*rrb4 + rrb0*rrb2*rrb3)/(dr10*dr12*dr13*dr14)
      wer2 = (rrb1*rrb3*rrb4 + rrb0*rrb3*rrb4 +
     &        rrb0*rrb1*rrb4 + rrb0*rrb1*rrb3)/(dr20*dr21*dr23*dr24)
      wer3 = (rrb1*rrb2*rrb4 + rrb0*rrb2*rrb4 +
     &        rrb0*rrb1*rrb4 + rrb0*rrb1*rrb2)/(dr30*dr31*dr32*dr34)
      wer4 = (rrb1*rrb2*rrb3 + rrb0*rrb2*rrb3 +
     &        rrb0*rrb1*rrb3 + rrb0*rrb1*rrb2)/(dr40*dr41*dr42*dr43)
      dfncdx = wer0*fnc(ir0) + wer1*fnc(ir1) +
     &         wer2*fnc(ir2) + wer3*fnc(ir3) +
     &         wer4*fnc(ir4)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine potimpro(potb,potg,backb,backg,facbh,facgr)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension potb(0:nnrb,0:nntb,0:nnpb),backb(0:nnrb,0:nntb,0:nnpb),
     &          potg(0:nnrg,0:nntg,0:nnpg),backg(0:nnrg,0:nntg,0:nnpg)
c
      do 3004 ipb = 0, npb
      do 3004 itb = 0, ntb
      do 3004 irb = 0, nrb
      potb(irb,itb,ipb) = (1.0d0 - facbh)*backb(irb,itb,ipb)
     &                           + facbh * potb(irb,itb,ipb)
 3004 continue
      do 3005 ipg = 0, npg
      do 3005 itg = 0, ntg
      do 3005 irg = 0, nrtot
      potg(irg,itg,ipg) = (1.0d0 - facgr)*backg(irg,itg,ipg)
     &                           + facgr * potg(irg,itg,ipg)
 3005 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine shibata_bunkai(bbbxb,bbbyb,bbbzb,bbbsb,
     &                          bbbxg,bbbyg,bbbzg,bbbsg,
     &                          sbwxb,sbwyb,sbwzb,sbwxg,sbwyg,sbwzg)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      dimension bbbxb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          bbbyb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          bbbzb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          bbbsb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          bbbxg(0:nnrg,0:nntg,0:nnpg),
     &          bbbyg(0:nnrg,0:nntg,0:nnpg),
     &          bbbzg(0:nnrg,0:nntg,0:nnpg),
     &          bbbsg(0:nnrg,0:nntg,0:nnpg)
      dimension sbwxb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          sbwyb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          sbwzb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          sbwsb(nnrb0:nnrb,0:nntb,0:nnpb),
     &          sbwxg(0:nnrg,0:nntg,0:nnpg),
     &          sbwyg(0:nnrg,0:nntg,0:nnpg),
     &          sbwzg(0:nnrg,0:nntg,0:nnpg),
     &          sbwsg(0:nnrg,0:nntg,0:nnpg)
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
      dimension grad(3)
c
c
      do 435 ipg = 0, npg 
      do 435 itg = 0, ntg 
      do 435 irg = 0, nrtot 
      xxx = rg(irg)*sintheg(itg)*cosphig(ipg) - orb
      yyy = rg(irg)*sintheg(itg)*sinphig(ipg)
      zzz = rg(irg)*costheg(itg)
      sbwsg(irg,itg,ipg) = bbbsg(irg,itg,ipg)
     &               -(xxx*bbbxg(irg,itg,ipg)
     &               + yyy*bbbyg(irg,itg,ipg)
     &               + zzz*bbbzg(irg,itg,ipg))
 435    continue
c
      intp = 5
      do 438 ipg = 0, npg 
      do 438 itg = 0, ntg 
      do 438 irg = 0, nrtot 
      if (irg.gt.irgbiin(itg,ipg)+intp.and.
     &    irg.lt.irgbiou(itg,ipg)-intp) go to 438
      call grgrad1g(sbwsg,grad,irg,itg,ipg,1)
      sbwxg(irg,itg,ipg) = bbbxg(irg,itg,ipg) + 0.125d0*grad(1)
      sbwyg(irg,itg,ipg) = bbbyg(irg,itg,ipg) + 0.125d0*grad(2)
      sbwzg(irg,itg,ipg) = bbbzg(irg,itg,ipg) + 0.125d0*grad(3)
 438  continue
c
c
      do 430 ipb = 0, npb 
      do 430 itb = 0, ntb 
      do 430 irb = 0, nrb
      xxx = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - orb
      yyy = rb(irb)*sintheb(itb)*sinphib(ipb)
      zzz = rb(irb)*costheb(itb)
      sbwsb(irb,itb,ipb) = bbbsb(irb,itb,ipb)
     &               -(xxx*bbbxb(irb,itb,ipb)
     &               + yyy*bbbyb(irb,itb,ipb)
     &               + zzz*bbbzb(irb,itb,ipb))
 430  continue
c
      do 431 ipb = 0, npb 
      do 431 itb = 0, ntb 
      do 431 irb = 0, nrb
      call grgrad1b(sbwsb,grad,irb,itb,ipb,1)
      sbwxb(irb,itb,ipb) = bbbxb(irb,itb,ipb) + 0.125d0*grad(1)
      sbwyb(irb,itb,ipb) = bbbyb(irb,itb,ipb) + 0.125d0*grad(2)
      sbwzb(irb,itb,ipb) = bbbzb(irb,itb,ipb) + 0.125d0*grad(3)
 431  continue
c
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjustasymptopia_bh(isaj)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      dimension psidat(0:nnrg), alphdat(0:nnrg)
c
c --  Fit psi    = 1 + MADM/2r, and alpha   = 1 - MK/r
c         psidat = 0.5/(psi - 1),   alphdat = 1/(1 - alpha)
c
c     isaj = 0 -> adjust psi and alpha in the asymptotics.
c     isaj = 1 -> no adjust
c
      pi = 3.14159265358979d+0
c
      ave = dble(ntg+1)*dble(npg+1)
      irg10 = nrtot
      do 4 irg = nrtot, 0, -1
      if (ome.ne.0.0d0) then 
      if (rg(irg).ge.10.0d0*pi/ome) irg10 = irg
      end if
    4 continue
      irgini = min0(nrtot-15,irg10)
      nrgend = nrtot - 5
      npoi = nrgend - irgini + 1
c
      do 10 irg = irgini, nrgend
      psiv  = 0.0d0
      alphv = 0.0d0
      do 20 itg = 0, ntg
      do 20 ipg = 0, npg
      psiv  = psiv  + psi(irg,itg,ipg)
      alphv = alphv + alph(irg,itg,ipg)
   20 continue
      psidat(irg)  = 0.5d0/(psiv/ave - 1.0d0)
      alphdat(irg) = 1.0d0/(1.0d0 - alphv/ave)
   10 continue
c
      s1 = 0.0d0
      sp2 = 0.0d0
      sa2 = 0.0d0
      do 30 irg = irgini, nrgend
      s1  = s1  + rg(irg)**2
      sp2 = sp2 + psidat(irg)*rg(irg)
      sa2 = sa2 + alphdat(irg)*rg(irg)
   30 continue
c
      coadm = s1/sp2
      cokom = s1/sa2
      fitadm = 0.5d0*coadm
      fitkom = 0.5d0*cokom
c
      fitvir = dabs((fitadm-fitkom)/fitadm)
c
      if (isaj.eq.0) then 
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = irgini, nrtot
      psi(irg,itg,ipg)  = 1.0d0 + coadm/(2.0d0*rg(irg))
      alph(irg,itg,ipg) = 1.0d0 - cokom/rg(irg)
   40 continue
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_restmass(imascond,emxemd,ahores,emdc,restmass,
     &                           emddiff,rmeps,eps,fmax0)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      common / masmas / ahoresm(0:4), ahoemdc(0:4)
c
      write(6,80) ' ===  emdc  and rest  mass ===' , emdc, ahores
 80   format(1a30,1p,2e12.4) 
c
      if (emxemd.lt.rmeps) then
c
      do 10 ii = 0, 3
      ahoresm(ii) = ahoresm(ii+1)
      ahoemdc(ii) = ahoemdc(ii+1)
 10   continue
      ahoresm(4) = ahores
      ahoemdc(4) = emdc
c
      go to (1,2,3) imascond
 1    continue
      if (ahores.le.restmass) emdc = (1.0d0+emddiff)*emdc
      if (ahores.gt.restmass) emdc = (1.0d0-emddiff)*emdc
      imascond = 2
      return
 2    fac1 = (restmass - ahoresm(3))/(ahoresm(4) - ahoresm(3))
      fac2 = 1.0d0 - fac1
      emdc = fac2*ahoemdc(3) + fac1*ahoemdc(4)
      fmax0 = 1.0d0
      if (dabs(restmass - ahoresm(4))/restmass.le.1.0d-4) then
      rmeps = eps
      imascond = 3
      end if
      return
 3    continue
      if (dabs(restmass - ahoresm(4))/restmass.gt.eps) then
      fac1 = (restmass - ahoresm(3))/(ahoresm(4) - ahoresm(3))
      fac2 = 1.0d0 - fac1
      emdc = fac2*ahoemdc(3) + fac1*ahoemdc(4)
      fmax0 = 1.0d0
      end if
      return
ck 2    fac1 = (restmass - ahoresm(3))/(ahoresm(4) - ahoresm(3))
ck      fac2 = 1.0d0 - fac1
ck      emdc = fac2*ahoemdc(3) + fac1*ahoemdc(4)
ckc      imascond = 3
ck      return
ck 3    continue
ck      return
c            
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_bhmass(imascond,emxemd,emddiff,eps,fmax0)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      common / adjbhm0 / ahmbak(0:4), bhmbak(0:4)
c
      write(6,80) ' === bhmass and  ADM  mass ===' , bhmass, fitadm
 80   format(1a30,1p,2e12.4) 
c
      if (emxemd.gt.1.0d-3) return
c
      do 10 ii = 0, 3
      ahmbak(ii) = ahmbak(ii+1)
      bhmbak(ii) = bhmbak(ii+1)
 10   continue
      ahmbak(4) = ahmass
      bhmbak(4) = bhmass
      fixedahm  = restmass/ratmas
c
      go to (1,2,3) imascond
 1    continue
      if (ahmass.le.fixedahm) bhmass = (1.0d0+emddiff)*bhmass
      if (ahmass.gt.fixedahm) bhmass = (1.0d0-emddiff)*bhmass
      imascond = 2
      return
 2    fac1 = (ahmass - ahmbak(3))/(ahmbak(4) - ahmbak(3))
      fac2 = 1.0d0 - fac1
      bhmass = fac2*bhmbak(3) + fac1*bhmbak(4)
      fmax0 = 1.0d0
      if (dabs(ahmass - ahmbak(4))/fixedahm.le.1.0d-4) then
      bheps = eps
      imascond = 3
      fmax0 = 1.0d0
      end if
      return
 3    continue
      if (dabs(ahmass - ahmbak(4))/fixedahm.gt.eps) then
      fac1 = (ahmass - ahmbak(3))/(ahmbak(4) - ahmbak(3))
      fac2 = 1.0d0 - fac1
      bhmass = fac2*bhmbak(3) + fac1*bhmbak(4)
      fmax0 = 1.0d0
      end if
      return
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_apmass(imascond,emxemd,emddiff,eps,fmax0)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      common / adjbhm1 / fkobak(0:4), apmbak(0:4)
c
      write(6,80) ' === apmass and Komar mass ===' , apmass, fitkom
 80   format(1a30,1p,2e12.4) 
c
      if (emxemd.gt.1.0d-3) return
c
      do 10 ii = 0, 3
      fkobak(ii) = fkobak(ii+1)
      apmbak(ii) = apmbak(ii+1)
 10   continue
      fkobak(4) = fitkom
      apmbak(4) = apmass
      fixedadm  = fitadm
c
      go to (1,2,3) imascond
 1    continue
      if (fitkom.le.fixedadm) apmass = (1.0d0+emddiff)*apmass
      if (fitkom.gt.fixedadm) apmass = (1.0d0-emddiff)*apmass
      imascond = 2
      return
 2    fac1 = (fitkom - fkobak(3))/(fkobak(4) - fkobak(3))
      fac2 = 1.0d0 - fac1
      apmass = fac2*apmbak(3) + fac1*apmbak(4)
      fmax0 = 1.0d0
      if (dabs(fitkom - fkobak(4))/fixedadm.le.1.0d-4) then
      bheps = eps
      imascond = 3
      fmax0 = 1.0d0
      end if
      return
 3    continue
      if (dabs(fitkom - fkobak(4))/fixedadm.gt.eps) then
      fac1 = (fitkom - fkobak(3))/(fkobak(4) - fkobak(3))
      fac2 = 1.0d0 - fac1
      apmass = fac2*apmbak(3) + fac1*apmbak(4)
      fmax0 = 1.0d0
      end if
      return
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_BY_Py_org(imascond,emxemd,emddiff,eps,fmax0)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/CB_shift_bh.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      common / adjbhm2 / bvybak(0:4), pmybak(0:4)
c
      bvyubh = bvyub(0,ntbeq,npbxz)
      vphiyb = dis - orbc 
      omephi  = - ome*vphiyb
      write(6,80) ' === pmomy                 ===' , pmomy
      write(6,80) ' === omephi and betay      ===' , omephi, bvyubh
 80   format(1a30,1p,2e12.4) 
c
      if (emxemd.gt.1.0d-3) return
c
      do 10 ii = 0, 3
      bvybak(ii) = bvybak(ii+1)
      pmybak(ii) = pmybak(ii+1)
 10   continue
      bvyubh = bvyub(0,ntbeq,npbxz)
      bvybak(4) = bvyubh
      pmybak(4) = pmomy
      vphiyb = dis - orbc 
      omephi  = - ome*vphiyb
c
      go to (1,2,3) imascond
 1    continue
      if (dabs(bvyubh).le.dabs(omephi)) pmomy = (1.0d0+emddiff)*pmomy
      if (dabs(bvyubh).gt.dabs(omephi)) pmomy = (1.0d0-emddiff)*pmomy
      imascond = 2
      return
 2    fac1 = (bvyubh - bvybak(3))/(bvybak(4) - bvybak(3))
      fac2 = 1.0d0 - fac1
      pmomy = fac2*pmybak(3) + fac1*pmybak(4)
      fmax0 = 1.0d0
      if (dabs(bvyubh - bvybak(4))/dabs(omephi).le.1.0d-4) then
      bheps = eps
      imascond = 3
      fmax0 = 1.0d0
      end if
      return
 3    continue
      if (dabs(bvyubh - bvybak(4))/dabs(omephi).gt.eps) then
      fac1 = (bvyubh - bvybak(3))/(bvybak(4) - bvybak(3))
      fac2 = 1.0d0 - fac1
      pmomy = fac2*pmybak(3) + fac1*pmybak(4)
      fmax0 = 1.0d0
      end if
      return
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_all(epsmax_adj,iter,rmeps_adj,epsmax_par,ii_adj)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/CB_shift_bh.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_flphy.f'
c
      common /adjipa/ icount_par, icount_fac
      common /adjvar/ hi, par_jaco(5,5), par_vec(5), fn_vec(5)
c
      dimension sgg(10), gg(10,10)
c
      dimension facp(10)
      data facp / 2.0d-2, 4.0d-2, 6.0d-2, 8.0d-2, 1.0d-1,
     &            2.0d-1, 4.0d-1, 6.0d-1, 8.0d-1, 1.0d-0 /
ck      dimension facp(20)
ck      data facp / 1.0d-2, 2.0d-2, 3.0d-2, 4.0d-2, 5.0d-2,
ck     &            6.0d-2, 7.0d-2, 8.0d-2, 9.0d-2, 1.0d-1,
ck     &            1.0d-1, 2.0d-1, 3.0d-1, 4.0d-1, 5.0d-1,
ck     &            6.0d-1, 7.0d-1, 8.0d-1, 9.0d-1, 1.0d-0 /
c
c
      omebvy = (omephi - bvyubh)/dabs(omephi)
      bvyubh = bvyub(0,ntbeq,npbxz)
      vphiyb = dis - orbc 
      omephi = - ome*vphiyb
      omebvy = (omephi - bvyubh)/dabs(omephi)
      ratio  = ahores/ahmass
c
      fixedadm  = ahoadm
      fixedkom  = ahokom
      fixedres  = ahores
      fixedrat  = ratio
      fixedvir  = (ahoadm - ahokom)/ahoadm
      fixeddlm  = (ahores - restmass)/restmass
      fixeddlr  = (ratio - ratmas)/ratmas
      fixedmom  = aholin/pmomy
ctesttest      fixeddip  = dipole
      fixeddip  = omebvy/omephi
c
      epsmax_par = dmax1(dabs(fixedvir),dabs(fixeddlm),dabs(fixeddlr),
     &                   dabs(fixedmom),dabs(fixeddip))
c
c
      if (iter.le.100) then 
      icount_fac = 0
      icount_par = 0
      return
      end if
c
c
      if(epsmax_adj.le.rmeps_adj) then 
c
      write(6,79)
     &         ' === icount_par and _fac    ===',icount_par,icount_fac
      write(6,80) ' === bhmass and  ADM  mass  ===' , bhmass, ahoadm
      write(6,80) ' === apmass and Komar mass  ===' , apmass, ahokom
      write(6,80) ' === pmomy and adm momentum ===' , pmomy , aholin
      write(6,80) ' === emdc  and rest mass    ===' , emdc, ahores
      write(6,80) ' === orbc  and dipole       ===' , orbc, omebvy
      write(6,80) ' === ratio  and  mass ratio ===' , ratio, ratmas
      write(6,80) ' === AH mass                ===' , ahmass
      write(6,80) ' === ADM mass - Komar mass  ===' , fixedvir
      write(6,80) ' === rest mass - rest mass  ===' , fixeddlm
      write(6,80) ' === ratio - mass ratio     ===' , fixeddlr
      write(6,80) ' === ADM momentum           ===' , fixedmom
      write(6,80) ' === dipole                 ===' , fixeddip
c
      write(24,79) ' === Iteration NO.          ===' , iter
      write(24,79)
     &         ' === icount_par and _fac    ===',icount_par,icount_fac
      write(24,80) ' === bhmass and  ADM  mass  ===' , bhmass, ahoadm
      write(24,80) ' === apmass and Komar mass  ===' , apmass, ahokom
      write(24,80) ' === pmomy and adm momentum ===' , pmomy , aholin
      write(24,80) ' === emdc  and rest mass    ===' , emdc, ahores
      write(24,80) ' === orbc  and dipole       ===' , orbc, omebvy
      write(24,80) ' === ratio  and  mass ratio ===' , ratio, ratmas
      write(24,80) ' === AH mass                ===' , ahmass
      write(24,80) ' === ADM mass - Komar mass  ===' , fixedvir
      write(24,80) ' === rest mass - rest mass  ===' , fixeddlm
      write(24,80) ' === ratio - mass ratio     ===' , fixeddlr
      write(24,80) ' === ADM momentum           ===' , fixedmom
      write(24,80) ' === dipole                 ===' , fixeddip
c
 79   format(1a30,2(7x,i5)) 
 80   format(1a30,1p,2e12.4) 
 81   format(1a30,5i5)
 82   format(1p,5e11.3,3x,e11.3)
c
c
      if(icount_par.eq.0) then 
c
      do 2001 ii = 1, 10
      sgg(ii) = 0.0d0
      do 2001 jj = 1, 10
      gg(ii,jj) = 0.0d0
 2001 continue
c
      par_vec(1) = bhmass
      par_vec(2) = apmass
      par_vec(3) = pmomy
      par_vec(4) = orbc
      par_vec(5) = emdc
      fn_vec(1) = fixedvir
      fn_vec(2) = fixeddlr
      fn_vec(3) = fixedmom
      fn_vec(4) = fixeddip
      fn_vec(5) = fixeddlm 
      sgg(1) = - fn_vec(1)
      sgg(2) = - fn_vec(2)
      sgg(3) = - fn_vec(3)
      sgg(4) = - fn_vec(4)
      sgg(5) = - fn_vec(5)
c
      end if
c
      if(icount_par.ge.1) then 
c
      gg(1,icount_par) = (fixedvir - fn_vec(1))/hi
      gg(2,icount_par) = (fixeddlr - fn_vec(2))/hi
      gg(3,icount_par) = (fixedmom - fn_vec(3))/hi
      gg(4,icount_par) = (fixeddip - fn_vec(4))/hi
      gg(5,icount_par) = (fixeddlm - fn_vec(5))/hi
c
      bhmass = par_vec(1)
      apmass = par_vec(2)
      pmomy  = par_vec(3)
      orbc   = par_vec(4)
      emdc   = par_vec(5)
c
      end if
c
      if (icount_par.eq.5) then
      icount_fac = icount_fac + 1 
ctesttest      ii = min0(15,icount_fac)
ck      ii = min0(13,icount_fac)
      ii = min0(10,icount_fac)
      ii_adj = ii
c
      write(24,79) ' === Jacobian and RHS  ===',icount_par,ii
      write(24,82) (gg(1,ia),ia=1,5),sgg(1)
      write(24,82) (gg(2,ia),ia=1,5),sgg(2)
      write(24,82) (gg(3,ia),ia=1,5),sgg(3)
      write(24,82) (gg(4,ia),ia=1,5),sgg(4)
      write(24,82) (gg(5,ia),ia=1,5),sgg(5)
c
      call minv(gg,sgg,5,10)
c
      fac0 = facp(ii)
      bhmass = par_vec(1) + sgg(1)*fac0
      apmass = par_vec(2) + sgg(2)*fac0
      pmomy  = par_vec(3) + sgg(3)*fac0
      orbc   = par_vec(4) + sgg(4)*fac0
      emdc   = par_vec(5) + sgg(5)*fac0
c
      epsmax_par = dmax1(epsmax_par,
     &                   dabs(par_vec(1) - bhmass)/dabs(par_vec(1)),
     &                   dabs(par_vec(2) - apmass)/dabs(par_vec(2)),
     &                   dabs(par_vec(3) - pmomy )/dabs(par_vec(3)),
     &                   dabs(par_vec(4) - orbc  )/dabs(par_vec(4)),
     &                   dabs(par_vec(5) - emdc  )/dabs(par_vec(5)))
c
      write(6,79) ' ===   Newton method   ===',icount_par,ii
      write(6,80) ' === bhmass OLD -> NEW ===', par_vec(1), bhmass
      write(6,80) ' === apmass OLD -> NEW ===', par_vec(2), apmass
      write(6,80) ' === pmomy  OLD -> NEW ===', par_vec(3), pmomy 
      write(6,80) ' === orbc   OLD -> NEW ===', par_vec(4), orbc  
      write(6,80) ' === emdc   OLD -> NEW ===', par_vec(5), emdc  
c
      icount_par = 0
      return
      end if
c
      icount_par = icount_par + 1
      hi = 1.0d-4*dabs(par_vec(icount_par))
c
      if (icount_par.eq.1) bhmass = bhmass + hi
      if (icount_par.eq.2) apmass = apmass + hi
      if (icount_par.eq.3) pmomy  = pmomy  + hi
      if (icount_par.eq.4) orbc   = orbc   + hi
      if (icount_par.eq.5) emdc   = emdc   + hi
c
      end if
c            
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_all_old(emxemd,iter,rmeps)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/CB_shift_bh.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_flphy.f'
c
      common /adjust/ sg_phy(10), sg_phy_bk(10)
      common /iadjus/ icount_adj(10,2), ifphy(10)
      dimension facp(18)
cc      save icount, ifphy
cc      save sg_phy_bk
c
      data facp / 4.0d-2, 2.0d-2, 1.0d-2, 4.0d-3, 2.0d-3, 1.0d-3,
     &            4.0d-4, 2.0d-4, 1.0d-4, 4.0d-5, 2.0d-5, 1.0d-5,
     &            4.0d-6, 2.0d-6, 1.0d-6, 4.0d-7, 2.0d-7, 1.0d-7 /
c
c
c
      bvyubh = dabs(bvyub(0,ntbeq,npbxz))
      vphiyb = dis - orbc 
      omephi = dabs(ome*vphiyb)
      omebvy  = (omephi - bvyubh)/dabs(omephi)
ctesttest      bvyubh = bvyub(0,ntbeq,npbxz)
ctesttest      vphiyb = dis - orbc 
ctesttest      omephi = - ome*vphiyb
ctesttest      omebvy  = (omephi - bvyubh)/dabs(omephi)
c      fixedmom  = fitpy
c      fixedadm  = fitadm
c      fixedkom  = fitkom
      fixedmom  = aholin
      fixedadm  = ahoadm
      fixedkom  = ahokom
      ratio  = restmass/ahmass
cc      ratio  = ahores/ahmass
c
      write(6,80) ' === bhmass and  ADM  mass  ===' , bhmass, fixedadm
      write(6,80) ' === apmass and Komar mass  ===' , apmass, fixedkom
      write(6,80) ' === pmomy and adm momentum ===' , pmomy , fixedmom
      write(6,80) ' === omephi and betay       ===' , omephi, bvyubh
      write(6,80) ' === orbc                   ===' , orbc
      write(6,80) ' === ahores and  rest mass  ===' , ahores, restmass
      write(6,80) ' === emdc                   ===' , emdc
      write(6,80) ' === ratio  and  mass ratio ===' , ratio, ratmas
      write(6,80) ' === AH mass                ===' , ahmass
      write(6,81) ' = parameter iteration level  =',(ifphy(ii),ii=1,5)
c
 80   format(1a30,1p,2e12.4) 
 81   format(1a30,5i5)
c
c
c --  sg_phy(1) = pmomy, sg_phy(2) = orbc, sg_phy(3) = apmass, 
c     sg_phy(4) = bhmass, sg_phy(5) = emdc 
c
ccc      if(iter.le.50.or.emxemd.ge.1.0d-3) then 
      if(iter.le.50.or.emxemd.ge.rmeps) then 
      do 100 ii = 1, 10
      icount_adj(ii,1) = 1
      icount_adj(ii,2) = 1
      ifphy(ii)  = 1
 100  continue
      ifphy(5)  = 5
      sg_phy_bk(1) = dsign(1.0d0,fixedmom)
      sg_phy_bk(2) = dsign(1.0d0,omebvy)
      sg_phy_bk(3) = dsign(1.0d0,fixedkom - fixedadm)
      sg_phy_bk(4) = dsign(1.0d0,ratio - ratmas)
      sg_phy_bk(5) = dsign(1.0d0,ahores - restmass)
      return
      end if
c
      write(24, *) ' === Iteration NO.          ===' , iter
      write(24,80) ' === bhmass and  ADM  mass  ===' , bhmass, fixedadm
      write(24,80) ' === apmass and Komar mass  ===' , apmass, fixedkom
      write(24,80) ' === pmomy and adm momentum ===' , pmomy, fixedmom
      write(24,80) ' === omephi and betay       ===' , omephi, bvyubh
      write(24,80) ' === orbc                   ===' , orbc
      write(24,80) ' === ahores and  rest mass  ===' , ahores, restmass
      write(24,80) ' === emdc                   ===' , emdc
      write(24,80) ' === ratio  and  mass ratio ===' , ratio, ratmas
      write(24,80) ' === AH mass                ===' , ahmass
      write(24,81) ' = parameter iteration level  =',(ifphy(ii),ii=1,5)
c
c
      sg_phy(1) = dsign(1.0d0,fixedmom)
      sg_phy(2) = dsign(1.0d0,omebvy)
      sg_phy(3) = dsign(1.0d0,fixedkom - fixedadm)
      sg_phy(4) = dsign(1.0d0,ratio - ratmas)
      sg_phy(5) = dsign(1.0d0,ahores - restmass)
c
c --  icount_adj(i,1) : count alternation of the sign.
c --  icount_adj(i,2) : count no change   of the sign.
c
      if(sg_phy(1).ne.sg_phy_bk(1)) icount_adj(1,1)=icount_adj(1,1)+1
      if(sg_phy(2).ne.sg_phy_bk(2)) icount_adj(2,1)=icount_adj(2,1)+1
      if(sg_phy(3).ne.sg_phy_bk(3)) icount_adj(3,1)=icount_adj(3,1)+1
      if(sg_phy(4).ne.sg_phy_bk(4)) icount_adj(4,1)=icount_adj(4,1)+1
      if(sg_phy(5).ne.sg_phy_bk(5)) icount_adj(5,1)=icount_adj(5,1)+1
      if(sg_phy(1).eq.sg_phy_bk(1)) icount_adj(1,2)=icount_adj(1,2)+1
      if(sg_phy(2).eq.sg_phy_bk(2)) icount_adj(2,2)=icount_adj(2,2)+1
      if(sg_phy(3).eq.sg_phy_bk(3)) icount_adj(3,2)=icount_adj(3,2)+1
      if(sg_phy(4).eq.sg_phy_bk(4)) icount_adj(4,2)=icount_adj(4,2)+1
      if(sg_phy(5).eq.sg_phy_bk(5)) icount_adj(5,2)=icount_adj(5,2)+1
c
      do 200 ii = 1, 5
      if (ifphy(ii).eq.18) go to 201
      if(icount_adj(ii,1).gt.5) then 
      icount_adj(ii,1) = 1
      icount_adj(ii,2) = 1
      ifphy(ii) = ifphy(ii) + 1
      end if
 201  continue
      if(icount_adj(ii,1).eq.1.and.icount_adj(ii,2).gt.50) then 
      icount_adj(ii,1) = 1
      icount_adj(ii,2) = 1
      ifphy(ii) = ifphy(ii) - 1
      if (ifphy(ii).le.1) ifphy(ii) = 1
      if (ifphy( 5).le.5) ifphy( 5) = 5
      end if
      if(sg_phy(5).eq.sg_phy_bk(5)) icount_adj(5,2)=icount_adj(5,2)+1
      sg_phy_bk(ii) = sg_phy(ii)
 200  continue
c
      fac0 = sg_phy(1)*facp(ifphy(1))
      pmomy = (1.0d0 - fac0)*pmomy
c
      fac0 = sg_phy(2)*facp(ifphy(2))
      orbc = (1.0d0 + fac0)*orbc
ctesttest      orbc = (1.0d0 - fac0)*orbc
c
      fac0 = sg_phy(3)*facp(ifphy(3))
      apmass = (1.0d0 - fac0)*apmass
c
      fac0 = sg_phy(4)*facp(ifphy(4))
      bhmass = (1.0d0 + fac0)*bhmass
c
ccc      if (emxemd.lt.1.0d-4) then
      if (emxemd.lt.rmeps) then
      fac0 = sg_phy(5)*facp(ifphy(5))
      emdc = (1.0d0 - fac0)*emdc
      end if
c
      return
c            
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_orb_center(imascond,emxemd,eps,fmax0)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/CB_shift_bh.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      common / adjbhm3 / bvybak(0:4), orbbak(0:4)
c
      bvyubh = bvyub(0,ntbeq,npbxz)
      vphiyb = dis - orbc 
      omephi  = - ome*vphiyb
      write(6,80) ' === omephi and betay      ===' , omephi, bvyubh
      write(6,80) ' === orbc                  ===' , orbc
c
 80   format(1a30,1p,2e12.4) 
c
      if (emxemd.gt.1.0d-3) return
      write(24,80) ' === omephi and betay      ===' , omephi, bvyubh
      write(24,80) ' === orbc                  ===' , orbc
c
      do 10 ii = 0, 3
      bvybak(ii) = bvybak(ii+1)
      orbbak(ii) = orbbak(ii+1)
 10   continue
      bvyubh = bvyub(0,ntbeq,npbxz)
      vphiyb = dis - orbc 
      omephi = - ome*vphiyb
      omebvy  = (omephi - bvyubh)/dabs(omephi)
      bvybak(4) = omebvy
      orbbak(4) = orbc
c
      go to (1,2,3) imascond
 1    continue
      if (omebvy.le.0.0d0) orbc = (1.0d0+0.05d0)*orbc
      if (omebvy.gt.0.0d0) orbc = (1.0d0-0.05d0)*orbc
      imascond = 2
      return
 2    fac1 = (0.0d0 - bvybak(3))/(bvybak(4) - bvybak(3))
      fac2 = 1.0d0 - fac1
      orbc = fac2*orbbak(3) + fac1*orbbak(4)
      fmax0 = 1.0d0
      if (dabs(orbc - orbbak(4))/dabs(orbc).le.1.0d-4) then
ccc      bheps = eps
      imascond = 3
ccc      fmax0 = 1.0d0
      end if
      return
 3    continue
      if (dabs(orbc - orbbak(4))/dabs(orbc).gt.1.0d-4) then
      fac1 = (0.0d0 - bvybak(3))/(bvybak(4) - bvybak(3))
      fac2 = 1.0d0 - fac1
      orbc = fac2*orbbak(3) + fac1*orbbak(4)
      fmax0 = 1.0d0
      end if
      return
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine adjust_BY_Py(ipmomycond,emxemd,fitpy,pmomy,fmax0)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      common / admmo0 / rlimom(0:4), ahpmomy(0:4)
c
      write(6,80) ' === pmomy and adm momentum ===' , pmomy, fitpy
 80   format(1a30,1p,2e12.4) 
c
      if (emxemd.gt.1.0d-3) return
      write(24,80) ' === pmomy and adm momentum ===' , pmomy, fitpy
c
      do 10 ii = 0, 3
      rlimom(ii) = rlimom(ii+1)
      ahpmomy(ii) = ahpmomy(ii+1)
 10   continue
      rlimom(4) = fitpy
      ahpmomy(4) = pmomy
c
      go to (1,2,3) ipmomycond
 1    continue
      if (fitpy.ge.0.0d0) pmomy = (1.0d0-0.05d0)*pmomy
      if (fitpy.lt.0.0d0) pmomy = (1.0d0+0.05d0)*pmomy
      ipmomycond = 2
      return
 2    fac1 = (0.0d0 - rlimom(3))/(rlimom(4) - rlimom(3))
      fac2 = 1.0d0 - fac1
      pmomy = fac2*ahpmomy(3) + fac1*ahpmomy(4)
      fmax0 = 1.0d0
      if (dabs(pmomy - ahpmomy(4))/dabs(pmomy).le.1.0d-4) then
cc      rmeps = eps
      ipmomycond = 3
      end if
      return
 3    continue
      if (dabs(pmomy - ahpmomy(4))/dabs(pmomy).gt.1.0d-4) then
      fac1 = (0.0d0 - rlimom(3))/(rlimom(4) - rlimom(3))
      fac2 = 1.0d0 - fac1
      emdc = fac2*ahpmomy(3) + fac1*ahpmomy(4)
      fmax0 = 1.0d0
      end if
      return
c            
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine orb_center_original(iorbcond,emxemd,fitpy,orbc,fmax0)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      common / admmo1 / rlimom(0:4), ahorbc(0:4)
c
cc      write(6,'1a30,1p,2e12.4') 
      write(6,80) ' === orbc and adm momentum ===' , orbc, fitpy
 80   format(1a30,1p,2e12.4) 
c
      if (emxemd.lt.1.0d-3) then
c
      do 10 ii = 0, 3
      rlimom(ii) = rlimom(ii+1)
      ahorbc(ii) = ahorbc(ii+1)
 10   continue
      rlimom(4) = fitpy
      ahorbc(4) = orbc
c
      go to (1,2,3) iorbcond
 1    continue
      if (fitpy.ge.0.0d0) orbc = (1.0d0+0.05d0)*orbc
      if (fitpy.lt.0.0d0) orbc = (1.0d0-0.05d0)*orbc
      iorbcond = 2
      return
 2    fac1 = (0.0d0 - rlimom(3))/(rlimom(4) - rlimom(3))
      fac2 = 1.0d0 - fac1
      orbc = fac2*ahorbc(3) + fac1*ahorbc(4)
      fmax0 = 1.0d0
      if (dabs(orbc - ahorbc(4))/orbc.le.1.0d-4) then
cc      rmeps = eps
      iorbcond = 3
      end if
      return
 3    continue
      if (dabs(orbc - ahorbc(4))/orbc.gt.1.0d-4) then
      fac1 = (0.0d0 - rlimom(3))/(rlimom(4) - rlimom(3))
      fac2 = 1.0d0 - fac1
      emdc = fac2*ahorbc(3) + fac1*ahorbc(4)
      fmax0 = 1.0d0
      end if
      return
c            
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine puncutre_velocity(iswitch)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/CB_shift_bh.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_bhphy.f'
c
      bvyubh = bvyub(0,ntbeq,npbxz)
      vphiyb = dis - orbc 
      omephi  = - ome*vphiyb
      if (iswitch.eq.1) then
      write(6,80) ' === pmomy                 ===' , pmomy
      write(6,80) ' === omephi and betay      ===' , omephi, bvyubh
      end if
 80   format(1a30,1p,2e12.4) 
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bhcenter
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension gamd(3,3), gamu(3,3)
c
      disl = dis - bhrad*0.5d0
      disr = dis + bhrad*0.5d0
      disc = 0.5d0*(disl + disr)
c
      icount = 0
 1000 continue
      icount = icount + 1
      if (icount.ge.1000) then
      write(6,*) ' can not find BH center. '
      stop
      end if
c
      aldetl = aldet(disl)
      aldetr = aldet(disr)
      aldetc = aldet(disc)
c
      if (aldetc*aldetl.lt.0.0d0) then
      disr = disc
      disc  = 0.5d0*(disr + disl)
      end if
      if (aldetc*aldetr.lt.0.0d0) then
      disl = disc
      disc  = 0.5d0*(disr + disl)
      end if
c
      error = dabs(disl-disr)
      if (error.le.1.0d-14) then
      bhdis = 0.5d0*(disl + disr)
      go to 1001
      end if
c
      go to 1000
c
 1001  continue
c
      end
c
      function aldet(dispp)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      dimension gamd(3,3), gamu(3,3)
c
      do 1 ioi = 0, 1
      if (ioi.eq.0) ipb = 0
      if (ioi.eq.1) ipb = npbxzm
      irb = 0
      itb = ntb
c
      x1 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis - dispp
      y1 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z1 = rb(irb)*costheb(itb)
      x2 = rb(irb)*sintheb(itb)*cosphib(ipb) + dis + dispp
      y2 = rb(irb)*sintheb(itb)*sinphib(ipb)
      z2 = rb(irb)*costheb(itb)
c
ck      call kerrschildmet(x1,y1,z1,x2,y2,z2,bhmass,bhmass,bhspin,bhspin,
ck     &  gamd,gamu,hm1,hm2,elx1,ely1,elz1,elx2,ely2,elz2,gksdet,pat,pat)
c
      bxd = 2.0d0*hm1*elx1 + 2.0d0*hm2*elx2
      byd = 2.0d0*hm1*ely1 + 2.0d0*hm2*ely2
      bzd = 2.0d0*hm1*elz1 + 2.0d0*hm2*elz2
      bvbv =(gamu(1,1)*bxd*bxd + gamu(1,2)*bxd*byd + gamu(1,3)*bxd*bzd
     &     + gamu(2,1)*byd*bxd + gamu(2,2)*byd*byd + gamu(2,3)*byd*bzd
     &     + gamu(3,1)*bzd*bxd + gamu(3,2)*bzd*byd + gamu(3,3)*bzd*bzd)
     &     * gksdet**(-1.0d0/3.0d0)
c
      if (ioi.eq.0) alphr = dsqrt(1.0d0 - 2.0d0*(hm1+hm2) + bvbv)
      if (ioi.eq.1) alphl = dsqrt(1.0d0 - 2.0d0*(hm1+hm2) + bvbv)
c
    1 continue
c
      aldet = alphr - alphl
c
      end
c
c -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
      subroutine bhns_xaxis
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      common / augfn / emdg(0:nnrg,0:nntg,0:nnpg),
     &                 ramg(0:nnrg,0:nntg,0:nnpg), 
     &               gradvg(0:nnrg,0:nntg,0:nnpg,1:3)
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      character*4 char
      character*3 moji
c
      pi = 3.141592654d0
c
      open(18,file='xgnu.output_x_pm',status='unknown')
      open(19,file='xgnu.output_bh_x_pm',status='unknown')
c
      small = 1.0d-9
      ipg = npgxzm
      itg = ntg
      iflag = 0
c
      do 5510 irg = 0, nrtot
c
      rgc = - rg(irg)
      psic = psi(irg,itg,ipg)
      alphc = alph(irg,itg,ipg)
      bydc = bvyd(irg,itg,ipg)
      wyc = wyd(irg,itg,ipg)
      psierc = paerr(psic,rgc,0)
      alpherc = paerr(alphc,rgc,1)
      emdgc = emdg(irg,itg,ipg)
      ramgc = ramg(irg,itg,ipg)
      emden = 0.0d0
      ramda = 0.0d0
      if (emdgc.gt.0.0d0) emden = emdgc
      if (emdgc.gt.0.0d0) ramda = ramgc
c
      write(18,4400) rgc,psic,alphc,bydc,psierc,alpherc,emden,ramda
     &              ,wyc
c
 5510 continue
c
      write(18,*) ' '
      iflag = 0
c
      ipg = npgxz
c
      do 5511 irg = 0, nrtot
c
      rgc  = rg(irg)
      psic = psi(irg,itg,ipg)
      alphc = alph(irg,itg,ipg)
      bydc = bvyd(irg,itg,ipg)
      wyc = wyd(irg,itg,ipg)
      psierc = paerr(psic,rgc,0)
      alpherc = paerr(alphc,rgc,1)
      emdgc = emdg(irg,itg,ipg)
      ramgc = ramg(irg,itg,ipg)
      emden = 0.0d0
      ramda = 0.0d0
      if (emdgc.gt.0.0d0) emden = emdgc
      if (emdgc.gt.0.0d0) ramda = ramgc
c
      if (rg(irg).le.ding+small) then 
      write(18,4400) rgc,psic,alphc,bydc,psierc,alpherc,emden,ramda
     &              ,wyc
      else if (rg(irg).ge.dis+radint-small) then 
      if (iflag.eq.0) write(18,*) ' '
      iflag = 1
      write(18,4400) rgc,psic,alphc,bydc,psierc,alpherc,emden,ramda
     &              ,wyc
      else
      go to 5511
      end if
c
 5511 continue
c
c
      write(19,*) ' '
      ipb = 0
      itb = ntb
      do 1512 irb = 0, nrb
      rbc  = dis+rb(irb)
      psibc = psib(irb,itb,ipb)
      alphbc = alphb(irb,itb,ipb)
      bydbc = bvydb(irb,itb,ipb)
      wybc = wydb(irb,itb,ipb)
      psierbc = paerr(psibc,rbc,0)
      alpherbc = paerr(alphbc,rbc,1)
      emden = 0.0d0
      ramda = 0.0d0
      write(19,4400)rbc,psibc,alphbc,bydbc,psierbc,alpherbc,emden,ramda
     &              ,wybc
 1512 continue
      write(19,*) ' '
      ipb = npbxzm
      itb = ntb
      do 1514 irb = 0, nrb
      rbc  = dis-rb(irb)
      psibc = psib(irb,itb,ipb)
      alphbc = alphb(irb,itb,ipb)
      bydbc = bvydb(irb,itb,ipb)
      wybc = wydb(irb,itb,ipb)
      psierbc = paerr(psibc,rbc,0)
      alpherbc = paerr(alphbc,rbc,1)
      emden = 0.0d0
      ramda = 0.0d0
      write(19,4400)rbc,psibc,alphbc,bydbc,psierbc,alpherbc,emden,ramda
     &              ,wybc
 1514 continue
c
 4000 format(1p,6e12.4)
 4400 format(1p,50e14.6)
c
      close(18)
      close(19)
c
c
      open(18,file='xgnu_fig_rseq.dat',status='unknown')
      open(19,file='xgnu_fig_rsme.dat',status='unknown')
c
      pi = 3.14159265358979d+0
c
      do 410 ipf = 0, npf
      phi0 = pi*dble(ipf)/dble(npf)
      xxeq = rs(ntf,ipf)*dcos(phi0)
      yyeq = rs(ntf,ipf)*dsin(phi0)
      write(18,201) xxeq, yyeq
 410  continue
      do 411 ipf = npf+1, 2*npf
      phi0 = pi*dble(ipf)/dble(npf)
      xxeq = rs(ntf,2*npf-ipf)*dcos(phi0)
      yyeq = rs(ntf,2*npf-ipf)*dsin(phi0)
      write(18,201) xxeq, yyeq
 411  continue
c
      do 4100 itf = 0, ntf*2
      iitf = iabs(ntf - itf)
      iipf = 0
      if (ntf - itf.lt.0) iipf = npf
      the0 = pi/2.*dble(itf)/dble(ntf)
      xxme = rs(iitf,iipf)*dcos(the0)
      zzme = rs(iitf,iipf)*dsin(the0)
      write(19,201) xxme, zzme
 4100 continue
      do 4110 itf = 0, ntf*2
      iitf = iabs(ntf - itf)
      iipf = npf
      if (ntf - itf.lt.0) iipf = 0
      the0 = pi/2.*dble(itf)/dble(ntf) + pi
      xxme = rs(iitf,iipf)*dcos(the0)
      zzme = rs(iitf,iipf)*dsin(the0)
      write(19,201) xxme, zzme
 4110 continue
c
 201  format(1p,50e14.6)
c
      close(18)
      close(19)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function paerr(psal,rv,ipa)
      implicit real*8 (a-h,o-z), integer (i-n)
c
c     ipa = 0 : psi
c           1 : alpha
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
ctest      bhmass = 2.0d0*bhrad
ctest      bhmass = bhrad
      rr1 = dabs(rv - dis)
      rr2 = dabs(rv + dis)
c
      psi0  = 1.0d0 + 0.5d0*bhmass/rr1 + 0.5d0*bhmass/rr2
      alps0 = 1.0d0 - 0.5d0*bhmass/rr1 - 0.5d0*bhmass/rr2
      alph0 = alps0/psi0
c
      if (ipa.eq.0) paerr = dabs((psi0 - psal)/psi0)*100.0d0
      if (ipa.eq.1) paerr = dabs((alph0 - psal)/alph0)*100.0d0
c
      end
c ______________________________________________________________________
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine confflat(x1,y1,z1,x2,y2,z2,rmass1,rmass2,spin1,spin2,
     &                      gamd,gamu,dgamd,gamdet,cri,crid,trcri,gmcri,
     &                      gdcri,ricci,ricsca,trk,dtrk,divom,ddivom,
     &                      pat1,pat2)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      dimension 
     &          gamd(3,3),dgamd(3,3,3),ddgamd(3,3,3,3),
     &          gamu(3,3),dgamu(3,3,3),ddgamu(3,3,3,3),
     &          crid(3,3,3),cri(3,3,3),trcri(3),gmcri(3),gdcri(3,3),
     &          ricci(3,3),dcri(3,3,3,3),dtrcri(3,3),domom(3),
     &          dtrk(3),omd(3),domd(3,3),ddomd(3,3,3),ddivom(3)
c
c --- conformal flat
c
c
      gamd(1,1) = 1.0d0
      gamd(1,2) = 0.0d0
      gamd(1,3) = 0.0d0
      gamd(2,1) = 0.0d0
      gamd(2,2) = 1.0d0
      gamd(2,3) = 0.0d0
      gamd(3,1) = 0.0d0
      gamd(3,2) = 0.0d0
      gamd(3,3) = 1.0d0
      gamu(1,1) = 1.0d0
      gamu(1,2) = 0.0d0
      gamu(1,3) = 0.0d0
      gamu(2,1) = 0.0d0
      gamu(2,2) = 1.0d0
      gamu(2,3) = 0.0d0
      gamu(3,1) = 0.0d0
      gamu(3,2) = 0.0d0
      gamu(3,3) = 1.0d0
c
      gamdet = 1.0d0
c
      do 10 ic = 1, 3
      do 10 ib = 1, 3
      do 10 ia = 1, 3
      dgamd(ia,ib,ic) = 0.0d0
      cri(ia,ib,ic) = 0.0d0
      crid(ia,ib,ic) = 0.0d0
 10   continue
c
      do 13 ia = 1, 3
      trcri(ia) = 0.0d0
      gmcri(ia) = 0.0d0
      dtrk(ia) = 0.0d0
   13 continue
c
c
      do 14 ib = 1, 3
      do 14 ia = 1, 3
      gdcri(ia,ib) = 0.0d0
      ricci(ia,ib) = 0.0d0
   14 continue
c
      ricsca = 0.0d0
      trk    = 0.0d0
      divom = 0.0d0
      do 29 ia = 1, 3
      ddivom(ia) = 0.0d0
   29 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine confflatcri(x1,y1,z1,x2,y2,z2,rmass1,rmass2,
     &                         spin1,spin2,gamd,gamu,dgamd,cri,crid,
     &                         pat1,pat2)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      dimension 
     &          gamd(3,3),dgamd(3,3,3),
     &          gamu(3,3),dgamu(3,3,3),
     &          crid(3,3,3),cri(3,3,3)
c
c --- Compute back ground geometry.
c
      gamd(1,1) = 1.0d0
      gamd(1,2) = 0.0d0
      gamd(1,3) = 0.0d0
      gamd(2,1) = 0.0d0
      gamd(2,2) = 1.0d0
      gamd(2,3) = 0.0d0
      gamd(3,1) = 0.0d0
      gamd(3,2) = 0.0d0
      gamd(3,3) = 1.0d0
      gamu(1,1) = 1.0d0
      gamu(1,2) = 0.0d0
      gamu(1,3) = 0.0d0
      gamu(2,1) = 0.0d0
      gamu(2,2) = 1.0d0
      gamu(2,3) = 0.0d0
      gamu(3,1) = 0.0d0
      gamu(3,2) = 0.0d0
      gamu(3,3) = 1.0d0
c
      do 10 ic = 1, 3
      do 10 ib = 1, 3
      do 10 ia = 1, 3
      cri(ia,ib,ic) = 0.0d0
      crid(ia,ib,ic) = 0.0d0
      dgamd(ia,ib,ic) = 0.0d0
 10   continue
c
      end
c
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine reset_alpha
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metbh.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
c --  set alpha
c
      small = 1.0d-10
      do 103 ipg = 0, npg
      do 103 itg = 0, ntg
      do 103 irg = 0, nrtot
      if (alph(irg,itg,ipg).le.0.0d0) then
      alph(irg,itg,ipg) = small
      alps(irg,itg,ipg) = small*psi(irg,itg,ipg)
      end if
cc      alph(irg,itg,ipg) = 1.0d0
cc      alps(irg,itg,ipg) = alph(irg,itg,ipg)*psi(irg,itg,ipg)
  103 continue
      do 104 ipb = 0, npb
      do 104 itb = 0, ntb
      do 104 irb = 0, nrb
      if (alphb(irb,itb,ipb).le.0.0d0) then
      alphb(irb,itb,ipb) = small
      alpsb(irb,itb,ipb) = small*psib(irb,itb,ipb)
      end if
cc      alphb(irb,itb,ipb) = 1.0d0
cc      alpsb(irb,itb,ipb) = alphb(irb,itb,ipb)*psib(irb,itb,ipb)
 104  continue
c
      end
