c ______________________________________________________________________
c ______________________________________________________________________
c
      program sphtocar
c
c --- For BHNS
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'grparmca.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/CB_param_cordp.f'
c
      character*1 chrot,chbhs,chgra,chope
      character*4 char
c
      pi = 3.14159265358979d+0
c
c --- Read files from storage.
c
      call input_alldata(char)
ccc      call subio_fluid(char)
ccc      call subio(char)
c
c +++ Coordinates
c
      drdr = 1.0d0/dble(nrf)
      rbov = dble(nrbov)*drdr
      dis = drdr*dnint(dis/drdr)
      ding = 1.0d0 + 2.0d0*rbov
      radint = dis - ding
      radext = radint + rbov
      radmid = dis + radext + rbov
      nrin = idnint(radmid/drdr) 
      nrtot = nrin + nrout 
c
c
cpuncture
      nrb0 = 0
      nrbin = nrb - nrbov
      npbxzm = npb/2
c
c###  GR coordinate, phig = -pi/4 to 3pi/4 
      nrgsf = nrf
      ntgeq = ntg
      npgxz  = npg/4
      npgyz  = npg/2
      npgxzm = 3*npg/4
      npgyzm = npg
c
c###  Fluid coordinate, phib = 0 to pi 
      nr = nrf
      nt = ntf
      np = npf
      ntfeq = ntf
      npfxz = 0
      npfyz = npf/2
      npfxzm= npf
c
      chrot = char(1:1)
      chbhs = char(2:2)
      chgra = char(3:3)
      chope = char(4:4)
c
      call nonvfl
      call nonvgr
      call nonvbh
c
      call subioca(chrot)
c
c
      end
c      
      include 'IO_input_alldata.f'
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subioca(chrot)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'grparmca.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_bhbou.f'
      include 'common_blocks/CB_param_intpp.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_bhphy.f'
      include 'common_blocks/CB_param_flphy.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, itbh
c
      common / meshc / nx, ny, nz, 
     &                 nxminb, nxmaxb, nyminb, nymaxb, nzmaxb,
     &                 nxminf, nxmaxf, nyminf, nymaxf, nzmaxf
      common / coorc / xx(nnx), yy(nny), zz(nnz) 
c
      common / kijall  / rkxxd(0:nnrg,0:nntg,0:nnpg),
     &                   rkxyd(0:nnrg,0:nntg,0:nnpg),
     &                   rkxzd(0:nnrg,0:nntg,0:nnpg),
     &                   rkyyd(0:nnrg,0:nntg,0:nnpg),
     &                   rkyzd(0:nnrg,0:nntg,0:nnpg),
     &                   rkzzd(0:nnrg,0:nntg,0:nnpg)
      common / kijball / rkxxdb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkxydb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkxzdb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkyydb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkyzdb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkzzdb(nnrb0:nnrb,0:nntb,0:nnpb)
c
      dimension vx(0:nnr,0:nnt,0:nnp), 
     &          vy(0:nnr,0:nnt,0:nnp), 
     &          vz(0:nnr,0:nnt,0:nnp), 
     &       emdex(0:nnr,0:nnt,0:nnp), 
     &        rsex(0:nnt,0:nnp)
      dimension gradv(0:nnr,0:nnt,0:nnp,1:3)
c
      dimension grvca(nnx,nny,nnz)
c
      character*3 chpr
      character*1 chrot,chgra
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
      open(21,file='gnbcart.dat',status='old')
c
c --  Interpolation to Cartesian coordinate.
c
      read(21,2400) nx, ny, nz, nstar
      read(21,2401) chpr
      write(6,2400) nx, ny, nz, nstar
      if (chpr.eq.'ini') ifl = 1
      if (chpr.eq.'shi') ifl = 2
      if (chpr.eq.'hwh') ifl = 3
      if (chpr.eq.'all') ifl = 4
      if (chpr.eq.'nsi') ifl = 5
      if (chpr.eq.'sha') ifl = 7
      if (chpr.eq.'fig') ifl = 8
      close(21)
 2400 format(4i5)
 2401 format(2x,a3)
c
c ---- nstar = grid points per a radius (half diameter) of a star. 
c ---- edge of computational domain would be nxout = nx/nstar.  
c
      nxout = nx/nstar
      dx = 1.0d0/dble(nstar)
      dy = dx
      dz = dy
      xop = dble(nx/2)*dx - 0.5d0*dx
      xom = -xop
      yop = dble(ny/2)*dy - 0.5d0*dy
      yom = -yop
      zop = dble(nz)*dz - 0.5d0*dz
      zom = 0.5d0*dz
c
      do 101 ix = 1, nx
      xx(ix) = xom + dble(ix-1)*dx
 101  continue
      do 102 iy = 1, ny
      yy(iy) = yom + dble(iy-1)*dy
 102  continue
      do 104 iz = 1, nz
      zz(iz) = zom + dble(iz-1)*dz
 104  continue
c
      nxminb = 1
      nxminf = 1
      do 107 ii = 1, nx
      if (xx(ii).lt.dis-orbc-radext) nxminb = ii
      if (xx(ii).lt.dis-orbc+radext) nxmaxb = min0(ii+1,nx)
      if (xx(ii).lt.   -orbc-1.0d0 ) nxminf = ii
      if (xx(ii).lt.   -orbc+1.0d0 ) nxmaxf = min0(ii+1,nx)
 107  continue
      nyminb = 1
      nyminf = 1
      do 108 ii = 1, ny
      if (yy(ii).lt.-radext) nyminb = ii
      if (yy(ii).lt. radext) nymaxb = min0(ii+1,ny)
      if (yy(ii).lt.-1.0d0 ) nyminf = ii
      if (yy(ii).lt. 1.0d0 ) nymaxf = min0(ii+1,ny)
 108  continue
      do 109 ii = 1, nz
      if (zz(ii).lt. radext) nzmaxb = min0(ii+1,nz)
      if (zz(ii).lt. 1.0d0 ) nzmaxf = min0(ii+1,nz)
 109  continue
c
c
      write(6,*) dis, orbc
      write(6,*) radext, radint, radmid
      write(6,*) xx(1), xx(nx)
      write(6,*) yy(1), yy(ny)
      write(6,*) zz(1), zz(nz)
      write(6,*) nxminb, nxmaxb, nxminf, nxmaxf
      write(6,*) nyminb, nymaxb, nyminf, nymaxf
      write(6,*) nzmaxb, nzmaxf
c
      if (nxmaxb.gt.nx) stop ' nxmaxb strange '
      if (nzmaxb.gt.nz) stop ' nzmaxb strange '
      if (nxmaxf.gt.nx) stop ' nxmaxf strange '
      if (nzmaxf.gt.nz) stop ' nzmaxf strange '
      if (xx(1).le.rg(1)) write(6,*) 
     & ' ### Cartesian grid is finer than spherical grid. ###'
c
c
c --------------
c --- Write. ---
c --------------
c
cshi      rkappa = 200.d0/pi
      rkappa = 1.d0
      rkapmn = rkappa**(-pinx)
      rkapn2 = rkappa**(pinx/2.0d0)
      dxx = dx*rkapn2*radi
      dyy = dy*rkapn2*radi
      dzz = dz*rkapn2*radi
      xbd = xx(nx)*rkapn2*radi
      ybd = yy(ny)*rkapn2*radi
      zbd = zz(nz)*rkapn2*radi
      romega = ome/rkapn2/radi*fitadm
      rradi = radi*rkapn2
      small = 1.0d-20
      rdis = dis*rkapn2*radi
      rorbc = orbc*rkapn2*radi
c
      open(8,file='parameter.dat',status='unknown')
      write(8,100) nx,ny,nz
      write(8,200) dxx,dyy,dzz
      write(8,200) xbd, ybd, zbd
      write(8,200) rkappa, pinx
      write(8,200) radi, romega
      write(8,200) rdis, rorbc
      write(8,200) fitadm, fitkom
      write(8,200) fitang, fitpy
      write(8,200) restmass, gravmass
      close(8)
c
      write(6,*) ' psi '
      call gr2cgr(psi,grvca)
      call bh2cgr(psib,grvca)
      call output_ca(grvca,1)
c
      write(6,*) ' alpha '
      call gr2cgr(alph,grvca)
      call bh2cgr(alphb,grvca)
      call output_ca(grvca,2)
c
      write(6,*) ' shift_x '
      call gr2cgr(bvxd,grvca)
      call bh2cgr(bvxdb,grvca)
      call output_ca(grvca,3)
c
      write(6,*) ' shift_y '
      call gr2cgr(bvyd,grvca)
      call bh2cgr(bvydb,grvca)
      call output_ca(grvca,4)
c
      write(6,*) ' shift_z '
      call gr2cgr(bvzd,grvca)
      call bh2cgr(bvzdb,grvca)
      call output_ca(grvca,5)
c
      call excurve_shibata
c
      write(6,*) ' k_xx '
      call gr2cgr(rkxxd,grvca)
      call bh2cgr(rkxxdb,grvca)
      call output_ca(grvca,11)
c
      write(6,*) ' k_xy '
      call gr2cgr(rkxyd,grvca)
      call bh2cgr(rkxydb,grvca)
      call output_ca(grvca,12)
c
      write(6,*) ' k_xz '
      call gr2cgr(rkxzd,grvca)
      call bh2cgr(rkxzdb,grvca)
      call output_ca(grvca,13)
c
      write(6,*) ' k_yy '
      call gr2cgr(rkyyd,grvca)
      call bh2cgr(rkyydb,grvca)
      call output_ca(grvca,14)
c
      write(6,*) ' k_yz '
      call gr2cgr(rkyzd,grvca)
      call bh2cgr(rkyzdb,grvca)
      call output_ca(grvca,15)
c
      write(6,*) ' k_zz '
      call gr2cgr(rkzzd,grvca)
      call bh2cgr(rkzzdb,grvca)
      call output_ca(grvca,16)
c
c      call gr2cgr(hxxd,hxxca)
c      call gr2cgr(hxyd,hxyca)
c      call gr2cgr(hxzd,hxzca)
c      call gr2cgr(hyyd,hyyca)
c      call gr2cgr(hyzd,hyzca)
c      call gr2cgr(hzzd,hzzca)
c
c      do 2 ipg = 0, npg
c      do 2 itg = 0, ntg
c      do 2 irg = 0, nrtot
c      hxxmhyyd(irg,itg,ipg)=0.5d0*(hxxd(irg,itg,ipg)-hyyd(irg,itg,ipg))
c      hxxmhzzd(irg,itg,ipg)=0.5d0*(hxxd(irg,itg,ipg)-hzzd(irg,itg,ipg))
c 2    continue
c      call gr2cgr(hxxmhyyd,hxxmhyyca)
c      call gr2cgr(hxxmhzzd,hxxmhzzca)
c
c
      call flgrad4(vep,gradv,rs,1,0)
c
      if (chrot.eq.'i') then
      write(6,*) ' Irrotational model. v covariant lower '
c
      do 1 ip = 0, np
      ipex = 2*np - ip
      do 1 it = 0, nt
      rsex(it,ip  ) = rs(it,ip)
      rsex(it,ipex) = rs(it,ip)
      do 1 ir = 0, nr
      emdex(ir,it,ip  ) = emd(ir,it,ip)
      emdex(ir,it,ipex) = emd(ir,it,ip)
      hhhinv = 1.0d0/(1.0d0 + (pinx+1.0d0)*emd(ir,it,ip))
      vx(ir,it,ip  ) = hhhinv*gradv(ir,it,ip,1)
      vy(ir,it,ip  ) = hhhinv*gradv(ir,it,ip,2)
      vz(ir,it,ip  ) = hhhinv*gradv(ir,it,ip,3)
      vx(ir,it,ipex) =-hhhinv*gradv(ir,it,ip,1)
      vy(ir,it,ipex) = hhhinv*gradv(ir,it,ip,2)
      vz(ir,it,ipex) =-hhhinv*gradv(ir,it,ip,3)
 1    continue
c
      else if (chrot.eq.'c') then
      write(6,*) ' Co-rotational model. v contravariant upper '
      do 4 ip = 0, np
      do 4 it = 0, nt
      do 4 ir = 0, nr
      xxxx = -orbc + r(ir)*rs(it,ip)*sinthe(it)*cosphi(ip)
      yyyy =         r(ir)*rs(it,ip)*sinthe(it)*sinphi(ip)
      vx(ir,it,ip) = - ome*yyyy
      vy(ir,it,ip) =   ome*xxxx
      vz(ir,it,ip) = 0.0d0
 4    continue
      else
      stop ' Unknown rotation law.' 
      end if
c
      write(6,*) ' fluid '
c
      call fl2cgr(emdex,grvca,rsex)
      call output_ca(grvca,21)
      call fl2cgr(vx,grvca,rsex)
      call output_ca(grvca,22)
      call fl2cgr(vy,grvca,rsex)
      call output_ca(grvca,23)
      call fl2cgr(vz,grvca,rsex)
      call output_ca(grvca,24)
c
c
c --- END
c
c
 100  format(4i5)
 200  format(1p,5e23.15)
 201  format(1p,20e14.6)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine output_ca(grvca,ifile)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'grparmca.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      common / meshc / nx, ny, nz, 
     &                 nxminb, nxmaxb, nyminb, nymaxb, nzmaxb,
     &                 nxminf, nxmaxf, nyminf, nymaxf, nzmaxf
c
      dimension grvca(nnx,nny,nnz)
c
      character*8 moji
c
c --- OUTPUT Shibata initial.
c
      if (ifile.eq.1) moji = 'data_psi'
      if (ifile.eq.2) moji = 'data_alp'
      if (ifile.eq.3) moji = 'data_bxd'
      if (ifile.eq.4) moji = 'data_byd'
      if (ifile.eq.5) moji = 'data_bzd'
      if (ifile.eq.11) moji = 'data_kxx'
      if (ifile.eq.12) moji = 'data_kxy'
      if (ifile.eq.13) moji = 'data_kxz'
      if (ifile.eq.14) moji = 'data_kyy'
      if (ifile.eq.15) moji = 'data_kyz'
      if (ifile.eq.16) moji = 'data_kzz'
      if (ifile.eq.21) moji = 'data_rho'
      if (ifile.eq.22) moji = 'data_vxd'
      if (ifile.eq.23) moji = 'data_vyd'
      if (ifile.eq.24) moji = 'data_vzd'
c
      open(18,file=moji//'.dat',status='unknown')
      write(18,100) nx,ny,nz
c
      do 10 iz = 1, nz
      do 10 iy = 1, ny
      do 10 ix = 1, nx
      write(18,200) grvca(ix,iy,iz)
 10   continue
c
      close(18)
c
c --- END
c
 100  format(4i5)
 200  format(1p,5e23.15)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine gr2cgr(fnc,cfn)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'grparmca.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/CB_param_cordp.f'
c
      common / meshc / nx, ny, nz, 
     &                 nxminb, nxmaxb, nyminb, nymaxb, nzmaxb,
     &                 nxminf, nxmaxf, nyminf, nymaxf, nzmaxf
      common / coorc / xx(nnx), yy(nny), zz(nnz) 
      dimension fnc(0:nnrg,0:nntg,0:nnpg), cfn(nnx,nny,nnz),
     &          fr4(4), ft4(4), fp4(4), r4(4), th4(4), phi4(4)
c
c
      tiny = 1.0d-14
c      tiny = 0.0d0
      pi = 3.14159265358979d+0
c
      do 10 iz = 1, nz
      do 10 iy = 1, ny
      do 10 ix = 1, nx
c
      xv = xx(ix) + orbc
      yv = yy(iy)
      zv = zz(iz)
      xxyy = sqrt(xv**2 + yv**2 + tiny)
      rv = sqrt(xv**2 + yv**2 + zv**2 + tiny)
      tv = datan2(xxyy,zv+tiny)
      pv = dmod(datan2(yv,xv+tiny)+2.0d0*pi,2.0d0*pi)
      if (pv.ge.3.0d0*pi/2.0d0) pv = -pi/2.0d0+ddim(pv,3.0d0*pi/2.0d0)
c
      if (ix.eq.nx/2+10.and.iy.ge.ny/2-2.and.iy.le.ny/2+2.and.iz.eq.1)
     & write(6,*) pv
c
      rvbh = sqrt((xv-dis)**2 + yv**2 + zv**2 + tiny)
      if (rvbh.lt.radint) go to 10
c
      do 112 irg = 0, nrtot - 1
      if (rv.ge.rg(irg).and.rv.lt.rg(irg+1)) then
      ir0 = min0(max0(irg-1,0),nrtot-3)
      go to 113
      end if
 112  continue
 113  continue
      do 114 itg = 0, ntg - 1
      if (tv.ge.thg(itg).and.tv.lt.thg(itg+1)) then
      it0 = min0(max0(itg-1,0),ntg-3)
      go to 115
      end if
 114  continue
 115  continue
      do 116 ipg = 0, npg - 1
      if (pv.ge.phig(ipg).and.pv.lt.phig(ipg+1)) then
ccc      ip0 = min0(max0(ipg-1,0),npg-3)
      ip0 = ipg-1
      go to 117
      end if
 116  continue
 117  continue
c
      do 20 ii = 1, 4
      irg0 = ir0 + ii - 1 
      itg0 = it0 + ii - 1
ccc      ipg0 = ip0 + ii - 1
      r4(ii) = rg(irg0)
      th4(ii) = thg(itg0)
ccc      phi4(ii) = phig(ipg0)
c ##  phig = -pi/4 to 3pi/4, equidistant
      phi4(ii) = phig(ip0+1) + dphig*dble(ii-2)
 20   continue
c
c --  general 
c
      do 80 kk = 1, 4
ccc      ipg0 = ip0 + kk - 1 
      ipg0 = mod(ip0+kk-1+npg,npg)
      do 81 jj = 1, 4
      itg0 = it0 + jj - 1 
      do 82 ii = 1, 4
      irg0 = ir0 + ii - 1 
      fr4(ii) = fnc(irg0,itg0,ipg0)
 82   continue
      ft4(jj) = fn_lagint(r4,fr4,rv)
 81   continue
      fp4(kk) = fn_lagint(th4,ft4,tv)
 80   continue
      cfn(ix,iy,iz) = fn_lagint(phi4,fp4,pv)
c
 10   continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine bh2cgr(fnc,cfn)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'grparmca.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / meshc / nx, ny, nz, 
     &                 nxminb, nxmaxb, nyminb, nymaxb, nzmaxb,
     &                 nxminf, nxmaxf, nyminf, nymaxf, nzmaxf
      common / coorc / xx(nnx), yy(nny), zz(nnz) 
c
      dimension fnc(nnrb0:nnrb,0:nntb,0:nnpb), cfn(nnx,nny,nnz)
      dimension fr4(4), ft4(4), fp4(4), r4(4), th4(4), phi4(4)
c
c ---
c
      tiny = 1.0d-14
c      tiny = 0.0d0
      pi = 3.14159265358979d+0
c
      do 100 iz = 1, nzmaxb
      do 100 iy = nyminb, nymaxb
      do 100 ix = nxminb, nxmaxb
c
      xv = xx(ix) + orbc - dis
      yv = yy(iy)
      zv = zz(iz)
      xxyy = dsqrt(xv**2 + yv**2 + tiny)
      rv = dsqrt(xv**2 + yv**2 + zv**2 + tiny)
      tv = datan2(xxyy,zv+tiny)
      pv = dmod(datan2(yv,xv+tiny)+2.0d0*pi,2.0d0*pi)
c
c      if (rv.gt.rb(nrb).or.rv.lt.rb(0)) then 
      if (rv.gt.rb(nrb)) go to 100
c
      do 112 irb = 0, nrb - 1
      if (rv.ge.rb(irb).and.rv.lt.rb(irb+1)) then
      ir0 = min0(max0(irb-1,0),nrb-3)
      go to 113
      end if
 112  continue
 113  continue
      do 114 itb = 0, ntb - 1
      if (tv.ge.thb(itb).and.tv.lt.thb(itb+1)) then
      it0 = min0(max0(itb-1,0),ntb-3)
      go to 115
      end if
 114  continue
 115  continue
      do 116 ipb = 0, npb - 1
      if (pv.ge.phib(ipb).and.pv.lt.phib(ipb+1)) then
ccc      ip0 = min0(max0(ipb-1,0),npb-3)
      ip0 = ipb-1
      go to 117
      end if
 116  continue
 117  continue
c
c
      do 20 ii = 1, 4
      irb0 = ir0 + ii - 1 
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r4(ii) = rb(irb0)
      th4(ii) = thb(itb0)
ccc      phi4(ii) = phib(ipb0)
c ##  phib = 0 to 2pi, equidistant
      phi4(ii) = phib(ip0+1) + dphib*dble(ii-2)
 20   continue
c
c --  general 
      do 80 kk = 1, 4
ccc      ipb0 = ip0 + kk - 1 
      ipb0 = mod(ip0+kk-1+npb,npb)
      do 81 jj = 1, 4
      itb0 = it0 + jj - 1 
      do 82 ii = 1, 4
      irb0 = ir0 + ii - 1 
      fr4(ii) = fnc(irb0,itb0,ipb0)
 82   continue
      ft4(jj) = fn_lagint(r4,fr4,rv)
 81   continue
      fp4(kk) = fn_lagint(th4,ft4,tv)
 80   continue
      cfn(ix,iy,iz) = fn_lagint(phi4,fp4,pv)
c
 100  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine fl2cgr(fnc,cfn,rsex)
c
c --- Compute non-variables for inteporation.
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
      include 'grparmca.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/CB_param_phisp.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / meshc / nx, ny, nz, 
     &                 nxminb, nxmaxb, nyminb, nymaxb, nzmaxb,
     &                 nxminf, nxmaxf, nyminf, nymaxf, nzmaxf
      common / coorc / xx(nnx), yy(nny), zz(nnz) 
c
      dimension fnc(0:nnr,0:nnt,0:nnp), cfn(nnx,nny,nnz)
      dimension rsex(0:nnt,0:nnp)
      dimension fr4(4), ft4(4), fp4(4), r4(4), th4(4), phi4(4)
c
c ---
      do 1000 iz = 1, nz
      do 1000 iy = 1, ny
      do 1000 ix = 1, nx
      cfn(ix,iy,iz) = 0.0d0
 1000 continue
c
      tiny = 1.0d-14
ccc      tiny = 0.0d0
      pi = 3.14159265358979d+0
c
      do 100 iz = 1, nzmaxf
      do 100 iy = nyminf, nymaxf
      do 100 ix = nxminf, nxmaxf
c
      xv = xx(ix) + orbc
      yv = yy(iy)
      zv = zz(iz)
      xxyy = dsqrt(xv**2 + yv**2 + tiny)
      rvg = dsqrt(xv**2 + yv**2 + zv**2 + tiny)
      tv = datan2(xxyy,zv+tiny)
      pv = dmod(datan2(yv,xv+tiny)+2.0d0*pi,2.0d0*pi)
c
      itf = idint(tv*dthfinv)
      ipf = idint(pv*dphifinv)
c
      it0 = min0(max0(itf-1,0),nt-3)
ccc      ip0 = min0(max0(ipf-1,0),np-3)
      ip0 = ipf-1
      phif0  = dphif*dble(ipf)
c
      do 1 ii = 1, 4
c --- theta, phi equidistant mesh.
      th4(ii) = thf(it0+1) + dthf*dble(ii-2)
ccc      phi4(ii) = phif(ip0+1) + dphif*dble(ii-2)
      phi4(ii) = phif0 + dphif*dble(ii-2)
 1    continue
c
c --  compute interpolated value for rs.
c
      rsave = 1.0d0
c
      do 5 jj = 1, 4
      itf0 = it0 + jj - 1
      do 4 ii = 1, 4
ccc      ipf0 = ip0 + ii - 1
      ipf0 = mod(ip0+ii-1+ 2*npf,2*npf)
      fp4(ii)=rsex(itf0,ipf0) 
c
 4    continue
      ft4(jj) = fn_lagint(phi4,fp4,pv)
 5    continue
      rsave = fn_lagint(th4,ft4,tv)
c
      rv = rvg/rsave
      if (rv.gt.1.0d0+tiny) go to 100
c
      irf = idint(rv*drfinv)
      ir0 = min0(max0(irf-1,0),nr-3)
c
      do 10 ii = 1, 4
      irf0 = ir0 + ii - 1
      r4(ii)=rf(irf0)
 10   continue
c      
c --  general 
c
      do 80 kk = 1, 4
ccc      ipf0 = ip0 + kk - 1 
      ipf0 = mod(ip0+kk-1+ 2*npf,2*npf)
      do 81 jj = 1, 4
      itf0 = it0 + jj - 1 
      do 82 ii = 1, 4
      irf0 = ir0 + ii - 1 
      fr4(ii) = fnc(irf0,itf0,ipf0)
 82   continue
      ft4(jj) = fn_lagint(r4,fr4,rv)
 81   continue
      fp4(kk) = fn_lagint(th4,ft4,tv)
 80   continue
      cfn(ix,iy,iz) = fn_lagint(phi4,fp4,pv)
c
 100  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine flgrad(fnc,grad,rs,isw,iswx)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / diffv / rsinv(0:nnt,0:nnp),
     &              dtrs(0:nnt,0:nnp),dprs(0:nnt,0:nnp)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
c
      dimension  fnc(0:nnr,0:nnt,0:nnp), rs(0:nnt,0:nnp), 
     &          grad(0:nnr,0:nnt,0:nnp,1:3)
      dimension  fp(0:nnp), dfp(0:nnp)
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c     Derivatives for variables.
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      drinv=1.0d0/dr
      dtinv=1.0d0/dth
      dpinv=1.0d0/dphi
      pi = 3.14159265358979d+0
c
c --- Clear.
c
      do 40 ip = 0, np
      do 40 it = 0, nt
      rsinv(it,ip)=1.0d0/rs(it,ip)
      dtrs(it,ip) = 0.0d0
      dprs(it,ip) = 0.0d0
      do 40 ir = 0, nr
      grad(ir,it,ip,1) = 0.0d0
      grad(ir,it,ip,2) = 0.0d0
      grad(ir,it,ip,3) = 0.0d0
 40   continue
c
c --- r-direction.
c
      do 41 ip = 0, np
      do 41 it = 0, nt
      grad( 0,it,ip,1) = 0.5d0*drinv*rsinv(it,ip)*
     & (-3.0d0*fnc( 0,it,ip)+4.0d0*fnc(   1,it,ip)-fnc(   2,it,ip))
      grad(nr,it,ip,1) = 0.5d0*drinv*rsinv(it,ip)*
     & ( 3.0d0*fnc(nr,it,ip)-4.0d0*fnc(nr-1,it,ip)+fnc(nr-2,it,ip))
      do 41 ir = 1, nr-1
      grad(ir,it,ip,1) = (fnc(ir+1,it,ip) - fnc(ir-1,it,ip))*
     &                  0.5d0*drinv*rsinv(it,ip)
 41   continue
c
c --- theta-direction.
c
      do 42 ip = 0, np
      dtrs( 0,ip) = 0.5d0*dtinv*
     & (-3.0d0*rs(0,ip)+4.0d0*rs(1,ip)-rs(2,ip))
      dtrs(nt,ip) = 0.5d0*dtinv*
     & (3.0d0*rs(nt,ip)-4.0d0*rs(nt-1,ip)+rs(nt-2,ip))
      do 43 ir = 1, nr
      grad(ir,0,ip,2) = 0.5d0*dtinv*
     & (-3.0d0*fnc(ir,0,ip)+4.0d0*fnc(ir,1,ip)-fnc(ir,2,ip))
     &                - r(ir)*dtrs(0,ip)*grad(ir,0,ip,1)
      grad(ir,nt,ip,2) = 0.5d0*dtinv*
     & (3.0d0*fnc(ir,nt,ip)-4.0d0*fnc(ir,nt-1,ip)+fnc(ir,nt-2,ip))
     &                 - r(ir)*dtrs(nt,ip)*grad(ir,nt,ip,1)
 43   continue
      do 44 it = 1, nt-1
      dtrs(it,ip) = 0.5d0*dtinv*(rs(it+1,ip) - rs(it-1,ip))
      do 44 ir = 1, nr
      grad(ir,it,ip,2) = (fnc(ir,it+1,ip)-fnc(ir,it-1,ip))*0.5d0*dtinv
     &                 - r(ir)*dtrs(it,ip)*grad(ir,it,ip,1)
 44   continue
 42   continue
c
c --- phi-direction.
c
      do 45 it = 0, nt
      dprs(it,0) = 0.5d0*dpinv*
     & (-3.0d0*rs(it,0)+4.0d0*rs(it,1)-rs(it,2))
caho      if(iswx.eq.-1) dprs(it,0) = dpinv*(rs(it,1)-rs(it,0))
caho      if(iswx.eq.-1) dprs(it,0) = 0.0d0
      dprs(it,np) = 0.5d0*dpinv*
     & (3.0d0*rs(it,np)-4.0d0*rs(it,np-1)+rs(it,np-2))
caho      if(iswx.eq.-1) dprs(it,np) = dpinv*(rs(it,np) - rs(it,np-1))
      do 46 ir = 1, nr
      grad(ir,it, 0,3) = 0.5d0*dpinv*
     & (-3.0d0*fnc(ir,it,0)+4.0d0*fnc(ir,it, 1)-fnc(ir,it,2))
     &                 - r(ir)*dprs(it,0)*grad(ir,it,0,1)
       if (iswx.eq.-1) 
     & grad(ir,it, 0,3) = dpinv*
     & (fnc(ir,it,1) - fnc(ir,it,0))
     &                 - r(ir)*dprs(it,0)*grad(ir,it,0,1)
      grad(ir,it,np,3) = 0.5d0*dpinv*
     & (3.0d0*fnc(ir,it,np)-4.0d0*fnc(ir,it,np-1)+fnc(ir,it,np-2))
     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
caho       if (iswx.eq.-1) 
caho     & grad(ir,it,np,3) = dpinv*
caho     & (fnc(ir,it,np) - fnc(ir,it,np-1))
caho     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
clast
ck       if (isw.eq.1) 
ck     & grad(ir,it,np,3) = dpinv*
ck     & (fnc(ir,it,np) - fnc(ir,it,np-1))
ck     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
clast
 46   continue
      do 47 ip = 1, np-1
      dprs(it,ip) = (rs(it,ip+1) - rs(it,ip-1))*0.5d0*dpinv
      do 47 ir = 1, nr
      grad(ir,it,ip,3) = (fnc(ir,it,ip+1)-fnc(ir,it,ip-1))*0.5d0*dpinv
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 47   continue
 45   continue
c
      if (iswx.ge.1) then
c
      error = 0.0d0
      do 400 it = nt/2, nt
c
cz      do 4001 ip = 0, np
cz 4001 fp(ip) = rs(it,ip)
cz      call fouri(fp,dfp,cosmp,sinmp,2)
cz      do 4002 ip = 0, 5
czz       ip = 0
cz      oldv = dprs(it,ip)
cz      dprs(it,ip) = 0.0d0
cz      dprs(it,ip) = dfp(ip)
cz 4002 error = 
cz     &  dmax1(error,dabs(dprs(it,ip) - oldv)/
cz     &              dabs(dprs(it,ip) + oldv))
czz      write(6,*) dprs(it,ip) , oldv
c      
      do 401 ir = nr/2, nr
c
      do 4004 ip = 0, np
 4004 fp(ip) = fnc(ir,it,ip)
      if (isw.eq.1) call fouri(fp,dfp,sinmp,cosmp,isw)
      if (isw.eq.2) call fouri(fp,dfp,cosmp,sinmp,isw)
      do 4005 ip = 0, iswx
      oldv = grad(ir,it,ip,3)
      grad(ir,it,ip,3) = 0.0d0
      grad(ir,it,ip,3) = dfp(ip)
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 4005 error = 
     &  dmax1(error,dabs(grad(ir,it,ip,3) - oldv)/
     &              dabs(grad(ir,it,ip,3) + oldv))
c
 401  continue
 400  continue
      if (error.ge.0.1d0) 
     & write(6,*) ' relative error for derivative ', error
c
      end if
c
      do 49 ip = 0, np
      do 49 it = 0, nt
      do 49 ir = 0, nr
      grad(ir,it,ip,1)=grad(ir,it,ip,1)
      grad(ir,it,ip,2)=grad(ir,it,ip,2)*rinv(ir)*rsinv(it,ip)
      grad(ir,it,ip,3)=grad(ir,it,ip,3)*rinv(ir)*rsinv(it,ip)*cosec(it)
 49   continue
c
c --- On theta=0 axis and the center for velocity.
c
      if (isw.eq.1) then
      do 58 ip = 0, np
      do 58 ir = 0, nr
      grad(ir,0,ip,3)=grad(ir,0,np/2,2)*cosphi(ip)
 58   continue
      do 59 ip = 0, np
      do 59 it = 0, nt
      grad(0,it,ip,2)=grad(0,nt,np/2,1)*costhe(it)*sinphi(ip)
      grad(0,it,ip,3)=grad(0,nt,np/2,1)*cosphi(ip)
 59   continue
      end if
c
      do 141 ip = 0, np
      do 141 it = 0, nt
      do 141 ir = 0, nr
      gr1=grad(ir,it,ip,1)
      gr2=grad(ir,it,ip,2)
      gr3=grad(ir,it,ip,3)
      grad(ir,it,ip,1) = gr1*sinthe(it)*cosphi(ip)
     &                 + gr2*costhe(it)*cosphi(ip)  
     &                 - gr3*sinphi(ip) 
      grad(ir,it,ip,2) = gr1*sinthe(it)*sinphi(ip)
     &                 + gr2*costhe(it)*sinphi(ip)
     &                 + gr3*cosphi(ip) 
      grad(ir,it,ip,3) = gr1*costhe(it)
     &                 - gr2*sinthe(it)
 141  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine flgrad4(fnc,grad,rs,isw,iswx)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / diffv / rsinv(0:nnt,0:nnp),
     &              dtrs(0:nnt,0:nnp),dprs(0:nnt,0:nnp)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
c
      dimension  fnc(0:nnr,0:nnt,0:nnp), rs(0:nnt,0:nnp), 
     &          grad(0:nnr,0:nnt,0:nnp,1:3)
      dimension  fp(0:nnp), dfp(0:nnp)
c
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c     Derivatives for variables.
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
      drinv=1.0d0/dr
      dtinv=1.0d0/dth
      dpinv=1.0d0/dphi
      drinv12=1.0d0/dr/12.0d0
      dtinv12=1.0d0/dth/12.0d0
      dpinv12=1.0d0/dphi/12.0d0
      pi = 3.14159265358979d+0
c
c --- Clear.
c
      do 40 ip = 0, np
      do 40 it = 0, nt
      rsinv(it,ip)=1.0d0/rs(it,ip)
      dtrs(it,ip) = 0.0d0
      dprs(it,ip) = 0.0d0
      do 40 ir = 0, nr
      grad(ir,it,ip,1) = 0.0d0
      grad(ir,it,ip,2) = 0.0d0
      grad(ir,it,ip,3) = 0.0d0
 40   continue
c
c --- r-direction.
c
      do 41 ip = 0, np
      do 41 it = 0, nt
      grad(   0,it,ip,1) = drinv12*rsinv(it,ip)*
     & ( - 25.0d0*fnc(   0,it,ip) + 48.0d0*fnc(   1,it,ip) 
     &   - 36.0d0*fnc(   2,it,ip) + 16.0d0*fnc(   3,it,ip) 
     &   -  3.0d0*fnc(   4,it,ip) )
      grad(   1,it,ip,1) = drinv12*rsinv(it,ip)*
     & ( -  3.0d0*fnc(   0,it,ip) - 10.0d0*fnc(   1,it,ip) 
     &   + 18.0d0*fnc(   2,it,ip) -  6.0d0*fnc(   3,it,ip) 
     &   +        fnc(   4,it,ip) )
      grad(nr  ,it,ip,1) = drinv12*rsinv(it,ip)*
     & (   25.0d0*fnc(nr  ,it,ip) - 48.0d0*fnc(nr-1,it,ip)
     &   + 36.0d0*fnc(nr-2,it,ip) - 16.0d0*fnc(nr-3,it,ip)
     &   +  3.0d0*fnc(nr-4,it,ip) )
      if (isw.eq.3) then
cc      grad(nr  ,it,ip,1) = drinv*rsinv(it,ip)*
cc     & ( fnc(nr,it,ip) - fnc(nr-1,it,ip) )
      grad(nr  ,it,ip,1) = 0.5d0*drinv*rsinv(it,ip)*
     & (3.0d0*fnc(nr,it,ip)-4.0d0*fnc(nr-1,it,ip)+fnc(nr-2,it,ip))
      end if
      grad(nr-1,it,ip,1) = drinv12*rsinv(it,ip)*
     & (    3.0d0*fnc(nr  ,it,ip) + 10.0d0*fnc(nr-1,it,ip)
     &   - 18.0d0*fnc(nr-2,it,ip) +  6.0d0*fnc(nr-3,it,ip)
     &   -        fnc(nr-4,it,ip) )
      do 41 ir = 2, nr-2
      grad(ir,it,ip,1) = drinv12*rsinv(it,ip)*
     & ( -        fnc(ir+2,it,ip) +  8.0d0*fnc(ir+1,it,ip)
     &   -  8.0d0*fnc(ir-1,it,ip) +        fnc(ir-2,it,ip) )
 41   continue
c
c --- theta-direction.
c
      do 42 ip = 0, np
      dtrs(   0,ip) = dtinv12*
     & ( - 25.0d0*rs(   0,ip) + 48.0d0*rs(   1,ip) 
     &   - 36.0d0*rs(   2,ip) + 16.0d0*rs(   3,ip) 
     &   -  3.0d0*rs(   4,ip) )
      dtrs(   1,ip) = dtinv12*
     & ( -  3.0d0*rs(   0,ip) - 10.0d0*rs(   1,ip) 
     &   + 18.0d0*rs(   2,ip) -  6.0d0*rs(   3,ip) 
     &   +        rs(   4,ip) )
      dtrs(nt  ,ip) = dtinv12*
     & (   25.0d0*rs(nt  ,ip) - 48.0d0*rs(nt-1,ip)
     &   + 36.0d0*rs(nt-2,ip) - 16.0d0*rs(nt-3,ip)
     &   +  3.0d0*rs(nt-4,ip) )
      dtrs(nt-1,ip) = dtinv12*
     & (    3.0d0*rs(nt  ,ip) + 10.0d0*rs(nt-1,ip)
     &   - 18.0d0*rs(nt-2,ip) +  6.0d0*rs(nt-3,ip)
     &   -        rs(nt-4,ip) )
      do 43 ir = 1, nr
      grad(ir,   0,ip,2) = dtinv12*
     & ( - 25.0d0*fnc(ir,   0,ip) + 48.0d0*fnc(ir,   1,ip) 
     &   - 36.0d0*fnc(ir,   2,ip) + 16.0d0*fnc(ir,   3,ip) 
     &   -  3.0d0*fnc(ir,   4,ip) )
     &                - r(ir)*dtrs(0,ip)*grad(ir,0,ip,1)
      grad(ir,   1,ip,2) = dtinv12*
     & ( -  3.0d0*fnc(ir,   0,ip) - 10.0d0*fnc(ir,   1,ip) 
     &   + 18.0d0*fnc(ir,   2,ip) -  6.0d0*fnc(ir,   3,ip) 
     &   +        fnc(ir,   4,ip) )
     &                - r(ir)*dtrs(1,ip)*grad(ir,1,ip,1)
      grad(ir,nt  ,ip,2) = dtinv12*
     & (   25.0d0*fnc(ir,nt  ,ip) - 48.0d0*fnc(ir,nt-1,ip)
     &   + 36.0d0*fnc(ir,nt-2,ip) - 16.0d0*fnc(ir,nt-3,ip)
     &   +  3.0d0*fnc(ir,nt-4,ip) )
     &                 - r(ir)*dtrs(nt,ip)*grad(ir,nt,ip,1)
      grad(ir,nt-1,ip,2) = dtinv12*
     & (    3.0d0*fnc(ir,nt  ,ip) + 10.0d0*fnc(ir,nt-1,ip)
     &   - 18.0d0*fnc(ir,nt-2,ip) +  6.0d0*fnc(ir,nt-3,ip)
     &   -        fnc(ir,nt-4,ip) )
     &                 - r(ir)*dtrs(nt-1,ip)*grad(ir,nt-1,ip,1)
 43   continue
      do 44 it = 2, nt-2
      dtrs(it,ip) = dtinv12*
     & ( -        rs(it+2,ip) +  8.0d0*rs(it+1,ip)
     &   -  8.0d0*rs(it-1,ip) +        rs(it-2,ip) )
      do 44 ir = 1, nr
      grad(ir,it,ip,2) = dtinv12*
     & ( -        fnc(ir,it+2,ip) +  8.0d0*fnc(ir,it+1,ip)
     &   -  8.0d0*fnc(ir,it-1,ip) +        fnc(ir,it-2,ip) )
     &                 - r(ir)*dtrs(it,ip)*grad(ir,it,ip,1)
 44   continue
 42   continue
c
c --- phi-direction.
c
      do 45 it = 0, nt
      dprs(it,   0) = dpinv12*
     & ( - 25.0d0*rs(it,   0) + 48.0d0*rs(it,   1) 
     &   - 36.0d0*rs(it,   2) + 16.0d0*rs(it,   3) 
     &   -  3.0d0*rs(it,   4) )
      dprs(it,   1) = dpinv12*
     & ( -  3.0d0*rs(it,   0) - 10.0d0*rs(it,   1) 
     &   + 18.0d0*rs(it,   2) -  6.0d0*rs(it,   3) 
     &   +        rs(it,   4) )
      dprs(it,np  ) = dpinv12*
     & (   25.0d0*rs(it,np  ) - 48.0d0*rs(it,np-1)
     &   + 36.0d0*rs(it,np-2) - 16.0d0*rs(it,np-3)
     &   +  3.0d0*rs(it,np-4) )
      dprs(it,np-1) = dpinv12*
     & (    3.0d0*rs(it,np  ) + 10.0d0*rs(it,np-1)
     &   - 18.0d0*rs(it,np-2) +  6.0d0*rs(it,np-3)
     &   -        rs(it,np-4) )
caho      if(iswx.eq.-1) 
caho     & dprs(it,0) = 0.5d0*dpinv*
caho     & (-3.0d0*rs(it,0)+4.0d0*rs(it,1)-rs(it,2))
      do 46 ir = 1, nr
      grad(ir,it,   0,3) = dpinv12*
     & ( - 25.0d0*fnc(ir,it,   0) + 48.0d0*fnc(ir,it,   1) 
     &   - 36.0d0*fnc(ir,it,   2) + 16.0d0*fnc(ir,it,   3) 
     &   -  3.0d0*fnc(ir,it,   4) )
     &                - r(ir)*dprs(it,0)*grad(ir,it,0,1)
      grad(ir,it,   1,3) = dpinv12*
     & ( -  3.0d0*fnc(ir,it,   0) - 10.0d0*fnc(ir,it,   1) 
     &   + 18.0d0*fnc(ir,it,   2) -  6.0d0*fnc(ir,it,   3) 
     &   +        fnc(ir,it,   4) )
     &                - r(ir)*dprs(it,1)*grad(ir,it,1,1)
      grad(ir,it,np  ,3) = dpinv12*
     & (   25.0d0*fnc(ir,it,np  ) - 48.0d0*fnc(ir,it,np-1)
     &   + 36.0d0*fnc(ir,it,np-2) - 16.0d0*fnc(ir,it,np-3)
     &   +  3.0d0*fnc(ir,it,np-4) )
     &                 - r(ir)*dprs(it,np)*grad(ir,it,np,1)
      grad(ir,it,np-1,3) = dpinv12*
     & (    3.0d0*fnc(ir,it,np  ) + 10.0d0*fnc(ir,it,np-1)
     &   - 18.0d0*fnc(ir,it,np-2) +  6.0d0*fnc(ir,it,np-3)
     &   -        fnc(ir,it,np-4) )
     &                 - r(ir)*dprs(it,np-1)*grad(ir,it,np-1,1)
caho       if (iswx.eq.-1) 
caho     & grad(ir,it, 0,3) = 0.5d0*dpinv*
caho     & (-3.0d0*fnc(ir,it,0)+4.0d0*fnc(ir,it, 1)-fnc(ir,it,2))
caho     &                 - r(ir)*dprs(it,0)*grad(ir,it,0,1)
 46   continue
      do 47 ip = 2, np-2
      dprs(it,ip) = dpinv12*
     & ( -        rs(it,ip+2) +  8.0d0*rs(it,ip+1)
     &   -  8.0d0*rs(it,ip-1) +        rs(it,ip-2) )
      do 47 ir = 1, nr
      grad(ir,it,ip,3) = dpinv12*
     & ( -        fnc(ir,it,ip+2) +  8.0d0*fnc(ir,it,ip+1)
     &   -  8.0d0*fnc(ir,it,ip-1) +        fnc(ir,it,ip-2) )
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 47   continue
 45   continue
c
cx      if (isw.eq.1) then
cx      do 490 ip = 0, np, np
cx      do 490 it = 0, nt
cx      do 490 ir = 0, nr
cx      grad(ir,it,ip,3)=0.0d0
cx 490  continue
cx      end if
c
      if (iswx.ge.1) then
c
      error = 0.0d0
      do 400 it = nt/2, nt
c
      do 401 ir = nr/2, nr
c
      do 4004 ip = 0, np
 4004 fp(ip) = fnc(ir,it,ip)
      if (isw.eq.1) call fouri(fp,dfp,sinmp,cosmp,isw)
      if (isw.eq.2) call fouri(fp,dfp,cosmp,sinmp,isw)
c
      do 4005 ip = 0, iswx 
      oldv = grad(ir,it,ip,3)
      grad(ir,it,ip,3) = 0.0d0
      grad(ir,it,ip,3) = dfp(ip)
     &                 - r(ir)*dprs(it,ip)*grad(ir,it,ip,1)
 4005 error = 
     &  dmax1(error,dabs(grad(ir,it,ip,3) - oldv)/
     &              dabs(grad(ir,it,ip,3) + oldv))
c
 401  continue
 400  continue
      if (error.ge.0.1d0) 
     & write(6,*) ' relative error for derivative ', error
c
      end if
c
      do 49 ip = 0, np
      do 49 it = 0, nt
      do 49 ir = 0, nr
      grad(ir,it,ip,1)=grad(ir,it,ip,1)
      grad(ir,it,ip,2)=grad(ir,it,ip,2)*rinv(ir)*rsinv(it,ip)
      grad(ir,it,ip,3)=grad(ir,it,ip,3)*rinv(ir)*rsinv(it,ip)*cosec(it)
 49   continue
c
c --- On theta=0 axis and the center for velocity.
c
      if (isw.eq.1) then
      do 58 ip = 0, np
      do 58 ir = 0, nr
      grad(ir,0,ip,3)=grad(ir,0,np/2,2)*cosphi(ip)
 58   continue
      do 59 ip = 0, np
      do 59 it = 0, nt
      grad(0,it,ip,2)=grad(0,nt,np/2,1)*costhe(it)*sinphi(ip)
      grad(0,it,ip,3)=grad(0,nt,np/2,1)*cosphi(ip)
 59   continue
      end if
c
      do 141 ip = 0, np
      do 141 it = 0, nt
      do 141 ir = 0, nr
      gr1=grad(ir,it,ip,1)
      gr2=grad(ir,it,ip,2)
      gr3=grad(ir,it,ip,3)
      grad(ir,it,ip,1) = gr1*sinthe(it)*cosphi(ip)
     &                 + gr2*costhe(it)*cosphi(ip)  
     &                 - gr3*sinphi(ip) 
      grad(ir,it,ip,2) = gr1*sinthe(it)*sinphi(ip)
     &                 + gr2*costhe(it)*sinphi(ip)
     &                 + gr3*cosphi(ip) 
      grad(ir,it,ip,3) = gr1*costhe(it)
     &                 - gr2*sinthe(it)
 141  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine fouri(fp,dfp,scfn,scdf,isw)
c
      implicit real*8(a-h,o-z), integer(i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / weigh / wgdr(0:nnr), wgdt(0:nnt), wgdp(0:nnp),
     &                wgrtp(0:nnr,0:nnt,0:nnp), 
     &                 w4dr(0:nnr), w4dt(0:nnt), w4dp(0:nnp),
     &                w4rtp(0:nnr,0:nnt,0:nnp), wahop(0:nnr,0:nnt,0:nnp)
c
      dimension fp(0:nnp), dfp(0:nnp), al(0:nnla)
      dimension scfn(0:nnla,0:nnp),  scdf(0:nnla,0:nnp)
c
      write(6,*) ' ## aho ## --- fouri is used '
c
      pi = 3.14159265358979d+0
      do 100 il = 0, nla
      aaa = 0.0d0
      do 200 ip = 0, np
      aaa = aaa + fp(ip)*scfn(il,ip)*wgdp(ip)
 200  continue
      fac = 2.0d0
      if (isw.eq.2.and.il.eq.0) fac = 1.0d0
      al(il) = aaa*fac/pi
 100  continue
c
      fac = (- 1.0d0)**(isw+1)
      do 110 ip = 0, np
      dfp(ip) = 0.0d0
cxxx      do 120 il = 0, nla
      do 120 il = 0, 4
      dfp(ip) = dfp(ip) + fac*dble(il)*al(il)*scdf(il,ip)
 120  continue
 110  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function fn_lagint(x,y,v)
      implicit real*8 (a-h,o-z), integer (i-n)
      dimension x(4),y(4)
c
      dx12 = x(1) - x(2)
      dx13 = x(1) - x(3)
      dx14 = x(1) - x(4)
      dx23 = x(2) - x(3)
      dx24 = x(2) - x(4)
      dx34 = x(3) - x(4)
      dx21 = - dx12
      dx31 = - dx13
      dx32 = - dx23
      dx41 = - dx14
      dx42 = - dx24
      dx43 = - dx34
      xv1 = v - x(1)
      xv2 = v - x(2)
      xv3 = v - x(3)
      xv4 = v - x(4)
      wex1 = xv2*xv3*xv4/(dx12*dx13*dx14)
      wex2 = xv1*xv3*xv4/(dx21*dx23*dx24)
      wex3 = xv1*xv2*xv4/(dx31*dx32*dx34)
      wex4 = xv1*xv2*xv3/(dx41*dx42*dx43)
c
      fn_lagint = wex1*y(1) + wex2*y(2) + wex3*y(3) + wex4*y(4)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function fn_lagint_o3(x,y,v)
      implicit real*8 (a-h,o-z), integer (i-n)
      dimension x(3),y(3)
c
      dx12 = x(1) - x(2)
      dx13 = x(1) - x(3)
      dx23 = x(2) - x(3)
      dx21 = - dx12
      dx31 = - dx13
      dx32 = - dx23
      xv1 = v - x(1)
      xv2 = v - x(2)
      xv3 = v - x(3)
      wex1 = xv2*xv3/(dx12*dx13)
      wex2 = xv1*xv3/(dx21*dx23)
      wex3 = xv1*xv2/(dx31*dx32)
c
      fn_lagint_o3 = wex1*y(1) + wex2*y(2) + wex3*y(3)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subio(char)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/GR_BHNS_metgr.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, itbh
c
ctest
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
ctest
      dimension gamd(3,3), gamu(3,3)
c
      character*4 char
      character*3 moji
c
c ------------------------------------------------------------
c
c
      open(3,file='bbhgra.input',status='old')
c
c -------------
c --- Read. ---
c -------------
c
c --- Metric potentials.  
c
c
      read(3,5000) nrb, ntb, npb, nlb
      read(3,5000) nrbov, msymb
      read(3,5000) ntg, npg, nlg, msymg
      read(3,5005) ngdin, nrout, rvout
      read(3,5001) ding, radint
      read(3,5002) itmx, eps, convf
      read(3,5005) iddd, numseq, bhcop
      read(3,5001) fffac,ffvep 
      read(3,5004) itype, itbh, char
      read(3,5010) bhrad, bhmass, bhspin
      read(3,5010) ome,   patfac
      read(3,5011) bhfac, numseq
c
      read(3,4000) ome, ber, radi, orbc, dis
c
      drdr = 1.0d0/dble(nrf)
      rbov = dble(nrbov)*drdr
      dis = drdr*dnint(dis/drdr)
      ding = 1.0d0 + 2.0d0*rbov
      radint = dis - ding
      radext = radint + rbov
      radmid = dis + radext + rbov
      nrin = idnint(radmid/drdr) 
      nrtot = nrin + nrout 
c
c --  BH coordinate
      do 200 ipb = 0, npb
      do 200 itb = 0, ntb
      read(3,4000) ( psib(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (alphb(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (bvxdb(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (bvydb(irb,itb,ipb), irb = 0, nrb)
      read(3,4000) (bvzdb(irb,itb,ipb), irb = 0, nrb)
 200  continue
c
c --  GR coordinate
      do 201 ipg = 0, npg
      do 201 itg = 0, ntg
      read(3,4000) ( psi(irg,itg,ipg), irg = 0, nrtot)
      read(3,4000) (alph(irg,itg,ipg), irg = 0, nrtot)
      read(3,4000) (bvxd(irg,itg,ipg), irg = 0, nrtot)
      read(3,4000) (bvyd(irg,itg,ipg), irg = 0, nrtot)
      read(3,4000) (bvzd(irg,itg,ipg), irg = 0, nrtot)
 201  continue
c      
 2000 continue
c
      do 202 ipb = 0, npb
      do 202 itb = 0, ntb
      do 202 irb = 0, nrb
      psib(irb,itb,ipb) = 1.0d0 + psib(irb,itb,ipb)
 202  continue
c
      do 204 ipg = 0, npg
      do 204 itg = 0, ntg
      do 204 irg = 0, nrtot
      psi(irg,itg,ipg) = 1.0d0 + psi(irg,itg,ipg)
 204  continue
c
      close(3)
c
 1000 continue
 4000 format(1p,6e12.4)
 4999 format(' ')
c
 5000 format( 5i5)
 5001 format( 1p,2e10.3)
 5002 format( 1i5, 1p,2e10.3)
 5003 format( 1p,1e10.3, 1i4)
 5004 format( 2i5, 3x, a4)
 5005 format( 2i5, 1p,1e10.3)
 5010 format(1p,3e10.3)
 5011 format(1p,1e10.3,2i5)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine subio_fluid(char)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_coflu.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / phisv / emd(0:nnr,0:nnt,0:nnp), vep(0:nnr,0:nnt,0:nnp),
     &                 rs(0:nnt,0:nnp), rho(0:nnr,0:nnt,0:nnp),
     &                 alm(nnbou,nnbou), ram(0:nnr,0:nnt,0:nnp)
c
      common / iomis / fffac, ffvep, eps, convf, itmx, iddd, numseq,
     &                 itype, itbh
      common / hijsw / swlp(4), swls(4), iswl
      common / cutsw / cutfac
c
      character*4 char
      character*3 moji
c
c ------------------------------------------------------------
c
      open(2,file='gnbflu.input',status='old')
c
c -------------
c --- Read. ---
c -------------
c
c --- Fluid variables
c
      read(2,5000) nrf, ntf, npf
      read(2,5000) nl, nla, nbou, msym
      read(2,5005) nnn, nrout, rvout
      read(2,5000) ntg, npg, nlg, msymg
      read(2,5002) ngdin, pinx, cutfac
      read(2,5002) itmx, eps, convf
      read(2,5000) iddd, iswl
      read(2,5001) fffac,ffvep 
      read(2,5004) itype, itbh, char
c
      read(2,4000) ome, ber, radi, orbc, dis
      do 100 ip = 0, np
      do 100 it = 0, nt
      read(2,4000) (emd(ir,it,ip), ir = 0, nr)
      read(2,4000) (vep(ir,it,ip), ir = 0, nr)
 100  continue
      do 110 ip = 0, np
      read(2,4000) (rs(it,ip), it = 0, nt)
 110  continue
c
      close(2)
c
c
 4000 format(1p,6e12.4)
 4999 format(' ')
c
 5000 format( 5i5)
 5001 format( 1p,2e10.3)
 5002 format( 1i5, 1p,2e10.3)
 5003 format( 1p,1e10.3, 1i4)
 5004 format( 2i5, 3x, a4)
 5005 format( 2i5, 1p,1e10.3)
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvfl(iddd)
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_coflu.f'
c
      common / extpt / cospmp(0:nnp,0:nnp), cosppp(0:nnp,0:nnp) 
      common / weigh / wgdr(0:nnr), wgdt(0:nnt), wgdp(0:nnp),
     &                wgrtp(0:nnr,0:nnt,0:nnp),
     &                 w4dr(0:nnr), w4dt(0:nnt), w4dp(0:nnp),
     &                w4rtp(0:nnr,0:nnt,0:nnp), wahop(0:nnr,0:nnt,0:nnp)
      common / legen / spn(0:nnt,0:nnp,0:nnl), 
     &                 fsn(0:nnr,0:nnl,0:nnr)
      common / asleg / pna(0:nnla,0:nnla,0:nnt),
     &               dtpna(0:nnla,0:nnla,0:nnt), 
     &               facnm(0:nnla,0:nnla), epsi(0:nnla)
      common / trimp / sinmp(0:nnla,0:nnp),  cosmp(0:nnla,0:nnp)
      common / asylm / ypna(0:nnla,0:nnla,0:nnt),
     &               dtypna(0:nnla,0:nnla,0:nnt)
c
      dimension fac(0:nnla)
      dimension qp1(0:nnl), qp2(0:nnl), qp3(0:nnl), qp4(0:nnl)
c
c- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Set up of meshes  ---  ( r(1) = dr ( not the center ) )
c --- The constatnt msym means the symmetry of the configuration.
c
      pi = 3.14159265358979d+0
      dr   = 1.0d0/dble(nr)
      dth  = pi/2.d0/dble(nt)
      dphi = pi/dble(np)
      drf   = dr
      dthf  = dth
      dphif = dphi
c
      drinv = 1.0d0/dr
      dthinv = 1.0d0/dth
      dphiinv = 1.0d0/dphi
      drfinv = drinv
      dthfinv = dthinv
      dphifinv = dphiinv
c
      do 100 ir = 0, nr
      r(ir) = dble(ir)*dr
      rf(ir) = r(ir)
  100 continue
      rinv( 0) = 0.d0
      rfinv(0) = rinv(0)
      do 104 ir = 1, nr
      rinv(ir) = 1.0d0/r(ir)
      rfinv(ir) = rinv(ir)
  104 continue      
c
      do 101 it = 0, nt
      th(it) = dble(it)*dth
      thf(it) = th(it)
  101 continue
      do 102 ip = 0, np
      phi(ip) = dble(ip)*dphi
      phif(ip) = phi(ip)
  102 continue
c
c --- cal. sine ,cosine and tange on grids of polar angle. ---
c --- notice ; tange diverge to infinity when agr=pi/2, j1=m
c
      do 121 it  = 0, nt
      sinthe(it) = dsin(th(it))
      costhe(it) = dcos(th(it))
      sinthef(it) = sinthe(it)
      costhef(it) = costhe(it)
  121 continue
      cosec( 0) = 0.0d0
      cosecf(0) = cosec(0)
      do 122 it = 1, nt
      cosec(it) = 1.0d0/dsin(th(it))
      cosecf(it)= cosec(it)
  122 continue
c
      do 124 ip  = 0, np
      sinphi(ip) = dsin(phi(ip))
      cosphi(ip) = dcos(phi(ip))
      sinphif(ip) = sinphi(ip)
      cosphif(ip) = cosphi(ip)
      do 124 nn  = 0, nla
      fnn = dble(nn)
      sinmp(nn,ip) = dsin(fnn*phi(ip))
      cosmp(nn,ip) = dcos(fnn*phi(ip))
  124 continue
c
      do 125 ip  = 0, np
      do 125 ipp = 0, np
      cospmp(ipp,ip) = dcos(phi(ip) - phi(ipp))
      cosppp(ipp,ip) = dcos(phi(ip) + phi(ipp))
  125 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvgr
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_mesh_fluid.f'
      include 'common_blocks/CB_param_cordp.f'
c
      common / trmpg / sinmpg(0:nnlg,0:nnpg), cosmpg(0:nnlg,0:nnpg)
      common / weigg / wgdrg(nnrg), wgdtg(0:nntg), wgdpg(0:nnpg),
     &                wgrtpg(nnrg,0:nntg,0:nnpg), 
     &               w4drg(0:nnrg), w4dtg(0:nntg), w4dpg(0:nnpg),
     &                wmrtpg(0:nnrg,0:nntg,0:nnpg)
      common / grfsn / hfsn(0:nnrg,0:nnlg,0:nnrg)
      common / grleg / pnag(0:nnlg,0:nnlg,0:nntg),
     &               facnmg(0:nnlg,0:nnlg), epsig(0:nnlg)
c
      dimension fac(0:nnlg)
c
c- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Set up of meshes  ---  ( r(1) = dr ( not the center ) )
c --- The constatnt msym means the symmetry of the configuration.
c
      pi = 3.14159265358979d+0
c
      dthg  = pi/2.d0/dble(ntg)
      dphig = 2.0d0*pi/dble(npg)
c
      dthginv=1.0d0/dthg
      dphiginv=1.0d0/dphig
      dthginv2=1.0d0/dthg/2.0d0
      dphiginv2=1.0d0/dphig/2.0d0
      dthginv12=1.0d0/dthg/12.0d0
      dphiginv12=1.0d0/dphig/12.0d0
c
cccc      drdr = ding/dble(ngdin)
      drdr = 1.0d0/dble(nrf)
      drdrinv = 1.0d0/drdr
      rvdom = rvout - radmid
c
      do 100 ir = 0, nrin
      drg(ir)   = drdr
      drginv(ir) = drdrinv
      drginv2(ir) = 0.5d0*drdrinv
 100  continue
c
c --- For variable mesh.
c
      ratrr = 1.2d0
c
 1400 continue
c
      ratrrb = ratrr
      alge = -(ratrr**(nrout+1)-ratrr-rvdom*drdrinv*(ratrr-1.0d0))
      dalge = dble(nrout+1)*ratrr**nrout - 1.0d0 - rvdom*drdrinv
      ratrr = ratrr + alge/dalge
      error = 2.d0*(ratrr - ratrrb)/(ratrr + ratrrb)
c 
      if (dabs(error).gt.1.d-14) go to 1400 
c
      do 101 ir = nrin+1, nrtot
      drg(ir) = ratrr*drg(ir-1)
      drginv(ir) = 1.0d0/drg(ir)
 101  continue
      do 102 ir = nrin+1, nrtot - 1
      drginv2(ir) = 1.0d0/(drg(ir)+drg(ir+1))
 102  continue
      drginv2(nrtot) = 1.0d0/(drg(nrtot)+drg(nrtot-1))
c
      rg(0) = 0.0d0
      rginv(0) = 0.0d0
      do 110 ir = 1, nrtot
      rg(ir) = rg(ir-1) + drg(ir)
      hrg(ir) = (rg(ir) + rg(ir-1))*0.5d0
      rginv(ir) = 1.0d0/rg(ir)
      hrginv(ir) = 1.0d0/hrg(ir)
  110 continue
      do 111 it = 0, ntg
      thg(it) = dble(it)*dthg
  111 continue
      phig(0) = - pi/2.0d0
      do 112 ip = 1, npg
      phig(ip) = dble(ip)*dphig + phig(0) 
  112 continue
c
      write(6,12) error, ratrr
      write(6,14) rvout, rg(nrtot)
 12   format(' GR ', 1p,4e23.15)
 14   format('    ', 1p,4e23.15)
      rdet = (rg(nrtot) - rvout)/rvout
      if(rdet.gt.1.d-10)then
      write(6,*) ' bad coordinate GR ', rdet
      stop
      end if
c
c --- cal. sine ,cosine and tange on grids of polar angle. ---
c --- notice ; tange diverge to infinity when agr=pi/2, j1=m
c
      do 121 it  = 0, ntg
      sintheg(it) = dsin(thg(it))
      costheg(it) = dcos(thg(it))
  121 continue
      cosecg( 0) = 0.0d0
      cotang( 0) = 0.0d0
      do 122 it = 1, ntg - 1
      cosecg(it) = 1.0d0/dsin(thg(it))
      cotang(it) = 1.0d0/dtan(thg(it))
  122 continue
      cosecg(ntg) = 1.0d0
      cotang(ntg) = 0.0d0
c
      do 124 ip  = 0, npg
      sinphig(ip) = dsin(phig(ip))
      cosphig(ip) = dcos(phig(ip))

      if (ip.ne.0.and.ip.ne.npg/4.and.ip.ne.npg/2.and.
     &    ip.ne.3*npg/4.and.ip.ne.npg) then
      cotphig(ip) = 1.0d0/dtan(phig(ip))
      else
      cotphig(ip) = 0.0d0
      end if
      do 124 nn  = 0, nlg
      fnn = dble(nn)
      sinmpg(nn,ip) = dsin(fnn*phig(ip))
      cosmpg(nn,ip) = dcos(fnn*phig(ip))
  124 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvbh
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      include 'common_blocks/CB_mesh_fluid.f'
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
c
      common / trmpb / sinmpb(0:nnlb,0:nnpb), cosmpb(0:nnlb,0:nnpb)
      common / weigb / wgdrb(nnrb), wgdtb(0:nntb), wgdpb(0:nnpb),
     &                wgrtpb(nnrb,0:nntb,0:nnpb), 
     &               w4drb(0:nnrb), w4dtb(0:nntb), w4dpb(0:nnpb)
      common / brfnv / hfnb_nb(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_di(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_hd(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_dd(0:nnrb,0:nnlb,0:nnrb),
     &                 hfnb_nd(0:nnrb,0:nnlb,0:nnrb)
      common / bfnsf / fnbsf_nb(0:nnlb,0:nnrb,4),
     &                 fnbsf_di(0:nnlb,0:nnrb,4),
     &                 fnbsf_hd(0:nnlb,0:nnrb,4),
     &                 fnbsf_dd(0:nnlb,0:nnrb,4),
     &                 fnbsf_nd(0:nnlb,0:nnrb,4)
      common / brleg / pnab(0:nnlb,0:nnlb,0:nntb),
     &               facnmb(0:nnlb,0:nnlb), epsib(0:nnlb)
c
      dimension fac(0:nnlb)
c
c- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c --- Set up of meshes  ---  ( r(1) = dr ( not the center ) )
c --- The constatnt msym means the symmetry of the configuration.
c
      pi = 3.14159265358979d+0
c
      dthb  = pi/2.d0/dble(ntb)
      dphib = 2.0d0*pi/dble(npb)
c
      dthbinv=1.0d0/dthb
      dphibinv=1.0d0/dphib
      dthbinv2=1.0d0/dthb/2.0d0
      dphibinv2=1.0d0/dphib/2.0d0
      dthbinv12=1.0d0/dthb/12.0d0
      dphibinv12=1.0d0/dphib/12.0d0
c
c --- outermost mesh of bh-domain is the same size as mid-domain. 
c
      rbdom = radint - bhrad
c
cccc      drdr = ding/dble(ngdin) 
      drdr = 1.0d0/dble(nrf)
      drdrinv = 1.0d0/drdr 
c
      do 100 ii = nrbin, nrb
      drb(ii) = drdr
      drbinv(ii) = drdrinv
 100  continue
c
c --- For variable mesh.
c
      if (bhcop.eq.0.0d0) then
c
      ratrr = 0.5d0
c
 1400 continue
c
      ratrrb = ratrr
      alge = -(1.0d0-ratrr**nrbin-rbdom*drdrinv*(1.0d0-ratrr))
      dalge = -dble(nrbin)*ratrr**(nrbin-1) + rbdom*drdrinv
      ratrr = ratrr + alge/dalge
      error = 2.d0*(ratrr - ratrrb)/(ratrr + ratrrb)
c
      if (dabs(error).gt.1.d-14) go to 1400
c
c --  drb(irb), hrb(irb) are between rb(irb-1) and rb(irb).
c
      do 101 ir = nrbin - 1, nrb0, -1
      drb(ir) = ratrr*drb(ir+1)
      drbinv(ir) = 1.0d0/drb(ir)
 101  continue
c
      end if 
c
      if (bhcop.ne.0.0d0) then
c
      nbhcop = idnint(bhcop) 
      nnbb = nrbin - nbhcop
      rbdom = radint - bhrad - nnbb*drdr
      ratrr = 0.5d0
c
 1410 continue
c
      ratrrb = ratrr
      alge = -(1.0d0-ratrr**nbhcop-rbdom*drdrinv*(1.0d0-ratrr))
      dalge = -dble(nbhcop)*ratrr**(nbhcop-1) + rbdom*drdrinv
      ratrr = ratrr + alge/dalge
      error = 2.d0*(ratrr - ratrrb)/(ratrr + ratrrb)
c
      if (dabs(error).gt.1.d-14) go to 1410
c
      do 150 ir = nrbin, nbhcop, -1
      drb(ir) = drdr
      drbinv(ir) = 1.0d0/drb(ir)
 150  continue
      do 149 ir = nbhcop - 1, nrb0, -1
      drb(ir) = ratrr*drb(ir+1)
      drbinv(ir) = 1.0d0/drb(ir)
 149  continue
c
      end if 
c
c
      do 102 ir = nrb0 + 1, nrb - 1
      drbinv2(ir) = 1.0d0/(drb(ir)+drb(ir+1))
 102  continue
      drbinv2(nrb0) = 1.0d0/(drb(nrb0+1)+drb(nrb0+2))
      drbinv2(nrb) = 1.0d0/(drb(nrb)+drb(nrb-1))
c
      rb(0) = bhrad
      rbinv(0) = 1.0d0/rb(0)
      if (bhrad.ne.0.0d0) rbinv(0) = 1.0d0/bhrad
      do 110 ir = 1, nrb
      rb(ir) = rb(ir-1) + drb(ir)
      hrb(ir) = (rb(ir) + rb(ir-1))*0.5d0
      rbinv(ir) = 1.0d0/rb(ir)
      hrbinv(ir) = 1.0d0/hrb(ir)
  110 continue
      do 114 ir = -1, nrb0, -1
      rb(ir) = rb(ir+1) - drb(ir+1)
      hrb(ir+1) = (rb(ir+1) + rb(ir))*0.5d0
      rbinv(ir) = 1.0d0/rb(ir)
      hrbinv(ir+1) = 1.0d0/hrb(ir+1)
  114 continue
      do 111 it = 0, ntb
      thb(it) = dble(it)*dthb
  111 continue
      do 112 ip = 0, npb
      phib(ip) = dble(ip)*dphib
  112 continue
c
      write(6,12) error, ratrr
      write(6,14) bhrad, rb(0)
      write(6,14) radext, rb(nrb)
 12   format(' BH ',1p,4e23.15)
 14   format('    ',1p,4e23.15)
      rdet = dmax1(dabs(rb(nrb) - radext),dabs(rb(0)-bhrad))
      if(rdet.gt.1.d-10)then
      write(6,*) ' bad coordinate BH ', rdet
      stop
      end if
c
c
c --- cal. sine ,cosine and tange on grids of polar angle. ---
c --- notice ; tange diverge to infinity when agr=pi/2, j1=m
c
      do 121 it  = 0, ntb
      sintheb(it) = dsin(thb(it))
      costheb(it) = dcos(thb(it))
  121 continue
      cosecb( 0) = 0.0d0
      cotanb( 0) = 0.0d0
      do 122 it = 1, ntb - 1
      cosecb(it) = 1.0d0/dsin(thb(it))
      cotanb(it) = 1.0d0/dtan(thb(it))
  122 continue
      cosecb(ntb) = 1.0d0
      cotanb(ntb) = 0.0d0
c
      do 124 ip  = 0, npb
      sinphib(ip) = dsin(phib(ip))
      cosphib(ip) = dcos(phib(ip))
      if (ip.ne.0.and.ip.ne.npb/4.and.ip.ne.npb/2.and.
     &    ip.ne.3*npb/4.and.ip.ne.npb) then
      cotphib(ip) = 1.0d0/dtan(phib(ip))
      else
      cotphib(ip) = 0.0d0
      end if
      do 124 nn  = 0, nlb
      fnn = dble(nn)
      sinmpb(nn,ip) = dsin(fnn*phib(ip))
      cosmpb(nn,ip) = dcos(fnn*phib(ip))
  124 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine excurve_shibata
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
      include 'common_blocks/GR_BHNS_metgr.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_metbh.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_bhpar.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_phisp.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg), 
     &                 ipgbiou(0:nnrg,0:nntg) 
c
      common / kijall  / rkxxd(0:nnrg,0:nntg,0:nnpg),
     &                   rkxyd(0:nnrg,0:nntg,0:nnpg),
     &                   rkxzd(0:nnrg,0:nntg,0:nnpg),
     &                   rkyyd(0:nnrg,0:nntg,0:nnpg),
     &                   rkyzd(0:nnrg,0:nntg,0:nnpg),
     &                   rkzzd(0:nnrg,0:nntg,0:nnpg)
      common / kijball / rkxxdb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkxydb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkxzdb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkyydb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkyzdb(nnrb0:nnrb,0:nntb,0:nnpb),
     &                   rkzzdb(nnrb0:nnrb,0:nntb,0:nnpb)
c
      dimension gradbx(3),gradby(3),gradbz(3),cdbvd(3,3)
      dimension baij(3,3)
c
c --- Compute source terms for volume integrals.
c
      intnum = 5
      intp = 2
      fac13 = 1.0d0/3.0d0
      fac23 = 2.0d0/3.0d0
      fac43 = 4.0d0/3.0d0
      fac512 = 5.0d0/12.0d0
c
c --  GR coordinate
c
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
      do 100 irg = 0, nrtot
      if (irg.gt.irgbiin(itg,ipg)+intp.and.
     &    irg.lt.irgbiou(itg,ipg)-intp) go to 100
c
c --  Aij.
c
      call grgrad1g(bvxd,gradbx,irg,itg,ipg)
      call grgrad1g(bvyd,gradby,irg,itg,ipg)
      call grgrad1g(bvzd,gradbz,irg,itg,ipg)
c
      cdbvd(1,1) = gradbx(1)
      cdbvd(1,2) = gradbx(2)
      cdbvd(1,3) = gradbx(3)
      cdbvd(2,1) = gradby(1)
      cdbvd(2,2) = gradby(2)
      cdbvd(2,3) = gradby(3)
      cdbvd(3,1) = gradbz(1)
      cdbvd(3,2) = gradbz(2)
      cdbvd(3,3) = gradbz(3)
c
      diver = fac23*(cdbvd(1,1) + cdbvd(2,2) + cdbvd(3,3))
c
c --  baij = 2\alpha aij
c
      baij(1,1) = 2.0d0*cdbvd(1,1) - diver
      baij(2,2) = 2.0d0*cdbvd(2,2) - diver
      baij(3,3) = 2.0d0*cdbvd(3,3) - diver
      baij(1,2) = cdbvd(1,2) + cdbvd(2,1)
      baij(1,3) = cdbvd(1,3) + cdbvd(3,1)
      baij(2,3) = cdbvd(2,3) + cdbvd(3,2)
      baij(2,1) = baij(1,2)
      baij(3,1) = baij(1,3)
      baij(3,2) = baij(2,3)
cccc      faca = 0.5d0/alphw
      faca = 0.5d0
c
      rkxxd(irg,itg,ipg) = faca*baij(1,1)
      rkxyd(irg,itg,ipg) = faca*baij(1,2)
      rkxzd(irg,itg,ipg) = faca*baij(1,3)
      rkyyd(irg,itg,ipg) = faca*baij(2,2)
      rkyzd(irg,itg,ipg) = faca*baij(2,3)
      rkzzd(irg,itg,ipg) = faca*baij(3,3)
c
 100  continue
c
c
c --  BH coordinate
c
      nrb0 = 0
      do 110 ipb = 0, npb
      do 110 itb = 0, ntb
      do 110 irb = 0, nrb
c
c --  Aij.
c
      call grgrad1b(bvxdb,gradbx,irb,itb,ipb,nrb0)
      call grgrad1b(bvydb,gradby,irb,itb,ipb,nrb0)
      call grgrad1b(bvzdb,gradbz,irb,itb,ipb,nrb0)
      cdbvd(1,1) = gradbx(1)
      cdbvd(1,2) = gradbx(2)
      cdbvd(1,3) = gradbx(3)
      cdbvd(2,1) = gradby(1)
      cdbvd(2,2) = gradby(2)
      cdbvd(2,3) = gradby(3)
      cdbvd(3,1) = gradbz(1)
      cdbvd(3,2) = gradbz(2)
      cdbvd(3,3) = gradbz(3)
c
      diver = fac23*(cdbvd(1,1) + cdbvd(2,2) + cdbvd(3,3))
c
c --  baij = 2\alpha aij
c
      baij(1,1) = 2.0d0*cdbvd(1,1) - diver
      baij(2,2) = 2.0d0*cdbvd(2,2) - diver
      baij(3,3) = 2.0d0*cdbvd(3,3) - diver
      baij(1,2) = cdbvd(1,2) + cdbvd(2,1)
      baij(1,3) = cdbvd(1,3) + cdbvd(3,1)
      baij(2,3) = cdbvd(2,3) + cdbvd(3,2)
      baij(2,1) = baij(1,2)
      baij(3,1) = baij(1,3)
      baij(3,2) = baij(2,3)
cccc      faca = 0.5d0/alphw
      faca = 0.5d0
      rkxxdb(irb,itb,ipb) = faca*baij(1,1)
      rkxydb(irb,itb,ipb) = faca*baij(1,2)
      rkxzdb(irb,itb,ipb) = faca*baij(1,3)
      rkyydb(irb,itb,ipb) = faca*baij(2,2)
      rkyzdb(irb,itb,ipb) = faca*baij(2,3)
      rkzzdb(irb,itb,ipb) = faca*baij(3,3)
c
c
 110  continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1g(fnc,grad1,irg,itg,ipg)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cogra.f'
c
      dimension fnc(0:nnrg,0:nntg,0:nnpg), fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(irg-2,0),nrtot-4)
      it0 = min0(max0(itg-2,0),ntg-4)
      ip0 = min0(max0(ipg-2,0),npg-4)
c
c ##  phig = -pi/2, pi/2
c ##  npnp ha npgxy tokani naosu beki???
      npnp = npg
c      npnp = npg*msymg/2
c
      rv = rg(irg)
      tv = thg(itg)
      pv = phig(ipg)
      rrgginv = rginv(irg)
c
      do 8 ii = 1, 5
      irg0 = ir0 + ii - 1
      itg0 = it0 + ii - 1
      ipg0 = ip0 + ii - 1
      r5(ii) = rg(irg0)
      th5(ii) = thg(itg0)
      phi5(ii) = phig(ipg0)
      if (irg.eq.0) then
      fr5(ii) = fnc(irg0,ntg,npgxz)
c##
      ft5(ii) = fnc(irg0,ntg,npnp)
      fp5(ii) = fnc(irg0,0,0)
      else if (irg.ne.0.and.itg.eq.0) then
      fr5(ii) = fnc(irg,itg0,npgxz)
c##
      ft5(ii) = fnc(irg,itg0,npnp)
      fp5(ii) = fnc(irg0,0,0)
      else
      fr5(ii) = fnc(irg0,itg,ipg)
      ft5(ii) = fnc(irg,itg0,ipg)
      fp5(ii) = fnc(irg,itg,ipg0)
      end if
    8 continue
c
c --- To cartesian component.  
c
      if (irg.eq.0) then
      grad1(1) = dfncdx(r5,fr5,rv)
      grad1(2) = dfncdx(r5,ft5,rv) 
      grad1(3) = dfncdx(r5,fp5,rv)
      else if (irg.ne.0.and.itg.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tv)*rrgginv
      grad1(2) = dfncdx(th5,ft5,tv)*rrgginv
      grad1(3) = dfncdx(r5,fp5,rv)
      else
      gr1 = dfncdx(r5,fr5,rv)
      gr2 = dfncdx(th5,ft5,tv)*rrgginv
      gr3 = dfncdx(phi5,fp5,pv)*rrgginv*cosecg(itg)
      grad1(1) = gr1*sintheg(itg)*cosphig(ipg)
     &         + gr2*costheg(itg)*cosphig(ipg)  
     &         - gr3*sinphig(ipg) 
      grad1(2) = gr1*sintheg(itg)*sinphig(ipg)
     &         + gr2*costheg(itg)*sinphig(ipg)
     &         + gr3*cosphig(ipg) 
      grad1(3) = gr1*costheg(itg)
     &         - gr2*sintheg(itg)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine grgrad1b(fnc,grad1,irb,itb,ipb,nrb0p)
c
      implicit real*8(a-h,o-z), integer (i-n)
c
      include 'grparm.f'
c
      include 'common_blocks/GR_BHNS_cobh.f'
c
      dimension fnc(nnrb0:nnrb,0:nntb,0:nnpb),
     &          fr5(5), ft5(5), fp5(5),
     &          grad1(3), r5(5), th5(5), phi5(5)
c
c --- Compute the gradient of a function.  
c --- The gradient is evaluated on grid points. 
c
      ir0 = min0(max0(irb-2,nrb0p),nrb-4)
      it0 = min0(max0(itb-2,0),ntb-4)
ccc      ip0 = min0(max0(ipb-2,0),npb-4)
c ##  phib = 0 to 2pi      
      ip0 = ipb
c
c ##  phib = 0 to 2pi
      npnp = npb/4
c
      do 8 ii = 1, 5
      irb0 = ir0 + ii - 1
      itb0 = it0 + ii - 1
ccc      ipb0 = ip0 + ii - 1
      r5(ii) = rb(irb0)
      th5(ii) = thb(itb0)
ccc      phi5(ii) = phib(ipb0)
c
c ##  phib = 0 to 2pi, equidistant
      ipb0 = mod(ip0+ii-3+npb,npb) 
      phi5(ii) = phib(ip0) + dphib*dble(ii-3)
c
c --  version r(0) > 0,  cf) subroutine grgrad1b0.
c
      if (itb.eq.0) then
      fr5(ii) = fnc(irb,itb0,0)
      ft5(ii) = fnc(irb,itb0,npnp)
      fp5(ii) = fnc(irb0,0,0)
      else
      fr5(ii) = fnc(irb0,itb,ipb)
      ft5(ii) = fnc(irb,itb0,ipb)
      fp5(ii) = fnc(irb,itb,ipb0)
      end if
    8 continue
c
      rbv = rb(irb)
      tbv = thb(itb)
      pbv = phib(ipb)
      rrbbinv = rbinv(irb)
c
c --- To cartesian component.  
c
      if (itb.eq.0) then
      grad1(1) = dfncdx(th5,fr5,tbv)*rrbbinv
      grad1(2) = dfncdx(th5,ft5,tbv)*rrbbinv
      grad1(3) = dfncdx(r5,fp5,rbv)
      else
      gr1 = dfncdx(r5,fr5,rbv)
      gr2 = dfncdx(th5,ft5,tbv)*rrbbinv
      gr3 = dfncdx(phi5,fp5,pbv)*rrbbinv*cosecb(itb)
      grad1(1) = gr1*sintheb(itb)*cosphib(ipb)
     &         + gr2*costheb(itb)*cosphib(ipb)  
     &         - gr3*sinphib(ipb) 
      grad1(2) = gr1*sintheb(itb)*sinphib(ipb)
     &         + gr2*costheb(itb)*sinphib(ipb)
     &         + gr3*cosphib(ipb) 
      grad1(3) = gr1*costheb(itb)
     &         - gr2*sintheb(itb)
c
      end if
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      subroutine nonvgb
c
c --- cal.non-variables on grids. (s.t. radius sine cosine etc.)
c
      implicit real*8 (a-h,o-z), integer (i-n)
c
      include 'grparm.f' 
c
      include 'common_blocks/GR_BHNS_cobh.f'
      include 'common_blocks/GR_BHNS_cogra.f'
c
      include 'common_blocks/CB_param_cordp.f'
      include 'common_blocks/CB_param_calcp.f'
      include 'common_blocks/CB_param_intpp.f'
c
      common / ifsgb / irgbiin(0:nntg,0:nnpg),
     &                 irgbiou(0:nntg,0:nnpg),
     &                 itgbi(0:nnrg,0:nnpg),
     &                 ipgbiin(0:nnrg,0:nntg),
     &                 ipgbiou(0:nnrg,0:nntg)
      common / gcifs / rgbifin(0:nntg,0:nnpg),
     &                 rgbifou(0:nntg,0:nnpg),
     &                  thgbif(0:nnrg,0:nnpg),
     &                 phigbifin(0:nnrg,0:nntg),
     &                 phigbifou(0:nnrg,0:nntg)
      common / ifhgb / ihrgbiin(0:nntg,0:nnpg),
     &                 ihrgbiou(0:nntg,0:nnpg),
     &                 ihtgbi(0:nnrg,0:nnpg),
     &                 ihpgbiin(0:nnrg,0:nntg),
     &                 ihpgbiou(0:nnrg,0:nntg)
      common / gcifh / hrgbifin(0:nntg,0:nnpg),
     &                 hrgbifou(0:nntg,0:nnpg),
     &                  hthgbif(0:nnrg,0:nnpg),
     &                 hphigbifin(0:nnrg,0:nntg),
     &                 hphigbifou(0:nnrg,0:nntg)
      common / gcfbc / rgb1(0:nnrg,0:nntg,0:nnpg),
     &                thgb1(0:nnrg,0:nntg,0:nnpg),
     &               phigb1(0:nnrg,0:nntg,0:nnpg),
     &                 rgb2(0:nnrg,0:nntg,0:nnpg),
     &                thgb2(0:nnrg,0:nntg,0:nnpg),
     &               phigb2(0:nnrg,0:nntg,0:nnpg)
      common / bcing / rbing(5,0:nntb,0:nnpb), rbex(5),
     &                 thbing(5,0:nntb,0:nnpb),
     &                 phibing(5,0:nntb,0:nnpb)
      common / weigg / wgdrg(nnrg), wgdtg(0:nntg), wgdpg(0:nnpg),
     &                wgrtpg(nnrg,0:nntg,0:nnpg), 
     &               w4drg(0:nnrg), w4dtg(0:nntg), w4dpg(0:nnpg),
     &                wmrtpg(0:nnrg,0:nntg,0:nnpg)
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
      pi = 3.14159265358979d+0
c
c --- Determin coordinates on interface between GR and BH coordinates.
c
      small = 1.0d-10
      do 10 ipg = 0, npg - 1
      do 10 itg = 1, ntg
      irgbiin(itg,ipg) = 0
      irgbiou(itg,ipg) = 0
      rgbifin(itg,ipg) = 0.0d0
      rgbifou(itg,ipg) = 0.0d0
      ihrgbiin(itg,ipg) = 0
      ihrgbiou(itg,ipg) = 0
      hrgbifin(itg,ipg) = 0.0d0
      hrgbifou(itg,ipg) = 0.0d0
      sth2 = (dis**2 - radint**2)/(dis**2*cosphig(ipg)**2)
      cphi2 = (dis**2 - radint**2)/(dis**2*sintheg(itg)**2)
      if (sintheg(itg)**2.gt.sth2.and.cosphig(ipg)**2.gt.cphi2) then
      rgbifin(itg,ipg) = 
     & dis*sintheg(itg)*cosphig(ipg) - 
     & dsqrt(radint**2-dis**2*(1.0d0-sintheg(itg)**2*cosphig(ipg)**2))
      rgbifou(itg,ipg) = 
     & dis*sintheg(itg)*cosphig(ipg) + 
     & dsqrt(radint**2-dis**2*(1.0d0-sintheg(itg)**2*cosphig(ipg)**2))
      hrgbifin(itg,ipg) = rgbifin(itg,ipg)
      hrgbifou(itg,ipg) = rgbifou(itg,ipg)
      do 11 irg = 0, nrtot-1
      if (rgbifin(itg,ipg).ge.rg(irg)-small.and.
     &    rgbifin(itg,ipg).lt.rg(irg+1)-small) irgbiin(itg,ipg)=irg 
      if (rgbifou(itg,ipg).gt.rg(irg)+small.and.
     &    rgbifou(itg,ipg).le.rg(irg+1)+small) irgbiou(itg,ipg)=irg+1
      if (hrgbifin(itg,ipg).ge.hrg(irg)-small.and.
     &    hrgbifin(itg,ipg).lt.hrg(irg+1)-small)ihrgbiin(itg,ipg)=irg 
      if (hrgbifou(itg,ipg).gt.hrg(irg)+small.and.
     &    hrgbifou(itg,ipg).le.hrg(irg+1)+small)ihrgbiou(itg,ipg)=irg+1
   11 continue
      end if
   10 continue
c
      do 20 ipg = 0, npg-1
      do 20 irg = 1, nrtot
      itgbi(irg,ipg) = 0
      thgbif(irg,ipg) = 0.0d0
      sth = (rg(irg)**2 + dis**2 - radint**2)
     &     /(2.0d0*dis*rg(irg)*cosphig(ipg))
      if (sth.le.1.0d0) then
      thgbif(irg,ipg) = dasin(sth)
      do 21 itg = 0, ntg-1
      if (thgbif(irg,ipg).ge.thg(itg).and.
     &    thgbif(irg,ipg).lt.thg(itg+1)) itgbi(irg,ipg) = itg
   21 continue
      end if
c
      ihtgbi(irg,ipg) = 0
      hthgbif(irg,ipg) = 0.0d0
      sth = (hrg(irg)**2 + dis**2 - radint**2)
     &     /(2.0d0*dis*hrg(irg)*cosphig(ipg))
      if (sth.le.1.0d0) then
      hthgbif(irg,ipg) = dasin(sth)
      do 22 itg = 0, ntg-1
      if (hthgbif(irg,ipg).ge.thg(itg).and.
     &    hthgbif(irg,ipg).lt.thg(itg+1)) ihtgbi(irg,ipg) = itg
   22 continue
      end if
   20 continue
c
      do 30 itg = 1, ntg
      do 30 irg = 1, nrtot
      ipgbiin(irg,itg) = 0
      ipgbiou(irg,itg) = 0
      phigbifin(irg,itg) = 0.0d0
      phigbifou(irg,itg) = 0.0d0
      cphi = (rg(irg)**2 + dis**2 - radint**2)
     &      /(2.0d0*dis*rg(irg)*sintheg(itg))
ctest      if (cphi.le.1.0d0) then
      if (cphi.lt.1.0d0) then
      phigbifou(irg,itg) = dacos(cphi)
      phigbifin(irg,itg) = - dacos(cphi)
      do 31 ipg = 0, npg-1
      if (phigbifou(irg,itg).gt.phig(ipg).and.
     &    phigbifou(irg,itg).le.phig(ipg+1)) ipgbiou(irg,itg)=ipg+1
      if (phigbifin(irg,itg).ge.phig(ipg).and.
     &    phigbifin(irg,itg).lt.phig(ipg+1)) ipgbiin(irg,itg)=ipg
   31 continue
      end if
c
      ihpgbiin(irg,itg) = 0
      ihpgbiou(irg,itg) = 0
      hphigbifin(irg,itg) = 0.0d0
      hphigbifou(irg,itg) = 0.0d0
      cphi = (hrg(irg)**2 + dis**2 - radint**2)
     &      /(2.0d0*dis*hrg(irg)*sintheg(itg))
ctest      if (cphi.le.1.0d0) then
      if (cphi.lt.1.0d0) then
      hphigbifou(irg,itg) = dacos(cphi)
      hphigbifin(irg,itg) = - dacos(cphi)
      do 32 ipg = 0, npg-1
      if (hphigbifou(irg,itg).gt.phig(ipg).and.
     &    hphigbifou(irg,itg).le.phig(ipg+1)) ihpgbiou(irg,itg)=ipg+1
      if (hphigbifin(irg,itg).ge.phig(ipg).and.
     &    hphigbifin(irg,itg).lt.phig(ipg+1)) ihpgbiin(irg,itg)=ipg
   32 continue
      end if
   30 continue
c
      do 40 ipg = 0, npg
      do 40 itg = 0, ntg
      do 40 irg = 0, nrtot
c
      rgb1(irg,itg,ipg) = 0.0d0
      thgb1(irg,itg,ipg) = 0.0d0
      phigb1(irg,itg,ipg) = 0.0d0
      rgb2(irg,itg,ipg) = 0.0d0
      thgb2(irg,itg,ipg) = 0.0d0
      phigb2(irg,itg,ipg) = 0.0d0
c
cz      if (irg.gt.irgbiin(itg,ipg).and.irg.lt.irgbiou(itg,ipg)) go to 41
      x0 = rg(irg)*sintheg(itg)*cosphig(ipg)
      y0 = rg(irg)*sintheg(itg)*sinphig(ipg)
      z0 = rg(irg)*costheg(itg)
c
      small = 0.0d0
      if(rg(irg)**2+dis**2-2.0d0*rg(irg)*dis*sintheg(itg)*cosphig(ipg).
     &   le.0.0d0) small = 1.0d-14
      rgb1(irg,itg,ipg) = dsqrt(rg(irg)**2 + small + dis**2
     &                  - 2.0d0*rg(irg)*dis*sintheg(itg)*cosphig(ipg))
      thgb1(irg,itg,ipg) = datan2(sqrt((x0 - dis)**2 + y0**2),z0)
      if (x0-dis.ne.0.0d0)
     &phigb1(irg,itg,ipg) = dmod(2.0d0*pi+datan2(y0,x0 - dis),2.0d0*pi)
cxx      phigb1(irg,itg,ipg) = datan2(y0,x0 - dis)
c
      rgb2(irg,itg,ipg) = dsqrt(rg(irg)**2 + dis**2 
     &                  + 2.0d0*rg(irg)*dis*sintheg(itg)*cosphig(ipg))
      thgb2(irg,itg,ipg) = datan2(sqrt((x0 + dis)**2 + y0**2),z0)
      if (x0+dis.ne.0.0d0) 
     &phigb2(irg,itg,ipg) = dmod(2.0d0*pi+datan2(y0,x0 + dis),2.0d0*pi)
cxx      phigb2(irg,itg,ipg) = datan2(y0,x0 + dis)
c
   41 continue
   40 continue
c
cc      irg = 10
cc      do itg = 0, ntg
cc      do ipg = 0, npg
cc      write(6,999) irg,itg,ipg,
cc     & rgb1(irg,itg,ipg),thgb1(irg,itg,ipg),phigb1(irg,itg,ipg)
cc      end do 
cc      end do 
cc 999  format(3i5,1p,3e14.6)
cc       stop
c
      ntgmin = ntg
      do 48 irg = 0, nrtot
      if (itgbi(irg,0).gt.0) ntgmin = min0(itgbi(irg,0),ntgmin)
   48 continue
      npgmin = npg
      npgmax = 0
      do 49 irg = 0, nrtot
      if (ipgbiin(irg,ntg).gt.0) npgmin = min0(ipgbiin(irg,ntg),npgmin)
      npgmax = max0(ipgbiou(irg,ntg),npgmax)
   49 continue
      write(6,*) 'ntgmin = ', ntgmin
      write(6,*) 'npgmin = ', npgmin, ',     npgmax = ',npgmax
c
c --  weight of integlation for volume integral in GR coordinate.
c
      san = 1.0d0/3.0d0
      do 100 ipg = 0, npg
      do 100 itg = 0, ntg
c
      ir0in = ihrgbiin(itg,ipg)
      rvin = hrgbifin(itg,ipg)
      r0in = rg(ir0in)
      dr0in = rvin - r0in
      ir0ou = ihrgbiou(itg,ipg)
      rvou = hrgbifou(itg,ipg)
      r0ou = rg(ir0ou-1)
      dr0ou = r0ou - rvou
c
      do 100 irg = 1, nrtot
c
      wgr = w4drg(irg)
      wgt = w4dtg(itg)
      wgp = w4dpg(ipg)
      if(irg.gt.ihrgbiin(ntg,npgxz).and.irg.lt.ihrgbiou(ntg,npgxz))then
      wgr = wgdrg(irg)
      wgt = wgdtg(itg)
      wgp = wgdpg(ipg)
      end if
cxx      if (irg.gt.ihrgbiin(itg,ipg).and.irg.lt.ihrgbiou(itg,ipg).and.
cxx     &    itg.gt.ihtgbi(irg,ipg).and.ipg.lt.ihpgbi(irg,itg)) then
      if (irg.gt.ihrgbiin(itg,ipg).and.irg.lt.ihrgbiou(itg,ipg)) then
      wgr = 0.0d0
      wgt = 0.0d0
      wgp = 0.0d0
      go to 101
      end if
c
ctesttest
      go to 101
ctesttest
      itmod = mod(itg,2)
      it0 = ihtgbi(irg,ipg)
      thv = hthgbif(irg,ipg)
      th0 = thg(it0)
      dt0 = thv - th0
      ipmod = mod(ipg,2)
      ip0 = ihpgbi(irg,itg)
      phiv = hphigbif(irg,itg)
      phi0 = phig(ip0)
      dp0 = phi0 - phiv
c     
      if (irg.eq.ihrgbiin(itg,ipg).and.ihrgbiin(itg,ipg).ne.0) 
     &                              wgr = hrg(irg)**2*(drg(irg)+dr0in)
      if (irg.eq.ihrgbiou(itg,ipg).and.ihrgbiou(itg,ipg).ne.0) 
     &                              wgr = hrg(irg)**2*(drg(irg)+dr0ou)
      if (ihtgbi(irg,ipg).ne.0) then
      if (itg.eq.ihtgbi(irg,ipg).and.itmod.eq.0)
     &                              wgt = sintheg(itg)*(san*dthg+dt0)
      if (itg.eq.ihtgbi(irg,ipg).and.itmod.eq.1) 
     &                              wgt = sintheg(itg)*(0.5d0*dthg+dt0)
      if (itg.eq.ihtgbi(irg,ipg)-1.and.itmod.eq.0)
     &                              wgt = sintheg(itg)*(0.5d0+san)*dthg
      end if
      if (ihpgbi(irg,itg).ne.0) then
      if (ipg.eq.ihpgbi(irg,itg).and.ipmod.eq.0) wgp=san*dphig + dp0
      if (ipg.eq.ihpgbi(irg,itg).and.ipmod.eq.1) wgp=0.5d0*dphig + dp0
      if (ipg.eq.ihpgbi(irg,itg)+1.and.ipmod.eq.0)wgp=(0.5d0+san)*dphig
      end if
 101  continue
      wmrtpg(irg,itg,ipg) = wgr*wgt*wgp
cc      write(6,102) irg,itg,ipg,wmrtpg(irg,itg,ipg), wgrtpg(irg,itg,ipg)     
cc      if (irg.eq.2.and.itg.eq.13.and.ipg.eq.1)then
cc      write(6,104)  wgdrg(irg) , wgdtg(itg), wgdpg(ipg)  
cc      write(6,104)       wgr ,  wgt,    wgp
cc      write(6,*)ihpgbi(irg,itg)
cc       stop
cc       end if
 100  continue
cc 102  format(3i4,1p,2e17.9)
cc 104  format(1p,3e17.9)
c
c --- Values for extended BH coodinate in GR coordinate, bing. 
c --- bing(0,itb,ipb) is on the interface.  extend 2 points.
c
      do 50 ii = 1, 5
      rbex(ii) = radext + drb(nrb)*(dble(ii)-3.0d0)
ctest      rbex(ii) = rb(nrb) + 0.5d0*drb(nrb)*(dble(ii)-3.0d0)
ctest      rbex(ii) = radext + drb(nrb)*(dble(ii)-5.0d0)
ctest      rbex(ii) = rb(nrb) + drb(nrb)*(dble(ii)-1.0d0)
      rrbb = rbex(ii)
      do 50 ipb = 0, npb
      do 50 itb = 0, ntb
c
      xb = rrbb*sintheb(itb)*cosphib(ipb)
      yb = rrbb*sintheb(itb)*sinphib(ipb)
      zb = rrbb*costheb(itb)
c
      rbing(ii,itb,ipb) = dsqrt((xb + dis)**2 + yb**2 + zb**2)
      thbing(ii,itb,ipb) = datan2(sqrt((xb + dis)**2 + yb**2),zb)
      phibing(ii,itb,ipb) = datan2(yb,xb + dis)
c
   50 continue
c
      end
c
c ______________________________________________________________________
c ______________________________________________________________________
c
      function dfncdx(xg,fnc,rb)
      implicit real*8 (a-h,o-z), integer (i-n)
      dimension xg(5),fnc(5)
c
      ir0 = 1
      ir1 = 2
      ir2 = 3
      ir3 = 4
      ir4 = 5
      dr01 = xg(ir0) - xg(ir1)
      dr02 = xg(ir0) - xg(ir2)
      dr03 = xg(ir0) - xg(ir3)
      dr04 = xg(ir0) - xg(ir4)
      dr12 = xg(ir1) - xg(ir2)
      dr13 = xg(ir1) - xg(ir3)
      dr14 = xg(ir1) - xg(ir4)
      dr23 = xg(ir2) - xg(ir3)
      dr24 = xg(ir2) - xg(ir4)
      dr34 = xg(ir3) - xg(ir4)
      dr10 = - dr01
      dr20 = - dr02
      dr21 = - dr12
      dr30 = - dr03
      dr31 = - dr13
      dr32 = - dr23
      dr40 = - dr04
      dr41 = - dr14
      dr42 = - dr24
      dr43 = - dr34
      rrb0 = rb - xg(ir0)
      rrb1 = rb - xg(ir1)
      rrb2 = rb - xg(ir2)
      rrb3 = rb - xg(ir3)
      rrb4 = rb - xg(ir4)
      wer0 = (rrb2*rrb3*rrb4 + rrb1*rrb3*rrb4 +
     &        rrb1*rrb2*rrb4 + rrb1*rrb2*rrb3)/(dr01*dr02*dr03*dr04)
      wer1 = (rrb2*rrb3*rrb4 + rrb0*rrb3*rrb4 +
     &        rrb0*rrb2*rrb4 + rrb0*rrb2*rrb3)/(dr10*dr12*dr13*dr14)
      wer2 = (rrb1*rrb3*rrb4 + rrb0*rrb3*rrb4 +
     &        rrb0*rrb1*rrb4 + rrb0*rrb1*rrb3)/(dr20*dr21*dr23*dr24)
      wer3 = (rrb1*rrb2*rrb4 + rrb0*rrb2*rrb4 +
     &        rrb0*rrb1*rrb4 + rrb0*rrb1*rrb2)/(dr30*dr31*dr32*dr34)
      wer4 = (rrb1*rrb2*rrb3 + rrb0*rrb2*rrb3 +
     &        rrb0*rrb1*rrb3 + rrb0*rrb1*rrb2)/(dr40*dr41*dr42*dr43)
      dfncdx = wer0*fnc(ir0) + wer1*fnc(ir1) +
     &         wer2*fnc(ir2) + wer3*fnc(ir3) +
     &         wer4*fnc(ir4)
c
      end
c
